//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
// Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
//-----------------------------------------------------------------------------
//
// Description:
//       cmlog server locater
//
// Author:  Jie Chen
//       CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogServerLocater.cc,v $
//   Revision 1.2  2001/07/25 14:26:37  chen
//   64 BIT Initial Port
//
//   Revision 1.1.1.1  1999/09/07 15:29:10  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:27:28  bickley
// Added cmlog to application development system.
//
//
#include <cmlogUtil.h>
#include "cmlogServerLocater.h"

cmlogServerLocater::cmlogServerLocater (unsigned req, int numRetries)
:req_ (req), numRetries_ (numRetries), ufunc_ (0), uarg_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogServerLocater Class Object\n");
#endif

#ifdef _CMLOG_BUILD_SERVER
  brdPort_ = cmlogUtil::PORT;
#else
  char *tmp = ::getenv ("CMLOG_PORT");
  int  tmport;
  if (tmp)
    sscanf (tmp, "%d", &tmport);
  else 
    tmport = CMLOG_PORT;

  brdPort_ = (unsigned short)tmport;
#endif
}

cmlogServerLocater::cmlogServerLocater (unsigned req, unsigned short port, 
					int numRetries)
:req_ (req), brdPort_ (port), numRetries_ (numRetries), ufunc_ (0), uarg_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cmlogServerLocater Class Object\n");
#endif
}

cmlogServerLocater::~cmlogServerLocater (void)
{
  // empty
  // ufunc and uarg_ are managed by caller
}

void
cmlogServerLocater::registerUpdateFunc (cmlogUpdateFunc func, void* arg)
{
  ufunc_ = func;
  uarg_ = arg;
}

int
cmlogServerLocater::locatingServer (char *hostname, int size, 
				    unsigned short& port)
{
  ACE_Reactor r_;
  cmlogSvcLocaterRep svcl(r_, brdPort_, req_);

  if (r_.register_handler (&svcl, ACE_Event_Handler::READ_MASK) == -1){
    fprintf (stderr, "Cannot register svc locater \n");
    return -1;
  }
  
  int status = 0;
  int i = 0;
  while (!svcl.foundServer() && i < numRetries_){
    status = svcl.sendRequest ();
    if (status == -1)
      break;
    ACE_Time_Value tv (0, 250000); // 0.25 seconds
    r_.handle_events (tv);

    // call the external function 
    if (ufunc_) {
      if((*ufunc_)(uarg_) == -1)
	return -1;
    }
    i++;
  }
  if (i >= numRetries_ || status == -1){
#ifdef _CODA_DEBUG
    fprintf (stderr, "Cannot find cmlog server\n");
#endif
    return -1;
  }
  port = svcl.serverPort_;
  if (size < ::strlen (svcl.serverHost_) + 1)
    return 1;
  else 
    ::strcpy (hostname, svcl.serverHost_);

  return 0;
} 
