//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CMLOG Server Data Manager
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogDataManager.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:10  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:27:17  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_DATA_MAMAGER_H
#define _CMLOG_DATA_MAMAGER_H

#include <stdio.h>
#include <string.h>
#include <cmlogStrHash.h>

class cmlogData;
class cmlogDataManagerIterator;

class cmlogDataManager
{
public:
  // constructor and destructor
  cmlogDataManager  (void);
  // all data inside table will be removed and memory not be freed
  ~cmlogDataManager (void);

  // operations: return 0 on success, return -1 on failure

  // add cmlogData into the manager
  int  addData     (cmlogData* data);
  // remove data from the manager but data is still valid
  int  removeData  (cmlogData* data);
  // remove data by name, data will be invalid (freed)
  int  removeData  (char *name);
  // find data
  int  hasData     (char *name);
  // find data
  int  findData    (char *name, cmlogData* &data);

  // clean all values, data are still valid
  void cleanAll    (void);

  // remove all values, data are removed, no longer valid
  void freeAll     (void);

  // update data values from some perminant storage
  void update      (void);

  // remove callbacks associated with a particular channel
  void removeCbksOfCh (void* ch);

  // print out all values
  void asciiDump   (FILE* fd = stdout);

private:
  // hash table for all variables
  cmlogStrHash  dataTable_;
  friend class  cmlogDataManagerIterator;
};

class cmlogDataManagerIterator
{
public:
  cmlogDataManagerIterator (cmlogDataManager& manager);
  ~cmlogDataManagerIterator (void);

  int                  init        (void);
  cmlogData*           operator () (void);
  int                  operator !  (void);
  int                  operator ++ (void);

protected:
  cmlogStrHashIterator ite_; 
};

extern cmlogDataManager* dataManager;
#endif
