//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      cmlog server client daemon signal handler
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogClntDSigHandler.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:09  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:26:56  bickley
// Added cmlog to application development system.
//
//
#ifndef _CMLOG_CLNTD_SIG_HANDLER_H
#define _CMLOG_CLNTD_SIG_HANDLER_H

#include <cmlogConfig.h>

extern sig_atomic_t finished;

class cmlogClntDSigHandler
{
public:
  // operation
  static int registerSignalHandlers (void);
  // all signal handlers 
  static void  signalFunc   (int signo);

private:
  // all signals we want to catch
  static int signals[];
  static int numSignals;

  // deny direct access
  cmlogClntDSigHandler (void);
};
#endif

  

