//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implemenation of signal handler for cmlog client daemon
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogClntDSigHandler.cc,v $
//   Revision 1.1.1.1  1999/09/07 15:29:09  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:26:54  bickley
// Added cmlog to application development system.
//
//
#include "cmlogClntDSigHandler.h"

int cmlogClntDSigHandler::signals[] = 
{SIGINT, SIGQUIT, SIGILL, SIGFPE,
 SIGSYS, SIGPIPE, SIGBUS, SIGSEGV,
 SIGTERM, SIGTSTP, SIGCONT, SIGIO, SIGPOLL};

int cmlogClntDSigHandler::numSignals = 13;

int
cmlogClntDSigHandler::registerSignalHandlers (void)
{
  struct sigaction act, oact;

  act.sa_handler = &(cmlogClntDSigHandler::signalFunc);
  sigemptyset (&act.sa_mask);
  act.sa_flags = 0;
#ifdef SA_RESTART
  act.sa_flags |= SA_RESTART;
#endif

  for (int i = 0; i < cmlogClntDSigHandler::numSignals; i++) 
    if (sigaction (cmlogClntDSigHandler::signals[i], &act, &oact) < 0)
      return -1;
  
  return 0;
}

void
cmlogClntDSigHandler::signalFunc (int signo)
{
#ifdef solaris
  char signame[SIG2STR_MAX];
  if (sig2str (signo, signame) == -1)
    sprintf (signame, "unknown");

  fprintf (stderr, "Interrupted by %s signal\n", signame);

  if (signo == SIGSEGV || signo == SIGBUS) {
    fprintf (stderr, "Fatal: Caught signal %s, Quit.......\n", signame);
    finished = 1;
    abort ();
  }
  else if (signo != SIGPIPE && signo != SIGTSTP &&
	   signo != SIGCONT && signo != SIGINT) {
    finished = 1; // exit from client daemon
  }
#else
  fprintf (stderr, "Interrupted by %d signal\n", signo);

  if (signo == SIGSEGV || signo == SIGBUS) {
    fprintf (stderr, "Fatal: Caught signal %d, Quit.......\n", signo);
    finished = 1;
    abort ();
  }
  else if (signo != SIGPIPE && signo != SIGTSTP &&
	   signo != SIGCONT && signo != SIGINT) {
    finished = 1; // exit from client daemon
  }
#endif
}
