//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//       cmlog query service class 
//
// Author:  Jie Chen
//
// Revision History:
//   $Log: cmlogQService.cc,v $
//   Revision 1.1.1.1  1999/09/07 15:29:09  chen
//   CMLOG version 2.0
//
// Revision 1.2  1998/02/18  15:05:06  chen
// add registerFd
//
// Revision 1.1  1997/09/18  14:28:56  chen
// new cmlog query service
//
//
//
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#include <cdevDirectory.h>
#include "cmlogQService.h"
#include "cmlogQRequestObject.h"
#include "cmlogQUpdateObj.h"

//=========================================================================
//        Implementation of class cmlogService
//=========================================================================
cmlogQService::cmlogQService (char* name, cdevSystem& system)
:cdevService (name, system), browser_ (), fds_ (0), numFds_ (0), uobjs_ ()
{
#ifdef _TRACE_OBJECTS
  printf ("              Create cmlogQService Class Object\n");
#endif
  // empty
}

cmlogQService::~cmlogQService (void)
{
#ifdef _TRACE_OBJECTS
  printf ("              Delete cmlogQService Class Object\n");
#endif
  if (browser_.connected ()) 
    browser_.disconnect ();
  if (numFds_ > 0)
    delete []fds_;

  cmlogSlistIterator ite (uobjs_);
  cmlogQUpdateObj* uobj = 0;

  for (ite.init (); !ite; ++ite) {
    uobj = (cmlogQUpdateObj *)ite ();
    delete uobj;
  }
}

int
cmlogQService::getFd (int* &fd, int& numFd)
{
  fd = fds_;
  numFd = numFds_;
  return CDEV_SUCCESS;
}

int
cmlogQService::flush (void)
{
#ifdef _CDEV_DEBUG
  printf ("Flush by cmlogQService\n");
#endif
  // all requests will be sent out without waiting
  return CDEV_SUCCESS;
}

int
cmlogQService::poll (void)
{
#ifdef _CDEV_DEBUG
  printf ("Poll by cmlogQService\n");
#endif

  return browser_.pendIO (0.01);
}

int
cmlogQService::pend (int fd)
{
#ifdef _CDEV_DEBUG
  printf ("Pend by cmlogQService\n");
#endif  

  return browser_.pendIO ();
}

int
cmlogQService::pend (double seconds, int)
{
#ifdef _CDEV_DEBUG
  printf ("Pend by cmlogQService for %lf seconds\n", seconds);
#endif  
  return browser_.pendIO (seconds);
}

int
cmlogQService::getRequestObject (char* deviceName, char* prog,
				cdevRequestObject* &req)
{
  if (!browser_.connected ()) {
    if (browser_.connect () != CMLOG_SUCCESS) {
      reportError (CDEV_SEVERITY_SEVERE, serviceName_, 0,
		   "Cannot find cmlog server anywhere!!!\n");
      req = 0;
      return CDEV_ERROR;
    }
    else {
      if (numFds_ > 0)
	delete []fds_;
      
      fds_ = new int[1];
      numFds_ = 1;
      fds_[0] = browser_.getFd ();

      // register fd to the system
      registerFd (browser_.getFd (), 1);

      // register disconnection callback
      if (browser_.disconnectCallback (&(cmlogQService::discCallback),
				       (void *)this) != CMLOG_SUCCESS) {
	reportError (CDEV_SEVERITY_WARN, serviceName_, 0,
		     "Cannot register disconnect callback\n");
      }
    }
  }
  req = new cmlogQRequestObject (deviceName, prog, this, system_);
  return CDEV_SUCCESS;
}

int
cmlogQService::getNameServer (cdevDevice* &ns)
{
  ns = 0;
  return CDEV_SUCCESS;
}

int
cmlogQService::addUpdateObject (cmlogQUpdateObj* uobj)
{
  cmlogSlistIterator ite (uobjs_);
  cmlogQUpdateObj*   tobj = 0;

  for (ite.init (); !ite; ++ite) {
    tobj = (cmlogQUpdateObj *) ite ();
    if (*(tobj->userCallback_) == *(uobj->userCallback_))
      return -1;
  }
  uobjs_.add ((void *)uobj);
  return 0;
}

int
cmlogQService::removeUpdateObject (cmlogQUpdateObj *uobj)
{
  cmlogSlistIterator ite (uobjs_);
  cmlogQUpdateObj*   tobj = 0;
  int found = 0;

  for (ite.init (); !ite; ++ite) {
    tobj = (cmlogQUpdateObj *) ite ();
    if (uobj == tobj) {
      found = 1;
      break;
    }
  }  
  if (found) {
    uobjs_.remove ((void *)uobj);
    return 0;
  }
  return 0;
}

int
cmlogQService::hasCallback (cdevCallback& callback)
{
  cmlogSlistIterator ite (uobjs_);
  cmlogQUpdateObj*   tobj = 0;
  int found = 0;

  for (ite.init (); !ite; ++ite) {
    tobj = (cmlogQUpdateObj *) ite ();
    if (*(tobj->userCallback_) == callback)
      return 1;
  }
  return 0;
}

void
cmlogQService::discCallback (int status, void* arg, cmlogPacket* packet)
{
  cmlogQService* qservice = (cmlogQService *)arg;

  if (qservice->numFds_ > 0) {
    // remove fds from the system
    for (int i = 0; i < qservice->numFds_; i++)
      qservice->registerFd (qservice->fds_[i], 0);

    delete [](qservice->fds_);
    qservice->numFds_ = 0;
  }

  cmlogSlistIterator ite (qservice->uobjs_);
  cmlogQUpdateObj* uobj = 0;
  cdevCallback* cbk = 0;
  cdevRequestObject* obj = 0;
  cdevData      empty;

  for (ite.init (); !ite; ++ite) {
    uobj = (cmlogQUpdateObj *)ite ();

    cbk = uobj->userCallback_;
    obj = uobj->reqObj_;
    cbk->fireCallback (CDEV_DISCONNECTED, cbk->userarg (),
		       *obj, empty, 0);
  }
}

cdevService*
newCmlogQService (char* name, cdevSystem* system)
{
  return new cmlogQService (name, *system);
}
