// simple test for cdev interface 
#include <cdevSystem.h>
#include <cdevRequestObject.h>
#include <cdevDevice.h>
#include <cdevGroup.h>
#include <unistd.h>

static int qdone = 0;

static void queryCallback (int status, void* arg,
			   cdevRequestObject& req,
			   cdevData& data)
{
  char text[500];

  if (status == CDEV_DISCONNECTED) {
    printf ("server is dead\n");
    return;
  }

  if (status == CDEV_SUCCESS)
    if (data.get ("text", text, sizeof (text)) == CDEV_SUCCESS)
      printf ("%s\n", text);

  if (cdevCallback::isTransactionDone ()) {
    printf ("transaction done\n");
    qdone = 1;
  }
}

static void updateCallback (int status, void* arg,
			    cdevRequestObject& req,
			    cdevData& data)
{
  char text[500];

  if (status == CDEV_DISCONNECTED) {
    printf ("server is dead\n");
    return;
  }

  int idx = (int)arg;

  if (status == CDEV_SUCCESS) {
    if (data.get ("text", text, sizeof (text)) == CDEV_SUCCESS)
      printf ("index %d: %s\n", idx, text);
  }

}

main (int argc, char** argv)
{
  cdevSystem& system = cdevSystem::defaultSystem ();
  char temp[100];
  int  idx0 = 0;
  int  idx1 = 1;
  int  i = 0;
  char comd[100];
  
  printf ("Enter test command\n");
  scanf ("%s", comd);

  if (strcasecmp (comd, "update") == 0) {
    cdevRequestObject* obj = cdevRequestObject::attachPtr ("cmlogq", "update");
    cdevCallback cbk0 (updateCallback, (void *)idx0);
    cdevCallback cbk1 (updateCallback, (void *)idx1);

    if (obj) {
      cdevGroup grp;
      grp.start ();
      obj->sendCallback (0, cbk0);
      obj->sendCallback (0, cbk1);
      grp.end ();
      grp.pend ();

      if (grp.allFinished ()) 
	printf ("update on success\n");
    
      while (1) {
	system.pend (0.5);
	i++;
	if (i > 50) {
	  cdevRequestObject* obj1 = 
	    cdevRequestObject::attachPtr ("cmlogq", "updateOff");
	  if (obj1) {
	    printf ("remove all callbacks\n");
	    cdevCallback emptycbk (0, 0);
	    obj1->sendCallback (0, emptycbk);
	  }
	  i = 0;
	}
      }
    }
  }
  else if (strcasecmp (comd, "query") == 0) {
    cdevRequestObject* obj = cdevRequestObject::attachPtr ("cmlogq", "query");
    cdevData out;
    char qstr[100];

    double stime, etime;
    printf ("Enter start and end time to search\n");
    scanf ("%lf %lf", &stime, &etime);
    if (etime <= stime) {
      printf ("End time cannot be smaller than starting time\n");
      exit (1);
    }
    out.insert ("start", stime);
    out.insert ("end", etime);

    printf ("Enter seaching string\n");
    scanf ("%s", qstr);
    out.insert ("queryMsg", qstr);

    if (obj) {
      qdone = 0;
      cdevCallback qcbk (queryCallback, 0);
      obj->sendCallback (out, qcbk);

      while (!qdone) 
	system.pend ();
    }
  }    
}
