//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      CDEV Interface to cmlogClient
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: cmlogService.h,v $
//   Revision 1.1.1.1  1999/09/07 15:29:09  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:26:29  bickley
// Added cmlog to application development system.
//
//
//
#ifndef _CMLOG_SERVICE_H
#define _CMLOG_SERVICE_H

#include <cdevService.h>
#include <cmlogClient.h>

class cmlogRequestObject;

//============================================================================
// Note for Usage:
//      One may need to set CMLOG_PORT to connect to a right server
//===========================================================================

extern "C" cdevService *newCmlogService (char *name, cdevSystem* system);

class cmlogService: public cdevService
{
public:
  // constructor
  cmlogService (char* name, cdevSystem& system);
  
  int getFd (int* &fd, int& numFd);
  // PURPOSE: return channel access network file descriptors
  // REQUIRE: callers provide pointer only and don't free memory
  // PROMISE: numFd will be real number of file descriptors of the 
  //          channel access client. return 0: always

  int flush (void);
  // PURPOSE: flush network requests
  // REQUIRE: nothing
  // PROMISE: return 0: success, return 1: ca error

  int poll (void);
  // PURPOSE: polling method
  // REQUIRE: nothing
  // PROMISE: return 0: success, return 1: ca error

  int pend (int fd = -1);
  // PURPOSE: handle network pending for very short time (== poll)
  //          requirment from cdevSystem pend ()
  // REQUIRE: nothing
  // PROMISE: return 0: success, return 1: ca error

  int pend (double seconds, int fd = -1);
  // PURPOSE: handle network pending for 'seconds'
  // REQUIRE: nothing
  // PROMISE: return 0: success. return 1: ca error

  int getRequestObject (char *deviceName, char *msg,
			cdevRequestObject * &req);
  // PURPOSE: return a cmlogRequestObject (called from attachPtr function
  //          of cdevRequestObject class)
  // REQUIRE: right pair of deviceName and msg. 
  // PROMISE: a codaRequestObject

  int getNameServer (cdevDevice* &ns);
  // PURPOSE: return own name server
  // REQUIRE: none
  // PROMISE: return nothing. no name server

  const char* className (void) const {return "cmlogService";}

protected:
  // deny direct access to destructor
  ~cmlogService (void);

private:
  cmlogClient client_;
  int         *fds_;
  int         numFds_;

  // friend class
  friend class cmlogRequestObject;
};
#endif
  
