//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//       cmlog service class 
//
// Author:  Jie Chen
//
// Revision History:
//   $Log: cmlogService.cc,v $
//   Revision 1.1.1.1  1999/09/07 15:29:09  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:26:28  bickley
// Added cmlog to application development system.
//
//
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#include <cdevDirectory.h>
#include "cmlogService.h"
#include "cmlogRequestObject.h"

//=========================================================================
//        Implementation of class cmlogService
//=========================================================================
cmlogService::cmlogService (char* name, cdevSystem& system)
:cdevService (name, system), client_ (), fds_ (0), numFds_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("              Create cmlogService Class Object\n");
#endif
  // empty
}

cmlogService::~cmlogService (void)
{
#ifdef _TRACE_OBJECTS
  printf ("              Delete cmlogService Class Object\n");
#endif
  if (client_.connected ()) 
    client_.disconnect ();
  if (numFds_ > 0)
    delete []fds_;
}

int
cmlogService::getFd (int* &fd, int& numFd)
{
  fd = fds_;
  numFd = numFds_;
  return CDEV_SUCCESS;
}

int
cmlogService::flush (void)
{
#ifdef _CDEV_DEBUG
  printf ("Flush by cmlogService\n");
#endif
  // all requests will be sent out without waiting
  return CDEV_SUCCESS;
}

int
cmlogService::poll (void)
{
#ifdef _CDEV_DEBUG
  printf ("Poll by cmlogService\n");
#endif
  return CDEV_SUCCESS;
}

int
cmlogService::pend (int fd)
{
#ifdef _CDEV_DEBUG
  printf ("Pend by cmlogService\n");
#endif  
  return CDEV_SUCCESS;
}

int
cmlogService::pend (double seconds, int)
{
#ifdef _CDEV_DEBUG
  printf ("Pend by cmlogService for %lf seconds\n", seconds);
#endif  
  return CDEV_SUCCESS;
}

int
cmlogService::getRequestObject (char* deviceName, char* prog,
				cdevRequestObject* &req)
{
  req = new cmlogRequestObject (deviceName, prog, this, system_);
  return CDEV_SUCCESS;
}

int
cmlogService::getNameServer (cdevDevice* &ns)
{
  ns = 0;
  return CDEV_SUCCESS;
}

cdevService*
newCmlogService (char* name, cdevSystem* system)
{
  return new cmlogService (name, *system);
}
