//-----------------------------------------------------------------------------
// Copyright (c) 1991,1992 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
// Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
//-----------------------------------------------------------------------------
// 
// Description:
//	Coda Xpm PushButton Command Header file
//	
// Author:  Jie Chen
//       CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: codaXpmpbtnComd.h,v $
//   Revision 1.2  2000/06/20 18:46:25  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:09  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:26:02  bickley
// Added cmlog to application development system.
//
//   Revision 1.1.1.1  1996/10/10 19:25:00  chen
//   coda motif C++ library
//
//

#ifndef _CODA_XPMBTN_COMD
#define _CODA_XPMBTN_COMD

#include <codaPbtnComd.h>

class XcodaXpmpbtnInterface;

class codaXpmpbtnComd: public codaPbtnComd
{
public:
  codaXpmpbtnComd(const char *, char **, int);
  codaXpmpbtnComd(const char *, char **, int, char *);
  virtual ~codaXpmpbtnComd ();
  
  virtual void createXInterface(Widget);
  virtual const char *className (void) const {return "codaXpmpbtnComd";}

private:
  char **_xpm_data;
  char *_bgsymbol;
};
#endif
