//-----------------------------------------------------------------------------
// Copyright (c) 1991,1992 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
// Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
//-----------------------------------------------------------------------------
// 
// Description:
//	Generic Command Class Header File
//	
// Author:  Jie Chen
//       CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: codaComd.h,v $
//   Revision 1.2  2000/06/20 18:46:24  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:09  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:25:46  bickley
// Added cmlog to application development system.
//
//   Revision 1.1.1.1  1996/10/10 19:24:59  chen
//   coda motif C++ library
//
//

#ifndef _CODA_COMD_H
#define _CODA_COMD_H

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>

class codaComdList;
class codaComdXInterface;

class codaComd
{
public:
  // Destructor    
  virtual ~codaComd ();                     
    
  // public interface for executing and undoing commands
  virtual void       execute();  
  void               undo();
    
  void               activate();   // Activate this object
  void               deactivate(); // Deactivate this object
    
  // Functions to register dependent commands
    
  void               addToActivationList ( codaComd * );
  void               addToDeactivationList ( codaComd * );
    
  // Register an Xinterface  used to execute this command
    
  void               registerXInterface ( codaComdXInterface * );
  codaComdXInterface *getXInterface();
  int                hasXInterface();
  virtual void       createXInterface (Widget) = 0;
    
  // Access functions 
    
  int active ()      { return _active; }
  int hasUndo()      { return _hasUndo; }
  const char *name () const { return _name; }

  // class name
  virtual const char *className () const { return "codaComd"; } ;

protected:
  // protect constructor
  codaComd (const char *,  int );                 

  int                _hasUndo;          // True if this object supports undo
  virtual void       doit()   = 0;      // Specific actions must be defined
  virtual void       undoit() = 0;      // by derived classes
    
private:
    
  // Lists of other commands to be activated or deactivated
  // when this command is executed or "undone"
    
  codaComdList       *_activationList;
  codaComdList       *_deactivationList;
  void               revert();          // Reverts object to previous state
  int                _active;           // Is this command currently active?
  int                _previouslyActive; // Previous value of _active
  const char         *_name;            // Name of this Cmd
  int                _redo;             // Redo this command after undo
  codaComdXInterface *_ci;              // one interface with one command
};
#endif
