//-----------------------------------------------------------------------------
// Copyright (c) 1991,1992 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
// Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
//-----------------------------------------------------------------------------
// 
// Description:
//	Cascade Button Widget Interface
//	
// Author:  Jie Chen
//       CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: XcodaCbtnInterface.cc,v $
//   Revision 1.2  2000/06/20 18:46:20  chen
//   port to CC 5.0 and gcc 2.95.2
//
//   Revision 1.1.1.1  1999/09/07 15:29:07  chen
//   CMLOG version 2.0
//
// Revision 1.1  1997/08/01  15:24:18  bickley
// Added cmlog to application development system.
//
//   Revision 1.1.1.1  1996/10/10 19:24:55  chen
//   coda motif C++ library
//
//
#include <stdio.h>
#include <XcodaCbtnInterface.h>
#include <codaComd.h>
#include <codaComdList.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>

XcodaCbtnInterface::XcodaCbtnInterface(Widget parent,
				       codaComd *cmd): 
				       codaComdXInterface (parent,
							   cmd)
{
#ifdef _TRACE_OBJECTS
  printf("Create XcodaCbtnInterface Object \n");
#endif
  // empty
}
void XcodaCbtnInterface::init()
{
  int    i;
  Arg    arg[10];
  int    ac = 0;

  _pulldown = XmCreatePulldownMenu (_parent, (char *)("pulldown"), NULL, 0);
  XtSetArg (arg[ac], XmNsubMenuId, _pulldown); ac++;
  _w = XtCreateWidget(_name, 
		      xmCascadeButtonWidgetClass,
		      _parent,
		      arg, ac);
  ac = 0;
  
  installDestroyHandler();

  if(_active)
    activate();
  else
    deactivate();
  XtManageChild (_w);
}

XcodaCbtnInterface::~XcodaCbtnInterface()
{
#ifdef _TRACE_OBJECTS
  printf("Create XcodaCbtnInterface \n");
#endif
}


void XcodaCbtnInterface::addCommands(codaComdList *list)
{
  int i;
  codaComd *cmd;

  for (i=0; i < list->size(); i++){
    cmd = (*list)[i];
    cmd->createXInterface(_pulldown);
  }
}

const char *XcodaCbtnInterface::className() const
{
  return "XcodaCbtnInterface";
}



