// The following configuration file is designed to work for Linux
// platforms using GNU C++.

#if !defined (ACE_CONFIG_H)
#define ACE_CONFIG_H

#define ACE_HAS_POSIX_TIME

// Platform supports POSIX O_NONBLOCK semantics.
#define ACE_HAS_POSIX_NONBLOCK

#define ACE_LACKS_STRRECVFD

// Platform supports System V IPC (most versions of UNIX, but not Win32)
#define ACE_HAS_SYSV_IPC			

// Compiler/platform contains the <sys/syscall.h> file.
#define ACE_HAS_SYSCALL_H

#define ACE_HAS_CONSISTENT_SIGNAL_PROTOTYPES

// Platforms lacks UNIX domain sockets.
#define ACE_LACKS_UNIX_DOMAIN_SOCKETS

// Compiler/platform supports alloca().
#define ACE_HAS_ALLOCA

#define ACE_LACKS_SENDMSG
#define ACE_LACKS_RECVMSG
#define ACE_LACKS_MSYNC
#define ACE_LACKS_MADVISE

// Compiler/platform has <alloca.h>
#define ACE_HAS_ALLOCA_H

// Compiler/platform has the getrusage() system call.
#define ACE_HAS_GETRUSAGE

// Compiler/platform defines the sig_atomic_t typedef.
#define ACE_HAS_SIG_ATOMIC_T

// Compiler/platform supports sys_siglist array.
#define ACE_HAS_SYS_SIGLIST

// Compiler supports the ssize_t typedef.
#define ACE_HAS_SSIZE_T

// Compiler/platform supports strerror ().
#define ACE_HAS_STRERROR

// Compiler/platform defines the F_SETOWN macro.
#define ACE_HAS_SETOWN

// Defines the page size of the system.
#define ACE_PAGE_SIZE 4096

#define ACE_HAS_SUNOS4_GETTIMEOFDAY

// Turns off the tracing feature.
#if !defined (ACE_NTRACE)
#define ACE_NTRACE 1
#endif /* ACE_NTRACE */

// Linux defines struct msghdr in /usr/include/socket.h
#define ACE_HAS_MSG
#define msg_accrights msg_control
#define msg_accrightslen msg_controllen

// TDN - adapted from file for SunOS4 platforms using the GNU g++ compiler
// Compiler's template mechanism must see source code (i.e., .C files).
#define ACE_TEMPLATES_REQUIRE_SOURCE

// Compiler doesn't support static data member templates.
#define ACE_LACKS_STATIC_DATA_MEMBER_TEMPLATES

// linux has c++ header
#define ACE_HAS_CPLUSPLUS_HEADERS

// Red Hat Linux has sigwait
#define ACE_HAS_SIGWAIT

// Linux has MAP_FAILED defined
#define ACE_HAS_MAP_FAILED

// Linux has AF_FILE
#define ACE_HAS_AF_FILE

// Linux has getrusage
#define ACE_HAS_GETRUSAGE_PROTO

// Linux has diffrent argument for getrusage and getrlimit
#define ACE_HAS_RUSAGE_WHO_ENUM enum __rusage_who
#define ACE_HAS_RLIMIT_RESOURCE_ENUM enum __rlimit_resource

// Linux socklen_t is unsigned
#define ACE_HAS_SOCKLEN_T socklen_t

// Linux recvfrom has size_t
#define ACE_HAS_SIZET_RECVFROM

// Linux has non-const msgsnd
#define ACE_HAS_NONCONST_MSGSND

#endif /* ACE_CONFIG_H */
