/* -*- C++ -*- */

#include "ace/Log_Msg.h"


// Unique thread id.  
INLINE thread_t 
ACE_Thread_Descriptor::self (void)
{
  ACE_TRACE ("ACE_Thread_Descriptor::self");
  return this->thr_id_;
}
  
// Unique kernel-level thread handle.

INLINE void 
ACE_Thread_Descriptor::self (hthread_t &handle)
{
  ACE_TRACE ("ACE_Thread_Descriptor::self");
  handle = this->thr_handle_;
}  

// Group ID.

INLINE int 
ACE_Thread_Descriptor::grp_id (void)
{
  ACE_TRACE ("ACE_Thread_Descriptor::grp_id");
  return grp_id_;
}

// Current state of the thread.
INLINE ACE_Thread_Descriptor::Thread_State 
ACE_Thread_Descriptor::state (void)
{
  ACE_TRACE ("ACE_Thread_Descriptor::Thread_State");
  return thr_state_;
}

#if defined (ACE_HAS_THREADS)

// Set the exit status.

INLINE void *
ACE_Thread_Control::status (void *s)
{
  ACE_TRACE ("ACE_Thread_Control::status");
  return this->status_ = s;
}

// Get the exit status.

INLINE void *
ACE_Thread_Control::status (void)
{
  ACE_TRACE ("ACE_Thread_Control::status");
  return this->status_;
}

#endif /* !defined (ACE_HAS_THREADS) */
