/* -*- C++ -*- */

// ============================================================================
//
// = LIBRARY
//    ace
// 
// = FILENAME
//    ARGV.h
//
// = AUTHOR
//    Doug Schmidt 
// 
// ============================================================================

#if !defined (ACE_ARGUMENT_VECTOR_H)
#define ACE_ARGUMENT_VECTOR_H

#include "ace/ACE.h"

class ACE_ARGV
  // = TITLE
  //     Transforms a string BUF into an ARGV-style vector of strings.
{
public:
  // = Initialization and termination.
  ACE_ARGV (char buf[]);
  // Converts BUF into an ARGV-style vector of strings. 

  ~ACE_ARGV (void);
  // Destructor.

  // = Accessor arguments.
  char *operator[] (int index) const;
  // Returns the INDEXth string in the ARGV array. 

  char **operator& (void) const;
  // Returns ARGV. 

  size_t count (void) const;
  // Returns ARGC. 

  void dump (void) const;
  // Dump the state of an object.

  ACE_ALLOC_HOOK_DECLARE;
  // Declare the dynamic allocation hooks.

private:
  size_t argc_;
  // Number of arguments in the ARGV array. 

  char **argv_;
  // The array of string arguments. 
};

#if defined (__INLINE__)
#include "ace/ARGV.i"
#endif /* __INLINE__ */

#endif /* ACE_ARGUMENT_VECTOR_H */
