/*----------------------------------------------------------------------------*
 *  Copyright (c) 1991, 1992  Southeastern Universities Research Association, *
 *                            Continuous Electron Beam Accelerator Facility   *
 *                                                                            *
 *    This software was developed under a United States Government license    *
 *    described in the NOTICE file included as part of this distribution.     *
 *                                                                            *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606 *
 *       heyes@cebaf.gov   Tel: (804) 249-7030    Fax: (804) 249-7363         *
 *----------------------------------------------------------------------------*
 * Description: follows this header.
 *
 * Author:
 *	David Abbott
 *	CEBAF Data Acquisition Group
 *
 * Revision History:
 *	  Initial revision
 *
 *
 *----------------------------------------------------------------------------*/

 /* ts_trigLib.c -- Primitive trigger control for VME CPUs using the TJNAF 
                     Trigger Supervisor (revision 2) as a trigger source

 File : ts_trigLib.h

 Routines:
	   void tstriglink();       link in trigger isr
	   void tstenable();        enable trigger
	   void tstdisable();       disable trigger
           void tstack();           Acknowledge/Reset trigger
	   char tsttype();          read trigger type
	   int  tsttest();          test for trigger (POLL)

------------------------------------------------------------------------------*/


#define TS_VEC 0xec
#define TS_LEVEL 3

#ifdef VXWORKSPPC
#define INUM_TO_IVEC(intNum)    ((VOIDFUNCPTR *) (intNum))
#else
#define INUM_TO_IVEC(intNum)    ((VOIDFUNCPTR *) (intNum<<2))
#endif


static inline void 
tstriglink(isr)
     VOIDFUNCPTR isr;
{
  static FUNCPTR handlerPtr = (FUNCPTR) 0;
  
  if (handlerPtr)
    free(handlerPtr);

/* Write interrupt vector into ts register*/
  if(ts) {
    ts->intVec = TS_VEC;
  }else{
    printf("tstriglink: ERROR: ts pointer is NULL\n");
    return;
  } 
  
#ifndef VXWORKSPPC
  handlerPtr = intHandlerCreate(isr,0);
  intVecSet((VOIDFUNCPTR *) (INUM_TO_IVEC(TS_VEC)),(VOIDFUNCPTR) handlerPtr);
#else
  if((intDisconnect(INUM_TO_IVEC(TS_VEC)) !=0))
     printf("Error disconnecting Interrupt\n");
  intConnect(INUM_TO_IVEC(TS_VEC),isr,0);
#endif

}

static inline void 
tstenable(intMask)
 unsigned long intMask;
{
 int lock_key;

#ifndef POLLING_MODE
  lock_key = intLock();

  sysIntEnable(TS_LEVEL);       /* Enable VME Level 5 interrupts on CPU*/

#ifdef TRIG_SUPV
  ts->csr2 |= 0x1800;
#else
  ts->csr2 |= 0x0000;
#endif
  intUnlock(lock_key);

#else

#ifdef TRIG_SUPV
  ts->csr2 |= 0x1000;
#else
  ts->csr2 |= 0x0000;
#endif

#endif
}

static inline void 
tstdisable(intMask)
 unsigned long intMask;
{
  ts->csr2 &= ~(0x1800);
}

static inline void 
tstack(intMask)
 unsigned long intMask;
{
  ts->lrocBufStatus = 0x100;
}

static inline unsigned long 
tsttype()
{
 unsigned long tt;
#ifdef TRIG_SUPV
/* Read Trigger type from TS local Data register */
  tt = (((ts->lrocData)&0xfc)>>2);
  syncFlag = (ts->lrocData)&0x01;
  lateFail = ((ts->lrocData)&0x02)>>1;
#else
/* Set default trigger type to 1 */
  tt=1;
#endif
  return(tt);
}

static inline int 
tsttest()
{
  unsigned long val=0;

  val = ts->lrocBufStatus;
  if( (val != 0xffffffff) && ((val&0xf) != 0) ) {
    return (1);
  } else {
    return(0);
  }
}

