/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	Define layer 1 routines as macros which invoke more generic macros.
 *	
 * Author:  Chip Watson, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: fb_fscc_inline.h,v $
 *   Revision 1.1.1.1  1996/08/21 19:20:57  heyes
 *   Imported sources
 *
*	  Revision 1.1  94/03/15  12:00:26  12:00:26  heyes (Graham Heyes)
*	  Initial revision
*	  
 *	  Revision 1.1  1993/04/14  20:42:13  watson
 *	  Initial revision
 *
 *	  Revision 1.1  1993/03/16  13:59:13  heyes
 *	  Initial revision
 *
 *	  Revision 1.3  1992/08/26  14:45:12  watson
 *	  FNAL mods to remove EG from block broadcast
 *
 *	  Revision 1.2  1992/07/16  14:54:14  watson
 *	  added remaining block transfer wrappers
 *
 *	  Revision 1.1  1992/07/15  19:53:51  watson
 *	  Initial revision
 *
 */

#ifndef INCfbfsccinline
#define INCfbfsccinline

#include "fb_fscc_macro.h"

/************************* Single Word Transfers *****************************/

#define fb_frd_1(pa,sa,data,eg,noarb,nopa,nosa,noda,holdas,hold) \
  FB_RD_SINGLE(AD,pa,sa,data,eg,noarb,nopa,nosa,noda,holdas,hold)

#define fb_fwd_1(pa,sa,data,eg,noarb,nopa,nosa,noda,holdas,hold) \
  FB_WR_SINGLE(AD,pa,sa,data,eg,noarb,nopa,nosa,noda,holdas,hold)

#define fb_frc_1(pa,sa,data,eg,noarb,nopa,nosa,noda,holdas,hold) \
  FB_RD_SINGLE(AC,pa,sa,data,eg,noarb,nopa,nosa,noda,holdas,hold)

#define fb_fwc_1(pa,sa,data,eg,noarb,nopa,nosa,noda,holdas,hold) \
  FB_WR_SINGLE(AC,pa,sa,data,eg,noarb,nopa,nosa,noda,holdas,hold)

#define fb_frdm_1(pa,sa,data,noarb,nopa,nosa,noda,holdas,hold) \
  FB_RD_SINGLE(ADM,pa,sa,data,0,noarb,nopa,nosa,noda,holdas,hold)

#define fb_fwdm_1(pa,sa,data,noarb,nopa,nosa,noda,holdas,hold) \
  FB_WR_SINGLE(ADM,pa,sa,data,0,noarb,nopa,nosa,noda,holdas,hold)

#define fb_frcm_1(pa,sa,data,noarb,nopa,nosa,noda,holdas,hold) \
  FB_RD_SINGLE(ACM,pa,sa,data,0,noarb,nopa,nosa,noda,holdas,hold)

#define fb_fwcm_1(pa,sa,data,noarb,nopa,nosa,noda,holdas,hold) \
  FB_WR_SINGLE(ACM,pa,sa,data,0,noarb,nopa,nosa,noda,holdas,hold)

/****************************** Block  Transfers *****************************/

#define fb_frdb_1(pa,sa,data,maxb,eg, \
		  noarb,nopa,nosa,noda,pipe,holdas,hold,nowait) \
  FB_RD_BLOCK(AD,pa,sa,data,maxb,eg, \
	      noarb,nopa,nosa,noda,pipe,holdas,hold,nowait)

#define fb_fwdb_1(pa,sa,data,maxb,eg, \
		  noarb,nopa,nosa,noda,pipe,holdas,hold,nowait) \
  FB_WR_BLOCK(AD,pa,sa,data,maxb,eg, \
	      noarb,nopa,nosa,noda,pipe,holdas,hold,nowait)

#define fb_frcb_1(pa,sa,data,maxb,eg, \
		  noarb,nopa,nosa,noda,pipe,holdas,hold,nowait) \
  FB_RD_BLOCK(AC,pa,sa,data,maxb,eg, \
	      noarb,nopa,nosa,noda,pipe,holdas,hold,nowait)

#define fb_fwcb_1(pa,sa,data,maxb,eg, \
		  noarb,nopa,nosa,noda,pipe,holdas,hold,nowait) \
  FB_WR_BLOCK(AC,pa,sa,data,maxb,eg, \
	      noarb,nopa,nosa,noda,pipe,holdas,hold,nowait)

#define fb_frdbm_1(pa,sa,data,maxb, \
		  noarb,nopa,nosa,noda,pipe,holdas,hold,nowait) \
  FB_RD_BLOCK(ADM,pa,sa,data,maxb,0, \
	      noarb,nopa,nosa,noda,pipe,holdas,hold,nowait)

#define fb_fwdbm_1(pa,sa,data,maxb, \
		  noarb,nopa,nosa,noda,pipe,holdas,hold,nowait) \
  FB_WR_BLOCK(ADM,pa,sa,data,maxb,0, \
	      noarb,nopa,nosa,noda,pipe,holdas,hold,nowait)

#define fb_frcbm_1(pa,sa,data,maxb, \
		  noarb,nopa,nosa,noda,pipe,holdas,hold,nowait) \
  FB_RD_BLOCK(ACM,pa,sa,data,maxb,0, \
	      noarb,nopa,nosa,noda,pipe,holdas,hold,nowait)

#define fb_fwcbm_1(pa,sa,data,maxb, \
		  noarb,nopa,nosa,noda,pipe,holdas,hold,nowait) \
  FB_WR_BLOCK(ACM,pa,sa,data,maxb,0, \
	      noarb,nopa,nosa,noda,pipe,holdas,hold,nowait)

/*********************Secondary Address Routines ****************************
 *
 *  To write SA, just do a read call with no data transfer (address only)
 *  To read SA, use FB_RD_SA macro
 */

#define fb_frdsa_1(pa,sa,eg,noarb,nopa,nosa,holdas,hold) \
  FB_RD_SA(AD,pa,sa,eg,noarb,nopa,nosa,holdas,hold)

#define fb_fwdsa_1(pa,sa,eg,noarb,nopa,nosa,holdas,hold) \
  FB_RD_SINGLE(AD,pa,sa,0,eg,noarb,nopa,nosa,1,holdas,hold)

#define fb_frcsa_1(pa,sa,eg,noarb,nopa,nosa,holdas,hold) \
  FB_RD_SA(AC,pa,sa,eg,noarb,nopa,nosa,holdas,hold)

#define fb_fwcsa_1(pa,sa,eg,noarb,nopa,nosa,holdas,hold) \
  FB_RD_SINGLE(AC,pa,sa,0,eg,noarb,nopa,nosa,1,holdas,hold)

/*********************** Miscellaneous Routines ****************************/

#define fb_frlen_1(data) \
  FB_FRLEN_1(data)

#define fb_fbprst_1 \
  FB_FBPRST_1

#endif	/* ifndef INCfbfsccinline */
