#!/bin/sh
#\
exec $CODA_BIN/dpwish -f "$0" ${1+"$@"}
#


proc draw_menu {} {
    global env

    set images_library $env(CODA)/common/images

    set coda_logo [image create photo -file $images_library/gif/RCLogo.gif]

    set w [frame .f1 -bd 2 -relief raised]
   
    label $w.logo -bg grey -padx 0 -pady 0 -image $coda_logo 
    
    menubutton $w.file -menu $w.file.m -text File -underline 0 \
	-takefocus 0

    menu $w.file.m
    $w.file.m add command -label "Exit     " -command exit -underline 1 \
	-accelerator "Ctrl+X"
	
    # Accelerator bindings

    bind all <Control-x> "exit"
    pack $w.file -in $w -side left
    pack $w.logo -side left  -padx 6 -expand yes
    pack $w -side top -fill x -expand yes
    return $w
}

proc draw_title {} {
    set w [frame .title -relief raised -borderwidth 2]
    label $w.a -width 10 -relief ridge -borderwidth 2 \
	-text "Component"
    label $w.t -width 15 -relief ridge -borderwidth 2 \
	-text "nevents"
    label $w.f -width 10 -relief ridge -borderwidth 2 \
	-text "ev/Sec"
    label $w.g -width 20 -relief ridge -borderwidth 2 \
	-text "nlongs"
    label $w.h -width 20 -relief ridge -borderwidth 2 \
	-text "Bytes/S"

    pack $w.a $w.t $w.f $w.g $w.h -in $w -side left
    pack $w -side top
    return $w
}

proc draw_widget {item} {
    set w [frame .[string tolower $item]]
    label $w.a -width 10 -relief ridge -borderwidth 2
    label $w.t -width 15 -relief ridge -borderwidth 2
    label $w.f -width 10 -relief ridge -borderwidth 2
    label $w.g -width 20 -relief ridge -borderwidth 2
    label $w.h -width 20 -relief ridge -borderwidth 2

    pack $w.a $w.t $w.f $w.g $w.h -in $w -side left
    pack $w -side top
    return $w
}


proc update_rows {name w} {
    if {![catch "DP_ask $name statistics" res]} {
	$w.t config -text [lindex $res 0]
	$w.f config -text [lindex $res 1]
	$w.g config -text [lindex $res 2]
	$w.h config -text [lindex $res 3]
    }
    dp_after 10000 update_rows $name $w
}

if {$argc > 0} {
    draw_menu
    draw_title
    foreach item $argv {
	set w [draw_widget $item]
    
	$w.a config -text $item
   
	global [set item]_oevents [set item]_olongs

	set [set item]_oevents 0
	set [set item]_olongs 0

	update_rows $item $w
    }
} else {
    puts "usage : $argv0 \[?component_name? \[?component_name?\] ...\]"
    exit
}
