# Boot file for CODA ROC 2.5 
# PowerPC version

#loginUserAdd "abbottd","yzzbdbccd"

# Load host table
hostAdd "mizar","129.57.14.33"
hostAdd "mizar.jlab.org","129.57.14.33"
hostAdd "alcor","129.57.14.30"
hostAdd "alcor.jlab.org","129.57.14.30"


# NFS Mount CODA distribution disk
#nfsMount "mizar","/usr/local"

# Setup environment / load coda_roc
putenv "MSQL_TCP_HOST=mizar"
putenv "EXPID=experiment_0"
putenv "TCL_LIBRARY=/usr/local/coda/2.5/common/lib/tcl7.4"
putenv "ITCL_LIBRARY=/usr/local/coda/2.5/common/lib/itcl2.0"
putenv "DP_LIBRARY=/usr/local/coda/2.5/common/lib/dp"
putenv "CMLOG_PORT=8103"
putenv "CMLOG_HOST=alcor"  
putenv "TOKEN_PORT=5555"
putenv "SESSION=davetest"


# Download Message logging libraries/client
ld < /group/da/CMLOG/CMLOG-R2_1-PROD-1/bin/ppc/cmlogClientD
ld < /group/da/CMLOG/CMLOG-R2_1-PROD-1/lib/ppc/libcmlog.a
ld < /group/da/CMLOG/CMLOG-R2_1-PROD-1/bin/ppc/cmlogVxLogMsg


cd "/usr/local/coda/2.5/VXWORKSPPC/bin"
ld < coda_roc

cd "/mizar/home/abbottd/vxWorks/universeDma"
ld < universeDma.o

# Load f1tdc Library
ld< ../f1tdc/f1tdcLib.o
f1Init(0xed0000,0,0,2)

# Load Interrupt and mempart libraries
cd "../tir"
ld < vmeIntLib.o
ld < ../sfi/dmaPLib.o
dmaPartInit()

# Load Dual CPU library
#cd "/mizar/home/abbottd/vxWorks/dualCPU"
#ld<dcpuLib.o
#sp dcpuInit,0


# Load User readout routines
cd "../tir"
ld < vmeUserLib.o
vmeUserInit()

# Spawn tasks
sp cmlogClientD
#sp cmlogVxLogMsg
taskDelay (60*5)
taskSpawn ("ROC",200,8,250000,coda_roc,"","-s","davetest","-objects","ROC1 ROC")


