#!/usr/bin/perl -w

#  initcodadb.pl

#  creates and fills coda base tables in pre-existing database

#  still to to:

#  Problems
#    msql allows connection to non-existent database!


#  E.Wolin, Jefferson Lab, 30-oct-2003


use DBI;
    

#  Perl code:
#  ----------

#  defaults
$dbtype   = "mSQL";
$account  = "wolin";
$password = undef;
$help     = "\n  Usage:\n         initcodadb [-t dbtype] [-a account] [-p password] dbname session_name\n\n";


# decode command line args
$line=join(" ",@ARGV);
if($line =~ s/-h//i) { die $help;}
($dbtype   =  $1) if ($line =~ s/-t\s+(\S*)//i);
($account  =  $1) if ($line =~ s/-a\s+(\S*)//i);
($password =  $1) if ($line =~ s/-p\s+(\S*)//i);


# get dbname and default session name
($dbname=$1,$session=$2) if ($line=~s/^\s*(\S+)\s+(\S+)//);
if(!defined $dbname  || ($dbname =~/^\s*$/)) {die $help;}
if(!defined $session || ($session=~/^\s*$/)) {die $help;}


#  get connection to pre-existing database
($conn=DBI->connect("DBI:$dbtype:dbname=$dbname;",$account,$password,
		    {PrintError=>1,AutoCommit=>1})) 
    || die "Failed to connect to database $dbname\n";


#  double-check
print("\nPreparing to drop existing base tables if they exist...continue (y or n): ");
($char)=(<STDIN>=~/\s*(\S)/);
if(($char ne 'y')&&($char ne 'Y')) {
    print "\n  ...operation canceled...\n\n";
    exit;
};


#  init sessions table
print "...creating and filling sessions table\n";
$conn->do("drop table sessions");
$conn->do("CREATE TABLE sessions (name CHAR(64) NOT NULL PRIMARY KEY, id INT NOT NULL,".
	  "owner CHAR(32) NOT NULL, inuse CHAR(32) NOT NULL, log_name CHAR(32) NOT NULL,".
	  "rc_name CHAR(32) NOT NULL, runNumber INT NOT NULL, config CHAR(32) NOT NULL)");


#  create default session
chomp($owner=`uname -n`); chomp($owner.=" ".`whoami`); chomp($owner.=" ".`id -u`); chomp($owner.=" ".`id -g`);
$sql="INSERT INTO sessions (name,id,owner,inuse,log_name,rc_name,runNumber,config) ".
    "VALUES (\'$session\',0,\'$owner\',\'no\',\'${session}_msg\',\'RunControl\',0,\'\')";
$conn->do($sql);


#  init process table 
print "...creating process table\n";
$conn->do("drop table process");
$conn->do("CREATE TABLE process ( name CHAR(32) NOT NULL PRIMARY KEY, id INT NOT NULL,".
	  "cmd CHAR(128) NOT NULL, type CHAR(32) NOT NULL, host CHAR(32) NOT NULL,".
	  "port INT NOT NULL, state CHAR(32) NOT NULL, pid INT NOT NULL, inuse CHAR(32) NOT NULL,".
	  "clone CHAR(32) NOT NULL)");


#  init runTypes table
print "...creating runTypes table\n";
$conn->do("drop table runTypes");
$conn->do("CREATE TABLE runTypes (name CHAR(32) NOT NULL PRIMARY KEY, id INT NOT NULL,".
	  "inuse CHAR(32) NOT NULL, category CHAR(32) NOT NULL)");


#  init priority table
print "...creating and filling priority table\n";
$conn->do("drop table priority");
$conn->do("CREATE TABLE priority (class CHAR(32) NOT NULL, priority INT NOT NULL)");


#  create default priorities
$sql="INSERT INTO priority (class,priority) VALUES (\'ROC\',11)";   $conn->do($sql);
$sql="INSERT INTO priority (class,priority) VALUES (\'EB\',15)";    $conn->do($sql);
$sql="INSERT INTO priority (class,priority) VALUES (\'ANA\',19)";   $conn->do($sql);
$sql="INSERT INTO priority (class,priority) VALUES (\'ER'\,23)";    $conn->do($sql);
$sql="INSERT INTO priority (class,priority) VALUES (\'LOG\',27)";   $conn->do($sql);
$sql="INSERT INTO priority (class,priority) VALUES (\'TS\',-27)";   $conn->do($sql);


#  done
$conn->disconnect;
exit;


#-------------------------------------------------------------------------
