global env auto_path
set auto_path "$auto_path $env(CODA)/common/lib/daq"

DIALOG Dlog

class CMONITOR {

    public variable monitors  ""
    public common heartbeat 
    public common status    
    public variable socket ""
    public variable session ""
    public variable widget ""
    public variable server ""

    constructor {w {sess ""} {none no}} {}
    destructor {}

    public method setSession {sess} {}
    public method db {args} {}
    public method select {mon_name {screen ""} {geometry ""}} {}
    public method monitor_callback {} {}
    private method heartbeat_callback {obj stamp {conf ""}} {}
}

body CMONITOR::monitor_callback {} {

    foreach monitor $monitors {
	set ix 2
	set w [$monitor widget]

	set ordering [$monitor cget -ordering]

	db query "SELECT config FROM sessions WHERE name='$session'"
	set config [db get next]

	if { "$config" == "{}" } {
	    $w.text.text config -state normal
	    $w.text.text delete 2.0 end	
	    $w.text.text yview -pickplace end
	    $w.text.text config -state disabled
	    return
	}

	if {$ordering != "" } {
	    db query \
		"SELECT $config.name,process.id,process.type,process.host,process.port,process.state,process.pid,process.inuse FROM $config,process WHERE process.type<>'MONI' AND $config.name=process.name"
		#"SELECT $config.name,process.id,process.type,process.host,process.port,process.stateprocess.,pid,process.inuse FROM $config,process WHERE process.type<>'MONI' AND $config.name=process.name ORDER BY $ordering"
	} else {
	    db query \
		"SELECT $config.name,process.id,process.type,process.host,process.port,process.state,process.pid,process.inuse FROM $config,process WHERE process.type<>'MONI'AND $config.name=process.name "
	}
	set processes [db get rest]

	$w.text.text config -state normal
	$w.text.text delete 2.0 end		 
	set time [ns_systime]
	foreach proc $processes {

	    set tag  [lindex $proc 5]
	    set name [lindex $proc 0]
	    set type [lindex $proc 2 ]
	    set host [lindex $proc 3] 
	    set port [lindex $proc 4]
	    set pid  [lindex $proc 6]
	    set inuse [lindex $proc 7]
	    if { $pid == -1 } {
		catch "unset heartbeat($name)"
	    }
	    if {[catch "set heartbeat($name)" heart]} {
		set heart "NO Heartbeat     "
		$w.text.text tag configure $name -background grey
	    } else {
		if {[expr "$heart < $time - 10.0"]} {
			$w.text.text tag configure $name -background red -foreground white
			dp_after 500 $w.text.text tag configure $name -background yellow -foreground black
		} else {
		    $w.text.text tag configure $name -background green -foreground black
		}
		set heart [ns_ctime $heart "%D %T"]
	    }		        
	    if { "$tag" == "down" } {set tag DEAD}
	    $w.text.text insert $ix.0 \
		"\n" none \
		[format " %-8s " $name] ix$ix \
		" " none \
		[format "%-4s" $type] "$type ix$ix" \
		" " none \
		[format "%-5s" [string range $tag 0 4]] "$tag ix$ix" \
		" " none \
		[format "%-10s" $host] ix$ix \
		" " none \
		[format "%-3s" $inuse] "$inuse ix$ix" \
		" " none \
		" $heart " "$name ix$ix"

	    incr ix
	    set res ""
	    foreach item $status($name) {
		set ${name}.[string range [lindex $item 0] 1 end] [lindex $item 2]
	    }
	    set scale [MainWin::get -scale]
	    if { [expr $scale >= 1.0] } {
	    set res [format "%-5s%8d\n%-5s%8d\n%-5s%8d\n%-5s%8d\n" \
			 "evnb" [set ${name}.nevents] \
			 "nlng" [set ${name}.nlongs] \
			 "ev/s" [expr int([set ${name}.event_rate])] \
			 "lw/s" [expr int([set ${name}.data_rate])]]
	    ${name}.obj setText3 $res
	    } else {
		${name}.obj setText3 ""
	    }
	}
	$w.text.text yview -pickplace end
	$w.text.text config -state disabled
    }
    
    #dp_after 3000 itcl_context $this CMONITOR monitor_callback
}

body CMONITOR::constructor {w {sess ""} {none no}} {
    global env argv images_library
    set widget $w
 
    set main_log_window $w

    # Here follows a bit of database stuff...

    if [catch "database set database $env(EXPID)" ret ] {
	puts "Unable to open database for $env(EXPID) \"ret\""
    }
    if {"$sess" != "" } {
	set session $sess
	
	set server [NS_ServerInit $sess:monitor]
	puts "server on file $server"
	#dp_after 3000 itcl_context $this CMONITOR monitor_callback
    }
    select status
}

body CMONITOR::setSession {sess} {
    if {"$server" == "" } {
	set server [NS_ServerInit $sess:monitor]
    } else {
    catch "close $server"
	if {[catch "db query \"update process set name='$sess:monitor',host='[dp_hostname]',port=$server,state='alive',inuse='no' where name='$sess:monitor'\""]} {
	    db query "insert into process (name,id,cmd,type,host,port,state,pid,inuse,clone) values ('$sess:monitor',-1,' ','USER','[dp_hostname]',$server,'alive',[pid],'yes','no')"
	}
    }
    set session $sess
    
}

body CMONITOR::heartbeat_callback {obj stamp {conf {}}} {
    set heartbeat($obj) $stamp
    set status($obj) $conf
}

body CMONITOR::destructor {} {
    delete object ::CMONITOR::status
}
    
body CMONITOR::db {args} {
    return [eval "database $args"]
}

body CMONITOR::select {mon_name {screen ""} {geometry ""}} {
    global env errorInfo
    
    if [catch "LOG $mon_name $widget $screen $geometry" res] {
	puts "result $res"
	if {[$mon_name selected] != "yes"} {
	    $mon_name select
	}
    } else {
	set w [$mon_name widget]
	#set geom [wm geometry $w]
	$mon_name select  
    }

    lappend monitors $mon_name
    
}


class LOG {
    private variable the_name "unnamed"
    private variable widget ""
    private variable printer ""
    private variable screen ""
    private variable selected "yes"
    private variable address "coda@cebaf.gov"
    private variable index_tag "0"
    private variable load_time ""
    private variable dialog
    private variable melt 1
    public variable ordering "type,name"

    constructor {wl {screen ""} {geometry ""}} {}
    destructor {}
    
    public method widget {} {}

    public method name {{arg ""}} {}
    public method selected {} {}
    public method select {} {}
    public method unselect {} {}
    public method remove {} {}
    public method icon {bitmap} {}
    public method prepend {index proc tag time text} {}
    public method process {} {}
    public method unbind {} {}
    public method bind {cmd text} {}
    public method move { x y } {}
    
    public method clear {} {}
    public method save {} {}
    public method load {} {}
    public method print {} {}
    public method email {} {}
    public method up {} {}
    public method down {} {}
    public method filter {} {}
    public method screen {} {}
    public method freeze {} {}

    public method reorder {w tag title} {}
}

body LOG::reorder {w tag title} {
    set ul [ $w.text.text tag cget $tag -under]

    if { $ul == "y" } {
	$w.text.text tag configure $tag -under n
	set order [split $ordering ,]
	set ix [lsearch -exact $order $title]
	set order [lreplace $order $ix $ix]
	set ordering ""
	foreach thing $order {
	    if { $ordering != "" } {
		set ordering "$ordering,$title"
	    } else {
		set ordering "$thing"
	    }
	}
	
    } else {
	$w.text.text tag configure $tag -under y
	if { $ordering != "" } {
	    set ordering "$ordering,$title"
	} else {
	    set ordering "$title"
	}
    }
}

body LOG::constructor {wl {screen_arg ""} {geometry_arg ""}} {
    global env
    set name [string range $this [expr [string last : $this]+1] end]
    set the_name $name

    DIALOG Dlg_$name
    set dialog Dlg_$name

    global images_library coda_logo coda_devil env
    set images_library $env(CODA)/common/images
    
    if { ![info exist coda_logo] } {
	set coda_logo [image create photo -file $images_library/gif/RCLogo.gif]
	set coda_devil [image create photo -file $images_library/gif/devil.gif]
    }
    
    # The offset used to position log windows automatically.    
    frame $wl.f 
    pack $wl.f -fill both -expand 1
    set wl $wl.f
    set widget $wl

    set fontM "-*-helvetica-medium-r-normal--*-140-*"
    
    set fontT "-*-courier-medium-r-normal--*-140-*"
    
    frame $wl.top -bg grey 
    
    frame $wl.top.button 
    
    label  $wl.top.button.devil -highlightthickness 2 -image $coda_devil

    button $wl.top.button.save  -bg grey -padx 0 -pady 0 -text save \
	-command "$this save"
    button $wl.top.button.print  -bg grey -padx 0 -pady 0 -text print \
	-command "$this print"
    button $wl.top.button.email -bg grey -padx 0 -pady 0 -text email \
	-command "$this email"
    button $wl.top.button.up -bg grey -padx 0 -pady 0 -text up \
	-command "$this up"
    button $wl.top.button.down -bg grey -padx 0 -pady 0 -text down \
	-command "$this down"

    frame $wl.text -bg grey 
    scrollbar $wl.text.scrollbar -command "$wl.text.text yview" -relief sunken
    
    text $wl.text.text -bg grey -width 56 \
	-relief sunken -borderwidth 2 -font -*-courier-medium-r-normal--*-120-* \
	-yscrollcommand "$wl.text.scrollbar set" 

    ###################
    # SETTING GEOMETRY
    ###################
    pack $wl.top \
        -anchor nw -expand 0 -fill x -side top 
    pack $wl.top.button \
        -anchor nw -expand 0 -fill x -side top 
    pack $wl.top.button.devil \
        -anchor center -expand 0 -fill none -side right 
    pack $wl.top.button.save \
        -anchor center -expand 0 -fill none -padx 1 -pady 1 -side left 
    pack $wl.top.button.print \
        -anchor center -expand 0 -fill none -padx 1 -pady 1 -side left 
    pack $wl.top.button.email \
        -anchor center -expand 0 -fill none -padx 1 -pady 1 -side left 
    pack $wl.text \
        -anchor center -expand 1 -fill both -side top 
    pack $wl.text.text \
        -anchor center -expand 0 -fill y -padx 2 -pady 5 -side left 
    pack $wl.text.scrollbar \
        -anchor center -expand 0 -fill y -padx 2 -pady 5 -side left 

    set printer cb113q
    
    # This special purpose binding makes it possible to send
    # complete lines back to the interpreter that created this
    # window. This allows us to use a log window as a simple
    # command frontend.
    
    #bind $wl.text.text <Shift-Return> "LOG::process $log"
    #bind $wl.text.text <Control-n>    "LOG::clear $log"
    #bind $wl.text.text <Control-o>    "LOG::load $log"
    #bind $wl.text.text <Control-s>    "LOG::save $log"
    #bind $wl.text.text <Control-q>    "$log delete"

    $wl.text.text configure -spacing1 5
    $wl.text.text configure -spacing3 5

    set grey 1

    for {set ix 1} { $ix < 100 } {incr ix} {
	$wl.text.text tag configure ix$ix -borderwidth  2 -relief sunken -back grey8$grey
	set grey [expr $grey == 0]
    }

    $wl.text.text tag configure DEBUG \
	-background lightblue -borderwidth  2 -relief flat

    $wl.text.text tag configure CNTRL \
	-background white -borderwidth  2 -relief raised

    $wl.text.text tag configure ERROR \
	-background red -borderwidth  2 -relief raised
#    $wl.text.text tag bind ERROR <Button-1> "$this ERROR_handler $wl"


    $wl.text.text tag configure WARN \
	-background yellow -borderwidth 2 -relief raised

    # components
    $wl.text.text tag configure ROC \
	-background yellow -borderwidth  2 -relief flat -foreground black
    $wl.text.text tag configure EB \
	-background blue -borderwidth  2 -relief flat -foreground white
    $wl.text.text tag configure USER \
	-background white -borderwidth  2 -relief flat -foreground black
    $wl.text.text tag configure RCS \
	-background violet -borderwidth  2 -relief flat -foreground black
    $wl.text.text tag configure MONI \
	-background violet -borderwidth  2 -relief flat -foreground black

    #states
    $wl.text.text tag configure alive \
	-background green -borderwidth  2 -relief flat -foreground black
    $wl.text.text tag configure active \
	-background green -borderwidth  2 -relief flat -foreground black

    $wl.text.text tag configure dead \
	-background red -borderwidth 2 -relief flat -foreground white
    $wl.text.text tag configure unknown \
	-background red -borderwidth 2 -relief flat -foreground white

    $wl.text.text tag configure configured \
	-background yellow -borderwidth 2 -relief flat -foreground black
    $wl.text.text tag configure downloaded \
	-background violet -borderwidth 2 -relief flat -foreground black
    $wl.text.text tag configure paused \
	-background orange -borderwidth 2 -relief flat -foreground white
    $wl.text.text tag configure active \
	-background green -borderwidth 2 -relief flat -foreground black
 
    # inuse
    $wl.text.text tag configure yes \
	-background black -borderwidth  2 -relief flat -foreground white
    $wl.text.text tag configure no \
	-background white -borderwidth  2 -relief flat -foreground black
    
    # Position the log window on the screen.
    
    #wm withdraw $wl

    dp_atexit append "delete object $this"

    $wl.text.text insert 1.0 \
	Name "Title NameTitle" \
	"       " none \
	Type "Title TypeTitle" \
	" " none \
	State "Title StateTitle" \
	" " none \
	host "Title HostTitle" \
	"       " none \
	use "Title InuseTitle" \
	" " none \
	heartbeat "Title HeartbeatTitle" 

    set titles "NameTitle TypeTitle StateTitle HostTitle InuseTitle"
    set names  "name type state host inuse"
    set ix 0
    foreach title $titles {
	$wl.text.text tag bind $title <Button-1> "$this reorder $wl $title [lindex $names $ix]"
	incr ix
    }
    foreach nam [split $ordering ,] {
	set tag [lindex $titles [lsearch -exact $names $nam]]
	$wl.text.text tag configure $tag -underline y
    }
    $wl.text.text config -state disabled    
}

body LOG::destructor {} {
    catch "destroy $widget"
    delete object $dialog

    dp_atexit 
}
    
body LOG::name { {arg ""} } {
    if {$arg == ""} {
	return $the_name
    } else {
	set name $arg
	set the_name $arg
	#wm title $widget $name
	#wm iconname $widget $name
	    
	$widget.top.title.name config -relief sunken -text "$name"
	
    }
}
    
# hide a log window

body LOG::unselect {} {
    #wm withdraw $widget
}
    
# unhide a log window
    
body LOG::select {} {
    #wm deiconify $widget
    if {$selected == "yes" } {
	set selected no
    } else {
	set selected yes
    }
}

body LOG::selected {} {
    return $selected
}

body LOG::remove { } {
    delete object $this
}

body LOG::move { x y } {
    set wl $widget
    #wm geometry $wl 952x585+$x+$y
}

body LOG::icon { bitmap } {
    #wm iconbitmap $widget $bitmap
}

body LOG::bind { cmd text } {

    set w $widget.text.text

    if {[tk colormodel $w] == "color"} {
        set bold "-foreground red"
        set normal "-foreground {}"
    } else {
        set bold "-foreground white -background black"
        set normal "-foreground {} -background {}"
    }

    $w insert end "<"
    set start [$w index end]
    $w insert $start $text
    $w yview -pickplace end
    set end [$w index end]
    $w insert end ">"
    set tag "tag$start$end"
    $w tag add $tag $start $end

    $w tag configure $tag -underline true
    $w tag bind $tag <Any-Enter> "$w tag configure $tag $bold"
    $w tag bind $tag <Any-Leave> "$w tag configure $tag $normal"
    $w tag bind $tag <Button-3> "[$log interpreter] send $cmd"
    $w tag bind $tag <Button-1> "[$log interpreter] send $cmd"
}

body LOG::unbind { } {
    set w $widget.text.text
    foreach tag [$w tag names] {
	catch {$w tag delete $tag}
    }
}

body LOG::clear { } {
    $widget.text.text config -state normal
    $widget.text.text delete 0.0 end
    $widget.text.text config -state disabled

}

body LOG::up { } {
    $widget.text.text yview "@0,0 - 24 lines"
}

body LOG::down { } {
    $widget.text.text yview "@0,0 + 24 lines"
}

body LOG::save { } {
    $widget.top.button.save config -state disabled
    $dialog setscreen $screen
    $dialog fileselect $widget "Write $the_name to file " 
    set fname [$dialog result filename]
    if {$fname==""} {
	$widget.top.button.save config -state normal
	return
    }
    set mode "w"
    if {[file exists $fname]} {
	$dialog confirm $widget \
	    "File $fname already exists!" [list replace append cancel]
	set result [$dialog result confirm]

	switch [lindex $result 0] {
	    "cancel" {
		$widget.top.button.save config -state normal
		return
	    }
	    "replace" {
		set mode "w"
	    }
	    "append" {
		set mode "a"
	    }
	}
    }

    if {[catch {open $fname $mode} file]} {
	$dialog acknowledge $widget "Unable to open $fname."
	$widget.top.button.save config -state normal
	return
    }

    puts $file [$widget.text.text get 1.0 end]
    close $file
    $widget.top.button.save config -state normal
}

body LOG::print { } {
    $widget.top.button.print config -state disabled
    
    set fname "/tmp/tkined.log"
    catch {exec /bin/rm -f $fname}
    $dialog setscreen $screen
    if {[file exists $fname] && ![file writable $fname]} {
	$dialog acknowledge $widget "Can not write temporary file $fname."
	$widget.top.button.print config -state normal
	return
    }

    if {[catch {open $fname w} file]} {
	$dialog acknowledge $widget "Can not open $fname: $file"
	$widget.top.button.print config -state normal
	return
    }

    if {[catch {puts $file [$widget.text.text get 1.0 end]} err]} {
	$dialog acknowledge $widget "Failed to write $fname: $err"
	$widget.top.button.print config -state normal
	return
    }

    catch {close $file}
    $dialog request $widget \
	"Please enter a printer name:" \
	[list [list Printer: $printer]] \
	[list send cancel]
    set printer [$dialog result request]
    
    if {[lindex $printer 0] == "cancel"} {
	$widget.top.button.print config -state normal
	return
    }
    catch "exec lp -d [lindex $printer 1] $fname" res
    $widget.top.button.print config -state normal

}

body LOG::email { } {
    global env
    $dialog setscreen $screen
    $dialog request $widget \
	"Please enter the email address:" \
	[list [list To: $address] \
	     [list Subject: "log report $the_name"] ] \
	[list send cancel] 

    set result [$dialog result request]
    if {[lindex $result 0] == "cancel"} return

    set to [lindex $result 1]
    if { $to == "" } {
        $dialog acknowledge $widget "Sender required"
    }
    set address $to
    set subject [lindex $result 2]
   if { $subject == "" } {
        $dialog acknowledge $widget "Subject required"
    }

    if {[catch {split $env(PATH) :} path]} {
	set path "/usr/bin /bin /usr/ucb /usr/local/bin"
    }

    if {[catch {open "|mail $to" w} file]} {
        $dialog acknowledge $widget "Unable to write to $mprog $to"
        return
    }
    puts $file "Subject: $subject"
    puts $file [$widget.text.text get 1.0 end]
    puts $file "."
    ::update
    close $file
}

body LOG::widget {} {
    return $widget
}

msql connect database

#CMONITOR monitor ghtest
#monitor select status


