/* This file has been generated from the following Tcl source file(s): cmonitor.tcl
 * on Fri Jun  6 14:47:58 EDT 1997 by heyes
 */
#include <tcl.h>
static char initCmd[] = 
    "global env auto_path\n"
    "set auto_path \"$auto_path $env(CODA)/common/lib/daq\"\n"
    "\n"
    "DIALOG Dlog\n"
    "\n"
    "class CMONITOR {\n"
    "\n"
    "    public variable monitors  \"\"\n"
    "    public common heartbeat \n"
    "    public common status    \n"
    "    public variable socket \"\"\n"
    "    public variable session \"\"\n"
    "    public variable widget \"\"\n"
    "    public variable server \"\"\n"
    "\n"
    "    constructor {w {sess \"\"} {none no}} {}\n"
    "    destructor {}\n"
    "\n"
    "    public method setSession {sess} {}\n"
    "    public method db {args} {}\n"
    "    public method select {mon_name {screen \"\"} {geometry \"\"}} {}\n"
    "    public method monitor_callback {} {}\n"
    "    private method heartbeat_callback {obj stamp {conf \"\"}} {}\n"
    "}\n"
    "\n"
    "body CMONITOR::monitor_callback {} {\n"
    "\n"
    "    foreach monitor $monitors {\n"
    "	set ix 2\n"
    "	set w [$monitor widget]\n"
    "\n"
    "	set ordering [$monitor cget -ordering]\n"
    "\n"
    "	db query \"SELECT config FROM sessions WHERE name='$session'\"\n"
    "	set config [db get next]\n"
    "\n"
    "	if { \"$config\" == \"{}\" } {\n"
    "	    $w.text.text config -state normal\n"
    "	    $w.text.text delete 2.0 end	\n"
    "	    $w.text.text yview -pickplace end\n"
    "	    $w.text.text config -state disabled\n"
    "	    return\n"
    "	}\n"
    "\n"
    "	if {$ordering != \"\" } {\n"
    "	    db query \\\n"
    "		\"SELECT $config.name,process.id,process.type,process.host,process.port,process.state,process.pid,process.inuse FROM $config,process WHERE process.type<>'MONI' AND $config.name=process.name\"\n"
    "	} else {\n"
    "	    db query \\\n"
    "		\"SELECT $config.name,process.id,process.type,process.host,process.port,process.state,process.pid,process.inuse FROM $config,process WHERE process.type<>'MONI'AND $config.name=process.name \"\n"
    "	}\n"
    "	set processes [db get rest]\n"
    "\n"
    "	$w.text.text config -state normal\n"
    "	$w.text.text delete 2.0 end		 \n"
    "	set time [ns_systime]\n"
    "	foreach proc $processes {\n"
    "\n"
    "	    set tag  [lindex $proc 5]\n"
    "	    set name [lindex $proc 0]\n"
    "	    set type [lindex $proc 2 ]\n"
    "	    set host [lindex $proc 3] \n"
    "	    set port [lindex $proc 4]\n"
    "	    set pid  [lindex $proc 6]\n"
    "	    set inuse [lindex $proc 7]\n"
    "	    if { $pid == -1 } {\n"
    "		catch \"unset heartbeat($name)\"\n"
    "	    }\n"
    "	    if {[catch \"set heartbeat($name)\" heart]} {\n"
    "		set heart \"NO Heartbeat     \"\n"
    "		$w.text.text tag configure $name -background grey\n"
    "	    } else {\n"
    "		if {[expr \"$heart < $time - 10.0\"]} {\n"
    "			$w.text.text tag configure $name -background red -foreground white\n"
    "			dp_after 500 $w.text.text tag configure $name -background yellow -foreground black\n"
    "		} else {\n"
    "		    $w.text.text tag configure $name -background green -foreground black\n"
    "		}\n"
    "		set heart [ns_ctime $heart \"%D %T\"]\n"
    "	    }		        \n"
    "	    if { \"$tag\" == \"down\" } {set tag DEAD}\n"
    "	    $w.text.text insert $ix.0 \\\n"
    "		\"\\n\" none \\\n"
    "		[format \" %-8s \" $name] ix$ix \\\n"
    "		\" \" none \\\n"
    "		[format \"%-4s\" $type] \"$type ix$ix\" \\\n"
    "		\" \" none \\\n"
    "		[format \"%-5s\" [string range $tag 0 4]] \"$tag ix$ix\" \\\n"
    "		\" \" none \\\n"
    "		[format \"%-10s\" $host] ix$ix \\\n"
    "		\" \" none \\\n"
    "		[format \"%-3s\" $inuse] \"$inuse ix$ix\" \\\n"
    "		\" \" none \\\n"
    "		\" $heart \" \"$name ix$ix\"\n"
    "\n"
    "	    incr ix\n"
    "	    set res \"\"\n"
    "	    foreach item $status($name) {\n"
    "		set ${name}.[string range [lindex $item 0] 1 end] [lindex $item 2]\n"
    "	    }\n"
    "	    set scale [MainWin::get -scale]\n"
    "	    if { [expr $scale >= 1.0] } {\n"
    "	    set res [format \"%-5s%8d\\n%-5s%8d\\n%-5s%8d\\n%-5s%8d\\n\" \\\n"
    "			 \"evnb\" [set ${name}.nevents] \\\n"
    "			 \"nlng\" [set ${name}.nlongs] \\\n"
    "			 \"ev/s\" [expr int([set ${name}.event_rate])] \\\n"
    "			 \"lw/s\" [expr int([set ${name}.data_rate])]]\n"
    "	    ${name}.obj setText3 $res\n"
    "	    } else {\n"
    "		${name}.obj setText3 \"\"\n"
    "	    }\n"
    "	}\n"
    "	$w.text.text yview -pickplace end\n"
    "	$w.text.text config -state disabled\n"
    "    }\n"
    "    \n"
    "}\n"
    "\n"
    "body CMONITOR::constructor {w {sess \"\"} {none no}} {\n"
    "    global env argv images_library\n"
    "    set widget $w\n"
    " \n"
    "    set main_log_window $w\n"
    "\n"
    "\n"
    "    if [catch \"database set database $env(EXPID)\" ret ] {\n"
    "	puts \"Unable to open database for $env(EXPID) \\\"ret\\\"\"\n"
    "    }\n"
    "    if {\"$sess\" != \"\" } {\n"
    "	set session $sess\n"
    "	\n"
    "	set server [NS_ServerInit $sess:monitor]\n"
    "	puts \"server on file $server\"\n"
    "    }\n"
    "    select status\n"
    "}\n"
    "\n"
    "body CMONITOR::setSession {sess} {\n"
    "    if {\"$server\" == \"\" } {\n"
    "	set server [NS_ServerInit $sess:monitor]\n"
    "    } else {\n"
    "    catch \"close $server\"\n"
    "	if {[catch \"db query \\\"update process set name='$sess:monitor',host='[dp_hostname]',port=$server,state='alive',inuse='no' where name='$sess:monitor'\\\"\"]} {\n"
    "	    db query \"insert into process (name,id,cmd,type,host,port,state,pid,inuse,clone) values ('$sess:monitor',-1,' ','USER','[dp_hostname]',$server,'alive',[pid],'yes','no')\"\n"
    "	}\n"
    "    }\n"
    "    set session $sess\n"
    "    \n"
    "}\n"
    "\n"
    "body CMONITOR::heartbeat_callback {obj stamp {conf {}}} {\n"
    "    set heartbeat($obj) $stamp\n"
    "    set status($obj) $conf\n"
    "}\n"
    "\n"
    "body CMONITOR::destructor {} {\n"
    "    delete object ::CMONITOR::status\n"
    "}\n"
    "    \n"
    "body CMONITOR::db {args} {\n"
    "    return [eval \"database $args\"]\n"
    "}\n"
    "\n"
    "body CMONITOR::select {mon_name {screen \"\"} {geometry \"\"}} {\n"
    "    global env errorInfo\n"
    "    \n"
    "    if [catch \"LOG $mon_name $widget $screen $geometry\" res] {\n"
    "	puts \"result $res\"\n"
    "	if {[$mon_name selected] != \"yes\"} {\n"
    "	    $mon_name select\n"
    "	}\n"
    "    } else {\n"
    "	set w [$mon_name widget]\n"
    "	$mon_name select  \n"
    "    }\n"
    "\n"
    "    lappend monitors $mon_name\n"
    "    \n"
    "}\n"
    "\n"
    "\n"
    "class LOG {\n"
    "    private variable the_name \"unnamed\"\n"
    "    private variable widget \"\"\n"
    "    private variable printer \"\"\n"
    "    private variable screen \"\"\n"
    "    private variable selected \"yes\"\n"
    "    private variable address \"coda@cebaf.gov\"\n"
    "    private variable index_tag \"0\"\n"
    "    private variable load_time \"\"\n"
    "    private variable dialog\n"
    "    private variable melt 1\n"
    "    public variable ordering \"type,name\"\n"
    "\n"
    "    constructor {wl {screen \"\"} {geometry \"\"}} {}\n"
    "    destructor {}\n"
    "    \n"
    "    public method widget {} {}\n"
    "\n"
    "    public method name {{arg \"\"}} {}\n"
    "    public method selected {} {}\n"
    "    public method select {} {}\n"
    "    public method unselect {} {}\n"
    "    public method remove {} {}\n"
    "    public method icon {bitmap} {}\n"
    "    public method prepend {index proc tag time text} {}\n"
    "    public method process {} {}\n"
    "    public method unbind {} {}\n"
    "    public method bind {cmd text} {}\n"
    "    public method move { x y } {}\n"
    "    \n"
    "    public method clear {} {}\n"
    "    public method save {} {}\n"
    "    public method load {} {}\n"
    "    public method print {} {}\n"
    "    public method email {} {}\n"
    "    public method up {} {}\n"
    "    public method down {} {}\n"
    "    public method filter {} {}\n"
    "    public method screen {} {}\n"
    "    public method freeze {} {}\n"
    "\n"
    "    public method reorder {w tag title} {}\n"
    "}\n"
    "\n"
    "body LOG::reorder {w tag title} {\n"
    "    set ul [ $w.text.text tag cget $tag -under]\n"
    "\n"
    "    if { $ul == \"y\" } {\n"
    "	$w.text.text tag configure $tag -under n\n"
    "	set order [split $ordering ,]\n"
    "	set ix [lsearch -exact $order $title]\n"
    "	set order [lreplace $order $ix $ix]\n"
    "	set ordering \"\"\n"
    "	foreach thing $order {\n"
    "	    if { $ordering != \"\" } {\n"
    "		set ordering \"$ordering,$title\"\n"
    "	    } else {\n"
    "		set ordering \"$thing\"\n"
    "	    }\n"
    "	}\n"
    "	\n"
    "    } else {\n"
    "	$w.text.text tag configure $tag -under y\n"
    "	if { $ordering != \"\" } {\n"
    "	    set ordering \"$ordering,$title\"\n"
    "	} else {\n"
    "	    set ordering \"$title\"\n"
    "	}\n"
    "    }\n"
    "}\n"
    "\n"
    "body LOG::constructor {wl {screen_arg \"\"} {geometry_arg \"\"}} {\n"
    "    global env\n"
    "    set name [string range $this [expr [string last : $this]+1] end]\n"
    "    set the_name $name\n"
    "\n"
    "    DIALOG Dlg_$name\n"
    "    set dialog Dlg_$name\n"
    "\n"
    "    global images_library coda_logo coda_devil env\n"
    "    set images_library $env(CODA)/common/images\n"
    "    \n"
    "    if { ![info exist coda_logo] } {\n"
    "	set coda_logo [image create photo -file $images_library/gif/RCLogo.gif]\n"
    "	set coda_devil [image create photo -file $images_library/gif/devil.gif]\n"
    "    }\n"
    "    \n"
    "    frame $wl.f \n"
    "    pack $wl.f -fill both -expand 1\n"
    "    set wl $wl.f\n"
    "    set widget $wl\n"
    "\n"
    "    set fontM \"-*-helvetica-medium-r-normal--*-140-*\"\n"
    "    \n"
    "    set fontT \"-*-courier-medium-r-normal--*-140-*\"\n"
    "    \n"
    "    frame $wl.top -bg grey \n"
    "    \n"
    "    frame $wl.top.button \n"
    "    \n"
    "    label  $wl.top.button.devil -highlightthickness 2 -image $coda_devil\n"
    "\n"
    "    button $wl.top.button.save  -bg grey -padx 0 -pady 0 -text save \\\n"
    "	-command \"$this save\"\n"
    "    button $wl.top.button.print  -bg grey -padx 0 -pady 0 -text print \\\n"
    "	-command \"$this print\"\n"
    "    button $wl.top.button.email -bg grey -padx 0 -pady 0 -text email \\\n"
    "	-command \"$this email\"\n"
    "    button $wl.top.button.up -bg grey -padx 0 -pady 0 -text up \\\n"
    "	-command \"$this up\"\n"
    "    button $wl.top.button.down -bg grey -padx 0 -pady 0 -text down \\\n"
    "	-command \"$this down\"\n"
    "\n"
    "    frame $wl.text -bg grey \n"
    "    scrollbar $wl.text.scrollbar -command \"$wl.text.text yview\" -relief sunken\n"
    "    \n"
    "    text $wl.text.text -bg grey -width 56 \\\n"
    "	-relief sunken -borderwidth 2 -font -*-courier-medium-r-normal--*-120-* \\\n"
    "	-yscrollcommand \"$wl.text.scrollbar set\" \n"
    "\n"
    "    pack $wl.top \\\n"
    "        -anchor nw -expand 0 -fill x -side top \n"
    "    pack $wl.top.button \\\n"
    "        -anchor nw -expand 0 -fill x -side top \n"
    "    pack $wl.top.button.devil \\\n"
    "        -anchor center -expand 0 -fill none -side right \n"
    "    pack $wl.top.button.save \\\n"
    "        -anchor center -expand 0 -fill none -padx 1 -pady 1 -side left \n"
    "    pack $wl.top.button.print \\\n"
    "        -anchor center -expand 0 -fill none -padx 1 -pady 1 -side left \n"
    "    pack $wl.top.button.email \\\n"
    "        -anchor center -expand 0 -fill none -padx 1 -pady 1 -side left \n"
    "    pack $wl.text \\\n"
    "        -anchor center -expand 1 -fill both -side top \n"
    "    pack $wl.text.text \\\n"
    "        -anchor center -expand 0 -fill y -padx 2 -pady 5 -side left \n"
    "    pack $wl.text.scrollbar \\\n"
    "        -anchor center -expand 0 -fill y -padx 2 -pady 5 -side left \n"
    "\n"
    "    set printer cb113q\n"
    "    \n"
    "    \n"
    "\n"
    "    $wl.text.text configure -spacing1 5\n"
    "    $wl.text.text configure -spacing3 5\n"
    "\n"
    "    set grey 1\n"
    "\n"
    "    for {set ix 1} { $ix < 100 } {incr ix} {\n"
    "	$wl.text.text tag configure ix$ix -borderwidth  2 -relief sunken -back grey8$grey\n"
    "	set grey [expr $grey == 0]\n"
    "    }\n"
    "\n"
    "    $wl.text.text tag configure DEBUG \\\n"
    "	-background lightblue -borderwidth  2 -relief flat\n"
    "\n"
    "    $wl.text.text tag configure CNTRL \\\n"
    "	-background white -borderwidth  2 -relief raised\n"
    "\n"
    "    $wl.text.text tag configure ERROR \\\n"
    "	-background red -borderwidth  2 -relief raised\n"
    "\n"
    "\n"
    "    $wl.text.text tag configure WARN \\\n"
    "	-background yellow -borderwidth 2 -relief raised\n"
    "\n"
    "    $wl.text.text tag configure ROC \\\n"
    "	-background yellow -borderwidth  2 -relief flat -foreground black\n"
    "    $wl.text.text tag configure EB \\\n"
    "	-background blue -borderwidth  2 -relief flat -foreground white\n"
    "    $wl.text.text tag configure USER \\\n"
    "	-background white -borderwidth  2 -relief flat -foreground black\n"
    "    $wl.text.text tag configure RCS \\\n"
    "	-background violet -borderwidth  2 -relief flat -foreground black\n"
    "    $wl.text.text tag configure MONI \\\n"
    "	-background violet -borderwidth  2 -relief flat -foreground black\n"
    "\n"
    "    $wl.text.text tag configure alive \\\n"
    "	-background green -borderwidth  2 -relief flat -foreground black\n"
    "    $wl.text.text tag configure active \\\n"
    "	-background green -borderwidth  2 -relief flat -foreground black\n"
    "\n"
    "    $wl.text.text tag configure dead \\\n"
    "	-background red -borderwidth 2 -relief flat -foreground white\n"
    "    $wl.text.text tag configure unknown \\\n"
    "	-background red -borderwidth 2 -relief flat -foreground white\n"
    "\n"
    "    $wl.text.text tag configure configured \\\n"
    "	-background yellow -borderwidth 2 -relief flat -foreground black\n"
    "    $wl.text.text tag configure downloaded \\\n"
    "	-background violet -borderwidth 2 -relief flat -foreground black\n"
    "    $wl.text.text tag configure paused \\\n"
    "	-background orange -borderwidth 2 -relief flat -foreground white\n"
    "    $wl.text.text tag configure active \\\n"
    "	-background green -borderwidth 2 -relief flat -foreground black\n"
    " \n"
    "    $wl.text.text tag configure yes \\\n"
    "	-background black -borderwidth  2 -relief flat -foreground white\n"
    "    $wl.text.text tag configure no \\\n"
    "	-background white -borderwidth  2 -relief flat -foreground black\n"
    "    \n"
    "    \n"
    "\n"
    "    dp_atexit append \"delete object $this\"\n"
    "\n"
    "    $wl.text.text insert 1.0 \\\n"
    "	Name \"Title NameTitle\" \\\n"
    "	\"       \" none \\\n"
    "	Type \"Title TypeTitle\" \\\n"
    "	\" \" none \\\n"
    "	State \"Title StateTitle\" \\\n"
    "	\" \" none \\\n"
    "	host \"Title HostTitle\" \\\n"
    "	\"       \" none \\\n"
    "	use \"Title InuseTitle\" \\\n"
    "	\" \" none \\\n"
    "	heartbeat \"Title HeartbeatTitle\" \n"
    "\n"
    "    set titles \"NameTitle TypeTitle StateTitle HostTitle InuseTitle\"\n"
    "    set names  \"name type state host inuse\"\n"
    "    set ix 0\n"
    "    foreach title $titles {\n"
    "	$wl.text.text tag bind $title <Button-1> \"$this reorder $wl $title [lindex $names $ix]\"\n"
    "	incr ix\n"
    "    }\n"
    "    foreach nam [split $ordering ,] {\n"
    "	set tag [lindex $titles [lsearch -exact $names $nam]]\n"
    "	$wl.text.text tag configure $tag -underline y\n"
    "    }\n"
    "    $wl.text.text config -state disabled    \n"
    "}\n"
    "\n"
    "body LOG::destructor {} {\n"
    "    catch \"destroy $widget\"\n"
    "    delete object $dialog\n"
    "\n"
    "    dp_atexit \n"
    "}\n"
    "    \n"
    "body LOG::name { {arg \"\"} } {\n"
    "    if {$arg == \"\"} {\n"
    "	return $the_name\n"
    "    } else {\n"
    "	set name $arg\n"
    "	set the_name $arg\n"
    "	    \n"
    "	$widget.top.title.name config -relief sunken -text \"$name\"\n"
    "	\n"
    "    }\n"
    "}\n"
    "    \n"
    "\n"
    "body LOG::unselect {} {\n"
    "}\n"
    "    \n"
    "    \n"
    "body LOG::select {} {\n"
    "    if {$selected == \"yes\" } {\n"
    "	set selected no\n"
    "    } else {\n"
    "	set selected yes\n"
    "    }\n"
    "}\n"
    "\n"
    "body LOG::selected {} {\n"
    "    return $selected\n"
    "}\n"
    "\n"
    "body LOG::remove { } {\n"
    "    delete object $this\n"
    "}\n"
    "\n"
    "body LOG::move { x y } {\n"
    "    set wl $widget\n"
    "}\n"
    "\n"
    "body LOG::icon { bitmap } {\n"
    "}\n"
    "\n"
    "body LOG::bind { cmd text } {\n"
    "\n"
    "    set w $widget.text.text\n"
    "\n"
    "    if {[tk colormodel $w] == \"color\"} {\n"
    "        set bold \"-foreground red\"\n"
    "        set normal \"-foreground {}\"\n"
    "    } else {\n"
    "        set bold \"-foreground white -background black\"\n"
    "        set normal \"-foreground {} -background {}\"\n"
    "    }\n"
    "\n"
    "    $w insert end \"<\"\n"
    "    set start [$w index end]\n"
    "    $w insert $start $text\n"
    "    $w yview -pickplace end\n"
    "    set end [$w index end]\n"
    "    $w insert end \">\"\n"
    "    set tag \"tag$start$end\"\n"
    "    $w tag add $tag $start $end\n"
    "\n"
    "    $w tag configure $tag -underline true\n"
    "    $w tag bind $tag <Any-Enter> \"$w tag configure $tag $bold\"\n"
    "    $w tag bind $tag <Any-Leave> \"$w tag configure $tag $normal\"\n"
    "    $w tag bind $tag <Button-3> \"[$log interpreter] send $cmd\"\n"
    "    $w tag bind $tag <Button-1> \"[$log interpreter] send $cmd\"\n"
    "}\n"
    "\n"
    "body LOG::unbind { } {\n"
    "    set w $widget.text.text\n"
    "    foreach tag [$w tag names] {\n"
    "	catch {$w tag delete $tag}\n"
    "    }\n"
    "}\n"
    "\n"
    "body LOG::clear { } {\n"
    "    $widget.text.text config -state normal\n"
    "    $widget.text.text delete 0.0 end\n"
    "    $widget.text.text config -state disabled\n"
    "\n"
    "}\n"
    "\n"
    "body LOG::up { } {\n"
    "    $widget.text.text yview \"@0,0 - 24 lines\"\n"
    "}\n"
    "\n"
    "body LOG::down { } {\n"
    "    $widget.text.text yview \"@0,0 + 24 lines\"\n"
    "}\n"
    "\n"
    "body LOG::save { } {\n"
    "    $widget.top.button.save config -state disabled\n"
    "    $dialog setscreen $screen\n"
    "    $dialog fileselect $widget \"Write $the_name to file \" \n"
    "    set fname [$dialog result filename]\n"
    "    if {$fname==\"\"} {\n"
    "	$widget.top.button.save config -state normal\n"
    "	return\n"
    "    }\n"
    "    set mode \"w\"\n"
    "    if {[file exists $fname]} {\n"
    "	$dialog confirm $widget \\\n"
    "	    \"File $fname already exists!\" [list replace append cancel]\n"
    "	set result [$dialog result confirm]\n"
    "\n"
    "	switch [lindex $result 0] {\n"
    "	    \"cancel\" {\n"
    "		$widget.top.button.save config -state normal\n"
    "		return\n"
    "	    }\n"
    "	    \"replace\" {\n"
    "		set mode \"w\"\n"
    "	    }\n"
    "	    \"append\" {\n"
    "		set mode \"a\"\n"
    "	    }\n"
    "	}\n"
    "    }\n"
    "\n"
    "    if {[catch {open $fname $mode} file]} {\n"
    "	$dialog acknowledge $widget \"Unable to open $fname.\"\n"
    "	$widget.top.button.save config -state normal\n"
    "	return\n"
    "    }\n"
    "\n"
    "    puts $file [$widget.text.text get 1.0 end]\n"
    "    close $file\n"
    "    $widget.top.button.save config -state normal\n"
    "}\n"
    "\n"
    "body LOG::print { } {\n"
    "    $widget.top.button.print config -state disabled\n"
    "    \n"
    "    set fname \"/tmp/tkined.log\"\n"
    "    catch {exec /bin/rm -f $fname}\n"
    "    $dialog setscreen $screen\n"
    "    if {[file exists $fname] && ![file writable $fname]} {\n"
    "	$dialog acknowledge $widget \"Can not write temporary file $fname.\"\n"
    "	$widget.top.button.print config -state normal\n"
    "	return\n"
    "    }\n"
    "\n"
    "    if {[catch {open $fname w} file]} {\n"
    "	$dialog acknowledge $widget \"Can not open $fname: $file\"\n"
    "	$widget.top.button.print config -state normal\n"
    "	return\n"
    "    }\n"
    "\n"
    "    if {[catch {puts $file [$widget.text.text get 1.0 end]} err]} {\n"
    "	$dialog acknowledge $widget \"Failed to write $fname: $err\"\n"
    "	$widget.top.button.print config -state normal\n"
    "	return\n"
    "    }\n"
    "\n"
    "    catch {close $file}\n"
    "    $dialog request $widget \\\n"
    "	\"Please enter a printer name:\" \\\n"
    "	[list [list Printer: $printer]] \\\n"
    "	[list send cancel]\n"
    "    set printer [$dialog result request]\n"
    "    \n"
    "    if {[lindex $printer 0] == \"cancel\"} {\n"
    "	$widget.top.button.print config -state normal\n"
    "	return\n"
    "    }\n"
    "    catch \"exec lp -d [lindex $printer 1] $fname\" res\n"
    "    $widget.top.button.print config -state normal\n"
    "\n"
    "}\n"
    "\n"
    "body LOG::email { } {\n"
    "    global env\n"
    "    $dialog setscreen $screen\n"
    "    $dialog request $widget \\\n"
    "	\"Please enter the email address:\" \\\n"
    "	[list [list To: $address] \\\n"
    "	     [list Subject: \"log report $the_name\"] ] \\\n"
    "	[list send cancel] \n"
    "\n"
    "    set result [$dialog result request]\n"
    "    if {[lindex $result 0] == \"cancel\"} return\n"
    "\n"
    "    set to [lindex $result 1]\n"
    "    if { $to == \"\" } {\n"
    "        $dialog acknowledge $widget \"Sender required\"\n"
    "    }\n"
    "    set address $to\n"
    "    set subject [lindex $result 2]\n"
    "   if { $subject == \"\" } {\n"
    "        $dialog acknowledge $widget \"Subject required\"\n"
    "    }\n"
    "\n"
    "    if {[catch {split $env(PATH) :} path]} {\n"
    "	set path \"/usr/bin /bin /usr/ucb /usr/local/bin\"\n"
    "    }\n"
    "\n"
    "    if {[catch {open \"|mail $to\" w} file]} {\n"
    "        $dialog acknowledge $widget \"Unable to write to $mprog $to\"\n"
    "        return\n"
    "    }\n"
    "    puts $file \"Subject: $subject\"\n"
    "    puts $file [$widget.text.text get 1.0 end]\n"
    "    puts $file \".\"\n"
    "    ::update\n"
    "    close $file\n"
    "}\n"
    "\n"
    "body LOG::widget {} {\n"
    "    return $widget\n"
    "}\n"
    "\n"
    "msql connect database\n"
    "\n"
    "\n"
    "\n"
    ;
/* End of Tcl code */
/* Init routine to drag this code into our program...*/
int cmonitor_Init (Tcl_Interp *interp)
{
    if (Tcl_Eval(interp,initCmd) != 0) {
       printf("tcl error : %s\n",interp->result);
       return TCL_ERROR;
    }
    return TCL_OK;
}
/* End of C code */
