/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	Support routines for the CAMAC RPC server
 *	
 * Author:  Chip Watson, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: tsSrvrLib.c,v $
 *   Revision 1.1  2000/08/17 19:22:43  abbottd
 *   Initial Revision
 *
*	  Revision 1.1  94/03/16  07:53:20  07:53:20  heyes (Graham Heyes)
*	  Initial revision
*	  
*	  Revision 1.1  94/03/15  11:47:24  11:47:24  heyes (Graham Heyes)
*	  Initial revision
*	  
 *	  Revision 1.1  1992/06/05  20:21:45  watson
 *	  Initial revision
 *
 */

#include <stdio.h>
#include <rpc/rpc.h>
#include "tsRpc.h"
#include "ts.h"
#include "ts_macros.h"



#ifdef VXWORKS

/* External Global Definitions  */
extern int sysLocalToBusAdrs();

void rpcTaskInit();

/* vxServerInit() must be called on VxWorks CPUs before any RPC
   library routines are called */
void vxServerInit()
{
  (void) rpcTaskInit();
}
#endif


int *ts_rpctsinit1_1(arg)
     TS_AF *arg;
{
  static int r;
  r = ts_init_1(arg->laddr,arg->iflag);
  return(&r);
}

int *ts_rpctsmeminit_1()
{
  static int r;
  r = tsMemInit();
  return(&r);
}

int *ts_rpctscsr_1(arg)
     unsigned long *arg;
{
  static unsigned long r;
  r = tsCsr(*arg);
  return( (int *)&r);
}

int *ts_rpctstrig_1(arg)
     unsigned long *arg;
{
  static unsigned long r;
  r = tsTrig(*arg);
  return( (int *)&r);
}

int *ts_rpctsroc_1(arg)
     TS_4CHAR *arg;
{
  static unsigned long r;
  r = tsRoc(arg->b4,arg->b3,arg->b2,arg->b1);
  return( (int *)&r);
}

int *ts_rpctssync_1(arg)
     unsigned long *arg;
{
  static unsigned long r;
  r = tsSync(*arg);
  return( (int *)&r);
}

int *ts_rpctsprescale_1(arg)
     TS_NV *arg;
{
  static unsigned long r;
  r = tsPrescale(arg->Num,arg->val);
  return( (int *)&r);
}

int *ts_rpctstimer_1(arg)
     TS_NV *arg;
{
  static unsigned long r;
  r = tsTimer(arg->Num,arg->val);
  return( (int *)&r);
}

int *ts_rpctsmemory_1(arg)
     TS_NV *arg;
{
  static unsigned long r;
  r = tsMemory(arg->Num,arg->val);
  return( (int *)&r);
}

int *ts_rpctsread_1(arg)
     TS_RN *arg;
{
  static unsigned long r;
  r = tsRead(arg->Reg,arg->Num);
  return( (int *)&r);
}

int *ts_rpctswrite_1(arg)
     TS_RNV *arg;
{
  static unsigned long r;
  r = tsWrite(arg->Reg,arg->Num,arg->Val);
  return( (int *)&r);
}

int *ts_rpctsstatus_1(arg)
     int *arg;
{
  static unsigned long r;
  r = tsStatus(*arg);
  return((int *)&r);
}

int *ts_rpctsstate_1(arg)
     int *arg;
{
  static unsigned long r;
  r = tsState(*arg);
  return((int *)&r);
}

void *ts_rpctstimerstatus_1(arg)
     int *arg;
{
  static int r;
  (void) tsTimerStatus(*arg);
  return;
}

void *ts_rpctstriggerstatus_1(arg)
     unsigned long *arg;
{
  static int r;
  (void) tsTriggerStatus(*arg);
  return;
}

void *ts_rpctsgo_1(arg)
     int *arg;
{
  static int r;
  (void) tsGo(*arg);
  return;
}

void *ts_rpctsstop_1(arg)
     int *arg;
{
  static int r;
  (void) tsStop(*arg);
  return;
}

void *ts_rpctsinit_1(arg)
     int *arg;
{
  static int r;
  (void) tsInit(*arg);
  return;
}


