// CDEV access calls for tcl
// Johannes van Zeijts, March 95, first version
//                      May   95, second version, using Walt Akers callback example 

#include <stdarg.h>

#include <tcl.h>
#include <tk.h>

#include <ctype.h>
#include <string.h>
#include <iostream.h>
#include <math.h>
#include <dlfcn.h>

// cdev includes
#include <cdevSystem.h>
#include <cdevRequestObject.h>
#include <cdevDevice.h>
#include <cdevGroup.h>
#include <cdevData.h>

class callbackInfo {
public:
  callbackInfo (Tcl_Interp *e, char *arg);
  ~callbackInfo ();
  Tcl_Interp *interp;
  char s[100];
};

callbackInfo::callbackInfo(Tcl_Interp *e, char *arg) {
  interp = e;
  strcpy(s,arg);
}

static char *cs;

// Format a cdevData into a tcl result
int Cdev_Handleresult(cdevData & result, Tcl_DString & ds) {
  int i,j,k,tag,len;
  size_t dim;
  char **sp;

  // assume we always return the "value" tag
  // Have to provide a way to retrieve other tags, like timestamp
  result.tagC2I("value", &tag);
  result.getDim(tag, &dim);

  // Always retrieve the result as a char*, cdevData does the conversion for me!
  Tcl_DStringInit(&ds);
  if (dim == 0) {
    result.get(tag,&cs);
    if (cs) 
      Tcl_DStringAppend(&ds,cs,-1);
    return TCL_OK;
  }
  else if (dim == 1) {
    cdevBounds bounds;
    result.getBounds(tag,&bounds,1);
    sp = new char*[bounds.length];
    result.get(tag,sp);
    for (i=0; i<bounds.length; i++) {
      Tcl_DStringAppendElement(&ds,sp[i]);
      delete sp[i];
    }
    delete sp;
    return TCL_OK;
  }
  else if (dim == 2) {
    cdevBounds bounds[2];
    result.getBounds(tag, bounds, 2);
    len = bounds[0].length*bounds[1].length;
    sp = new char*[len];
    result.get(tag,sp);
    for (i=0, k=0; i<bounds[0].length; i++) {
      Tcl_DStringStartSublist(&ds);
      for (j=0; j<bounds[1].length; j++, k++) {
	Tcl_DStringAppendElement(&ds,sp[k]);
	delete sp[k];
      }
      Tcl_DStringEndSublist(&ds);
    }
    delete sp;
    return TCL_OK;
  }
  return TCL_ERROR;
}

// executes inside poll() whenever 'file' is readable
void Cdev_CallbackFunction(int /* status */, void* userarg, cdevRequestObject & /* obj */, cdevData & result) {  
  int i;
  callbackInfo *info;
  Tcl_DString ds;
  // have to check status and do appropriate action like: set Error(info->s) ???
  i = Cdev_Handleresult(result,ds);
  info = (callbackInfo *) userarg;
  Tcl_SetVar2(info->interp,"cdevResult",info->s,Tcl_DStringValue(&ds),TCL_GLOBAL_ONLY); 
  Tcl_DStringFree(&ds);  
}

// Old way of polling, superseded by FileHandler calls
void Cdev_UpdateProc( ClientData dummy) {
  cdevSystem::defaultSystem().poll();
  Tk_CreateTimerHandler(200, Cdev_UpdateProc, dummy);
}

void Cdev_FileProc(ClientData /* clientdata */, int /* mask */) {
  cdevSystem::defaultSystem().poll();
}

int cdevdebug = 0;

int CdevDebugCmd(ClientData /* dummy */, Tcl_Interp * /* interp */, int /* argc */, char ** /* argv */) {
  if (cdevdebug == 0) {
    cdevdebug = 1;
  } else {
    cdevdebug = 0;
  }
  return TCL_OK;
}

int done;
void scriptCallback (int, void *, cdevRequestObject &, cdevData &data)
{
  static int resultCount = 0;
  done = cdevCallback::isTransactionDone();
  fprintf(stdout, "Result count %i - %s done...\n", ++resultCount, done?"   ":"NOT");
 if(done) data.asciiDump();
}
	
int CdevCmd(ClientData /* dummy */, Tcl_Interp *interp, int argc, char **argv) {
// cdev device message {tag value} {..} cb
  int i,c1,c2,tag;
  char **s1,**s2;
  cdevData out,result;
  Tcl_DString ds;
  cdevCallback *cb = NULL;
  callbackInfo *info;
  static int once = 1;
  
 
  if (argc < 4) {
    Tcl_AppendResult(interp,"useage: ",
		     argv[0]," <class> <device> <msg> [args...] ",(char *) NULL);
    return TCL_ERROR;
  }
  

  {
    cdevDevice& ns = cdevDevice::attachRef ("cdevDirectory");
    cdevData out, result;
    char ddlstr[80],tmp2[100];
    char *tmp = getenv("CODA_LIB");
    if (tmp) {
      sprintf(tmp2,"%s/coda.ddl",tmp);
    } else {
      interp->result = "set env. var. CODA_LIB";
      return TCL_ERROR;
    }
    out.insert("file",tmp2);
    ns.send ("update",out,result);
    out.remove();
    result.remove();
    sprintf (ddlstr, "%s : %s;",argv[1],argv[2]);
    out.insert ("value", ddlstr);
    int stt = ns.send("update", out, result);
  }
  //if (strcmp(argv[1],"Script") == 0) {
  //  cdevRequestObject& service = cdevRequestObject::attachRef(argv[2],argv[3]);
  //  cdevCallback cb (scriptCallback, NULL);	
  //  service.sendCallback(result, cb);
  //  done = 0;
  //  while(!done) cdevSystem::defaultSystem().pend();
  //  return TCL_OK;
  //}
  cdevRequestObject& service = cdevRequestObject::attachRef(argv[2],argv[3]);

  for (i = 4; i<argc; i++) {
    if (Tcl_SplitList(interp,argv[i],&c1,&s1) != TCL_OK) {
      return TCL_ERROR;
    }
    if (c1 == 2) { // {tag value} pair
      if (Tcl_SplitList(interp,s1[1],&c2,&s2) != TCL_OK) {
	return TCL_ERROR;
      }
      //      if (c2 == 1) {
      //	cout << "inserting tag " << s1[0] << " with: " << s1[1] <<endl;
      //        out.insert(s1[0],s1[1]);
      //	out.insert(s1[0],strtod(s1[1], &term));
      //      } else {
      //	cout << "inserting tag " << s1[0] << " with value " << s1[1] << " with " << c2 << " counts" <<endl;
      //        out.insert(s1[0],s2,c2);
      //      }
      out.insert(s1[0],s1[1]);
      free(s2);
      free(s1);
    } else if (c1 == 1) {
      if (i != argc-1) {
	interp->result = "expecting callbacktag at end";
	return TCL_ERROR;
      }
      info = new callbackInfo(interp,argv[i]);
      cb = new cdevCallback(Cdev_CallbackFunction, (void *) info);
      if (service.sendCallback(out,*cb) != 0) {
	return TCL_ERROR;
      } else {
	return TCL_OK;
      }
    } else {
      interp->result = "expecting tag/value pair";
      return TCL_ERROR;
    }
  }

  if (service.send(out,result) != CDEV_SUCCESS) {
    interp->result = "error in send";
    return TCL_ERROR;
  }

  if (cdevdebug == 1) {

    result.asciiDump(stdout);
  }

  if (result.tagC2I("status",&tag) == CDEV_SUCCESS) {
    if(result.get(tag,&i) == CDEV_SUCCESS) {
      if (i != CDEV_SUCCESS) {
	if (result.tagC2I("severity", &tag) == CDEV_SUCCESS) {
	  Tcl_DStringInit(&ds);
	  result.get(tag,&cs);
	  Tcl_DStringAppend(&ds,cs,-1);
	  Tcl_DStringResult(interp,&ds);
	  Tcl_DStringFree(&ds);
	} else {
	  interp->result = "cdev status != 0";
	}
	return TCL_ERROR;
      }
    }
  }

  // assume we always return the "value" tag, if no result return
  
  if (result.tagC2I("value", &tag) != 0) {
    return TCL_OK;
  }
  
  if (Cdev_Handleresult(result,ds) != TCL_OK) {
    interp->result = "cannot handle cdev result";
    return TCL_ERROR;
  }

  Tcl_DStringResult(interp,&ds);
  Tcl_DStringFree(&ds);
  return TCL_OK;
}

void Cdev_RegisterFD(int * /* dummy */, int fd, int condition) {
  if ( condition) {
    Tk_CreateFileHandler( fd, TK_READABLE, Cdev_FileProc, NULL);
  } else {
    Tk_DeleteFileHandler( fd);
  }
}

extern "C"
int Cdev_Init(Tcl_Interp *interp) {

//  int i,fd[20],numFD = 20;
//  System.getFd(fd, numFD);
// for (i=0;i<numFD;i++) {
//    Cdev_RegisterFD(fd[i],1);
//  }
//  System.registerFdCallback(Cdev_RegisterFD);
//  cdevGlobalTagTable.initialize();

  Tcl_CreateCommand(interp, "cdev", CdevCmd, (ClientData *) NULL, (Tcl_CmdDeleteProc *)NULL);
  Tcl_CreateCommand(interp, "cdevdebug", CdevDebugCmd, (ClientData *) NULL, (Tcl_CmdDeleteProc *)NULL);
  Cdev_UpdateProc(NULL);
  return TCL_OK;
}










