'\" @(#)tclStruct:typedef.n	1.3	95/09/12
.so man.macros
.TH struct_typedef n "" TclStruct "TclStruct Built-In Commands"
.BS
.SH NAME
struct_typedef \- Append to variable
.SH SYNOPSIS
\fBstruct_typedef \fItypeName\fR|\fB#auto \fItypedefinition\fR
.BE

.SH DESCRIPTION
.PP
Define a new struct type with a name of \fItypeName\fR.  The
special name \fB#auto\fR indicates that the name of the type is
to be generated by the struct package.  The new type name is
returned from a successful definition.
.PP
The syntax of a \fItypedefinition\fR follows.  The use of "{" indicates
a Tcl list so a literal "{" is not absolutely necessary.
.DS
typedefinition::
	'^' type2
	type2
type2::
	type3 '*' count
	type3
type3::
	typeName typeoptions
	struct

struct::
	"{" "struct" structinfo "}"
structinfo::
	empty
	structinfo elemdef
	structinfo "size" num
	structinfo "align" num
elemdef::
	"{" typedefinition fieldname typeoptions "}"
typeoptions::
	empty
	"align" num
	"basic" boolean
	"endian" boolean
	"fill" fillstr
.\"	"justify" ???
	"nullok" boolean
	"offset" num
	"strict" boolean
	"unsigned" boolean
.DE
.PP
The following options may be specified when defining a new type:
.TP
\fBalign \fInum\fR
Replace the default alignment of a type.  The alignment must be
set to a positive power of 2.  An alignment of 1 specifies no alignment
restrictions.
.TP
\fBbasic \fIboolean\fR
Set or reset the \fBbasic\fR flag on a certain types.
The basic flag may only be set or reset on
\fBhex\fR and \fBchar\fR arrays.  When basic is set the
types are accessed as strings of characters,
when reset the types are accessed as arrays of the underlying
type.
By default the basic flag is set on these types.
.TP
\fBendian \fBbig\fR|\fBlittle\fR
For integer values the byte order of the binary value may be
set to either "big" or "little" endian.
The default byte order is the machine dependent, and is the
native byte order of the machine.
.TP
\fBfill \fIstring\fR
Specify a fill character for character arrays.  Trailing fill
characters will be removed when the array is being read, and
upon being written the fill character will be used to pad the
array out to its full size.
The default fill character is the nul byte.
.\".TP
.\"\fBjustify \fBleft\fR|\fBright\fR|\fBcenter\fR|\fBnone\fR
.\"Warning: currently this type option has no effect.
.\"This will eventually be needed for COBOL data types.
.TP
\fBnullok \fIboolean\fR
This flag is normally set to enable the reading and writing of nul characters
and null pointers.  It may be turned off in a derived type when references
to null are not allowed.
.TP
\fBoffset \fInum\fR
This 'type' option is only valid on a structure member and may be used to
set the starting offset of this field in the structure.
.TP
\fBstrict \fIboolean\fR
This flag prevents silent conversion of illegal values
when writing to objects.
This flag is set on all the built-in types.
.br
Turning the strict flag off allows:
1) Non-zero indices on a pointer,
2) Silent trucation of strings when the space is too small for
the full string,
3) Silent truncation of integer values outside of valid range,
and
4) Zero fill remaining portion of array when too few elements
are specified.
.TP
\fBunsigned \fIboolean\fR
This flag may be set or reset on numeric types only.
Setting the \fBunsigned\fR flag makes a type accept non-negative values
only.
.SH EXAMPLES
.PP
This example defines a structure used in a simple list.
Note the self-referential next pointer.
The fill and nullok options are unnecessary but are
included here for documentation.
.DS
struct_typedef exlist {struct
	{char*8 name fill {}}
	{ushort flags}
	{ushort count}
	{^exlist next nullok 1}
}
.DE
We will use the list definition above as part of a hash-chaining
implementation.
Here is the definition of the buckets for the hash table.
This defines an array of 50 pointers to the exlist structure.
.DS
struct_typedef exbuckets {^exlist*50}
.DE
.PP
This is the definition of X/Open Transaction Identifier.
This is the Tcl equivalent of the xid.h header file.
.DS
set XIDDATASIZE 128
set MAXGTRIDSIZE 64
set XIDSIZE [expr $XIDDATASIZE + (3 * [struct_info sizeof long] )]
struct_typedef XID {struct
	{long formatID}
	{long gtrid_length}
	{long bqual_length}
	{hex*$XIDDATASIZE data}
}
global NULLXID
struct_new NULLXID XID
set NULLXID() {-1 -1 -1 {}}
.DE

.SH KEYWORDS
type, struct
.SH "SEE ALSO"
structtypes(n),
struct_untypedef(n).
