/* # 1 "tdc.c" */
/* # 1 "./inc/rol.h" 1 3 */
typedef void (*VOIDFUNCPTR) ();
typedef unsigned long (*FUNCPTR) ();
typedef struct semaphore *SEM_ID;
typedef unsigned long time_t;
/* # 1 "./inc/libpart.h" 1 */
typedef struct danode			       
    {
    struct danode         *n;	               
    struct danode         *p;	               
    struct rol_mem_part   *part;	           
    int                    fd;		       
    char                  *current;	       
    unsigned long          left;	       
    unsigned char          type;               
    unsigned char          source;             
    void                   (*reader)();        
    unsigned long          length;	       
    unsigned long          data[1];	       
    } DANODE;
typedef struct alist			       
    {
    DANODE        *f;		               
    DANODE        *l;		               
    int          c;			       
    } DALIST;
typedef struct rol_mem_part *ROL_MEM_ID;
typedef struct rol_mem_part{
    DANODE	 node;		 
    DALIST	 list;		 
    char	 name[40];	 
    int		 size;		 
    int		 incr;		 
    int		 total;		 
    long         part[1];	 
} ROL_MEM_PART;
extern int nodeInUse__[32];
extern ROL_MEM_ID  partCreate();	       
extern ROL_MEM_ID  partFindByName();
extern int	   partStats();		       
extern int	   partStatsAll();	       
extern void        partIncr ();
/* # 36 "./inc/rol.h" 2 3 */
/* # 1 "./inc/cm.h" 1 */
/* # 1 "./inc/time.h" 1 3 */
struct timeval
    {
    long tv_sec;	 
    long tv_usec;	 
    };
extern time_t time (time_t *tloc);
extern double difftime(time_t t2, time_t t1);
extern int time_now(struct timeval *tv);
/* # 4 "./inc/cm.h" 2 */
/* # 1 "./inc/cm_constants.h" 1 */
/* # 7 "./inc/cm.h" 2 */
/* # 1 "./inc/cm_sd.h" 1 */
typedef struct cm_value {
	char *data;
	char *olddata;
	char *varp;
	unsigned short size;	 
	char mallocable;	 
	char type;
} cm_value;
struct cm_flattened_data {
	unsigned long size;
	char data[1];
};
/* # 8 "./inc/cm.h" 2 */
/* # 1 "./inc/cm_interface.h" 1 */
typedef int boolean;
typedef int cm_command_association;
extern cm_command_association input_command_association;
struct usr_var_role {
  unsigned reader : 1;
  unsigned nonxwriter : 1;
  unsigned xwriter : 1;
  unsigned wakeup : 1;
};
typedef struct {
  char name[        80 ];
  cm_value data;	 
  struct usr_var_role role;
  unsigned long old_count;	 
  unsigned long count;		 
  int old_command_association;	 
  int command_association;	 
  struct timeval timestamp;	 
  struct {
    unsigned declared	: 1;
    unsigned written 	: 1;
    unsigned inuse		: 1;
    unsigned undeclared	: 1;
  } status;
  unsigned char declared;
} cm_variable, cm_command_variable, cm_status_variable;
cm_value *cm_get_value();
void cm_set_value();
boolean cm_get_new_command_value();
void cm_set_new_command_value();
boolean cm_new_command_pendingp();
boolean cm_status_equal();
boolean cm_status_synchronizedp();
void cm_set_status_value();
cm_variable *cm_declare();
cm_variable *next_user_variable();
/* # 9 "./inc/cm.h" 2 */
/* # 1 "./inc/cm_slot.h" 1 */
struct slot_read_response_hdr{
	unsigned long count;
	struct timeval timestamp;
	long command_association;
};
struct slot_read_response {
	struct slot_read_response_hdr srr_hdr;
	struct cm_flattened_data fdata;	 
};
struct slot_write_hdr {
	long command_association;
};
struct slot_write {
	struct slot_write_hdr sw_hdr;
	struct cm_flattened_data fdata;
};
/* # 81 "./inc/cm_slot.h" */
struct slot_role {
	unsigned char reader;
	unsigned char wakeup;
	unsigned char xwriter;
	unsigned char nonxwriter;
};
struct slot_declare {
	long command_association;
	struct slot_role role;
};
struct slot_undeclare {
	char dummy;	 
};
struct slot_error_hdr {
	long type;	 
};
struct slot_error {
	struct slot_error_hdr se_hdr;
	char msg[1];
};
union slot_generic {
  struct slot_declare declare;
  struct slot_write write;
  struct slot_read_response read_response;
  struct slot_error error;
  struct slot_undeclare undeclare;
};
struct slot_hdr {
  char name[        80 ];
  long type;		 
  long size;		 
};
struct slot {
  struct slot_hdr slot_hdr;
  union slot_generic subslot;
};
struct big_slot {
  char name[        80 ];
  long type;
  long size;
  union slot_generic subslot;
  char buffer[	20000 ];
};
/* # 10 "./inc/cm.h" 2 */
/* # 1 "./inc/cm_msg.h" 1 */
struct msg {
	long size;		 
	long version;	         
	long slots;	         
	char name[        80 ];
	char read_wait;		 
	struct slot data[1];	
} ;
/* # 11 "./inc/cm.h" 2 */
/* # 1 "./inc/cm_sync.h" 1 */
/* # 12 "./inc/cm.h" 2 */
/* # 1 "./inc/cm_time.h" 1 */
extern struct timeval cm_period_zero, cm_period_infinite;
/* # 13 "./inc/cm.h" 2 */
/* # 37 "./inc/rol.h" 2 3 */
typedef struct rolParameters *rolParam;
typedef struct rolParameters
  {
    char          *name;	 
    char          *listName;	 
    int            runType;	 
    int            runNumber;	 
    VOIDFUNCPTR    doit;	 
    int            daproc;	 
    void          *id;		 
    int            nounload;	 
    int            inited;	 
    long          *dabufp;	 
    long          *dabufpi;	 
    ROL_MEM_PART  *pool;         
    ROL_MEM_PART  *output;	 
    ROL_MEM_PART  *input;        
    ROL_MEM_PART  *dispatch;     
    ROL_MEM_PART  *dispQ;        
    unsigned long  recNb;	 
    SEM_ID         wakeup;	 
    char          *usrString;	 
    void          *private;	 
    int            pid;
  } ROLPARAMS;
/* # 1 "./inc/services.h" 1 */
/* # 1 "./inc/obj.h" 1 */
/* # 1 "./inc/rc.h" 1 */
typedef struct rp {
  int a ;
  int b ;
} rpStruct;
typedef struct rp *runparameters;
typedef struct rp rp;
typedef struct reti {
  int a;
  int b;
} retiStruct;
typedef struct arg_rs *retrs;
struct arg_rs {
	int value;
	char *name;
} arg_rsStruct;
typedef struct arg_rs arg_rs;
typedef struct retr {
  int a;
  float b;
} retrStruct;
typedef struct argw_f {
  char *name;
  float value;
} argw_fStruct;
typedef struct argw_i {
  char *name;
  int value;
} argw_iStruct;
typedef struct argw_s {
  char *name;
  char *value;
} argw_sStruct;
extern int xdr_record();
extern int xdr_event();
extern int xdr_rp();
extern int xdr_ri();
extern int xdr_arg_rs();
extern int xdr_retrs();
extern int xdr_rr();
extern int xdr_wf();
extern int xdr_wi();
extern int xdr_ws();
extern int *dacreate();
extern int *daremove();
extern int *dadownload();
extern int *daprestart();
extern int *daend();
extern int *dapause();
extern int *dago();
extern int *daterminate();
extern int *dareport();
extern int daWriteEvent();
extern int rcConnect();
extern struct reti *dareadint();
extern retrs *dareadstring();
extern int daSync();
extern char *rcStates();
extern int *dareqevent();
extern int lastContext();
extern int restoreContext();
extern int daHandleSpy();
/* # 62 "./inc/obj.h" 2 */
typedef struct classStruct *objClass;
typedef struct classStruct SERVICE;
typedef struct classStruct {
  short     magic;		 
  char     *name;		 
  char     *className;		 
  int       ourId;		 
  int       expId;		 
  rolParam **rol;		 
  char     *rolNames;		 
  int       nrol;		 
  int       action;		 
  int       state;		 
  char     *log;		 
  char     *target;		 
  int       runNumber;		 
  int       runType;		 
} objClassStore;
/* # 43 "./inc/services.h" 2 */
extern SERVICE rc_service_ana_;
extern SERVICE rc_service_eb_;
extern SERVICE rc_service_roc_;
extern SERVICE rc_service_ts_;
extern void rcservice_ (SERVICE *service_name);
extern void rcexecute_ ();
/* # 73 "./inc/rol.h" 2 3 */
static int EVENT_type;
extern int global_env[];
extern long global_env_depth;
extern char *global_routine[100];
static int stream_fd__;
static rolParam rol;
static unsigned long evnb;
static int trig_type;
extern SERVICE _service;
extern long recPermis;
extern int dodone;
extern long data_tx_mode;
extern int async_roc_flag;
/* # 1 "./inc/BankTools.h" 1 3 */
long *StartOfEvent[32 ],event_depth__;
/* # 90 "./inc/BankTools.h" 3 */
/* # 102 "./inc/BankTools.h" 3 */
/* # 136 "./inc/rol.h" 2 3 */
/* # 1 "./inc/trigger_dispatch.h" 1 3 */
static unsigned char dispatch_busy, currType; 
static int intLockKey,trigId;
static unsigned long theEvMask, currEvMask, evMasks[   16 ];
static VOIDFUNCPTR wrapperGenerator;
static FUNCPTR trigRtns[   32 ], syncTRtns[   32 ], doneRtns[   32 ];
static unsigned long Tcode[   32 ];
static DANODE *__the_event__, *input_event__;
/* # 44 "./inc/trigger_dispatch.h" 3 */
/* # 94 "./inc/trigger_dispatch.h" 3 */
static void cdodispatch()
{
  unsigned char theType,theSource;
  int ix;
  unsigned char loopTimes = rol->dispQ->list.c;
  DANODE *theNode;
  dispatch_busy = 1;
  while (loopTimes--) {
{( theNode) = 0;if((&rol->dispQ->list)->c){(&rol->dispQ->list)->c--;( theNode) = 
(&rol->dispQ->list)->f;(&rol->dispQ->list)->f = (&rol->dispQ->list)->f->n;};if (!(&rol->dispQ->list)->c) (&rol->dispQ->list)->l = 
0;} ;     theType = theNode->type;
    theSource = theNode->source;
    if (theEvMask) { 
      if ((theEvMask & (1<<theSource)) && (theType == currType)) {
	theEvMask = theEvMask & ~(1<<theSource);
	input_event__ = theNode;
	rol->dabufpi = (long *) &input_event__->data[1];
	intUnlock(intLockKey); ;
	(*theNode->reader)(theType, Tcode[theSource]);
	intLockKey = intLock(); ;
	if (theNode)
	 {nodeInUse__[theNode->fd]--; {if(! (&theNode->part->list)->c 
){(&theNode->part->list)->f = (&theNode->part->list)->l = ( theNode);( theNode)->p = 0;} else {( theNode)->p = 
(&theNode->part->list)->l;(&theNode->part->list)->l->n = ( theNode);(&theNode->part->list)->l = ( theNode);} ( theNode)->n = 
0;(&theNode->part->list)->c++;} ;} ; 	if (!theEvMask) {
	 if (wrapperGenerator) {event_depth__--; *StartOfEvent[event_depth__] = (long) (((char 
*) (rol->dabufp)) - ((char *) StartOfEvent[event_depth__]));	if 
((*StartOfEvent[event_depth__] & 1) != 0) { (rol->dabufp) = ((long *)((char *) (rol->dabufp))+1); 
*StartOfEvent[event_depth__] += 1; }; if ((*StartOfEvent[event_depth__] & 2) !=0) { *StartOfEvent[event_depth__] = 
*StartOfEvent[event_depth__] + 2; (rol->dabufp) = ((long *)((short *) (rol->dabufp))+1);; 
};	*StartOfEvent[event_depth__] = ( (*StartOfEvent[event_depth__]) >> 2) - 1;}; ;	 	 if (__the_event__) { if (rol->output) { {if(! (&(rol->output->list))->c 
){(&(rol->output->list))->f = (&(rol->output->list))->l = (__the_event__);(__the_event__)->p = 0;} else 
{(__the_event__)->p = (&(rol->output->list))->l;(&(rol->output->list))->l->n = 
(__the_event__);(&(rol->output->list))->l = (__the_event__);} (__the_event__)->n = 0;(&(rol->output->list))->c++;} ; } else { if 
(stream_fd__ > 0) {	__the_event__->data[0] = _service.ourId; __the_event__->length = 
__the_event__->data[1] +2; if (stream_io_write(stream_fd__,__the_event__) <0 ) return ; } else { 
{nodeInUse__[__the_event__->fd]--; {if(! (&__the_event__->part->list)->c ){(&__the_event__->part->list)->f = 
(&__the_event__->part->list)->l = ( __the_event__);( __the_event__)->p = 0;} else {( __the_event__)->p = 
(&__the_event__->part->list)->l;(&__the_event__->part->list)->l->n = ( __the_event__);(&__the_event__->part->list)->l = ( __the_event__);} ( 
__the_event__)->n = 0;(&__the_event__->part->list)->c++;} ;} ;	} } __the_event__ = (DANODE *) 0; } ; 	 {int ix; if (currEvMask) if (rol->pool->list.c) { for (ix=0; ix < trigId; ix++) if 
(currEvMask & (1<<ix)) (*doneRtns[ix])(currType,Tcode[ix]); currEvMask = 0; } } ; 	}
      } else {
	{if(! (&rol->dispQ->list)->c ){(&rol->dispQ->list)->f = (&rol->dispQ->list)->l = ( 
theNode);( theNode)->p = 0;} else {( theNode)->p = 
(&rol->dispQ->list)->l;(&rol->dispQ->list)->l->n = ( theNode);(&rol->dispQ->list)->l = ( theNode);} ( theNode)->n = 
0;(&rol->dispQ->list)->c++;} ;       }
    } else { 
      if ((1<<theSource) & evMasks[theType]) {
	currEvMask = theEvMask = evMasks[theType];
	currType = theType;
      } else {
        currEvMask = (1<<theSource);
      }
      evnb++;
      if (wrapperGenerator) {
	(*wrapperGenerator)(theType);
      }
      input_event__ = theNode;
      rol->dabufpi = (long *) &input_event__->data[1];
      intUnlock(intLockKey); ;
      (*theNode->reader)(theType, Tcode[theSource]);
      intLockKey = intLock(); ;
      if (theNode)
	{nodeInUse__[theNode->fd]--; {if(! (&theNode->part->list)->c 
){(&theNode->part->list)->f = (&theNode->part->list)->l = ( theNode);( theNode)->p = 0;} else {( theNode)->p = 
(&theNode->part->list)->l;(&theNode->part->list)->l->n = ( theNode);(&theNode->part->list)->l = ( theNode);} ( theNode)->n = 
0;(&theNode->part->list)->c++;} ;} ;       if (theEvMask) {
	theEvMask = theEvMask & ~(1<<theSource);
      } 
      if (!theEvMask) {
	 if (__the_event__) { if (rol->output) { {if(! (&(rol->output->list))->c 
){(&(rol->output->list))->f = (&(rol->output->list))->l = (__the_event__);(__the_event__)->p = 0;} else 
{(__the_event__)->p = (&(rol->output->list))->l;(&(rol->output->list))->l->n = 
(__the_event__);(&(rol->output->list))->l = (__the_event__);} (__the_event__)->n = 0;(&(rol->output->list))->c++;} ; } else { if 
(stream_fd__ > 0) {	__the_event__->data[0] = _service.ourId; __the_event__->length = 
__the_event__->data[1] +2; if (stream_io_write(stream_fd__,__the_event__) <0 ) return ; } else { 
{nodeInUse__[__the_event__->fd]--; {if(! (&__the_event__->part->list)->c ){(&__the_event__->part->list)->f = 
(&__the_event__->part->list)->l = ( __the_event__);( __the_event__)->p = 0;} else {( __the_event__)->p = 
(&__the_event__->part->list)->l;(&__the_event__->part->list)->l->n = ( __the_event__);(&__the_event__->part->list)->l = ( __the_event__);} ( 
__the_event__)->n = 0;(&__the_event__->part->list)->c++;} ;} ;	} } __the_event__ = (DANODE *) 0; } ; 	 {int ix; if (currEvMask) if (rol->pool->list.c) { for (ix=0; ix < trigId; ix++) if 
(currEvMask & (1<<ix)) (*doneRtns[ix])(currType,Tcode[ix]); currEvMask = 0; } } ;       }
    }  
  }
  dispatch_busy = 0;
}
static int theIntHandler(int theSource)
{
  if (theSource == 0) return(0);
  {  
    DANODE *theNode;
    intLockKey = intLock(); ;
{{( theNode) = 0;if((&(rol->dispatch->list))->c){(&(rol->dispatch->list))->c--;( 
theNode) = (&(rol->dispatch->list))->f;(&(rol->dispatch->list))->f = 
(&(rol->dispatch->list))->f->n;};if (!(&(rol->dispatch->list))->c) (&(rol->dispatch->list))->l = 0;} ;} ;     theNode->type = (EVENT_type ); 
    theNode->source = theSource; 
    theNode->reader = trigRtns[theSource]; 
{if(! (&rol->dispQ->list)->c ){(&rol->dispQ->list)->f = (&rol->dispQ->list)->l = ( 
theNode);( theNode)->p = 0;} else {( theNode)->p = 
(&rol->dispQ->list)->l;(&rol->dispQ->list)->l->n = ( theNode);(&rol->dispQ->list)->l = ( theNode);} ( theNode)->n = 
0;(&rol->dispQ->list)->c++;} ;     if (!dispatch_busy) 
      cdodispatch();
    intUnlock(intLockKey); ;
  }
}
static int cdopolldispatch()
{
  unsigned char theSource, theType;
  int stat = 0;
  DANODE *theNode;
  for (theSource=0;theSource<trigId;theSource++){
    if (syncTRtns[theSource]){
      if ( theNode = (*syncTRtns[theSource])(Tcode[theSource])) {
	stat = 1;
	{  
	  intLockKey = intLock(); ;
	  if (theNode == 1) 
	 {{( theNode) = 0;if((&(rol->dispatch->list))->c){(&(rol->dispatch->list))->c--;( 
theNode) = (&(rol->dispatch->list))->f;(&(rol->dispatch->list))->f = 
(&(rol->dispatch->list))->f->n;};if (!(&(rol->dispatch->list))->c) (&(rol->dispatch->list))->l = 0;} ;} ; 	  theNode->type = (EVENT_type ); 
	  theNode->source = theSource; 
	  theNode->reader = trigRtns[theSource]; 
	 {if(! (&rol->dispQ->list)->c ){(&rol->dispQ->list)->f = (&rol->dispQ->list)->l = ( 
theNode);( theNode)->p = 0;} else {( theNode)->p = 
(&rol->dispQ->list)->l;(&rol->dispQ->list)->l->n = ( theNode);(&rol->dispQ->list)->l = ( theNode);} ( theNode)->n = 
0;(&rol->dispQ->list)->c++;} ; 	  if (!dispatch_busy) 
	    cdodispatch();
	  intUnlock(intLockKey); ;
	}
      }
    }
  }
  return (stat);
}
/* # 143 "./inc/rol.h" 2 3 */
static void __download();
static void __prestart();
static void __end();
static void __pause();
static void __go();
static void __status();
static void __poll();
static char rol_name__[40];
static char temp_string__[132];
static unsigned long address___;
static void __init__(param)
     rolParam param;
{
  while(1) {
    if (param->daproc) {
      switch(param->daproc) {
      case        0 :
	{
	  char name[40];
	  printf("user init \n");
	  stream_fd__ = 0;
	  rol = param;
	  rol->inited = 1;
	  eprintf(5,"rol->inited %d\n",rol->inited);
	  strcpy(rol_name__, "Un-named" );
	  rol->listName = rol_name__;
	  strcpy(name, rol->listName);
	  strcat(name, ":pool");
	  rol->pool  = partCreate(name, 32768  ,16,0);
	  strcpy(name, rol->listName);
	  strcat(name, ":input");
	  rol->input = partCreate(name, 0, 0, 0);
	  strcpy(name, rol->listName);
	  strcat(name, ":dispQ");
	  rol->dispQ = partCreate(name, 0, 0, 0);
	  strcpy(name, rol->listName);
	  strcat(name, ":dispatch");
	  rol->dispatch  = partCreate(name, 0, 32, 4);
	  eprintf(0,"INFO: __init__ from %s\n",rol->listName);
	  eprintf(0,"INFO: done init\n");  
	  break;
	}
      case    1 :
	__download();
	break;
      case    2 :
	__prestart();
	break;
      case       4 :
	__pause();
	break;
      case         3 :
	__end();
	break;
      case          5 :
	__go();
	break;
      case        6 :
	__poll();
	break;
      default:
	eprintf(0,"WARN: unsupported action\n");
	break;
      }
      param->daproc = 0;
      __poll();
    }
  }
}
static void __poll(objClass class)
{
{cdopolldispatch(); {int ix; if (currEvMask) if (rol->pool->list.c) { for (ix=0; ix < 
trigId; ix++) if (currEvMask & (1<<ix)) (*doneRtns[ix])(currType,Tcode[ix]); currEvMask = 0; } } ;} 
; }
/* # 2 "tdc.c" 2 */
VOIDFUNCPTR tdc__init__ = __init__;
/* # 1 "./inc/FASTBUS_source.h" 1 3 */
/* # 1 "./inc/fb_trigLib.h" 1 */
static inline void wdStart()
{
(*(unsigned char *) (	0x00640000	+ 0x10 )) = 0xf2 ;	   (*(unsigned char *) (	0x00640000	+      0x13                  )) =100;
  (*(unsigned char *) (	0x00640000	+      0x14                  )) =0x0;
(*(unsigned char *) (	0x00640000	+ 0x15 )) =0x0;		 (*(unsigned char *) (	0x00640000	+ 0x10 )) = 0xf3 ;	 }
static inline void fptriglink(isr)
     VOIDFUNCPTR isr;
{
  static FUNCPTR handlerPtr = (FUNCPTR) 0;
  if (handlerPtr)
    free(handlerPtr);
  handlerPtr = intHandlerCreate(isr,0);
  intVecSet((VOIDFUNCPTR *) (0x4f<<2),(VOIDFUNCPTR) handlerPtr);
(*(unsigned char *) (	0x00480000	+ 	0x03 	)) &= ~	(1<<7	)	; (*(unsigned char *) (	0x00480000	+ 	0x09 	)) |= 	(1<<7	)	; }
static inline void fptenable()
{
(*(unsigned char *) (	0x00480000	+ 	0x03 	)) |= 	(1<<7	)	; }
static inline void fptdisable()
{
(*(unsigned char *) (	0x00480000	+ 	0x03 	)) &= ~	(1<<7	)	; }
static inline char fpttype()
{
  return((((*(unsigned char *) (               0x004c0000      )) &0x3c)>>2));
}
static inline void fpttypeset(char tt)
{
(*(unsigned char *) (	0x00640000	+ 0x09 )) = (tt<<5) | ((*(unsigned char *) (	0x00640000	+ 
0x09 )) &0x1f); }
static inline void fpttoggle()
{
(*(unsigned char *) (	0x00480000	+ 	0x03 	)) &= ~	(1<<7	)	; (*(unsigned char *) (	0x00480000	+ 	0x03 	)) |= 	(1<<7	)	;   (*(unsigned char *) (	0x00640000	+      0x09                  )) =0x10;  
  (*(unsigned char *) (	0x00640000	+      0x09                  )) =0;	  
}
static inline void fpbusy()
{
  (*(unsigned char *) (	0x00640000	+      0x09                  ))  |=  0x10;
}
static inline void fpnotbusy()
{
  (*(unsigned char *) (	0x00640000	+      0x09                  ))  &= ~0x10;
}
static inline int fpttest()
{
  int ii;
ii = (((*(unsigned char *) (	0x00480000	+ 	0x05 	)) & 0x80)!=0);   return(ii);
}
/* # 4 "./inc/FASTBUS_source.h" 2 3 */
/* # 1 "./inc/fb_types.h" 1 */
typedef int			FB_boolean;
typedef unsigned long		FB_buffer_mode;
typedef unsigned long		FB_error_code;
typedef int			FB_integer;
typedef unsigned long		FB_line;
typedef	int			FB_list_pointer;
typedef unsigned long		FB_operator;
typedef	unsigned long	       	FB_parameter_id;
typedef unsigned long		FB_parameter_value;
typedef unsigned long		FB_port_id;
typedef unsigned long		FB_response_code;
typedef FUNCPTR			FB_routine;
typedef unsigned long		FB_seq_buffer_id;
typedef int			FB_severity;
typedef	unsigned long		FB_word;
typedef char			*FB_string;
typedef FB_word			*array_of_FB_word;
/* # 5 "./inc/FASTBUS_source.h" 2 3 */
/* # 1 "./inc/fb_fscc_macro.h" 1 */
/* # 1 "./inc/fb_fscc_def.h" 1 */
extern int fscc_csr[32];	 
extern volatile int fscc_error;	 
extern int fscc_error_seq;	 
extern int fscc_error_slv;	 
extern int fscc_int_count;	 
extern int fscc_berr_count;	 
extern int fscc_seq_buf_action;	 
extern int fscc_frlen_info;	 
/* # 99 "./inc/fb_fscc_macro.h" 2 */
/* # 1 "./inc/fb_error.h" 1 */
/* # 1 "./inc/fb_error_code_msg_c.h" 1 */
/* # 46 "./inc/fb_error.h" 2 */
/* # 100 "./inc/fb_fscc_macro.h" 2 */
extern int fb_errno;
void fscc_error_decode(int noarb,int nopa,int nosa,
		       int noda,int holdas,int hold);
/* # 168 "./inc/fb_fscc_macro.h" */
/* # 200 "./inc/fb_fscc_macro.h" */
/* # 230 "./inc/fb_fscc_macro.h" */
/* # 255 "./inc/fb_fscc_macro.h" */
/* # 321 "./inc/fb_fscc_macro.h" */
/* # 357 "./inc/fb_fscc_macro.h" */
/* # 385 "./inc/fb_fscc_macro.h" */
/* # 413 "./inc/fb_fscc_macro.h" */
/* # 435 "./inc/fb_fscc_macro.h" */
/* # 6 "./inc/FASTBUS_source.h" 2 3 */
/* # 1 "./inc/fb_proto_1.h" 1 */
void fb_fbinit_1();
void fb_frd_1(int pa, int sa, unsigned long *data, int eg, int noarb, 
	      int nopa, int nosa, int noda, int holdas, int hold);
void fb_fwd_1(int pa, int sa, unsigned long data, int eg, int noarb, 
	      int nopa, int nosa, int noda, int holdas, int hold);
void fb_frc_1(int pa, int sa, unsigned long *data, int eg, int noarb, 
	      int nopa, int nosa, int noda, int holdas, int hold);
void fb_fwc_1(int pa, int sa, unsigned long data, int eg, int noarb, 
	      int nopa, int nosa, int noda, int holdas, int hold);
void fb_frdm_1(int pa, int sa, unsigned long *data, int noarb, 
	       int nopa, int nosa, int noda, int holdas, int hold);
void fb_fwdm_1(int pa, int sa, unsigned long data, int noarb, 
	       int nopa, int nosa, int noda, int holdas, int hold);
void fb_frcm_1(int pa, int sa, unsigned long *data, int noarb, 
	       int nopa, int nosa, int noda, int holdas, int hold);
void fb_fwcm_1(int pa, int sa, unsigned long data, int noarb, 
	       int nopa, int nosa, int noda, int holdas, int hold);
void fb_frdb_1(int pa, int sa, unsigned long *data, int maxbytes, int eg, 
		int noarb, int nopa, int nosa, int noda, int pipe, 
		int holdas, int hold, int nowait);
void fb_fwdb_1(int pa, int sa, unsigned long *data, int maxbytes, int eg, 
		int noarb, int nopa, int nosa, int noda, int pipe, 
		int holdas, int hold, int nowait);
void fb_frcb_1(int pa, int sa, unsigned long *data, int maxbytes, int eg, 
		int noarb, int nopa, int nosa, int noda, int pipe, 
		int holdas, int hold, int nowait);
void fb_fwcb_1(int pa, int sa, unsigned long *data, int maxbytes, int eg, 
		int noarb, int nopa, int nosa, int noda, int pipe, 
		int holdas, int hold, int nowait);
void fb_frdbm_1(int pa, int sa, unsigned long *data, int maxbytes, 
		int noarb, int nopa, int nosa, int noda, int pipe, 
		int holdas, int hold, int nowait);
void fb_fwdbm_1(int pa, int sa, unsigned long *data, int maxbytes,  
		int noarb, int nopa, int nosa, int noda, int pipe, 
		int holdas, int hold, int nowait);
void fb_frcbm_1(int pa, int sa, unsigned long *data, int maxbytes, 
		int noarb, int nopa, int nosa, int noda, int pipe, 
		int holdas, int hold, int nowait);
void fb_fwcbm_1(int pa, int sa, unsigned long *data, int maxbytes, 
		int noarb, int nopa, int nosa, int noda, int pipe, 
		int holdas, int hold, int nowait);
void fb_frdsa_1(int pa, unsigned long *sa, int eg, int noarb, 
		int nopa, int nosa, int holdas, int hold);
void fb_fwdsa_1(int pa, unsigned long sa, int eg, int noarb, 
		int nopa, int nosa, int holdas, int hold);
void fb_frcsa_1(int pa, unsigned long *sa, int eg, int noarb, 
		int nopa, int nosa, int holdas, int hold);
void fb_fwcsa_1(int pa, unsigned long sa, int eg, int noarb, 
		int nopa, int nosa, int holdas, int hold);
void fb_fbprst_1();
void fb_frlen_1(unsigned long *data);
void fb_fcarb_1();
void fb_fcrel_1();
void fb_fcpd_1(int pa);
void fb_fcpdm_1(int pa);
void fb_fcpc_1(int pa);
void fb_fcpcm_1(int pa);
void fb_fcdisc_1();
void fb_fcrw_1(int *data);
void fb_fcww_1(int data);
void fb_fcrsa_1(int *data);
void fb_fcwsa_1(int data);
void fb_fcrb_1(int *data, int maxbytes);
void fb_fcwb_1(int *data, int maxbytes);
void fb_fbprst_1();
/* # 12 "./inc/FASTBUS_source.h" 2 3 */
char	*FB_ERRTXT[	((((unsigned long)( 0X800BC324 ) & 	0x00003fff	) >> 3		) ) +1] = 	{
	"",
	"ERROR: 0x%X %s,%s - address release timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - AK timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - block data - SS=2, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data parity error, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - data SS=0, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=1, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=2, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=3, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=4, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=5, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=6, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=7, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - DK release timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - DK timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - long timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - pad cycle SS=0, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - pad cycle SS=1, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - pad cycle SS=2, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - pad cycle SS=3, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - pad cycle SS=4, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - pad cycle SS=5, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - pad cycle SS=6, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - pad cycle SS=7, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - s.addr cycle DK timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=0, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=1, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=2, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=3, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=4, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=5, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=6, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=7, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - software timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - wait timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - normal successful completion\n",
	"ERROR: 0x%X %s,%s - error accessing data buffer\n",
	"ERROR: 0x%X %s,%s - abort action\n",
	"ERROR: 0x%X %s,%s - already connected\n",
	"ERROR: 0x%X %s,%s - bad parameter value\n",
	"ERROR: 0x%X %s,%s - buffer overflow\n",
	"ERROR: 0x%X %s,%s - session closed, no actions possible\n",
	"ERROR: 0x%X %s,%s - routine connection failed\n",
	"ERROR: 0x%X %s,%s - routine disconnect failed\n",
	"ERROR: 0x%X %s,%s - environment active\n",
	"ERROR: 0x%X %s,%s - environment id overflow\n",
	"ERROR: 0x%X %s,%s - environment overflow\n",
	"ERROR: 0x%X %s,%s - environment release\n",
	"ERROR: 0x%X %s,%s - generic error\n",
	"ERROR: 0x%X %s,%s - generic fatal\n",
	"ERROR: 0x%X %s,%s - hardware error\n",
	"ERROR: 0x%X %s,%s - hardware warning\n",
	"ERROR: 0x%X %s,%s - holding address\n",
	"ERROR: 0x%X %s,%s - holding bus\n",
	"ERROR: 0x%X %s,%s - error was ignored\n",
	"ERROR: 0x%X %s,%s - illegal parameter value\n",
	"ERROR: 0x%X %s,%s - illegal sequential buffer id\n",
	"ERROR: 0x%X %s,%s - unexpected implementation error\n",
	"ERROR: 0x%X %s,%s - generic informational\n",
	"ERROR: 0x%X %s,%s - invalid environment id\n",
	"ERROR: 0x%X %s,%s - invalid list pointer\n",
	"ERROR: 0x%X %s,%s - invalid port id\n",
	"ERROR: 0x%X %s,%s - invalid sequential buffer id\n",
	"ERROR: 0x%X %s,%s - last pad\n",
	"ERROR: 0x%X %s,%s - last secondary address\n",
	"ERROR: 0x%X %s,%s - last list pointer\n",
	"ERROR: 0x%X %s,%s - list overflow\n",
	"ERROR: 0x%X %s,%s - long timer on\n",
	"ERROR: 0x%X %s,%s - no address connection\n",
	"ERROR: 0x%X %s,%s - no more status\n",
	"ERROR: 0x%X %s,%s - no privilege\n",
	"ERROR: 0x%X %s,%s - no supplementary status\n",
	"ERROR: 0x%X %s,%s - not connected\n",
	"ERROR: 0x%X %s,%s - not holding mastership\n",
	"ERROR: 0x%X %s,%s - not master\n",
	"ERROR: 0x%X %s,%s - session already open\n",
	"ERROR: 0x%X %s,%s - operation pending\n",
	"ERROR: 0x%X %s,%s - pipeline transfer\n",
	"ERROR: 0x%X %s,%s - pointer overflow\n",
	"ERROR: 0x%X %s,%s - port active\n",
	"ERROR: 0x%X %s,%s - port already allocated\n",
	"ERROR: 0x%X %s,%s - port not allocated\n",
	"ERROR: 0x%X %s,%s - port not available\n",
	"ERROR: 0x%X %s,%s - port owned\n",
	"ERROR: 0x%X %s,%s - read only parameter\n",
	"ERROR: 0x%X %s,%s - operation successfully retried\n",
	"ERROR: 0x%X %s,%s - sequenctial buffer active\n",
	"ERROR: 0x%X %s,%s - sequenctial buffer exists\n",
	"ERROR: 0x%X %s,%s - sequenctial buffer id overflow\n",
	"ERROR: 0x%X %s,%s - software timer on\n",
	"ERROR: 0x%X %s,%s - status not found\n",
	"ERROR: 0x%X %s,%s - status overflow\n",
	"ERROR: 0x%X %s,%s - successful operation\n",
	"ERROR: 0x%X %s,%s - unknown error\n",
	"ERROR: 0x%X %s,%s - unknown parameter\n",
	"ERROR: 0x%X %s,%s - unsupported port operation\n",
	"ERROR: 0x%X %s,%s - unsupported paramter\n",
	"ERROR: 0x%X %s,%s - unsupported routine\n",
	"ERROR: 0x%X %s,%s - user array overflow\n",
	"ERROR: 0x%X %s,%s - generic warning\n",
	"ERROR: 0x%X %s,%s - fscc FIFO error\n",
	};
static int padr,sadr;
static char *fb_rtn;
inline void 
  fpbr(int pa, long len) 
{
  int i;
  if ((len>4000)||(len<1)) len = 4000;
  if(pa<0) {
    fb_frdb_1(0,0,*rol->dabufp,(len<<2),1,1,1,1,0,0,1,1,0);
  } else {
    fb_frdb_1(pa,0,*rol->dabufp,(len<<2),1,1,0,1,0,0,0,0,0);
  }
if (fb_errno!=				 0X800BC119 ) { fb_rtn = "fb_frdb_1 data"; goto fooy; } ;   fb_frlen_1(&i);
  if (fb_errno!=				   0X800BC119  ) { fb_rtn = "fprb"; goto fooy; } ;
  *rol->dabufp += (i>>2);
  return;
 fooy:
daLogMsg(FB_ERRTXT[(((unsigned long)(fb_errno) & 	0x00003fff	) >> 3		) ],	fb_errno, 
global_routine[global_env_depth], fb_rtn,	padr,sadr); ;   return;
}
static inline void 
  fpbrf(int pa, long len) 
{
  int i, ix;
  if ((len>512)||(len<1)) len = 512;
*(unsigned char *) 0x64000C &=(~	0x10	); *(unsigned char *) 0x64000C |=	0x10	; ; *(unsigned char *) 0x64000C &=(~	0x01	); *(unsigned char *) 0x64000C |=	0x01	; ;     *(unsigned char *) 0x64000C  |=	0x04	 ;
  if(pa<0) {
    fb_frdb_1(0,0,	-1  ,(len<<2),1,1,1,1,0,0,1,1,0);
  } else {
    fb_frdb_1(pa,0,	-1  ,(len<<2),1,1,0,1,0,0,0,0,0);
  }
if (fb_errno!=				 0X800BC119 ) { fb_rtn = "fb_frdb_1 data"; goto fooy; } ;   fb_frlen_1(&i);
  if((ix = (i>>2) - 1)>=0) {    
  asm("movel #6815744,a2");                  
  asm("movel %0,d1": :"g" (ix));      
  asm("movel _dabufp,a0");                   
  asm("movel a0@,a1");                       
  asm("movel a2@,a1@+");                     
  asm(".long 1472856060");                   
  asm("movel a1,a0@");                       
  }
   *(unsigned char *) 0x64000C  &=(~	0x04	) ;
  if (fb_errno!=				   0X800BC119  ) { fb_rtn = "fpbrf buffer"; goto fooy; } ;
  return;
 fooy:
daLogMsg(FB_ERRTXT[(((unsigned long)(fb_errno) & 	0x00003fff	) >> 3		) ],	fb_errno, 
global_routine[global_env_depth], fb_rtn,	padr,sadr); ;   return;
}
/* # 4 "tdc.c" 2 */
static void __download()
{
    eprintf(0,"INFO: Readout list compiled %s\n", DAYTIME);
    {
       static int ourTaskId=0;  
       if (taskIdSelf() != ourTaskId)
         {
           ourTaskId = taskIdSelf();
           fb_task_init_1();
         }
    }
    async_roc_flag = 0; 
  {   
    eprintf(0,"INFO: User Download Executing\n");
  }   
    return;
   fooy: 
daLogMsg(FB_ERRTXT[(((unsigned long)(fb_errno) & 	0x00003fff	) >> 3		) ],	fb_errno, 
global_routine[global_env_depth], fb_rtn,	padr,sadr); ;      return ;
}       
static void __prestart()
{
{ dispatch_busy = 0; bzero((char *) evMasks, sizeof(evMasks)); bzero((char *) syncTRtns, 
sizeof(syncTRtns)); bzero((char *) Tcode, sizeof(Tcode)); wrapperGenerator = 0; theEvMask = 0; currEvMask = 0; 
trigId = 1; __the_event__ = (DANODE *) 0;} ;     fb_init_1 ();
    fb_frd_1(0,0,0,0,0,1,1,1,1,1);  
if (fb_errno!=				 0X800BC119 ) { fb_rtn = "hidden arbitrate"; goto fooy; } ;     fptdisable();
    evnb = 0;
  {   
unsigned long tdcid;
    eprintf(0,"INFO: Entering User Prestart\n");
    padr   = 1;
    fb_fwcm_1(padr,0,0x40000000,1,0,1,0,0,0);
      if (fb_errno != 0x800BC119){ 
          fb_rtn = "write 0x40000000 into broadcast control 1" ;
          goto fooy;
      }
    padr   = 20 ; 
    sadr = 1 ;
    fb_fwc_1(padr,sadr,0x40000000,1,1,0,0,0,1,1);
      if (fb_errno != 0x800BC119){ 
          fb_rtn = "write 0x40000000" ;
          goto fooy;
      }
    sadr = 18 ;
    fb_fwc_1(0,sadr,0x000015E0,1,1,1,0,0,1,1);
      if (fb_errno != 0x800BC119){ 
          fb_rtn = "write 0x000015E0" ;
          goto fooy;
      }
    fb_frd_1(0,0,0,1,1,1,1,1,0,0); 
    if (fb_errno != 0x800BC119){ 
        fb_rtn = "release" ;
        goto fooy;
        }
    padr   = 20 ; 
    sadr = 0 ;
    fb_frc_1(padr,sadr,&tdcid,1,1,0,0,0,0,0);
    if (fb_errno != 0x800BC119){ 
fb_rtn = "read geographic control TDCSLOT1 secondary address 0 into tdcid" ;         goto fooy;
    }
    eprintf(0,"INFO: TDC1 ID = %x \n",tdcid);
    eprintf(0,"INFO: User Prestart Executed\n");
  }   
if (__the_event__) if (__the_event__) { if (rol->output) { {if(! 
(&(rol->output->list))->c ){(&(rol->output->list))->f = (&(rol->output->list))->l = 
(__the_event__);(__the_event__)->p = 0;} else {(__the_event__)->p = 
(&(rol->output->list))->l;(&(rol->output->list))->l->n = (__the_event__);(&(rol->output->list))->l = (__the_event__);} (__the_event__)->n = 
0;(&(rol->output->list))->c++;} ; } else { if (stream_fd__ > 0) {	__the_event__->data[0] = _service.ourId; 
__the_event__->length = __the_event__->data[1] +2; if (stream_io_write(stream_fd__,__the_event__) <0 ) return 
; } else { {nodeInUse__[__the_event__->fd]--; {if(! (&__the_event__->part->list)->c 
){(&__the_event__->part->list)->f = (&__the_event__->part->list)->l = ( __the_event__);( __the_event__)->p = 0;} else {( 
__the_event__)->p = (&__the_event__->part->list)->l;(&__the_event__->part->list)->l->n = ( 
__the_event__);(&__the_event__->part->list)->l = ( __the_event__);} ( __the_event__)->n = 0;(&__the_event__->part->list)->c++;} ;} ;	} } 
__the_event__ = (DANODE *) 0; } ;     evnb = 0;
    rol->recNb = 0;
      *(unsigned char *) 0x4C0000  = 0x81;
    return;
   fooy: 
daLogMsg(FB_ERRTXT[(((unsigned long)(fb_errno) & 	0x00003fff	) >> 3		) ],	fb_errno, 
global_routine[global_env_depth], fb_rtn,	padr,sadr); ;      return ;
}       
static void __end()
{
      *(unsigned char *) 0x4C0000  = 0x80;
    fptdisable();
  {   
    eprintf(0,"INFO: User End Executing\n");
  }   
if (__the_event__) if (__the_event__) { if (rol->output) { {if(! 
(&(rol->output->list))->c ){(&(rol->output->list))->f = (&(rol->output->list))->l = 
(__the_event__);(__the_event__)->p = 0;} else {(__the_event__)->p = 
(&(rol->output->list))->l;(&(rol->output->list))->l->n = (__the_event__);(&(rol->output->list))->l = (__the_event__);} (__the_event__)->n = 
0;(&(rol->output->list))->c++;} ; } else { if (stream_fd__ > 0) {	__the_event__->data[0] = _service.ourId; 
__the_event__->length = __the_event__->data[1] +2; if (stream_io_write(stream_fd__,__the_event__) <0 ) return 
; } else { {nodeInUse__[__the_event__->fd]--; {if(! (&__the_event__->part->list)->c 
){(&__the_event__->part->list)->f = (&__the_event__->part->list)->l = ( __the_event__);( __the_event__)->p = 0;} else {( 
__the_event__)->p = (&__the_event__->part->list)->l;(&__the_event__->part->list)->l->n = ( 
__the_event__);(&__the_event__->part->list)->l = ( __the_event__);} ( __the_event__)->n = 0;(&__the_event__->part->list)->c++;} ;} ;	} } 
__the_event__ = (DANODE *) 0; } ;     return;
   fooy: 
daLogMsg(FB_ERRTXT[(((unsigned long)(fb_errno) & 	0x00003fff	) >> 3		) ],	fb_errno, 
global_routine[global_env_depth], fb_rtn,	padr,sadr); ;      return ;
}  
static void __pause()
{
      *(unsigned char *) 0x4C0000  = 0x80;
    fptdisable();
  {   
    eprintf(0,"INFO: Pause Executing\n");
  }   
if (__the_event__) if (__the_event__) { if (rol->output) { {if(! 
(&(rol->output->list))->c ){(&(rol->output->list))->f = (&(rol->output->list))->l = 
(__the_event__);(__the_event__)->p = 0;} else {(__the_event__)->p = 
(&(rol->output->list))->l;(&(rol->output->list))->l->n = (__the_event__);(&(rol->output->list))->l = (__the_event__);} (__the_event__)->n = 
0;(&(rol->output->list))->c++;} ; } else { if (stream_fd__ > 0) {	__the_event__->data[0] = _service.ourId; 
__the_event__->length = __the_event__->data[1] +2; if (stream_io_write(stream_fd__,__the_event__) <0 ) return 
; } else { {nodeInUse__[__the_event__->fd]--; {if(! (&__the_event__->part->list)->c 
){(&__the_event__->part->list)->f = (&__the_event__->part->list)->l = ( __the_event__);( __the_event__)->p = 0;} else {( 
__the_event__)->p = (&__the_event__->part->list)->l;(&__the_event__->part->list)->l->n = ( 
__the_event__);(&__the_event__->part->list)->l = ( __the_event__);} ( __the_event__)->n = 0;(&__the_event__->part->list)->c++;} ;} ;	} } 
__the_event__ = (DANODE *) 0; } ;     return;
   fooy: 
daLogMsg(FB_ERRTXT[(((unsigned long)(fb_errno) & 	0x00003fff	) >> 3		) ],	fb_errno, 
global_routine[global_env_depth], fb_rtn,	padr,sadr); ;      return ;
}  
static void __go()
{
    fpttoggle();
  {   
    eprintf(0,"INFO: Go Executing\n");
  }   
if (__the_event__) if (__the_event__) { if (rol->output) { {if(! 
(&(rol->output->list))->c ){(&(rol->output->list))->f = (&(rol->output->list))->l = 
(__the_event__);(__the_event__)->p = 0;} else {(__the_event__)->p = 
(&(rol->output->list))->l;(&(rol->output->list))->l->n = (__the_event__);(&(rol->output->list))->l = (__the_event__);} (__the_event__)->n = 
0;(&(rol->output->list))->c++;} ; } else { if (stream_fd__ > 0) {	__the_event__->data[0] = _service.ourId; 
__the_event__->length = __the_event__->data[1] +2; if (stream_io_write(stream_fd__,__the_event__) <0 ) return 
; } else { {nodeInUse__[__the_event__->fd]--; {if(! (&__the_event__->part->list)->c 
){(&__the_event__->part->list)->f = (&__the_event__->part->list)->l = ( __the_event__);( __the_event__)->p = 0;} else {( 
__the_event__)->p = (&__the_event__->part->list)->l;(&__the_event__->part->list)->l->n = ( 
__the_event__);(&__the_event__->part->list)->l = ( __the_event__);} ( __the_event__)->n = 0;(&__the_event__->part->list)->c++;} ;} ;	} } 
__the_event__ = (DANODE *) 0; } ;     fptenable();
    fpttoggle();
      *(unsigned char *) 0x4C0000  = 0x82;
    return;
   fooy: 
daLogMsg(FB_ERRTXT[(((unsigned long)(fb_errno) & 	0x00003fff	) >> 3		) ],	fb_errno, 
global_routine[global_env_depth], fb_rtn,	padr,sadr); ;      return ;
}
void tstrig(int EVTYPE,int EVSOURCE)
{
    long EVENT_LENGTH;
    fptdisable ();
    intLevelSet (1);
    trig_type = 1;
    evnb++;
  {   
    padr   = 20 ; 
    fb_fwc_1(padr,0,0x400,1,1,0,1,0,1,1);
      if (fb_errno != 0x800BC119){ 
          fb_rtn = "write 0x400" ;
          goto fooy;
      }
    fb_frd_1(0,0,0,1,1,1,1,1,0,0); 
    if (fb_errno != 0x800BC119){ 
        fb_rtn = "release" ;
        goto fooy;
        }
    padr   = 20  ;
    fpbrf(-1,0); 
    fb_frd_1(0,0,0,1,1,1,1,1,0,0); 
    if (fb_errno != 0x800BC119){ 
        fb_rtn = "release" ;
        goto fooy;
        }
  }   
    return;
  fooy: 
    *rol->dabufp = 0xFB000BAD;
    *rol->dabufp++;
printf (FB_ERRTXT[(((unsigned long)(fb_errno) & 	0x00003fff	) >> 3		) ],	fb_errno, 
global_routine[global_env_depth], fb_rtn,	padr,sadr); ;      return ;
}  
void tstrig_done()
{
  {   
  }   
    fptenable();
    fpttoggle();
      *(unsigned char *) 0x4C0000  = 0xc2;
      *(unsigned char *) 0x4C0000  = 0x82;
    return;
   fooy: 
printf (FB_ERRTXT[(((unsigned long)(fb_errno) & 	0x00003fff	) >> 3		) ],	fb_errno, 
global_routine[global_env_depth], fb_rtn,	padr,sadr); ;      return ;
}  
static void __status()
{
  {   
  }   
}  
