/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	Fastbus Standard Routines Library for SFI, level 1
 *	
 * Author:  David Abbott, CEBAF Data Acquisition Group
 *
 * Revision History:
 *
 *
 *	This file contains low level routines to be called by the Fastbus
 *	standard routines to perform Fastbus actions on the STRUCK SFI.
 *
 *  Public Routines:
 *  ---------------
 *      fb_frd_1()               read data
 *      fb_fwd_1()               write data
 *      fb_frc_1()               read control
 *      fb_fwc_1()               write control
 *      fb_frdm_1()              read data multiple listener
 *      fb_fwdm_1()              write data multiple listener
 *      fb_frcm_1()              read control multiple listener
 *      fb_fwcm_1()              write control multiple listener
 *
 *      fb_frdb_1()              read data block
 */

/*======================================================================*/
/*
   Functions    : FWC FRC

   In           : See generic input description at top of file
		  
   Out          : returns 0, if no error, else number of errors

   Description  : Single Cycle Write and Read routines to control space
*/
/*======================================================================*/

unsigned long 
fb_fwc_1(PAddr, SAddr, WData, EG, noarb, nopa, nosa, nodata, holdas, hold)

unsigned long PAddr;
unsigned long SAddr;
unsigned long WData;
unsigned long EG;
unsigned long noarb;
unsigned long nopa;
unsigned long nosa;
unsigned long nodata;
unsigned long holdas;
unsigned long hold;

{
register unsigned long reg32 = 0;
register Return = 0;
register Exit   = 0;

if (!nopa)
  *fastPrimCsr  = PAddr; /* primary address cycle   */
if (!nosa)
  *fastSecadW   = SAddr; /* secondary address cycle */ 
if (holdas)
  *fastRndmW = WData;
else
  *fastRndmWDis = WData;


/* wait for sequencer done */
do 
   {
   reg32 = *sfi.sequencerStatusReg;

   switch(reg32 & 0x00008001)
      {
      case 0x00008001:
         /* OK */
         Return = 0;
         Exit = 1;
         break;
      case 0x00000001:
         /* Not Finished */
         break;
      case 0x00000000:
         /* Not Initialized */
         Return = *sfi.sequencerStatusReg & 0x0000ffff;
         Return |= 0x00020000;
         Exit = 1;
         break;
      case 0x00008000:
         /* Bad Status is set, we will see */
         Return = *sfi.sequencerStatusReg & 0x0000ffff;
         Return |= 0x00010000;
         Exit = 1;
         break;
      }
   } while(!Exit);



return(Return);

}



unsigned long 
fb_frc_1(PAddr, SAddr, rData, EG, noarb, nopa, nosa, nodata, holdas, hold)

unsigned long PAddr;
unsigned long SAddr;
unsigned long *rData;
unsigned long EG;
unsigned long noarb;
unsigned long nopa;
unsigned long nosa;
unsigned long nodata;
unsigned long holdas;
unsigned long hold;

{
register unsigned long reg32 = 0;
register Return = 0;
register Exit   = 0;

if (!nopa)
  *fastPrimCsr  = PAddr; /* primary address cycle   */
if (!nosa)
  *fastSecadW   = SAddr; /* secondary address cycle */ 
if (holdas)
  *fastRndmR = reg32;
else
  *fastRndmRDis = reg32;



/* wait for sequencer done */
do 
   {
   reg32 = *sfi.sequencerStatusReg;

   switch(reg32 & 0x00008001)
      {
      case 0x00008001:
         /* OK */
         Return = 0;
         Exit = 1;
        /* read seq fifo flags */
        /* check if EMPTY ; if EMPTY then Dummy read and Loop until not Empty */
        /*                   else if not empty then read fifo */


	reg32 = *sfi.readSeqFifoFlags;

	
        if((reg32 & 0x00000010) == 0x00000010)
	   {
	   reg32 = *sfi.readSeq2VmeFifoBase; /* dummy read */
	   reg32 = *sfi.readSeqFifoFlags;
           if((reg32 & 0x00000010) == 0x00000010) 
              {
	      /* Fehler !!! */
              Return = *sfi.sequencerStatusReg & 0x0000ffff;
              Return |= 0x00100000;
              }
           }
        
         /* read fifo */

         *rData = *sfi.readSeq2VmeFifoBase;
         
         break;
      case 0x00000001:
         /* Not Finished */
         break;
      case 0x00000000:
         /* Not Initialized */
         Return = *sfi.sequencerStatusReg & 0x0000ffff;
         Return |= 0x00020000;
         Exit = 1;
         break;
      case 0x00008000:
         /* Bad Status is set, we will see */
         Return = *sfi.sequencerStatusReg & 0x0000ffff;
         Return |= 0x00010000;
         Exit = 1;
         break;
      }
   } while(!Exit);



return(Return);

}

/*======================================================================*/
/*
   Functions    : FWD FRD

   In           : See generic input description at top of file
		  
   Out          : returns 0, if no error, else number of errors

   Description  : Single Cycle Write and Read routines to data space

*/
/*======================================================================*/

unsigned long 
fb_fwd_1(PAddr, SAddr, WData, EG, noarb, nopa, nosa, nodata, holdas, hold)

unsigned long PAddr;
unsigned long SAddr;
unsigned long WData;
unsigned long EG;
unsigned long noarb;
unsigned long nopa;
unsigned long nosa;
unsigned long nodata;
unsigned long holdas;
unsigned long hold;

{
register unsigned long reg32 = 0;
register Return = 0;
register Exit   = 0;

if (!nopa)
  *fastPrimDsr  = PAddr; /* primary address cycle   */
if (!nosa)
  *fastSecadW   = SAddr; /* secondary address cycle */ 
if (holdas)
  *fastRndmW = WData;
else
  *fastRndmWDis = WData;


/* wait for sequencer done */
do 
   {
   reg32 = *sfi.sequencerStatusReg;

   switch(reg32 & 0x00008001)
      {
      case 0x00008001:
         /* OK */
         Return = 0;
         Exit = 1;
         break;
      case 0x00000001:
         /* Not Finished */
         break;
      case 0x00000000:
         /* Not Initialized */
         Return = *sfi.sequencerStatusReg & 0x0000ffff;
         Return |= 0x00020000;
         Exit = 1;
         break;
      case 0x00008000:
         /* Bad Status is set, we will see */
         Return = *sfi.sequencerStatusReg & 0x0000ffff;
         Return |= 0x00010000;
         Exit = 1;
         break;
      }
   } while(!Exit);



return(Return);

}



unsigned long 
fb_frd_1(PAddr, SAddr, rData, EG, noarb, nopa, nosa, nodata, holdas, hold)

unsigned long PAddr;
unsigned long SAddr;
unsigned long *rData;
unsigned long EG;
unsigned long noarb;
unsigned long nopa;
unsigned long nosa;
unsigned long nodata;
unsigned long holdas;
unsigned long hold;

{
register unsigned long reg32 = 0;
register Return = 0;
register Exit   = 0;

if (!nopa)
  *fastPrimDsr  = PAddr; /* primary address cycle   */
if (!nosa)
  *fastSecadW   = SAddr; /* secondary address cycle */ 
if (holdas)
  *fastRndmR = reg32;
else
  *fastRndmRDis = reg32;



/* wait for sequencer done */
do 
   {
   reg32 = *sfi.sequencerStatusReg;

   switch(reg32 & 0x00008001)
      {
      case 0x00008001:
         /* OK */
         Return = 0;
         Exit = 1;
        /* read seq fifo flags */
        /* check if EMPTY ; if EMPTY then Dummy read and Loop until not Empty */
        /*                   else if not empty then read fifo */


	reg32 = *sfi.readSeqFifoFlags;

	
        if((reg32 & 0x00000010) == 0x00000010)
	   {
	   reg32 = *sfi.readSeq2VmeFifoBase; /* dummy read */
	   reg32 = *sfi.readSeqFifoFlags;
           if((reg32 & 0x00000010) == 0x00000010) 
              {
	      /* Fehler !!! */
              Return = *sfi.sequencerStatusReg & 0x0000ffff;
              Return |= 0x00100000;
              }
           }
        
         /* read fifo */

         *rData = *sfi.readSeq2VmeFifoBase;
         
         break;
      case 0x00000001:
         /* Not Finished */
         break;
      case 0x00000000:
         /* Not Initialized */
         Return = *sfi.sequencerStatusReg & 0x0000ffff;
         Return |= 0x00020000;
         Exit = 1;
         break;
      case 0x00008000:
         /* Bad Status is set, we will see */
         Return = *sfi.sequencerStatusReg & 0x0000ffff;
         Return |= 0x00010000;
         Exit = 1;
         break;
      }
   } while(!Exit);



return(Return);

}

/*======================================================================*/
/*
   Functions    : FWCM FRCM

   In           : See generic input description at top of file
		  
   Out          : returns 0, if no error, else number of errors

   Description  : Single Cycle Write and Read routines to control space
                  for Multi-Listeners.
*/
/*======================================================================*/

unsigned long 
fb_fwcm_1(PAddr, SAddr, WData, noarb, nopa, nosa, nodata, holdas, hold)

unsigned long PAddr;
unsigned long SAddr;
unsigned long WData;
unsigned long noarb;
unsigned long nopa;
unsigned long nosa;
unsigned long nodata;
unsigned long holdas;
unsigned long hold;

{
register unsigned long reg32 = 0;
register Return = 0;
register Exit   = 0;

if (!nopa)
  *fastPrimCsrM  = PAddr; /* primary address cycle   */
if (!nosa)
  *fastSecadW   = SAddr; /* secondary address cycle */ 
if (holdas)
  *fastRndmW = WData;
else
  *fastRndmWDis = WData;


/* wait for sequencer done */
do 
   {
   reg32 = *sfi.sequencerStatusReg;

   switch(reg32 & 0x00008001)
      {
      case 0x00008001:
         /* OK */
         Return = 0;
         Exit = 1;
         break;
      case 0x00000001:
         /* Not Finished */
         break;
      case 0x00000000:
         /* Not Initialized */
         Return = *sfi.sequencerStatusReg & 0x0000ffff;
         Return |= 0x00020000;
         Exit = 1;
         break;
      case 0x00008000:
         /* Bad Status is set, we will see */
         Return = *sfi.sequencerStatusReg & 0x0000ffff;
         Return |= 0x00010000;
         Exit = 1;
         break;
      }
   } while(!Exit);



return(Return);

}



unsigned long 
fb_frcm_1(PAddr, SAddr, rData, noarb, nopa, nosa, nodata, holdas, hold)

unsigned long PAddr;
unsigned long SAddr;
unsigned long *rData;
unsigned long noarb;
unsigned long nopa;
unsigned long nosa;
unsigned long nodata;
unsigned long holdas;
unsigned long hold;

{
register unsigned long reg32 = 0;
register Return = 0;
register Exit   = 0;

if (!nopa)
  *fastPrimCsrM  = PAddr; /* primary address cycle   */
if (!nosa)
  *fastSecadW   = SAddr; /* secondary address cycle */ 
if (holdas)
  *fastRndmR = reg32;
else
  *fastRndmRDis = reg32;



/* wait for sequencer done */
do 
   {
   reg32 = *sfi.sequencerStatusReg;

   switch(reg32 & 0x00008001)
      {
      case 0x00008001:
         /* OK */
         Return = 0;
         Exit = 1;
        /* read seq fifo flags */
        /* check if EMPTY ; if EMPTY then Dummy read and Loop until not Empty */
        /*                   else if not empty then read fifo */


	reg32 = *sfi.readSeqFifoFlags;

	
        if((reg32 & 0x00000010) == 0x00000010)
	   {
	   reg32 = *sfi.readSeq2VmeFifoBase; /* dummy read */
	   reg32 = *sfi.readSeqFifoFlags;
           if((reg32 & 0x00000010) == 0x00000010) 
              {
	      /* Fehler !!! */
              Return = *sfi.sequencerStatusReg & 0x0000ffff;
              Return |= 0x00100000;
              }
           }
        
         /* read fifo */

         *rData = *sfi.readSeq2VmeFifoBase;
         
         break;
      case 0x00000001:
         /* Not Finished */
         break;
      case 0x00000000:
         /* Not Initialized */
         Return = *sfi.sequencerStatusReg & 0x0000ffff;
         Return |= 0x00020000;
         Exit = 1;
         break;
      case 0x00008000:
         /* Bad Status is set, we will see */
         Return = *sfi.sequencerStatusReg & 0x0000ffff;
         Return |= 0x00010000;
         Exit = 1;
         break;
      }
   } while(!Exit);



return(Return);

}

/*======================================================================*/
/*
   Functions    : FWDM FRDM

   In           : See generic input description at top of file
		  
   Out          : returns 0, if no error, else number of errors

   Description  : Single Cycle Write and Read routines to data space
                  for Multi-Listeners.
*/
/*======================================================================*/

unsigned long 
fb_fwdm_1(PAddr, SAddr, WData, noarb, nopa, nosa, nodata, holdas, hold)

unsigned long PAddr;
unsigned long SAddr;
unsigned long WData;
unsigned long noarb;
unsigned long nopa;
unsigned long nosa;
unsigned long nodata;
unsigned long holdas;
unsigned long hold;

{
register unsigned long reg32 = 0;
register Return = 0;
register Exit   = 0;

if (!nopa)
  *fastPrimDsrM  = PAddr; /* primary address cycle   */
if (!nosa)
  *fastSecadW   = SAddr; /* secondary address cycle */ 
if (holdas)
  *fastRndmW = WData;
else
  *fastRndmWDis = WData;


/* wait for sequencer done */
do 
   {
   reg32 = *sfi.sequencerStatusReg;

   switch(reg32 & 0x00008001)
      {
      case 0x00008001:
         /* OK */
         Return = 0;
         Exit = 1;
         break;
      case 0x00000001:
         /* Not Finished */
         break;
      case 0x00000000:
         /* Not Initialized */
         Return = *sfi.sequencerStatusReg & 0x0000ffff;
         Return |= 0x00020000;
         Exit = 1;
         break;
      case 0x00008000:
         /* Bad Status is set, we will see */
         Return = *sfi.sequencerStatusReg & 0x0000ffff;
         Return |= 0x00010000;
         Exit = 1;
         break;
      }
   } while(!Exit);



return(Return);

}



unsigned long 
fb_frdm_1(PAddr, SAddr, rData, noarb, nopa, nosa, nodata, holdas, hold)

unsigned long PAddr;
unsigned long SAddr;
unsigned long *rData;
unsigned long noarb;
unsigned long nopa;
unsigned long nosa;
unsigned long nodata;
unsigned long holdas;
unsigned long hold;

{
register unsigned long reg32 = 0;
register Return = 0;
register Exit   = 0;

if (!nopa)
  *fastPrimDsrM  = PAddr; /* primary address cycle   */
if (!nosa)
  *fastSecadW   = SAddr; /* secondary address cycle */ 
if (holdas)
  *fastRndmR = reg32;
else
  *fastRndmRDis = reg32;



/* wait for sequencer done */
do 
   {
   reg32 = *sfi.sequencerStatusReg;

   switch(reg32 & 0x00008001)
      {
      case 0x00008001:
         /* OK */
         Return = 0;
         Exit = 1;
        /* read seq fifo flags */
        /* check if EMPTY ; if EMPTY then Dummy read and Loop until not Empty */
        /*                   else if not empty then read fifo */


	reg32 = *sfi.readSeqFifoFlags;

	
        if((reg32 & 0x00000010) == 0x00000010)
	   {
	   reg32 = *sfi.readSeq2VmeFifoBase; /* dummy read */
	   reg32 = *sfi.readSeqFifoFlags;
           if((reg32 & 0x00000010) == 0x00000010) 
              {
	      /* Fehler !!! */
              Return = *sfi.sequencerStatusReg & 0x0000ffff;
              Return |= 0x00100000;
              }
           }
        
         /* read fifo */

         *rData = *sfi.readSeq2VmeFifoBase;
         
         break;
      case 0x00000001:
         /* Not Finished */
         break;
      case 0x00000000:
         /* Not Initialized */
         Return = *sfi.sequencerStatusReg & 0x0000ffff;
         Return |= 0x00020000;
         Exit = 1;
         break;
      case 0x00008000:
         /* Bad Status is set, we will see */
         Return = *sfi.sequencerStatusReg & 0x0000ffff;
         Return |= 0x00010000;
         Exit = 1;
         break;
      }
   } while(!Exit);



return(Return);

}


unsigned long 
fb_frdb_1(PAddr, SAddr, Buffer, Max_ExpLWord, next_buffer, cnt_RecLWord, Mode, Wait)

unsigned long PAddr;           /* Primary Address */
unsigned long SAddr;	       /* Secondary Address */
unsigned long Buffer;          /* Address of LWord-Buffer (VME-Slave Address!!! )*/
unsigned long Max_ExpLWord;    /* Max. Count of 32Bit Datawords  */
unsigned long *next_buffer;    /* Address of LWord-Buffer after READ */
unsigned long *cnt_RecLWord;   /* Count of Received 32Bit Datawords  */ 
unsigned long Mode;            /* Readout-Modus (Direct and/or VME) */
			       /* 0x10 only Direct            */
			       /* 0x09 VMED32 Data cycle      */
			       /* 0x0A VMED32 Blocktransfer   */
                               /* 0x0C VMED64 Blocktransfer   */
			       /* 0x19 Direct and VME32Datacycl. */
			       /* 0x1A Direct and VME32Blocktr.  */
                               /* 0x1C Direct and VME64Blocktr.  */
unsigned long Wait;            /* Count for CPU idle loop before
                                  polling the Sequencer status */
{
register unsigned long reg32 = 0;
register Return = 0;
register Exit   = 0;
unsigned long ii,kk;

Max_ExpLWord &= 0x00ffffff;
Max_ExpLWord |= (Mode << 24);

*fastLoadDmaAddressPointer = Buffer;       /* Load local addr pointer */
*fastPrimDsr               = PAddr;        /* primary address cycle   */
*fastSecadW                = SAddr;        /* secondary address cycle */ 
*fastStartFrdbWithClearWc  = Max_ExpLWord; /* start dma               */
*fastDiscon                = reg32;        /* disconnect              */
*fastStoreFrdbWc           = reg32;        /* get wordcount           */
*fastStoreFrdbAp           = reg32;        /* get final addr ptr      */

/* wait for sequencer done */
for (ii=0;ii<Wait;ii++)
  kk = ii*ii;

do 
   {
   reg32 = *sfi.sequencerStatusReg;

   switch(reg32 & 0x00008001)
      {
      case 0x00008001:
         /* OK */
         Return = 0;
         Exit = 1;
        /* read seq fifo flags */
        /* check if EMPTY ; if EMPTY then Dummy read and Loop until not Empty */
        /*                   else if not empty then read fifo */


	reg32 = *sfi.readSeqFifoFlags;

	
        if((reg32 & 0x00000010) == 0x00000010)
	   {
	   reg32 = *sfi.readSeq2VmeFifoBase; /* dummy read */
	   reg32 = *sfi.readSeqFifoFlags;
           if((reg32 & 0x00000010) == 0x00000010) 
              {
	      /* Fehler !!! */
              Return = *sfi.sequencerStatusReg & 0x0000ffff;
              Return |= 0x00100000;
              }
           }
        
         /* read fifo */

         *cnt_RecLWord = *sfi.readSeq2VmeFifoBase;
         /* Check for FIFO Empty: */
	 reg32 = *sfi.readSeqFifoFlags;
         if((reg32 & 0x00000010) == 0x00000010) 
            {
	    /* Fehler !!! */
            Return = *sfi.sequencerStatusReg & 0x0000ffff;
            Return |= 0x00040000;
            }

         *next_buffer  = *sfi.readSeq2VmeFifoBase;

         break;
      case 0x00000001:
         /* Not Finished */
         break;
      case 0x00000000:
         /* Not Initialized */
         Return = *sfi.sequencerStatusReg & 0x0000ffff;
         Return |= 0x00020000;
         Exit = 1;
         break;
      case 0x00008000:
         /* Bad Status is set, we will see */
         Return = *sfi.sequencerStatusReg & 0x0000ffff;
         Return |= 0x00010000;
         Exit = 1;
         break;
      }
   } while(!Exit);



return(Return);


}
