#ifndef __FASTBUS__
#define __FASTBUS__

#include "fb_trigLib.h"
#include "fb_types.h"
#include "fb_fscc_macro.h"

#ifdef FB_BUILD_INLINE
#include "fb_status_macros.h"
#include "fb_fscc_inline.h"
#else
#include "fb_proto_1.h"
#endif

#ifndef FB_LIMITED_STATUS
  char	*FB_ERRTXT[FB_ERROR_MAX+1] =
	{
	"",
	"ERROR: 0x%X %s,%s - address release timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - AK timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - block data - SS=2, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data parity error, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - data SS=0, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=1, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=2, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=3, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=4, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=5, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=6, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=7, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - DK release timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - DK timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - long timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - pad cycle SS=0, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - pad cycle SS=1, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - pad cycle SS=2, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - pad cycle SS=3, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - pad cycle SS=4, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - pad cycle SS=5, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - pad cycle SS=6, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - pad cycle SS=7, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - s.addr cycle DK timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=0, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=1, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=2, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=3, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=4, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=5, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=6, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=7, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - software timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - wait timeout, PAD %d, SAD %d\n",

	"ERROR: 0x%X %s,%s - normal successful completion\n",
	"ERROR: 0x%X %s,%s - error accessing data buffer\n",
	"ERROR: 0x%X %s,%s - abort action\n",
	"ERROR: 0x%X %s,%s - already connected\n",
	"ERROR: 0x%X %s,%s - bad parameter value\n",
	"ERROR: 0x%X %s,%s - buffer overflow\n",
	"ERROR: 0x%X %s,%s - session closed, no actions possible\n",
	"ERROR: 0x%X %s,%s - routine connection failed\n",
	"ERROR: 0x%X %s,%s - routine disconnect failed\n",
	"ERROR: 0x%X %s,%s - environment active\n",
	"ERROR: 0x%X %s,%s - environment id overflow\n",
	"ERROR: 0x%X %s,%s - environment overflow\n",
	"ERROR: 0x%X %s,%s - environment release\n",
	"ERROR: 0x%X %s,%s - generic error\n",
	"ERROR: 0x%X %s,%s - generic fatal\n",
	"ERROR: 0x%X %s,%s - hardware error\n",
	"ERROR: 0x%X %s,%s - hardware warning\n",
	"ERROR: 0x%X %s,%s - holding address\n",
	"ERROR: 0x%X %s,%s - holding bus\n",
	"ERROR: 0x%X %s,%s - error was ignored\n",
	"ERROR: 0x%X %s,%s - illegal parameter value\n",
	"ERROR: 0x%X %s,%s - illegal sequential buffer id\n",
	"ERROR: 0x%X %s,%s - unexpected implementation error\n",
	"ERROR: 0x%X %s,%s - generic informational\n",
	"ERROR: 0x%X %s,%s - invalid environment id\n",
	"ERROR: 0x%X %s,%s - invalid list pointer\n",
	"ERROR: 0x%X %s,%s - invalid port id\n",
	"ERROR: 0x%X %s,%s - invalid sequential buffer id\n",
	"ERROR: 0x%X %s,%s - last pad\n",
	"ERROR: 0x%X %s,%s - last secondary address\n",
	"ERROR: 0x%X %s,%s - last list pointer\n",
	"ERROR: 0x%X %s,%s - list overflow\n",
	"ERROR: 0x%X %s,%s - long timer on\n",
	"ERROR: 0x%X %s,%s - no address connection\n",
	"ERROR: 0x%X %s,%s - no more status\n",
	"ERROR: 0x%X %s,%s - no privilege\n",
	"ERROR: 0x%X %s,%s - no supplementary status\n",
	"ERROR: 0x%X %s,%s - not connected\n",
	"ERROR: 0x%X %s,%s - not holding mastership\n",
	"ERROR: 0x%X %s,%s - not master\n",
	"ERROR: 0x%X %s,%s - session already open\n",
	"ERROR: 0x%X %s,%s - operation pending\n",
	"ERROR: 0x%X %s,%s - pipeline transfer\n",
	"ERROR: 0x%X %s,%s - pointer overflow\n",
	"ERROR: 0x%X %s,%s - port active\n",
	"ERROR: 0x%X %s,%s - port already allocated\n",
	"ERROR: 0x%X %s,%s - port not allocated\n",
	"ERROR: 0x%X %s,%s - port not available\n",
	"ERROR: 0x%X %s,%s - port owned\n",
	"ERROR: 0x%X %s,%s - read only parameter\n",
	"ERROR: 0x%X %s,%s - operation successfully retried\n",
	"ERROR: 0x%X %s,%s - sequenctial buffer active\n",
	"ERROR: 0x%X %s,%s - sequenctial buffer exists\n",
	"ERROR: 0x%X %s,%s - sequenctial buffer id overflow\n",
	"ERROR: 0x%X %s,%s - software timer on\n",
	"ERROR: 0x%X %s,%s - status not found\n",
	"ERROR: 0x%X %s,%s - status overflow\n",
	"ERROR: 0x%X %s,%s - successful operation\n",
	"ERROR: 0x%X %s,%s - unknown error\n",
	"ERROR: 0x%X %s,%s - unknown parameter\n",
	"ERROR: 0x%X %s,%s - unsupported port operation\n",
	"ERROR: 0x%X %s,%s - unsupported paramter\n",
	"ERROR: 0x%X %s,%s - unsupported routine\n",
	"ERROR: 0x%X %s,%s - user array overflow\n",
	"ERROR: 0x%X %s,%s - generic warning\n",
	"ERROR: 0x%X %s,%s - fscc FIFO error\n",
	};
#endif

static int padr,sadr;
static char *fb_rtn;

#define IFERROR(str) \
  if (fb_errno!=FB_ERR_NORMAL) {\
    fb_rtn = str;\
    goto fooy;\
  }


#ifdef FB_LIMITED_STATUS
#define FB_REPORT_ERROR  daLogMsg("ERROR","FB %0X\n",fb_errno);
#else
#define FB_REPORT_ERROR  daLogMsg(FB_ERRTXT[FB_GET_ERROR_VALUE(fb_errno)],\
	   fb_errno, \
	   global_routine[global_env_depth],  \
	   fb_rtn,\
	   padr,sadr);
#endif

inline void 
  fpbr(int pa, long len) 
{
  int i;
  if ((len>4000)||(len<1)) len = 4000;
  if(pa<0) {
    fb_frdb_1(0,0,(rol->dabufp),(len<<2),1,1,1,1,0,0,1,1,0);
  } else {
    fb_frdb_1(pa,0,(rol->dabufp),(len<<2),1,1,0,1,0,0,0,0,0);
  }
  IFERROR("fb_frdb_1 data");
  fb_frlen_1(&i);
  IFERROR("fprb");
  (rol->dabufp) += (i>>2);
  return;
  
 fooy:
  FB_REPORT_ERROR;
  return;
}

static inline void 
  fpbrf(int pa, long len) 
{
  int i, ix;
#ifdef PARALLEL_LINK
  len=4095;
#else
  if ((len>512)||(len<1)) len = 512;
  FSCC_DATARS;
  FSCC_COPYRS;
  FSCC_COPYEN;
#endif
  if(pa<0) {
    fb_frdb_1(0 ,0,FB_DATA_PATH_ADDR,(len<<2),1,1,1,1,0,0,1,1,0);
  } else {
    fb_frdb_1(pa,0,FB_DATA_PATH_ADDR,(len<<2),1,1,0,1,0,0,0,0,0);
  }
  IFERROR("fb_frdb_1 data");
#ifndef PARALLEL_LINK
  fb_frlen_1(&i);
  bufp = rol->dabufp;
  if((ix = (i>>2) - 1)>=0) {   /* # of longwords - 1*/

  asm("movel #0x680000,a2");                /* address of Processor fifo        */
  asm("movel %0,d1":/*none*/:"g" (ix));     /* load word count - 1              */
  asm("movel _bufp,a0");                    /* get pointer to rol               */
  asm("movel a0@,a1");                      /* a1= *dabufp                      */
  asm("movel a2@,a1@+");                    /* move from fifo to *dabufp        */
  asm(".long 1472856060");                  /* asm("dbf d1,-4")                 */
  asm("movel a1,a0@");                      /* put a1 back into *dabufp         */
  }

  FSCC_COPYDIS;
  IFERROR("fpbrf buffer");
#endif
  return;
  
 fooy:
  FB_REPORT_ERROR;
  return;
}

static int FSCC_handlers,FSCCflag; /* NOTE FSCC only is allowed one inturrupt source */
static unsigned long FSCC_isAsync;

void FSCC_int_handler()
{
  theIntHandler(FSCC_handlers);
}


#define FSCC_TEST fpttest

#define FSCC_INIT { FSCC_handlers =0;FSCC_isAsync = 0;FSCCflag = 0;}

#define FSCC_ASYNC(code,id) {printf("linking async FSCC trigger to id %d \n",id); \
			       FSCC_handlers = (id);FSCC_isAsync = 1;fptriglink(FSCC_int_handler);}

#define FSCC_SYNC(code,id)  {printf("linking sync FSCC trigger to id %d \n",id); \
			      FSCC_handlers = (id);FSCC_isAsync = 0;}

#define FSCC_SETA(code) {theIntHandler(FSCC_handlers);}

#define FSCC_SETS(code) FSCCflag = code;

#define FSCC_ENA(code,val) fptenable();

#define FSCC_DIS(code) fptdisable();

#define FSCC_CLRS(code) FSCCflag = 0;

#define FSCC_GETID(code) FSCC_handlers

#define FSCC_TTYPE fpttype

#define FSCC_START(val)	 {;}

#define FSCC_STOP(val)	 {fptdisable();}

#define FSCC_ENCODE(code) code

#endif
