/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	CODA readout language compiler main routine
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: crl_main.c,v $
 *   Revision 1.1.1.1  1996/08/21 19:20:51  heyes
 *   Imported sources
 *
*	  Revision 1.1  94/03/16  10:00:56  10:00:56  heyes (Graham Heyes)
*	  Initial revision
*	  
*	  Revision 1.1  93/10/27  09:29:31  09:29:31  heyes (Graham Heyes)
*	  Initial revision
*	  
 *	  
 */
#include <stdio.h>
#include <string.h>
#include "crlHash.h"

int mode;
int type;
FILE *fout;
char infile[100];
char *rolf_name;

extern void yyparse();

main(argc, argv)
     int argc;
     char **argv;
{
  char *outfile;
  char *p,*q,temp[40];
  extern FILE *yyin;

  mode = type = 0;

  if(argc > 3 || argc < 2){
    fprintf(stderr,"Usage: %s inputfile\n",argv[0]);
    exit(1);
  }
  if(argc > 1){
    strcpy(infile,argv[1]);
    yyin = fopen(infile,"r");
    if(yyin == NULL){
      fprintf(stderr, "Cannot open file %s\n",infile);
      exit(1);
    }
  }
  if(argc > 2){
    outfile = argv[2];
  }
  else{
    p = rolf_name = infile;
    q = temp;
    while(*p != '.'){
      if (*p == '/') rolf_name = p +1;
      *q = *p;
      q++; p++;
    }
    *q = '\0';
    *p = '\0';
    strcat(temp,".c");
    outfile = temp;
  }

  fout = fopen(outfile,"w");
  if(fout == NULL){
    fprintf(stderr,"Cannot open file %s\n",outfile);
    exit(1);
  }
  crlHashCreate();
  yyparse();
  /*printf("Destroy hash table \n");*/
  crlHashDestroy();
}
