/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *     CODA readout language symbol hashtable related routines
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: crlHashLib.c,v $
 *   Revision 1.2  1998/02/03 21:11:12  rwm
 *   Nix compiler warnings.
 *
 *   Revision 1.1.1.1  1996/08/21 19:20:51  heyes
 *   Imported sources
 *
*	  Revision 1.1  94/03/16  10:00:54  10:00:54  heyes (Graham Heyes)
*	  Initial revision
*	  
*	  Revision 1.1  93/10/27  09:29:30  09:29:30  heyes (Graham Heyes)
*	  Initial revision
*	  
 *	  
 */
#include <stdio.h>
#include <string.h>
#include "crlHash.h"

static symbolEntry *hash_table_head[97];
static void crlSymbol_copy();
static int  hashFunction();

/****************************************************************
 *           void crlHashCreate()                               *
 * Hash table creation routine. Hash table is organized in      *
 * such a way to eliminate the collision                        *
 ***************************************************************/
void crlHashCreate()
{
   register int i;
   
   for(i=0;i<97;i++){
     hash_table_head[i]=(symbolEntry *)calloc(1,sizeof(symbolEntry));
     if(hash_table_head[i] == NULL){
       fprintf(stderr,"Cannot allocate memory for crl hash table\n");
       exit(1);
     }
     else{
       hash_table_head[i]->crlSymbol.var_name = (char *)NULL;
       hash_table_head[i]->crlSymbol.var_type = 97;
       hash_table_head[i]->next=(symbolEntry *)NULL;
     }
   }
 }

/*************************************************************
 *              int crlHashAdd()                             *
 * Add an item to the hashTable, return 0 on success         *
 * return 1 on failure                                       *
 ************************************************************/
int crlHashAdd(key,symbol)
char  *key;
CrlSymbol *symbol;
{
  int hashvalue,i;
  int slot_num;
  symbolEntry *ptr,*txt;

  slot_num= hash_table_head[0]->crlSymbol.var_type;
  hashvalue=hashFunction(key,slot_num);

  for(ptr=hash_table_head[hashvalue]->next;ptr!=NULL;ptr=ptr->next){
    if((strcmp(ptr->crlSymbol.var_name,key)) == 0)
      break;
    else
      ;
  }
  if(ptr !=NULL)
    return 1;
  else{
    txt=(symbolEntry *)calloc(1,sizeof(symbolEntry));
    if(txt == NULL){
      fprintf(stderr,"Cannot allocate memory for this cns entry.\n");
      exit(1);
    }
    crlSymbol_copy(&txt->crlSymbol,symbol);
    txt->next = hash_table_head[hashvalue]->next;
    hash_table_head[hashvalue]->next=txt;
    return 0;
  }
}

/************************************************************
 *            int crlHashDelete()                           *
 * delete a single item from the Hash Table                 *
 * return 0 on success, return 1 on failure                 *
 ***********************************************************/
int crlHashDelete(key)
char       *key;
{
  int hashvalue;
  symbolEntry *ptr,*qtr;
  int slot_num;

  slot_num=hash_table_head[0]->crlSymbol.var_type; /* get number of slot */
  hashvalue=hashFunction(key,slot_num);
  qtr=hash_table_head[hashvalue];
  for(ptr=hash_table_head[hashvalue]->next;ptr!=NULL;ptr=ptr->next){
    if((strcmp(ptr->crlSymbol.var_name, key)) == 0)
      break;
    else
      qtr=qtr->next;
  }

  if(ptr !=NULL){
    qtr->next=ptr->next;
    ptr->next=NULL;
    cfree(ptr,1,sizeof(symbolEntry));
    return 0;
  }
  else
    return 1;
  
}

/**************************************************************
 *            int crlHashFind()                               *
 * Find out whether a particular item which has key 'key'     *
 * existed in the hash Tabel, return 0 on success,            *
 * return 1 for failure                                       *
 *************************************************************/
int crlHashFind(key)
char *key;
{
  int hashvalue;
  symbolEntry *ptr;
  int slot_num;

  slot_num=hash_table_head[0]->crlSymbol.var_type;
  hashvalue=hashFunction(key,slot_num);
  for(ptr=hash_table_head[hashvalue]->next;ptr != NULL;ptr=ptr->next){
    if((strcmp(ptr->crlSymbol.var_name, key)) == 0)
      break;
    else
      ;
  }
  if(ptr != NULL){
    return 0;
  }
  else
    return 1;
}

/**********************************************************
 *            int crlHashDestroy()                        *
 * Destroy hashTable and free memory                      *
 * return 0 on success, return 1 on failure               *
 *********************************************************/
int crlHashDestroy()
{
  int i;
  symbolEntry *ptr,*qtr;
  int slot_num;

  slot_num=hash_table_head[0]->crlSymbol.var_type;
  for(i=0;i<slot_num;i++){
    ptr = hash_table_head[i];
    while(ptr != NULL){
      qtr = ptr->next;
      cfree(ptr,1,sizeof(symbolEntry));
      ptr = qtr;
    }
  }
  return 0;
}


/**********************************************************
 *           int hashFunction()                           *
 * return hash value according to the char key            *
 * case insensitive                                       *
 *********************************************************/
static int hashFunction(s,slot_num)
char *s;
int slot_num;
{
   char *q,*qq;
   char *p;
   unsigned h=0,g;
   
   q = (char *)malloc((strlen(s)+1)*sizeof(s));
   qq = q;
   while(*s != '\0'){
     *q = toupper(*s);
     q++; s++;
   }
   *q = '\0';
   
   for(p=qq;*p!='\0';p=p+1)
     {
      h=(h<<4)+(*p);
      if(g=h&0xf0000000)
	{
         h=h^(g>>24);
         h=h^g;
       }
    }
   return h%slot_num;
 }


/**********************************************************
 *        void crlSymbol_copy()                           *
 * locally used structure copy routine                    *
 * copy expid struct from id1 to id2                      *
 * id2 memory must be allocated before use this routine   *
 **********************************************************/
static void crlSymbol_copy(id2,id1) 
CrlSymbol *id2,*id1;
{
  id2->var_name = strdup(id1->var_name);
  id2->var_type = id1->var_type;
}

/*********************************************************
 *        void crlAddSymbols()                           *
 * Description:                                          *
 *    add list of var names to symbol hashtable          *
 ********************************************************/
void crlAddSymbols(var_list,type)
char        *var_list;
int         type;
{
  char *p, *q,temp[80];
  int  status;
  CrlSymbol crlSymbol;

  if(strchr(var_list,',') == NULL){  /* single var name */
    crlSymbol.var_name = strdup(var_list);
    crlSymbol.var_type = type;
    status = crlHashAdd(crlSymbol.var_name, &crlSymbol);
  }
  else{
    p = var_list;
    q = temp;
    while(*p != '\n' && *p != '\0'){
      if(*p == ','){
	*q = '\0';
	p++;
	crlSymbol.var_name = strdup(temp);
	crlSymbol.var_type = type;
	status = crlHashAdd(crlSymbol.var_name,&crlSymbol);
	q = temp;
      }
      else{
	*q = *p;
	q++; p++;
      }
    }
  }
}

/*****************************************************************
 *        void isSymbolFound()                                   *
 * Description:                                                  *
 *    Check to see whether a var name existed in the hashTable   *
 ****************************************************************/
void isSymbolFound(symbol)
char        *symbol;
{
  int status = 0;
  
  status = crlHashFind(symbol);
  if(status != 0){
    fprintf(stderr,"Error: Undefined symbol \"%s\"\n", symbol);
    fprintf(stderr,"Cannot continue, Quit.\n");
    exit(1);
  }

}
