/*
 * static char blasterCSid[]="@(#)blaster.c	32.1 9/10/92 SH00028 AppEng/SCCS Interphase";
 */
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <sys/errno.h>
#include <sys/file.h>
#ifndef LINUX
#include <sys/lock.h>
#endif
#include <pwd.h>
#include <errno.h>
#include <search.h>
#include <signal.h>

#define INIT_DB 2
#define QUERY   3
#define QUIT    1

#define close(s) printf("closing %d at %d\n",s,__LINE__);close(s);

static	int	readTimeout;

static void alarmHandler(sig)
	int	sig;
{
	signal(sig, alarmHandler);
	readTimeout = 1;
}

static intToBuf(cp,val)
        u_char  *cp;
        int     val;
{
        *cp++ = (unsigned int)(val & 0x000000ff);
        *cp++ = (unsigned int)(val & 0x0000ff00) >> 8;
        *cp++ = (unsigned int)(val & 0x00ff0000) >> 16;
        *cp++ = (unsigned int)(val & 0xff000000) >> 24;
}


static bufToInt(cp)
        u_char  *cp;
{
        int val;
 
        val = 0;
        val = *cp++;
        val += ((int) *cp++) << 8 ;
        val += ((int) *cp++) << 16;
        val += ((int) *cp++) << 24;
        return(val);
}

static int hpHash;

typedef struct hashEnt *hashEntPtr;

typedef struct hashEnt {
  char name[80];
  char host[80];
  int port;
  int socket;
} HASHENT;

static unsigned long broad_addr,broad_port,broad_sock;
static struct sockaddr_in sockaddr;

static int
inet_connect(host, port, server, udp, reuseAddr, lingerTime)
    char *host;			/* Host to connect, name or IP address */
    int port;			/* Port number to use */
    int server;			/* 1->make server, 0->connect to server */
    int udp;			/* Make it a udp protocol socket */
    int reuseAddr;		/* Allow local reuse of addresses */
    int lingerTime;		/* Time to linger on close */
{
    struct hostent *hostent, _hostent;
    int sock, status;
#ifdef __DGUX__
    struct sockaddr_in hostaddr, hostaddrPtr[2];
#else
    int hostaddr, hostaddrPtr[2];
#endif

#define MAXHOSTNAMELEN 200
    char localhost[MAXHOSTNAMELEN];
    int result;
    int linger[2];

    hostent = NULL;

    /*
     * Translate the hostname
     */
    if (host == NULL) {
      errno = EINVAL;
      return -1;
     /* gethostname(localhost,MAXHOSTNAMELEN);
      host = localhost;*/
    }
    if (!(udp|server)) {

      if (strcmp(host,"") == 0) {
	gethostname(localhost,MAXHOSTNAMELEN);
	host = localhost;
      }
      hostent = gethostbyname(host);
    }
#ifdef __DGUX__
    if (hostent == NULL) {
	if (strlen(host) == 0) {
            memset(&hostaddr,0,sizeof(hostaddr));
	} else {
	    hostaddr.sin_addr = inet_addr(host);
	}
	if ((int)hostaddr.sin_addr.s_addr == -1) {
	    if (server && !strlen(host)) {
		hostaddr.sin_addr.s_addr = INADDR_ANY;
	    } else {
		errno = EINVAL;
		return -1;
	    }
	}
#else
    if (hostent == NULL) {
	if (strlen(host) == 0) {
	    hostaddr = 0;
	} else {
	    hostaddr = inet_addr(host);
	}
	if (hostaddr == -1) {
	    if (server && !strlen(host)) {
		hostaddr = INADDR_ANY;
	    } else {
		errno = EINVAL;
		return -1;
	    }
	}
#endif

	_hostent.h_addr_list = (char **) hostaddrPtr;
#ifdef CRAY_HACKS
	hostaddr <<= 32;
#endif

#ifdef __DGUX__
	_hostent.h_addr_list[0] = (char *) &hostaddr.sin_addr;
	_hostent.h_length = sizeof(hostaddr.sin_addr);
#else
	_hostent.h_addr_list[0] = (char *) &hostaddr;
	_hostent.h_length = sizeof(hostaddr);
#endif
	_hostent.h_addr_list[1] = NULL;
	_hostent.h_addrtype = AF_INET;
	hostent = &_hostent;
    }

    /*
     * Create the socket
     */
    if (udp) {
	sock = socket(PF_INET, SOCK_DGRAM, 0);
    } else {
	sock = socket(PF_INET, SOCK_STREAM, 0);
    }
    if (sock < 0) {
	return -1;
    }

    /*
     * Set the linger and reuseAddr socket options
     */
#ifdef SO_LINGER
    linger[0] = lingerTime > 0;
    linger[1] = lingerTime;
    result = setsockopt(sock, SOL_SOCKET, SO_LINGER,
			(char *)linger, sizeof(linger));
#endif
    {
	int one = 1;
	result = setsockopt(sock, SOL_SOCKET, SO_REUSEADDR,
			    (char *)&one, sizeof(int));
    }
    {
      int val = 1;
      setsockopt(sock,IPPROTO_TCP,TCP_NODELAY,(char *)&val,sizeof(int));
    }
    {
      int val = 1;
      setsockopt(sock,SOL_SOCKET,SO_BROADCAST,(char *)&val,sizeof(int));
    }
    {
      int val = 1;
      setsockopt(sock,SOL_SOCKET,SO_DONTROUTE,(char *)&val,4);
    }

    /*
     * Bind the socket
     */
    memset((char *)&sockaddr, 0,sizeof(sockaddr));
    sockaddr.sin_family = AF_INET;
#ifdef CRAY_HACKS
    {
    unsigned long foo;

    memcpy((char *)&foo,
	   (char *)hostent->h_addr_list[0],
	   (size_t)hostent->h_length);

    sockaddr.sin_addr.s_addr = foo>>32;
    }
#else
    memcpy((char *)&(sockaddr.sin_addr.s_addr),
	   (char *)hostent->h_addr_list[0],
	   (size_t)hostent->h_length);
#endif

    sockaddr.sin_port = htons(port);

    if (server | udp) {
	status = bind(sock, (struct sockaddr *)&sockaddr, sizeof(sockaddr));
    } else {
	status = connect(sock, (struct sockaddr *)&sockaddr, sizeof(sockaddr));
    }

    if (status < 0) {
	close(sock);
	return -1;
    }

    /*
     * Finally, listen on the socket if it's a server.
     */
    if (server && !udp) {
	listen(sock, 5);
    }
    return sock;
}

int DP_cmd_init(char *host)
{
 static char tmp[100];
 char *tmp2,*tmp3;
 sprintf(tmp,"MSQL_TCP_HOST=%s",host);
 putenv(tmp);
 hpHash = hcreate(100);
 tmp2 = getenv ("ROC_BROADCAST_ADDR");
 if (tmp2) {
   broad_addr = inet_addr(tmp2);
   tmp3 = getenv ("ROC_BROADCAST_PORT");
   if (tmp3) {
     broad_port = atoi( tmp3);
     
     broad_sock = inet_connect(tmp2,broad_port,0,1,1,0);
     {
       unsigned long optval = 2;

       if (getenv("ROC_BROADCAST_TTL")) 
	 optval = atoi(getenv("ROC_BROADCAST_TTL"));

       setsockopt(broad_sock, 
		  IPPROTO_IP, 
		  IP_TTL, 
		  (char *)&optval, 
		  sizeof(optval));
     }
     if (broad_sock < 0) {
       perror("can't open UDP socket :");
       broad_sock = 0;
     }
   }
   else 
     {
       broad_addr = broad_port = 0;
     }
   
 }
 return 0;
}

int DP_cmd(char *name,char *command,char *result,int timeout) 
{
  ENTRY *found,try,new;
  char *host;
  int port, status;
  hashEntPtr ent;
  int retries = 0;
  static int init = 1;
  
  if (init) {
    signal(SIGALRM,alarmHandler);
    init = 0;
  }

  alarm(40);

  readTimeout = 0;
  
  try.key = name;

  found = hsearch(try,FIND);

  if (found) {
    ent = (hashEntPtr) found->data;
  } else {
    
    ent = (hashEntPtr) malloc(sizeof(HASHENT));
    
    new.data = (void *)ent;
    new.key = name;

    strcpy(ent->name,name);

    get_hostport(NULL,name,ent->host,&ent->port,result);

    ent->socket = 0;
    hsearch(new,ENTER);
    
  }
  alarm(0);

retry:
  alarm(timeout);
  readTimeout = 0;

  status = do_command(ent->host,ent->port,command,result,&ent->socket,0);

  alarm(0);
  
  if ((status == -2) || (status == -4)) {
    int status2;
    alarm(4);
    readTimeout = 0;

    printf("DP_cmd: do_command failed status=%d\n",status);
    status2 = get_hostport(NULL,name,ent->host,&ent->port,result);
    ent->socket = 0;
    alarm(0);
    if (status2 < 0) {
      printf("DP_cmd: get_hostport failed status2=%d\n",status2);
      return status2;
    }
    sleep(1);
    if (retries++ < 5) 
      goto retry;
  }

  return status;
}

int DP_cmd_broadcast(char *command)
{
  int status;
  if (broad_sock) {

    /*printf("length %d :%s\n",strlen(command)+1,command);*/

    status = sendto(broad_sock, command, strlen(command)+1, 0, 
		    (const struct sockaddr *)&sockaddr, sizeof(sockaddr));
  }

}

int DP_cmd_async(char *name,char *command) 
{
  ENTRY *found,try,new;
  char *host;
  int port, status = 0;
  hashEntPtr ent;
  int retries = 0;
  static int init = 1;
  static char result[1000];
  if (init) {
    signal(SIGALRM, alarmHandler);
    init = 0;
  }

  alarm(4);
  readTimeout = 0;
  
  try.key = name;

  found = hsearch(try,FIND);

  if (found) {
    ent = (hashEntPtr) found->data;
  } else {
    
    ent = (hashEntPtr) malloc(sizeof(HASHENT));
    
    new.data = (void *)ent;
    new.key = name;

    strcpy(ent->name,name);

    get_hostport(NULL,name,ent->host,&ent->port,result);
    ent->socket = 0;
    hsearch(new,ENTER);
    
  }
  alarm(0);

retry:
  
  alarm(4);
  readTimeout = 0;

  status = do_command(ent->host,ent->port,command,result, &ent->socket,1);
  alarm(0);
  
  if ((status == -2)||(status == -4)) {
    int status2;
    alarm(4);
    readTimeout = 0;

    printf("DP_cmd_async: do_command failed status=%d\n",status);
    status2 = get_hostport(NULL,name,ent->host,&ent->port,result);
    ent->socket = 0;
    alarm(0);
    if (status2 < 0) {
      printf("DP_cmd_async: get_hostport failed status2=%d\n",status2);
      return status2;
    }
    sleep(1);
    if (retries++ < 5) 
      goto retry;
  }

  if (status)
    printf("DP_cmd_async Error: %s\n", result);

  return status;
}

int do_command(char *host,int port,char *command,char *result,int *so, int async) 
{
  struct sockaddr_in  sin;
  int 		      s, ix = 0;
  char 		      buffer[10000],*p;
  int                 on = 1;
  int                 y,l;
  char                rep;
  int 		      size;
  struct hostent      *hp, *gethostbyname ();

  bzero (&sin, sizeof (sin));
  
  if (!*so) {
    s = socket (AF_INET, SOCK_STREAM, 0);
    {
      int cval = 1;
      int linger[2];

      linger[0] = 0;
      linger[1] = 0;
      setsockopt(s, SOL_SOCKET, SO_LINGER,
		 (char *)linger, sizeof(linger));
      setsockopt(s, IPPROTO_TCP, TCP_NODELAY, (char *)&cval,4);
    }
    
    if (s < 0)
      printf ("cannot open socket\n");
    
    hp = gethostbyname (host);
    if (hp == 0 && (sin.sin_addr.s_addr = inet_addr (host)) == -1)
      {
	sprintf (result, "%s: unkown host", host);
	return -1;
      }
    
    if (hp != 0)
      bcopy (hp->h_addr, &sin.sin_addr, hp->h_length);
    
    sin.sin_port 	= htons (port);
    sin.sin_family = AF_INET;
    
    if (connect (s, (struct sockaddr *) &sin, sizeof (sin)) < 0)
      {
	sprintf (result,"connect failed: host %s port %d", inet_ntoa (sin.sin_addr),
		 ntohs (sin.sin_port));
	return -2;
      }
    p = buffer;
    
    for (ix=0;ix<199;ix++,p++) {
      
      l = read(s,p,1);
      
      if (l <=0) {
	alarm(0);
	close(*so);*so = 0 ;
	sprintf(result,"read returned <= 0 on connect\n");
	return -2;
      }
      
      if ((*p == '\n') || (l <= 0)) break;
      
    }
    if (readTimeout)
      {
	alarm(0);
	close(*so);*so = 0 ;
	return(-3);
      }
    
    *so = s;
  } else {
    s = *so;
  }
  bzero(buffer,100);
  
  *((long *) buffer) = htonl(2+strlen(command));

  if (async) {
    buffer[4] = 'd';
  } else {
    buffer[4] = 'e';
  }

  buffer[5] = 0x31;
  sprintf(&buffer[6],command);
  if ((y = send(s, buffer, 6+strlen(command), MSG_DONTROUTE)) < 0)
    {
      sprintf (result,"write error");
      close(*so);*so = 0 ;
      return -4;
    }
  if (!async) {
    y = recv(s,(char *) &size,4,0);
    
    if (y <=0) {
      alarm(0);
      close(*so);*so = 0 ;
      return -5;
    }
    if (readTimeout)
      {
	alarm(0);
	close(*so);*so = 0 ;
	return(-5);
      }
    
    size = ntohl(size);
    
    p = buffer;
    
    while (size) {
      y = recv(s,p,100,0);
      p += y;
      size -= y;
    }
    
    if (y <=0) {
      alarm(0);
      close(*so);*so = 0 ;
      return -5;
    }
    
    if (readTimeout) {
      alarm(0);
      close(*so);*so = 0 ;
      return(-5);
    }
    
    *p = 0;
    
    p = buffer + 2;
    
    strcpy(result,p);

    if (buffer[0] == 'r') 
      return 0;
    if (buffer[0] == 'x')
      return -9;
    close(s);
    *so = 0;
  }
  return 0;
}

int get_hostport(char *msqlHost,char *theName,char *theHost,int *thePort,char *result)
{
  struct sockaddr_in	sin;
  int 		  s, ix = 0;
  char 		  buffer[1000],*p;
  int             on = 1;
  int             y,l;
  char            rep;
  int		  blen,blocks;
  int 		  size;
  struct hostent *hp, *gethostbyname ();
  struct  servent         *serv_ptr;
  char           *host, *envVar;
  int             port;
  unsigned long   tl;
  
  bzero (&sin, sizeof (sin));
  
  s = socket (AF_INET, SOCK_STREAM, 0);

  {
    int cval = 1;
    int linger[2];
    
    linger[0] = 0;
    linger[1] = 0;
    setsockopt(s, SOL_SOCKET, SO_LINGER,
	       (char *)linger, sizeof(linger));

    setsockopt(s, IPPROTO_TCP, TCP_NODELAY, (char *)&cval,4);
  }
  
  if (s < 0)
    printf ("cannot open socket\n");

  host = msqlHost;

  if ((envVar = (char *) getenv("MSQL_TCP_HOST")))
    {
      host = envVar;
    }

  if (host == NULL) {
    sprintf(result,"msqld host required\n");
    return -10;
  }

  hp = gethostbyname (host);

  port = ntohs(8101);
#ifndef VXWORKS
  if ((serv_ptr = getservbyname("msql", "tcp")))
    {
      port = ntohs(serv_ptr->s_port);
    }
#endif
  if ((envVar =(char *) getenv("MSQL_TCP_PORT")))
    {
      port = ntohs(atoi(envVar)); 
    }
  
  if (hp == 0 && (sin.sin_addr.s_addr = inet_addr (host)) == -1)
    {
      sprintf (result, "%s: unkown host", host);
      return -11;
    }

  if (hp != 0)
        bcopy (hp->h_addr, &sin.sin_addr, hp->h_length);

    sin.sin_port 	= port;
    sin.sin_family 	= AF_INET;
    
    if (connect (s, (struct sockaddr *) &sin, sizeof (sin)) < 0)
      {
    	sprintf (result,"connect failed: host %s port %d\n", inet_ntoa (sin.sin_addr),
		ntohs (sin.sin_port));
	
	return -12;
      }

    bzero(buffer,100);

    p = buffer;

    read(s,&tl,4);
    blen = bufToInt(&tl);
    for (ix=0;ix<blen;ix++,p++) {
      
      l = read(s,p,1);

      if ((l <= 0) || readTimeout) {
	alarm(0);
	return -13;
      }
      if (l <= 0) break;
    }

    y = atoi(buffer);
    if (y == -1) {
      sprintf(result,"msql error: %s",&buffer[(int)index(buffer,':')+1]);
      return -14;
    }
    {
      struct passwd *pw;
      
      pw = (struct passwd *) getpwuid(getuid());

      if (!pw)
	{
	  sprintf(result,"error: unknown user");
	  return(-15);
	}

      sprintf(&buffer[4],"%s\n",pw->pw_name);
      intToBuf(buffer,strlen(&buffer[4]));
      
      if ((y = send(s, buffer, 4+strlen(&buffer[4]), MSG_DONTROUTE)) < 0)
	{
	  sprintf (result,"write error");
	}
      
      bzero(buffer,100);
    
      p = buffer;
      
      read(s,&tl,4);
      blen = bufToInt(&tl);
      for (ix=0;ix<blen;ix++,p++) {
	
	l = read(s,p,1);

	if ((l <= 0) || readTimeout) {
	  alarm(0);
	  return -16;
	}
	
	if (l <= 0) break;
		
      }

      y = atoi(buffer);
      if (y == -1) {
	sprintf(result,"msql error: %s",&buffer[(int)index(buffer,':')+1]);
	return -17;
      }
    }

    sprintf(&buffer[4],"%d:%s\n",INIT_DB,getenv("EXPID"));
    intToBuf(buffer,strlen(&buffer[4]));

    if ((y = send(s, buffer, 4+strlen(&buffer[4]), MSG_DONTROUTE)) < 0)
      {
	sprintf (result,"msql write error: ");
      }
    
    bzero(buffer,100);

    p = buffer;
    read(s,&tl,4);
    blen = bufToInt(&tl);

    for (ix=0;ix<blen;ix++,p++) {
      
      l = read(s,p,1);
      if ((l <= 0) || readTimeout) {
	alarm(0);
	return -18;
      }

      if (l <= 0) break;
    }

    sprintf(&buffer[4],"%d:select port from process where name='%s'\n",QUERY,theName);

    intToBuf(buffer,strlen(&buffer[4]));

    if ((y = send(s, buffer, 4+strlen(&buffer[4]), MSG_DONTROUTE)) < 0)
      {
	sprintf (result,"msql write error: ");
	return -19;
      }
    read(s,&tl,4);
    blen = bufToInt(&tl);

    p = buffer;
    for (ix=0;ix<blen;ix++,p++) {
      
      l = read(s,p,1);
      if ((l <= 0) || readTimeout) {
	alarm(0);
	return -20;
      }

      if (l <= 0) break;
    }

    y = atoi(buffer);
    if (y == -1) {
      sprintf(result,"msql error: %s",&buffer[(int)index(buffer,':')+1]);
      return -21;
    }

    bzero(buffer,100);

    p = buffer;
    read(s,&tl,4);
    blen = bufToInt(&tl);

    for (ix=0;ix<blen;ix++,p++) {
      
      l = read(s,p,1);
      if ((l <= 0) || readTimeout) {
	alarm(0);
	return -22;
      }

      if (l <= 0) break;
    }
    y = atoi(buffer);
    if (y == -100) {
      sprintf(result,"no entry in db\n");
      return -23;
    }
    *p = 0;
    ix=0;
    sscanf(&buffer[2],"%d",&ix);
    *thePort = ix;
    bzero(buffer,100);

    p = buffer;
    read(s,&tl,4);
    blen = bufToInt(&tl);

    for (ix=0;ix<blen;ix++,p++) {
      
      l = read(s,p,1);
      if ((l <= 0) || readTimeout) {
	alarm(0);
	return -24;
      }
      
      if (l <= 0) break;
    }

    bzero(buffer,100);
    p = buffer;
    read(s,&tl,4);
    blen = bufToInt(&tl);

    for (ix=0;ix<blen;ix++,p++) {
      
      l = read(s,p,1);
      if ((l <= 0) || readTimeout) {
	alarm(0);
	return -35;
      }

      if (l <= 0) break;
    }

    bzero(buffer,100);

    sprintf(&buffer[4],"%d:select host from process where name='%s'\n",QUERY,theName);

    intToBuf(buffer,strlen(&buffer[4]));

    if ((y = send(s, buffer, 4+strlen(&buffer[4]), MSG_DONTROUTE)) < 0)
      {
	perror ("blaster write error: ");
      }
    
    p = buffer;

    bzero(buffer,sizeof(buffer));

    read(s,&tl,4);
    blen = bufToInt(&tl);
    for (ix=0;ix<blen;ix++,p++) {
      
      l = read(s,p,1);
      if ((l <= 0) || readTimeout) {
	alarm(0);
	return -26;
      }

      if (l <= 0) break;
    }

    bzero(buffer,100);

    p = buffer;

    bzero(buffer,sizeof(buffer));

    read(s,&tl,4);
    blen = bufToInt(&tl);
    for (ix=0;ix<blen;ix++,p++) {
      
      l = read(s,p,1);
      if ((l <= 0) || readTimeout) {
	alarm(0);
	return -26;
      }

      if (l <= 0) break;
    }

    bzero(buffer,100);
    p = buffer;

    read(s,&tl,4);
    blen = bufToInt(&tl);
    for (ix=0;ix<blen;ix++,p++) {
      
      l = read(s,p,1);
      if ((l <= 0) || readTimeout) {
	alarm(0);
	return -27;
      }

      if (l <= 0) break;
    }

    *p = 0;
    y = atoi(buffer);
    if (y == -100) {
      sprintf(result,"no entry in db\n");
      return -28;
    }
    strcpy(theHost,&buffer[2]);
    for (l=0;l<strlen(theHost);l++)
      {
	if (theHost[l] == '\n')
	  theHost[l] = 0;
      }
    
    sprintf(&buffer[4],"%d:\n",QUIT);
    intToBuf(buffer,strlen(&buffer[4]));
    if ((y = send(s, buffer, 4+strlen(&buffer[4]), MSG_DONTROUTE)) < 0)
      {
	perror ("blaster write error: ");
      }
    
    close (s);
    
    return 0;

}


