//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//       CODA service class 
//
// Author:  Jie Chen
//
// Revision History:
//   $Log: codaService.h,v $
//   Revision 1.2  1997/02/03 13:47:29  heyes
//   add ask command
//
//   Revision 1.1.1.1  1996/10/11 13:39:32  chen
//   run control source
//
//
#ifndef _CODA_SERVICE_H
#define _CODA_SERVICE_H

#include <cdevService.h>
#include <rcClient.h>

#define CODA_MAX_DYN_COMPS 100

class codaRequestObject;

//============================================================================
// Note for Usage:
//      setup three environment variables before doing anything else.
//      EXPID, CODA_HOSTNAME, CODA_EXPTNAME
//      
//      reason: no site wide service name server available at this moment
//===========================================================================

extern "C" cdevService *newCodaService (char* name, cdevSystem* system);

class codaService: public cdevService
{
public:
  // constructor
  codaService (char* name, cdevSystem& system = cdevSystem::defaultSystem ());
  
  int getFd (int* &fd, int& numFd);
  // PURPOSE: return channel access network file descriptors
  // REQUIRE: callers provide pointer only and don't free memory
  // PROMISE: numFd will be real number of file descriptors of the 
  //          channel access client. return 0: always

  int flush (void);
  // PURPOSE: flush network requests
  // REQUIRE: nothing
  // PROMISE: return 0: success, return 1: ca error

  int poll (void);
  // PURPOSE: polling method
  // REQUIRE: nothing
  // PROMISE: return 0: success, return 1: ca error

  int pend (int fd = -1);
  // PURPOSE: handle network pending for very short time (== poll)
  //          requirment from cdevSystem pend ()
  // REQUIRE: nothing
  // PROMISE: return 0: success, return 1: ca error

  int pend (double seconds, int fd = -1);
  // PURPOSE: handle network pending for 'seconds'
  // REQUIRE: nothing
  // PROMISE: return 0: success. return 1: ca error

  int getRequestObject (char *deviceName, char *msg,
			cdevRequestObject * &req);
  // PURPOSE: return a codaRequestObject (called from attachPtr function
  //          of cdevRequestObject class)
  // REQUIRE: right pair of deviceName and msg. 
  // PROMISE: a codaRequestObject

  int getNameServer (cdevDevice* &ns);
  // PURPOSE: return own name server
  // REQUIRE: none
  // PROMISE: return nothing. no name server

  // int tag for coda service
  static int CODA_TAG_VALUE, CODA_TAG_STATUS, CODA_TAG_SEVERITY;
  static int CODA_TAG_TIME, CODA_TAG_UNITS, CODA_TAG_DISPHI, CODA_TAG_DISPLO;
  static int CODA_TAG_ALRMHI, CODA_TAG_ALRMLO, CODA_TAG_WRNHI, CODA_TAG_WRNLO;
  static int CODA_TAG_CTRLHI, CODA_TAG_CTRLLO;
  // new tags
  static int CODA_TAG_PV, CODA_TAG_DFV, CODA_TAG_RO, CODA_TAG_NAME;

  const char* className (void) const {return "codaService";}

protected:
  // deny direct access to destructor
  ~codaService (void);
  // map char tags to int tags
  static void mapCtagToItag (void);

  // connect to the remote server
  int         connect (char* session);
  // disconnection callback
  static void discCallback (int status, void* arg, daqNetData* data);
  // dynamic components  monitoring callback
  static void dynamicCompCallback (int status, void* arg, daqNetData* data);

private:
  rcClient codaClient_;
  int      *fds_;
  int      numFds_;

  // dynamic components
  char*      components_[CODA_MAX_DYN_COMPS];
  int        numComps_;

  // friend class
  friend class codaRequestObject;
};
#endif
