//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of rcAnaLogButton Class
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: rcAnaLogButton.cc,v $
//   Revision 1.1.1.1  1996/10/11 13:39:27  chen
//   run control source
//
//
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <XcodaApp.h>

#include <codaComdXInterface.h>

#include <rcAnaLogDialog.h>
#include <rcNetStatus.h>
#include <rcInfoPanel.h>
#include "rcAnaLogButton.h"

rcAnaLogButton::rcAnaLogButton (char* name, int active,
				char* acc, char* acc_text,
				rcClientHandler& handler)
:rcMenuComd (name, active, acc, acc_text, handler), dialog_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("         Create rcAnaLogButton Class Object\n");
#endif
}

rcAnaLogButton::~rcAnaLogButton (void)
{
#ifdef _TRACE_OBJECTS
  printf ("         Delete rcAnaLogButton Class Object\n");
#endif
  // dialog_ will be destroyed by Xt Mechanism
}

void
rcAnaLogButton::doit (void)
{
  if (!dialog_) {
    dialog_ = new rcAnaLogDialog (this, "Ana Log Dialog", 
				  "Logging File Dialog",
				  netHandler_);
    dialog_->init ();
    dialog_->setModal ();
  }
  if (dialog_->isMapped ())
    dialog_->popdown ();
  dialog_->popup ();
}

void
rcAnaLogButton::undoit (void)
{
  // empty
}
