//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of rcSvcInfoFinder Class
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: rcSvcInfoFinder.cc,v $
//   Revision 1.2  1997/09/05 12:03:44  heyes
//   almost final
//
//   Revision 1.1.1.1  1996/10/11 13:39:31  chen
//   run control source
//
//
#if defined (_CODA_2_0_T) || defined (_CODA_2_0)

#include <codaConst.h>
#include <stdlib.h>
#include "rcSvcInfoFinder.h"
#include <msql.h>

char* rcSvcInfoFinder::processTableName = "process";

int
rcSvcInfoFinder::findRcServer (char* msqld, char* database, char* session,
			       char* &host, unsigned short& port)
{
  char* localdir = getenv ("CODADB");
			
  int dbaseSock = msqlConnect (msqld);
  if (dbaseSock < 0) {
      fprintf (stderr, "Cannot connect to msql server\n");
      return CODA_FATAL;
  }

  if (::msqlSelectDB (dbaseSock, database) < 0) {
    fprintf (stderr, "Cannot select database %s\n", database);
    ::msqlClose (dbaseSock);
    return CODA_FATAL;
  }

  char qstring[256];
  sprintf (qstring, "select * from %s where name = '%s'",
	   rcSvcInfoFinder::processTableName, session);

  if (::msqlQuery (dbaseSock, qstring) < 0) {
    fprintf (stderr, "Get information for rcServer %s error: %s\n",
	     session, msqlErrMsg);
    ::msqlClose (dbaseSock);
    return CODA_ERROR;
  }

  m_result* res = msqlStoreResult ();
  if (!res) {
    ::msqlClose (dbaseSock);
    return CODA_ERROR;
  }
  
  m_row row;

  row = ::msqlFetchRow (res);

  if (row) {
    host = new char[strlen (row[4]) + 1];
    ::strcpy (host, row[4]);
    int tport = atoi (row[5]);
    port = (unsigned short)tport;
    
    ::msqlFreeResult (res);

    ::msqlClose (dbaseSock);
    return CODA_SUCCESS;
  }
  ::msqlFreeResult (res);  

  ::msqlClose (dbaseSock);
  return CODA_ERROR;
}

int
rcSvcInfoFinder::removeDeadRcServer (char* msqld, 
				     char* database, 
				     char* session)
{
  char* localdir = getenv ("CODADB");
			
  int dbaseSock = msqlConnect (msqld);
  if (dbaseSock < 0) {
      fprintf (stderr, "Cannot connect to msql server\n");
      return CODA_FATAL;
  }

  if (::msqlSelectDB (dbaseSock, database) < 0) {
    fprintf (stderr, "Cannot select database %s\n", database);
    return CODA_FATAL;
  }
  
  char qstring[256];
  sprintf (qstring, "delete from %s where name = '%s'",
	   rcSvcInfoFinder::processTableName, session);
  if (::msqlQuery (dbaseSock, qstring) < 0) {
    fprintf (stderr, "Delete dead rcServer %s info error: %s\n",
	     session, msqlErrMsg);
    return CODA_ERROR;
  }
  ::msqlClose (dbaseSock);
  return CODA_SUCCESS;
}

#endif

  
    
