/* -*- C++ -*- */

// ============================================================================
//
// = LIBRARY
//    ACE
// 
// = FILENAME
//    SPIPE_Addr.h
//
// = AUTHOR
//    Doug Schmidt 
// 
// ============================================================================

#if !defined (ACE_SPIPE_ADDR_H)
#define ACE_SPIPE_ADDR_H
#include "Addr.h"
#include "sysincludes.h"

/* This is a hack... */
/* SHOULD WE PUT THIS COMMENT IN HERE? - S.D. */
#define AF_SPIPE (AF_MAX + 1)

class SPIPE_Addr : public Addr
  // = TITLE
  //    Defines the SVR4 STREAM pipe address family address format. 
  //
  // = DESCRIPTION
  // 
{
public:
  SPIPE_Addr (void);
  SPIPE_Addr (const SPIPE_Addr &sa);
  SPIPE_Addr (const char rendezvous_point[], gid_t = 0, uid_t = 0);

  void set (const char rendezvous_point[], gid_t = 0, uid_t = 0);

  SPIPE_Addr &operator= (const SPIPE_Addr &);

  virtual void *get_addr (void) const;
  virtual int addr_to_string (char addr[], size_t) const;
  virtual int  operator == (const Addr &SAP) const;
  virtual int  operator != (const Addr &SAP) const;

  const char *get_path_name (void) const; 
  uid_t	     get_user_id (void) const;
  void	     set_user_id (uid_t uid);
  gid_t	     get_group_id (void) const;
  void	     set_group_id (gid_t gid);

private:
  struct 
  {
    gid_t gid_;
    uid_t uid_;
    char  rendezvous_[MAXNAMLEN + 1];
  } SPIPE_addr_;
};

#if defined (__INLINE__)
#define INLINE inline
#include "SPIPE_Addr.i"
#else
#define INLINE 
#endif /* __INLINE__ */

#endif /* _SPIPE_ADDR_H */
