/****************************************************************
*
* header file for use of Struck sfi with CODA crl (version 2.0)
*
*                             DJA   March 1996
*
*****************************************************************/
#ifndef __SFI__
#define __SFI__

/* Global variable to hold the source mask */
unsigned long sfiTrigSource;

#include "sfi.h"
#include "coda_sfi.h"
#include "sfi_triglib.h"


/* define CODA readout list specific routines/definitions */

static int SFI_handlers,SFIflag;
static unsigned long SFI_isAsync;

void SFI_int_handler()
{
/* Clear inturrupt source */
  *sfi.VmeIrqMaskReg  = (sfiTrigSource<<8);      /* Clear Source */
  theIntHandler(SFI_handlers);
}


#define SFI_TEST  sfittest

#define SFI_INIT { SFI_handlers =0;SFI_isAsync = 0;SFIflag = 0;}

#define SFI_ASYNC(code,id) {printf("linking async SFI trigger to id %d \n",id); \
			       SFI_handlers = (id);SFI_isAsync = 1;sfitriglink(SFI_int_handler);}

#define SFI_SYNC(code,id)  {printf("linking sync SFI trigger to id %d \n",id); \
			      SFI_handlers = (id);SFI_isAsync = 0;}

#define SFI_SETA(code) {theIntHandler(SFI_handlers);}

#define SFI_SETS(code) SFIflag = code;

#define SFI_ENA(code,val) sfitenable(val);

#define SFI_DIS(code,val) sfitdisable(val);

#define SFI_CLRS(code) SFIflag = 0;

#define SFI_GETID(code) SFI_handlers

#define SFI_TTYPE sfittype

#define SFI_START(val)	 {;}

#define SFI_STOP(val)	 {sfitdisable();}

#define SFI_ENCODE(code) code


#endif

