Richard Kwarciany
Fermilab

Friday, 11-SEP-92  1500hrs
FSCC Instruction List Microcode Version: 1
Revision: 1
EPS448
U106,U110,U108



PART:	EPS448,EPS448,EPS448

INPUTS:	I0@12
	I1@11
	I2@10
	I3@9
	I4@5
	I5@4
	I6@3
	I7@2


OUTPUTS:LC1@1		%	1	%
	LC0@28		%	2	%
	LCOE@27		%	3	%
	/SRT@26		%	4	%
	FW@25		%	5	%
	/POE@24		%	6	%
	DDIR@23		%	7	%
	CPAB@22		%	8	%
	SAB@20		%	9	%
	CPBA@19		%	10	%
	SBA@18		%	11	%
	/DG@17		%	12	%
	/FDOE@16	%	13	%
	/FCOE@15	%	14	%
	FPCREQ@14	%	15	%
	DFIFOEN@13	%	16	%

OUTPUTS:REL@1		%	17	%
	REQ@28		%	18	%
	FEOBA@27	%	19	%
	/MUX3@26	%	20	%
	EG@25		%	21	%
	RD@24		%	22	%
	MS2@23		%	23	%
	MS1@22		%	24	%
	MS0@20		%	25	%
	CWT@19		%	26	%
	CDK@18		%	27	%
	SDK@17		%	28	%
	CDS@16		%	29	%
	SDS@15		%	30	%
	CAS@14		%	31	%
	SAS@13		%	32	%

OUTPUTS:PFIFOEN@1	%	33	%
	/SR@28		%	34	%
	SCLK@27		%	35	%
	FCLK@26		%	36	%
	DEOE@25		%	37	%
	CEOE@24		%	38	%
	TMR@23		%	39	%
	CCLEAR@22	%	40	%
	STAT3@20	%	41	%
	STAT2@19	%	42	%
	STAT1@18	%	43	%
	STAT0@17	%	44	%
	/DSACK@16	%	45	%
	/MUX2@15	%	46	%
	/MUX1@14	%	47	%
	/MUX0@13	%	48	%




%	DEFAULT = all bits false except: DDIR=1, FCOE*=0, MUX1*=0	%
%	 123456789012345678901234567890123456789012345678	%
DEFAULT:[000101100001101000010000000000000100000000001101B]


%	Macros for Chip 1	%

MACROS:	CHOLD		="000"		%LC1,LC0,LCOE%
	CLOAD		="100"
	COUNT		="110"
	CREAD		="001"
	CDEF		="000"

	SRT		="0"		%SRT*%
	NSRT		="1"

	DW		="1"		%SDW%
	NDW		="0"

%			  0000111		       %
%			  6789012   <<-- output numbers%
%			  ^^^^^^^		       %
	DATADEF		="1000001"	%POE*,DDIR,CPAB,SAB,CPBA,SBA,DG*%
	DATAOUT		="1000000"
	DATAOUTLATCH	="1000100"
	DATAOUTHOLD	="1000010"
	DATAIN		="1100000"
	DATAINLATCH	="1110000"
	DATAINHOLD	="1101000"
	DATAINFIFO	="1101000"
	COUNTIN		="1000001"

	FDOE		="0"		%FDOE*%
	NFDOE		="1"

	FCOE		="0"		%FCOE*%
	NFCOE		="1"

	IRQ		="0"		%FPCREQ*%
	NIRQ		="1"

	DFFEN		="1"		%DFIFOEN%
	DFFDIS		="0"

%			  0000000001111111		%
%			  1234567890123456		%
%			  ^^^^^^^^^^^^^^^^		%
	CTRLDEF		="0001011000011010"	%DEFAULTS FOR U42X40%


%	Macros for Chip 2	%

%			  1112222222222333		%
%			  7890123456789012		%
%			  ^^^^^^^^^^^^^^^^		%
	REQ		="0101000000000000"	%REL,REQ%
	REL		="1011000000101010"	%(EOEA, Clear DS,DK,AS,GK)%
	HOLDB		="00"
	NREQ		="00"

	EOBA		="1"		%EOBA%
	NEOBA		="0"

	ILR		="0"		%SMUX3%
	NILR		="1"

	EG		="1"		%EG%
	NEG		="0"

	RD		="1"		%RD%
	NRD		="0"

	MS0		="000"		%MS2,MS1,MS0%
	MS1		="001"
	MS2		="010"
	MS3		="011"
	MS4		="100"
	MS5		="101"
	MS6		="110"
	MS7		="111"

	CWT		="1"		%CWT%
	XWT		="0"

	SDK		="01"		%CDK,SDK%
	CDK		="10"
	XDK		="00"

	SDS		="01"		%CDS,SDS%
	CDS		="10"
	XDS		="00"

	SAS		="01"		%CAS,SAS%
	CAS		="10"
	XAS		="00"

%			  1112222222222333		%
%			  7890123456789012		%
%			  ^^^^^^^^^^^^^^^^		%
	FBDEF		="0001000000000000"	%DEFAULTS FOR U47X40%



%	Macros for Chip 3	%

	PFFEN		="1"		%PFIFOEN%
	PFFDIS		="0"

	SR		="0"		%SR*%
	NSR		="1"

	SCLK		="1"		%SCLK%
	NSCLK		="0"

	FCLK		="1"		%FCLK%
	NFCLK		="0"

	DEOE		="1"		%DEOE%
	NDEOE		="0"

	CEOE		="1"		%CEOE%
	NCEOE		="0"

	TMR		="1"		%TMR%
	NTMR		="0"

	CCLR		="1"		%CCLEAR%
	NCCLR		="0"

	STAT0		="0000"		%STATE3,STATE2,STATE1,STATE0%
	STAT1		="0001"
	STAT2		="0010"
	STAT3		="0011"
	STAT4		="0100"
	STAT5		="0101"
	STAT6		="0110"
	STAT7		="0111"
	STAT8		="1000"
	STAT9		="1001"
	STAT10		="1010"
	STAT11		="1011"
	STAT12		="1100"
	STAT13		="1101"
	STAT14		="1110"
	STAT15		="1111"

	DSAK		="0"		%DSACK*%
	NDSAK		="1"

	MUX3		="111"		%MUX2,MUX1,MUX0%
	MUX2		="011"
	MUX1		="101"
	MUX0		="110"







%-----------------------------------------------------------------------%
%	Here the 448's set all outputs to their default state, then	%
%	wait for either the 68020 to call, or somebody on FASTBUS	%
%	to want something.  When FBSEL is true, that means the 68020 	%
%	is calling, and we need to get the vector from MUX2 and go to	%
%	the routine at that address.  If, on the other hand, FSLV is	%
%	true, we go to the slave handler.				%
%-----------------------------------------------------------------------%



PROGRAM:

RESET:	[Z] JUMP SELECT;

%-----------------------------------------------------------------------%
%-----------------------------------------------------------------------%
%	Routine entry points.						%
%	Entry points are the first instruction of each routine.		%
%-----------------------------------------------------------------------%
%-----------------------------------------------------------------------%

%-----------------------------------------------------------------------%
%	Routine ARBITRATE	STATUS=1				%
%	--WRITE--							%
%-----------------------------------------------------------------------%
%									%
%	This routine sets FREQ true, waits for FRDY to become true,	%
%	then returns home.						%
%-----------------------------------------------------------------------%
ARB:	IF /I6		%FBREQ*%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I2	%FRDY%
	THEN	[CTRLDEF
		FBDEF
		PFFDIS NSR SCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT1 NDSAK MUX1]
		JUMP HOME;
	ELSE 	[CDEF NSRT NDW DATAOUTHOLD NFDOE FCOE NIRQ DFFDIS
		REQ
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT1 NDSAK MUX0]
		JUMP ARB;


%-----------------------------------------------------------------------%
%	Routine BUS_RELEASE	STATUS = 2				%
%	--WRITE--							%
%-----------------------------------------------------------------------%
%									%
%	This routine sets FREL true, clears DS, DK, and AS, then goes 	%
%	home.  Note that since no data is needed, the control lines	%
%	latching the 68020 data	are returned to their default states, 	%
%	discarding the data.						%
%-----------------------------------------------------------------------%
BUSREL:		[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT2 NDSAK MUX1]
		JUMP BUSRELX;



%-----------------------------------------------------------------------%
%-----------------------------------------------------------------------%
%	Primary Address Cycles		STATUS=3			%
%-----------------------------------------------------------------------%
%-----------------------------------------------------------------------%

%-----------------------------------------------------------------------%
%	Routine ADDRESS_DATA_GEOGRAPHICAL				%
%									%
%	Geographical primary address cycle to data space.		%
%	(we assert EG)							%
%	--WRITE--							%
%-----------------------------------------------------------------------%
%									%
%	IF FBREQ Release bus, TMR=0, JUMP INTF.				%
%	ELSEIF WT=1, loop here.						%
%	ELSEIF AK=1 THEN turn off FASTBUS AD line drivers, negate EG, 	%
%		MS, and go home.					%
%	ELSE set AS, TMR (turn on short timer), and loop here.		%
%									%
%-----------------------------------------------------------------------%
ADDDG:	IF /I6		%FBREQ*%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I7		%FRWT%
	THEN 	[CDEF NSRT NDW DATAOUTHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR EG NRD MS0 XWT XDK XDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT3 NDSAK MUX0]
		JUMP ADDDG;
	ELSEIF I5		%FRAK%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		FBDEF
		PFFDIS NSR SCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT3 NDSAK MUX1]
		JUMP HOME;
	ELSE 	[CDEF NSRT NDW DATAOUTHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR EG NRD MS0 XWT XDK XDS SAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT3 NDSAK MUX0]
		JUMP ADDDG;


%-----------------------------------------------------------------------%
%	Routine ADDRESS_CSR_GEOGRAPHICAL				%
%									%
%	Geographical primary address cycle to CSR space.		%
%	(We assert EG)							%
%	--WRITE--							%
%-----------------------------------------------------------------------%
%									%
%	IF FBREQ THEN Release bus, JUMP INTF.				%
%	ELSEIF WT=1, loop here.						%
%	ELSEIF AK=1 THEN turn off FASTBUS AD line drivers, negate EG, 	%
%		MS, and go home.					%
%	ELSE set AS, TMR (turn on short timer), and loop here.		%
%									%
%-----------------------------------------------------------------------%
ADDCG:	IF /I6		%FBREQ%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I7		%FRWT%
	THEN 	[CDEF NSRT NDW DATAOUTHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR EG NRD MS1 XWT XDK XDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT3 NDSAK MUX0]
		JUMP ADDCG;
	ELSEIF I5		%FRAK%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		FBDEF
		PFFDIS NSR SCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT3 NDSAK MUX1]
		JUMP HOME;
	ELSE 	[CDEF NSRT NDW DATAOUTHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR EG NRD MS1 XWT XDK XDS SAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT3 NDSAK MUX0]
		JUMP ADDCG;


%-----------------------------------------------------------------------%
%	Routine ADDRESS_DATA_LOGICAL					%
%									%
%	This routine is identical to ADDRESS_DATA_GEOGRAPHICAL		%
%	except that EG is not driven.					%
%	--WRITE--							%
%-----------------------------------------------------------------------%
%									%
%	IF FBREQ THEN Release bus, TMR=0, JUMP INTF.			%
%	ELSEIF WT=1, loop here.						%
%	ELSEIF AK=1 THEN turn off FASTBUS AD line drivers, negate MS, 	%
%		and go home.						%
%	ELSE set AS, TMR (turn on short timer), and loop here.		%
%									%
%-----------------------------------------------------------------------%
ADDDL:	IF /I6		%FBREQ*%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I7		%FRWT%
	THEN 	[CDEF NSRT NDW DATAOUTHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG NRD MS0 XWT XDK XDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT3 NDSAK MUX0]
		JUMP ADDDL;
	ELSEIF I5		%FRAK%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		FBDEF
		PFFDIS NSR SCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT3 NDSAK MUX1]
		JUMP HOME;
	ELSE 	[CDEF NSRT NDW DATAOUTHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG NRD MS0 XWT XDK XDS SAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT3 NDSAK MUX0]
		JUMP ADDDL;



%-----------------------------------------------------------------------%
%	Routine ADDRESS_CSR_LOGICAL					%
%-----------------------------------------------------------------------%
%	This routine is identical to ADDRESS_CSR_GEOGRAPHICAL except	%
%	that EG is not driven.						%
%	--WRITE--							%
%-----------------------------------------------------------------------%
%									%
%	IF FBREQ THEN Release bus, TMR=0, JUMP INTF.			%
%	ELSEIF WT=1, loop here.						%
%	ELSEIF AK=1 THEN turn off FASTBUS AD line drivers, negate MS, 	%
%	and go home.							%
%	ELSE set AS, TMR (turn on short timer), and loop here.		%
%									%
%-----------------------------------------------------------------------%
ADDCL:	IF /I6		%FBREQ*%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX0]
		JUMP INTF;
	ELSEIF I7		%FRWT%
	THEN 	[CDEF NSRT NDW DATAOUTHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG NRD MS1 XWT XDK XDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT3 NDSAK MUX0]
		JUMP ADDCL;
	ELSEIF I5		%FRAK%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		FBDEF
		PFFDIS NSR SCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT3 NDSAK MUX1]
		JUMP HOME;
	ELSE 	[CDEF NSRT NDW DATAOUTHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG NRD MS1 XWT XDK XDS SAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT3 NDSAK MUX0]
		JUMP ADDCL;


%-----------------------------------------------------------------------%
%	Routine ADDRESS_DATA_BROADCAST					%
%									%
%	This routine does a broadcast primary address cycle to		%
%	DATA space.							%
%	--WRITE--							%
%-----------------------------------------------------------------------%
%	IF FBREQ THEN Release bus, TMR=0, jump INTF.			%
%	ELSEIF WT=1, then loop here.					%
%	ELSEIF AK=1, Then turn off FASTBUS AD line drivers, negate MS, 	%
%		and go home.						%
%	ELSE set AS, TMR (turn on short timer), and loop here.		%
%									%
%-----------------------------------------------------------------------%
ADDDB:	IF /I6		%FBREQ*%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I7		%FRWT%
	THEN 	[CDEF NSRT NDW DATAOUTHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG NRD MS2 XWT XDK XDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT3 NDSAK MUX0]
		JUMP ADDDB;
	ELSEIF I5		%FRAK%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		FBDEF
		PFFDIS NSR SCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT3 NDSAK MUX1]
		JUMP HOME;
	ELSE 	[CDEF NSRT NDW DATAOUTHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG NRD MS2 XWT XDK XDS SAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT3 NDSAK MUX0]
		JUMP ADDDB;


%-----------------------------------------------------------------------%
%	Routine ADDRESS_CSR_BROADCAST					%
%									%
%	This routine does a broadcast primary address cycle to		%
%	CSR space.							%
%	--WRITE--							%
%-----------------------------------------------------------------------%
%	IF FBREQ THEN Release bus, TMR=0, JUMP INTF.			%
%	ELSEIF WT=1, loop here.						%
%	ELSEIF AK=1 THEN turn off FASTBUS AD line drivers, negate MS, 	%
%		and go home.						%
%	ELSE set AS, TMR (turn on short timer), and loop here.		%
%									%
%-----------------------------------------------------------------------%
ADDCB:	IF /I6		%FBREQ*%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I7		%FRWT%
	THEN 	[CDEF NSRT NDW DATAOUTHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG NRD MS3 XWT XDK XDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT3 NDSAK MUX0]
		JUMP ADDCB;
	ELSEIF I5		%FRAK%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		FBDEF
		PFFDIS NSR SCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT3 NDSAK MUX1]
		JUMP HOME;
	ELSE 	[CDEF NSRT NDW DATAOUTHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG NRD MS3 XWT XDK XDS SAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT3 NDSAK MUX0]
		JUMP ADDCB;

%-----------------------------------------------------------------------%
%	Routine ADDRESS_RELEASE						%
%	--WRITE--							%
%-----------------------------------------------------------------------%
%		EG=0 RD=0 MS=0 WT=0 Clear DK,DS,AS			%
ADDREL:	IF /I6		%FBREQ*%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I7		%FRWT%
	THEN 	[CTRLDEF
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT4 NDSAK MUX1]
		JUMP ADDREL;
	ELSE 	[CTRLDEF
		HOLDB NEOBA NILR NEG NRD MS0 XWT CDK CDS CAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT4 NDSAK MUX0]
		JUMP ADDRELX;

%-----------------------------------------------------------------------%
%-----------------------------------------------------------------------%
%	Data Cycle Routines	STATUS=5				%
%-----------------------------------------------------------------------%
%-----------------------------------------------------------------------%

%-----------------------------------------------------------------------%
%	Routine DATA_PROCESSOR_RANDOM_READ				%
%	--READ--							%
%-----------------------------------------------------------------------%
DATPRR:	IF /I6		%FBREQ*%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I7		%FRWT%
	THEN 	[CDEF NSRT NDW DATAIN FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS0 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT5 NDSAK MUX0]
		JUMP DATPRR;
	ELSEIF I4		%FRDK%
	THEN 	[CDEF NSRT NDW DATAINLATCH FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS0 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT5 NDSAK MUX0]
		JUMP DATPRRX;
	ELSE 	[CDEF NSRT NDW DATAIN FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS0 XWT XDK SDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT5 NDSAK MUX0]
		JUMP DATPRR;


%-----------------------------------------------------------------------%
%	Routine DATA_PROCESSOR_RANDOM_WRITE				%
%	--WRITE--							%
%-----------------------------------------------------------------------%
DATPRW:	IF /I6		%FBREQ*%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I7		%FRWT%
	THEN 	[CDEF NSRT NDW DATAOUTHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG NRD MS0 XWT XDK XDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT5 NDSAK MUX0]
		JUMP DATPRW;
	ELSEIF I4		%FRDK%
	THEN 	[CTRLDEF
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT5 NDSAK MUX0]
		JUMP DATPRWX;
	ELSE 	[CDEF NSRT NDW DATAOUTHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG NRD MS0 XWT XDK SDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT5 NDSAK MUX0]
		JUMP DATPRW;

%-----------------------------------------------------------------------%
%	Routine DATA_PROCESSOR_SEC_ADDRESS_READ				%
%	--READ--							%
%-----------------------------------------------------------------------%
DATPSR:	IF /I6		%FBREQ*%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I7		%FRWT%
	THEN 	[CDEF NSRT NDW DATAIN FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS2 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT6 NDSAK MUX0]
		JUMP DATPSR;
	ELSEIF I4		%FRDK%
	THEN 	[CDEF NSRT NDW DATAINLATCH FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS2 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT6 NDSAK MUX0]
		JUMP DATPSRX;
	ELSE 	[CDEF NSRT NDW DATAIN FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS2 XWT XDK SDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT6 NDSAK MUX0]
		JUMP DATPSR;

%-----------------------------------------------------------------------%
%	Routine DATA_PROCESSOR_SEC_ADDRESS_WRITE			%
%	--WRITE--							%
%-----------------------------------------------------------------------%
DATPSW:	IF /I6		%FBREQ*%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I7		%FRWT%
	THEN 	[CDEF NSRT NDW DATAOUTHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG NRD MS2 XWT XDK XDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT6 NDSAK MUX0]
		JUMP DATPSW;
	ELSEIF I4		%FRDK%
	THEN 	[CTRLDEF
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT6 NDSAK MUX0]
		JUMP DATPSWX;
	ELSE 	[CDEF NSRT NDW DATAOUTHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG NRD MS2 XWT XDK SDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT6 NDSAK MUX0]
		JUMP DATPSW;

%-----------------------------------------------------------------------%
%	Dummy instruction to keep vector address consistant with the	%
%		standard microcode.					%
%-----------------------------------------------------------------------%
YOUDUMMY:	[CTRLDEF
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT0 NDSAK MUX1]
		JUMP HOME;

%-----------------------------------------------------------------------%
%	Routine DATA_PROCESSOR_BLOCK_TRANSFER_WRITE			%
%	--WRITE--							%
%-----------------------------------------------------------------------%
DATPBW:		[CDEF NSRT NDW DATAOUTHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG NRD MS1 XWT XDK XDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT5 NDSAK MUX0]
		JUMP DATPBWX;


%-----------------------------------------------------------------------%
%	Routine DATA_PROCESSOR_BLOCK_TRANSFER_TERMINATE			%
%	--WRITE--							%
%-----------------------------------------------------------------------%
%	This routine does a graceful termination of a block transfer	%
%	where DS and DK are brought to their idle states without	%
%	effecting the slave. 						%
%		MS=0 RD=0						%
%		then							%
%		DS=0							%
DATPBT:	IF /I6		%FBREQ*%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I7		%FRWT%
	THEN 	[CTRLDEF
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT5 NDSAK MUX0]
		JUMP DATPBT;
	ELSEIF /I4		%FRDK%
	THEN	[CTRLDEF
		HOLDB EOBA NILR NEG NRD MS0 XWT XDK XDS XAS
		PFFDIS NSR SCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT5 NDSAK MUX1]
		JUMP HOME;
	ELSE 	[CTRLDEF
		HOLDB NEOBA NILR NEG NRD MS0 XWT XDK CDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT5 NDSAK MUX0]
		JUMP DATPBT;

%-----------------------------------------------------------------------%
%	Routine LOCAL_COUNTER_LOAD					%
%	--WRITE--							%
%-----------------------------------------------------------------------%
LC_LOAD:	[CLOAD NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		FBDEF
		PFFDIS SR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT9 NDSAK MUX1]
		JUMP LC_LOADX;


%-----------------------------------------------------------------------%
%	Routine LOCAL_COUNTER_READ					%
%	--READ--							%
%-----------------------------------------------------------------------%
LC_READ:	[CREAD NSRT DW DATADEF NFDOE FCOE NIRQ DFFEN
		FBDEF
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT9 NDSAK MUX1]
		JUMP LC_READX;

%-----------------------------------------------------------------------%
%	Routine FIFO_WRITE						%
%	--WRITE--							%
%-----------------------------------------------------------------------%
FIFO_WR:	[CDEF NSRT DW DATADEF NFDOE FCOE NIRQ DFFEN
		FBDEF
		PFFEN SR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT10 NDSAK MUX1]
		JUMP FIFO_WRX;

%-----------------------------------------------------------------------%
%	Routine DATA_FIFO_BLOCK_TRANSFER_READ				%
%	--WRITE or READ--						%
%-----------------------------------------------------------------------%
DATFBR:	IF /I6			%FBREQ*%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I7		%FRWT%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT7 NDSAK MUX0]
		JUMP DATFBR;
	ELSE	[COUNT NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK SDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT7 NDSAK MUX0]
		JUMP DATFBRX;

%-----------------------------------------------------------------------%
%	Routine DATA_FIFO_PIPELINED_READ_1  (100ns transfers)		%
%	--WRITE or READ--						%
%-----------------------------------------------------------------------%
DATFP1:	IF /I6		%FBREQ*%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I7		%FRWT%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		JUMP DATFP1;
	ELSE 	[COUNT NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK SDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		JUMP DATFP1X;

%-----------------------------------------------------------------------%
%	Routine DATA_FIFO_PIPELINED_READ_2  (200ns transfers)		%
%	--WRITE or READ--						%
%-----------------------------------------------------------------------%
DATFP2:	IF /I6		%FBREQ*%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I7		%FRWT%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		JUMP DATFP2;
	ELSE 	[COUNT NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK SDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		JUMP DATFP2X;

%-----------------------------------------------------------------------%
%	Routine DATA_FIFO_PIPELINED_READ_4  (400ns transfers)		%
%	--READ or WRITE--						%
%-----------------------------------------------------------------------%
DATFP4:	IF /I6		%FBREQ*%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I7		%FRWT%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		JUMP DATFP4;
	ELSE 	[COUNT NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK SDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		JUMP DATFP4X;


%-----------------------------------------------------------------------%
%	Local_Counter_Load_From_FASTBUS (single word random read)	%
%-----------------------------------------------------------------------%
LC_SWR:	IF /I6		%FBREQ*%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I7		%FRWT%
	THEN 	[CDEF NSRT NDW DATAIN FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG RD MS0 XWT XDK XDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT5 NDSAK MUX0]
		JUMP LC_SWR;
	ELSEIF I4		%FRDK%
	THEN 	[CLOAD NSRT NDW DATAINLATCH FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG RD MS0 XWT XDK XDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT5 NDSAK MUX0]
		JUMP LC_SWRX;
	ELSE 	[CDEF NSRT NDW DATAIN FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG RD MS0 XWT XDK SDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT5 NDSAK MUX0]
		JUMP LC_SWR;


%-----------------------------------------------------------------------%
%	Data FIFO Block Read with Leading Word Count			%
%	--WRITE--							%
%-----------------------------------------------------------------------%
DATFBRWC:IF /I6		%FBREQ*%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I7		%FRWT%
	THEN 	[CDEF NSRT NDW DATAIN FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT7 NDSAK MUX0]
		JUMP DATFBRWC;
	ELSEIF I4		%FRDK%
	THEN 	[CLOAD NSRT NDW DATAINLATCH FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT7 NDSAK MUX0]
		JUMP DATFBRWCX;
	ELSE 	[CDEF NSRT NDW DATAIN FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK SDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT7 NDSAK MUX0]
		JUMP DATFBRWC;



%-----------------------------------------------------------------------%
%	Dummy Instruction						%
%	--WRITE--							%
%		This instruction neccessary to keep start vectors 	%
%	consistant with older versions of FSCC microcode.		%
%-----------------------------------------------------------------------%
DUMMY:		[CTRLDEF
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT0 NDSAK MUX1]
		JUMP HOME;


%-----------------------------------------------------------------------%
%	Null								%
%	--WRITE or READ--						%
%-----------------------------------------------------------------------%
NULL:		[CTRLDEF
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT12 NDSAK MUX1]
		JUMP NULLX;


%-----------------------------------------------------------------------%
%	End Of Event							%
%	--WRITE --							%
%-----------------------------------------------------------------------%
EOE:		[CHOLD NSRT DW DATADEF NFDOE FCOE NIRQ DFFEN
		FBDEF
		PFFDIS NSR NSCLK NFCLK DEOE CEOE NTMR NCCLR STAT14 NDSAK MUX1]
		JUMP EOEX;


%-----------------------------------------------------------------------%
%	Bulb Test							%
%	--WRITE or READ--						%
%-----------------------------------------------------------------------%
BULBTST:	[CDEF NSRT NDW DATAOUTHOLD FDOE FCOE IRQ DFFDIS
		HOLDB NEOBA NILR EG RD MS7 XWT SDK SDS SAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT11 NDSAK MUX1]
		JUMP BULBTST;


%-----------------------------------------------------------------------%
%	Trigger_Hold							%
%	--Write--				Status = C		%
%-----------------------------------------------------------------------%
TRIGGER:	[CTRLDEF
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT12 NDSAK MUX1]
		JUMP TRIGGERX;


%-----------------------------------------------------------------------%
%	List Retransmit							%
%	--Write--				Status = B		%
%-----------------------------------------------------------------------%
LRT:		[CDEF SRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT11 NDSAK MUX1]
		JUMP LRTX;


%-----------------------------------------------------------------------%
%	Sequencer Select						%
%	Wait here to be selected by the 68020				%
%		FB1S* + FB2S means that the FASTBUS standard sequencer 	%
%			has been selected. (not this code)		%
%		FB1S* * FB2S* means that the LIST sequencer has been 	%
%			selected. (this code)				%
%									%
%	Whichever sequencer has not been selected, puts it's outputs	%
%		into high Z, and is not accessable unless it is reset.	%
%-----------------------------------------------------------------------%
SELECT:	IF /I1 * /I5		%FB1S* * FB2S*%
	THEN [] JUMP WAYHOME;
	ELSEIF (/I1 * I5) + (I1 * /I5)	%FB2S* + FB1S*%
	THEN [Z] CONTINUE;
	ELSE [Z] JUMP SELECT;

TURNOFF:[Z] JUMP TURNOFF;
%-----------------------------------------------------------------------%
%-----------------------------------------------------------------------%
WAYHOME:	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT0 NDSAK MUX1]
		CONTINUE;

		[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT0 NDSAK MUX1]
		CONTINUE;

		[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT0 NDSAK MUX1]
		CONTINUE;

		[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT0 NDSAK MUX1]
		CONTINUE;

		[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT0 NDSAK MUX1]
		CONTINUE;



%-----------------------------------------------------------------------%
%	Main Idle Loop							%
%		Sequencer loops here waiting for the FB1S to become	%
%		true.  This happens when the List Instruction fifo is	%
%		not empty, and when it is enabled.			%
%-----------------------------------------------------------------------%
%	When HOME, all outputs are default 			%
HOME:	IF /I1 * /I5	%FB1S* * FB2S*%
	THEN	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT0 NDSAK MUX1]
		JUMP WAYHOME;
	ELSEIF /I1		%FB1S*%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA ILR NEG NRD MS0 XWT XDK XDS XAS
		PFFDIS SR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT0 NDSAK MUX3]
		JUMP LETSGO;
	ELSE 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT0 NDSAK MUX1]
		JUMP HOME;



%-----------------------------------------------------------------------%
%	This is the jump to the appropriate FASTBUS			%
%	primative routine as determined by the vector received from	%
%	the '020 through the List Instruction FIFO and MUX3.		%
%-----------------------------------------------------------------------%


LETSGO:		[CDEF NSRT NDW DATAOUTLATCH NFDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA ILR NEG NRD MS0 XWT XDK XDS XAS
		PFFDIS SR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT0 NDSAK MUX3]
		PUSHI;

		[CDEF NSRT NDW DATAOUTHOLD NFDOE FCOE NIRQ DFFDIS
		FBDEF
		PFFDIS SR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT0 NDSAK MUX0]
		RETURN;



%-----------------------------------------------------------------------%
%	Bus Release							%
%-----------------------------------------------------------------------%
%	Release Bus, Status=2						%
%									%
%	Status=2, Status clock = 1					%
BUSRELX:	[CTRLDEF
		FBDEF
		PFFDIS NSR SCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT2 NDSAK MUX1]
		JUMP HOME;



%-----------------------------------------------------------------------%
%	Routine ADDRESS_RELEASE						%
%	--WRITE--							%
%-----------------------------------------------------------------------%
%		Wait for AK to go low, then go HOME.			%
ADDRELX:IF /I6		%FBREQ*%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I5		%FRAK%
	THEN 	[CTRLDEF
		HOLDB NEOBA NILR NEG NRD MS0 XWT CDK CDS CAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT4 NDSAK MUX0]
		JUMP ADDRELX;
	ELSE 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		FBDEF
		PFFDIS NSR SCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT4 NDSAK MUX1]
		JUMP HOME;



%-----------------------------------------------------------------------%
%-----------------------------------------------------------------------%
%	Data Cycle Routines	Status = 5				%
%-----------------------------------------------------------------------%
%-----------------------------------------------------------------------%

%-----------------------------------------------------------------------%
%	Routine DATA_PROCESSOR_RANDOM_READ				%
%	--READ--							%
%-----------------------------------------------------------------------%
%	IF FBREQ THEN clear FASTBUS lines, TMR=0, JUMP TO INTF.		%
%	ELSEIF WT=1 THEN Enable FASTBUS transceivers and drivers 	%
%		(FDOE*=0,DDIR=1,CPBA=0, DSAB=0,DSBA=0,DG*=0), enable 	%
%		data and processor FIFO's, Assert RD=1, MS=0 and	%
%		loop here.						%
%	ELSEIF DK=1 THEN continue.					%
%	ELSE Enable FASTBUS AD line drivers, enable data and proccessor %
%		FIFO's, Assert RD=1, MS=0, DS(u), TMR, and loop here.	%
%									%
%	Hold FIFO's enabled for one more cycle, and continue.		%
%									%
%	IF FBREQ THEN clear FASTBUS lines, TMR=0, JUMP TO INTF.		%
%	ELSEIF WT=1 THEN disable FASTBUS transceivers, disable FIFO's,	%
%		continue to assert RD=1, MS=0, and DS=1, and loop here.	%
%	ELSEIF DK=0 THEN disable FASTBUS transceivers, deassert TMR, RD,%
%		and MS, and go HOME.					%
%	ELSE disable FASTBUS transceivers, disable FIFO's, deassert RD,	%
%		MS, and DS, assert TMR, and loop here.			%
%									%
%-----------------------------------------------------------------------%
DATPRRX:	[CDEF NSRT NDW DATAINHOLD FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS0 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT5 NDSAK MUX0]
		CONTINUE;

WAIT1:	IF /I6		%FBREQ*%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I7		%FRWT%
	THEN 	[CDEF NSRT NDW DATAINHOLD FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS0 XWT XDK XDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT5 NDSAK MUX0]
		JUMP WAIT1;
	ELSEIF /I4		%/FRDK%
	THEN 	[CDEF NSRT NDW DATAINHOLD FDOE FCOE NIRQ DFFEN
		FBDEF
		PFFDIS NSR SCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT5 NDSAK MUX1]
		JUMP HOME;
	ELSE 	[CDEF NSRT NDW DATAINHOLD FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS0 XWT XDK CDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT5 NDSAK MUX0]
		JUMP WAIT1;


%-----------------------------------------------------------------------%
%	Routine DATA_PROCESSOR_RANDOM_WRITE				%
%	--WRITE--							%
%-----------------------------------------------------------------------%
%	IF FBREQ THEN clear FASTBUS lines, TMR=0, JUMP TO INTF.		%
%	ELSEIF WT=1 THEN Enable FASTBUS transceivers and drivers 	%
%		(FDOE*=0, DDIR=0, CPBA=0, DSAB=0, DSBA=1, DG*=0), 	%
%		Assert RD=0, MS=0 and loop here.			%
%	ELSEIF DK=1 THEN disable FASTBUS transceivers and drivers, and 	%
%		continue.						%
%	ELSE Assert DS(u), TMR, keep FASTBUS lines asserted, and loop 	%
%		here.							%
%		Way down in 'Lusiana close to New Orleans, 		%
%		way back up in the woods among the evergreens,		%
%		there was a log cabin made of earth and wood,		%
%		where lived a country boy name of Johnny B. Good.	%
%	IF FBREQ THEN clear FASTBUS lines, TMR=0, JUMP TO HOME.		%
%	ELSEIF WT=1 THEN continue to assert DS=1, and loop here.	%
%	ELSEIF DK=0 THEN go HOME.					%
%	ELSE deassert DS, assert TMR, and loop here.			%
%-----------------------------------------------------------------------%
DATPRWX:IF /I6		%FBREQ*%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I7		%FRWT%
	THEN 	[CTRLDEF
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT5 NDSAK MUX0]
		JUMP DATPRWX;
	ELSEIF /I4		%/FRDK%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		FBDEF
		PFFDIS NSR SCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT5 NDSAK MUX1]
		JUMP HOME;
	ELSE 	[CTRLDEF
		HOLDB NEOBA NILR NEG NRD MS0 XWT XDK CDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT5 NDSAK MUX0]
		JUMP DATPRWX;


%-----------------------------------------------------------------------%
%	Routine DATA_PROCESSOR_SEC_ADDRESS_READ		Status = 6	%
%	--READ--							%
%-----------------------------------------------------------------------%
%	IF FBREQ THEN clear FASTBUS lines, TMR=0, JUMP TO INTF.		%
%	ELSEIF WT=1 THEN Enable FASTBUS transceivers and drivers 	%
%		(FDOE*=0, DDIR=1,CPBA=0, DSAB=0,DSBA=0,DG*=0), enable 	%
%		processor and data FIFO's, Assert RD=1, MS=2 and	%
%		loop here.						%
%	ELSEIF DK=1 THEN continue.					%
%	ELSE Assert DS(u), TMR, and loop here.				%
%									%
%	Hold FIFO's enabled for one more cycle, and continue.		%
%									%
%	IF FBREQ THEN clear FASTBUS lines, TMR=0, DEassert DSACK, jump 	%
%		to INTF. 						%
%	ELSEIF WT=1 THEN disable FASTBUS transceivers, disbable FIFO's	%
%		continue to assert RD=1, MS=2, and DS=1, and loop here.	%
%	ELSEIF DK=0 THEN disable FASTBUS transceivers, disable FIFO's	%
%		deassert RD, and MS, and go HOME.			%
%	ELSE disable FASTBUS transceivers, disable FIFO's, deassert RD, %
%		MS, and DS, assert TMR, and loop here.			%
%									%
%-----------------------------------------------------------------------%
DATPSRX:	[CDEF NSRT NDW DATAINHOLD FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS2 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT6 NDSAK MUX0]
		CONTINUE;

WAIT2:	IF /I6		%FBREQ*%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I7		%FRWT%
	THEN 	[CDEF NSRT NDW DATAINHOLD FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS2 XWT XDK XDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT6 NDSAK MUX0]
		JUMP WAIT2;
	ELSEIF /I4		%/FRDK%
	THEN 	[CDEF NSRT NDW DATAINHOLD FDOE FCOE NIRQ DFFEN
		FBDEF
		PFFDIS NSR SCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT6 NDSAK MUX1]
		JUMP HOME;
	ELSE 	[CDEF NSRT NDW DATAINHOLD FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS2 XWT XDK CDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT6 NDSAK MUX0]
		JUMP WAIT2;


%-----------------------------------------------------------------------%
%	Routine DATA_PROCESSOR_SEC_ADDRESS_WRITE	status = 6	%
%	--WRITE--							%
%-----------------------------------------------------------------------%
%	IF FBREQ THEN clear FASTBUS lines, TMR=0, jump to INTF. 	%
%	ELSEIF WT=1 THEN Enable FASTBUS transceivers and drivers 	%
%		(FDOE*=0, DDIR=0, CPBA=0, DSAB=0, DSBA=1, DG*=0), 	%
%		Assert RD=0, MS=2 and loop here.			%
%	ELSEIF DK=1 THEN disable FASTBUS transceivers and drivers, and 	%
%		continue.						%
%	ELSE Assert DS(u), keep FASTBUS lines asserted, assert TMR, 	%
%		and loop here.						%
%	IF FBREQ THEN clear FASTBUS lines, TMR=0, jump to HOME.		%
%	ELSEIF WT=1 THEN continue to assert DS=1, and loop here.	%
%	ELSEIF DK=0 THEN go HOME.					%
%	ELSE deassert DS, assert TMR, and loop here.			%
%-----------------------------------------------------------------------%
DATPSWX:IF /I6		%FBREQ*%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I7		%FRWT%
	THEN 	[CTRLDEF
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT6 NDSAK MUX0]
		JUMP DATPSWX;
	ELSEIF /I4		%/FRDK%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		FBDEF
		PFFDIS NSR SCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT6 NDSAK MUX1]
		JUMP HOME;
	ELSE 	[CTRLDEF
		HOLDB NEOBA NILR NEG NRD MS0 XWT XDK CDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT6 NDSAK MUX0]
		JUMP DATPSWX;




%-----------------------------------------------------------------------%
%	Routine DATA_PROCESSOR_BLOCK_TRANSFER_WRITE			%
%	--WRITE--							%
%-----------------------------------------------------------------------%
%	As with DATPBR, DSACK will have to be returned after each DK(t) %
%		to allow the 68020 to output new data.			%
%									%
%	Keep FASTBUS AD line drivers enabled, assert MS=1, set MUX1,	%
%		and continue.						%
%	IF FBREQ THEN Release bus, JUMP INTF.				%
%	ELSEIF WT=1 THEN Assert MS=1, keep FASTBUS transceivers enabled,%
%		and enable FASTBUS drivers (DDIR=0, CPBA=0, DSAB=0, 	%
%		DSBA=1, DG*=0, FDOE*=0), and loop here.			%
%	ELSEIF DS=0 THEN Assert MS=1, DS(u), TMR, keep FASTBUS 		%
%		transceivers enabled and enable FASTBUS drivers (DDIR=0,%
%		CPBA=0, DSAB=0, DSBA=1, DG*=0, FDOE*=0), and JUMP to 	%
%		DKUPW.							%
%	ELSE Assert MS=1, DS(d), TMR, keep FASTBUS transceivers enabled,%
%		and enable FASTBUS drivers (DDIR=0, CPBA=0, DSAB=0, 	%
%		DSBA=1, DG*=0, FDOE*=0), and JUMP to DKDWNW.		%
%DKDWNW									%
%	IF FBREQ THEN Release bus, JUMP TO INTF.			%
%	ELSEIF DK=0 THEN deassert MS, TMR, disable FASTBUS transceivers %
%		and drivers (DDIR=0, CPBA=0, DSAB=0, DSBA=0, DG*=1, 	%
%		FDOE*=1), do End-of-Block acknowledge, and JUMP HOME.	%
%	ELSE continue to assert MS, TMR, and keep FASTBUS transceivers 	%
%		and drivers enabled, and loop here.			%
%DKUPW									%
%	IF FBREQ THEN Release bus, JUMP TO INTF.			%
%	ELSEIF DK=1 THEN deassert MS, TMR, disable FASTBUS transceivers %
%		and drivers (DDIR=0, CPBA=0, DSAB=0, DSBA=0, DG*=1, 	%
%		FDOE*=1), do End-of-Block acknowledge, and JUMP HOME.	%
%	ELSE continue to assert MS, TMR, and keep FASTBUS transceivers 	%
%		and drivers enabled, and loop here.			%
%-----------------------------------------------------------------------%
DATPBWX:IF /I6		%FBREQ*%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I7		%FRWT%
	THEN 	[CDEF NSRT NDW DATAOUTHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG NRD MS1 XWT XDK XDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT5 NDSAK MUX0]
		JUMP DATPBWX;
	ELSEIF /I1		%/FRDS%
	THEN 	[CDEF NSRT NDW DATAOUTHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG NRD MS1 XWT XDK SDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT5 NDSAK MUX0]
		JUMP DKUPW;
	ELSE 	[CDEF NSRT NDW DATAOUTHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG NRD MS1 XWT XDK CDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT5 NDSAK MUX0]
		JUMP DKDWNW;

DKDWNW:	IF /I6		%FBREQ*%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF /I4		%/FRDK%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		HOLDB EOBA NILR NEG NRD MS0 XWT XDK XDS XAS
		PFFDIS NSR SCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT5 NDSAK MUX1]
		JUMP HOME;
	ELSE 	[CDEF NSRT NDW DATAOUTHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG NRD MS1 XWT XDK XDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT5 NDSAK MUX0]
		JUMP DKDWNW;

DKUPW:	IF /I6		%FBREQ*%
	THEN	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I4		%FRDK%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		HOLDB EOBA NILR NEG NRD MS0 XWT XDK XDS XAS
		PFFDIS NSR SCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT5 NDSAK MUX1]
		JUMP HOME;
	ELSE 	[CDEF NSRT NDW DATAOUTHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG NRD MS1 XWT XDK XDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT5 NDSAK MUX0]
		JUMP DKUPW;


%-----------------------------------------------------------------------%
%	Routine LOCAL_COUNTER_LOAD					%
%	--WRITE--							%
%-----------------------------------------------------------------------%
%	This routine loads the Local Word Counter with data from	%
%	the processor.  Only the lower 12 bits of the 32 bit word	%
%	are used.							%
%									%
%	Keep SR (list data fifo read) true, put Local Word Counter into %
%		load mode, and continue.				%
%	Negate SR, put Local Word Counter into hold, and jump HOME.	%
%									%
LC_LOADX:	[CHOLD NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		FBDEF
		PFFDIS NSR SCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT9 NDSAK MUX1]
		JUMP HOME;


%-----------------------------------------------------------------------%
%	Routine LOCAL_COUNTER_READ					%
%	--READ--							%
%-----------------------------------------------------------------------%
%	Routine to allow the value of the Local	Word Counter to be	%
%		pushed into the data FIFO.				%
%									%
%	Set DW (data fifo write) true, put Local Word Counter into 	%
%		Read mode, and continue.				%
%	Keep all outputs the same for one more cycle.			%
%	Negate DW, and put Local Word Counter into Hold mode, return	%
%		home.							%
%									%
LC_READX:	[CREAD NSRT DW DATADEF NFDOE FCOE NIRQ DFFEN
		FBDEF
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT9 NDSAK MUX1]
		CONTINUE;

		[CREAD NSRT NDW COUNTIN NFDOE FCOE NIRQ DFFDIS
		FBDEF
		PFFDIS NSR SCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT9 NDSAK MUX1]
		JUMP HOME;

%-----------------------------------------------------------------------%
%	Routine FIFO_WRITE						%
%	--WRITE--							%
%-----------------------------------------------------------------------%
%	Routine to write a word from the list data FIFO into the 	%
%		processor and data FIFO's.				%
%									%
%	Keep SR (list data fifo read) true, set data FIFO Write true 	%
%		(DW=1), enable FIFO's.					%
%	Set FCLK true.							%
%	Negate DW, FCLK, and SR, JUMP TO HOME.				%
%									%
FIFO_WRX:	[CDEF NSRT DW DATADEF NFDOE FCOE NIRQ DFFEN
		FBDEF
		PFFEN NSR SCLK FCLK NDEOE NCEOE NTMR NCCLR STAT10 NDSAK MUX1]
		JUMP HOME;

%-----------------------------------------------------------------------%
%	Routine DATA_FIFO_BLOCK_TRANSFER_READ				%
%	--WRITE or READ--						%
%-----------------------------------------------------------------------%
%	This routine does a FASTBUS handshake block transfer read from	%
%	the FASTBUS crate segment to the FSCC's Output Port Data FIFO, 	%
%	and also the Processor Data FIFO.				%
%-----------------------------------------------------------------------%
%	Note: DDIR, and SAB must be held high throughout the block	%
%		transfer operation.					%
%									%
%DATFBR:IF FBREQ							%
%	THEN release bus jump to EOEERROR				%
%	ELSEIF WT=1							%
%	THEN Enable FASTBUS xceivers, enable processor and Data FIFO's	%
%		MS=1, RD=1, Place local word counter into hold, and 	%
%		loop here.						%
%	ELSE Turn on FASTBUS xcievers, enable processor and Data FIFO's	%
%		MS=1, RD=1, Place local word counter into count, set 	%
%		DS=1, NO FCLK!, and jump to DATFBRX.			%
%									%
%BXFERLP:IF (/FRDK * FRSS1) + EOB + FBREQ				%
%	THEN Enable FASTBUS xceivers, enable processor and Data FIFO's	%
%		MS=1, RD=1, Place local word counter into hold mode, 	%
%		and JUMP to EOBIRQ.					%
%	ELSEIF WT=1							%
%	THEN Enable FASTBUS xceivers, enable processor and Data FIFO's	%
%		MS=1, RD=1, Place local word counter into hold, and 	%
%		loop here.						%
%	ELSEIF DK=0							%
%	THEN Turn on FASTBUS xcievers, enable processor and Data FIFO's	%
%		MS=1, RD=1, Place local word counter into count, set 	%
%		DS=1, set FCLK, and continue.				%
%	ELSE Place local word counter into hold, and loop here.		%
%									%
%DATFBRX:Place counter into hold mode, negate FCLK, set TMR, and 	%
%		continue.  This	cycle ensures that the FSCC's minimum 	%
%		FASTBUS cycle time (100ns) is not violated.  If some 	%
%		slave returns DK too quickly, the FSCC could 		%
%		try to do another DS before the FIFO's were ready for 	%
%		the next word.  This cycle keeps the sequencer from 	%
%		looking for DK before it should.			%
%									%
%	Keep TMR true, and do another NOP for the same reason as above.	%
%									%
%	IF (FRDK* FRSS1) + EOB + FBREQ					%
%	THEN counter=hold, NTMR, keep FIFO's enabled and jump to EOBIRQ.%
%	ELSEIF WT=1							%
%	THEN counter=hold, NTMR, keep both FIFO's enabled and loop here.%
%	ELSEIF DK=1 							%
%	THEN counter=decr, set DS=0, set FCLK, keep FIFO's enabled,	%
%		Clear TMR, and continue.				%
%	ELSE counter=hold, TMR, keep FIFO's enabled, and loop here.	%
%									%
%	Place local word counter in hold, negate FCLK, keep processor 	%
%		and oport FIFO's enabled, set TMR, and JUMP to DATFBR.  %
%		This cycle ensures that the FSCC's minimum cycle time 	%
%		is not violated in the same way as above.		%
%	Keep TMR set, do another NOP for the same reason as above, and	%
%		jump to BXFERLP.					%
%									%
%EOBIRQ:IF FBREQ THEN Release bus, jump to EOEERROR.			%
%	ELSEIF DS=1 							%
%	THEN counter=hold, TMR, continue.				%
%	ELSE counter=hold, TMR, JUMP DSLOWH.				%
%									%
%	--case DS=1--							%
%	IF FBREQ THEN Release bus, jump to EOEERROR.			%
%	ELSEIF DK=1 THEN Clear TMR, continue.				%
%	ELSE keep TMR true, and wait here.				%
%									%
%	Wait two cycles to allow for FIFO write.			%
%									%
%	IF FBREQ THEN Release bus, jump to EOEERROR.			%
%	ELSEIF WT=1							%
%	THEN RD=1, MS=0, counter=hold, FIFO'S disabled loop here.	%
%	ELSE DS=0, RD=0, MS=0, FIFO's Disabled continue.		%
%									%
%	IF FBREQ THEN Release bus, jump EOEERROR.				%
%	ELSEIF DK=0 THEN NTMR, EOBA, IRQ, jump HOME.			%
%	ELSE TMR, wait here.						%
%									%
%PDSLOWH:IF FBREQ THEN Release bus, jump to EOEERROR.			%
%	ELSEIF DK=0 THEN clear TMR, continue.				%
%	ELSE TMR, wait here.						%
%									%
%	wait three cycles to ensure FIFO write, then IRQ, EOBA, jump	%
%	home.								%
%									%
BXFERLP:IF (/I4 * I0) + I3 + /I6	%(/FRDK * FRSS1) + FEOB + FBREQ*%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT7 NDSAK MUX0]
		JUMP EOBIRQ;
	ELSEIF I7		%FRWT%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT7 NDSAK MUX0]
		JUMP BXFERLP;
	ELSEIF /I4		%/FRDK%
	THEN 	[COUNT NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK SDS XAS
		PFFEN NSR NSCLK FCLK NDEOE NCEOE NTMR NCCLR STAT7 NDSAK MUX0]
		CONTINUE;
	ELSE 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT7 NDSAK MUX0]
		JUMP BXFERLP;

DATFBRX:	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT7 NDSAK MUX0]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT7 NDSAK MUX0]
		CONTINUE;

WAIT3:	IF (I4 * I0) + I3 + /I6		%(FRDK * FRSS1) + FEOB + FBREQ*%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT7 NDSAK MUX0]
		JUMP EOBIRQ;
	ELSEIF I7		%FRWT%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT7 NDSAK MUX0]
		JUMP WAIT3;
	ELSEIF I4		%FRDK%
	THEN 	[COUNT NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK CDS XAS
		PFFEN NSR NSCLK FCLK NDEOE NCEOE NTMR NCCLR STAT7 NDSAK MUX0]
		CONTINUE;
	ELSE 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT7 NDSAK MUX0]
		JUMP WAIT3;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT7 NDSAK MUX0]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT7 NDSAK MUX0]
		JUMP BXFERLP;

EOBIRQ:	IF /I0		%/FRSS1%
	THEN	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFEN NSR NSCLK FCLK NDEOE NCEOE NTMR NCCLR STAT7 NDSAK MUX0]
		CONTINUE;
	ELSE	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT7 NDSAK MUX0]
		CONTINUE;

	IF /I6		%FBREQ*%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX0]
		JUMP EOEERROR;
	ELSEIF I1		%FRDS%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT7 NDSAK MUX0]
		CONTINUE;
	ELSE 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT7 NDSAK MUX0]
		JUMP DSLOWH;

%	Case--DS=1							%
DSHIGHH:IF /I6		%FBREQ*%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX0]
		JUMP EOEERROR;
	ELSEIF I4		%FRDK%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT7 NDSAK MUX0]
		CONTINUE;
	ELSE 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT7 NDSAK MUX0]
		JUMP DSHIGHH;

		[CHOLD NSRT NDW DATAINFIFO NFDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT7 NDSAK MUX0]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO NFDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT7 NDSAK MUX0]
		CONTINUE;

WAIT5:	IF /I6		%FBREQ*%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP EOEERROR;
	ELSEIF I7		%FRWT%
	THEN 	[CTRLDEF
		HOLDB NEOBA NILR NEG RD MS0 XWT XDK XDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT7 NDSAK MUX0]
		JUMP WAIT5;
	ELSE 	[CTRLDEF
		HOLDB NEOBA NILR NEG RD MS0 XWT XDK CDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT7 NDSAK MUX0]
		CONTINUE;

WAIT6:	IF /I6		%FBREQ*%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP EOEERROR;
	ELSEIF /I4		%FRDK=0%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE IRQ DFFDIS
		HOLDB EOBA NILR NEG NRD MS0 XWT XDK XDS XAS
		PFFDIS NSR SCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT7 NDSAK MUX1]
		JUMP HOME;
	ELSE 	[CTRLDEF
		HOLDB NEOBA NILR NEG RD MS0 XWT XDK XDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT7 NDSAK MUX0]
		JUMP WAIT6;


%	Case--DS=0							%
DSLOWH:	IF /I6		%FBREQ*%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP EOEERROR;
	ELSEIF /I4		%FRDK=0%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT7 NDSAK MUX1]
		CONTINUE;
	ELSE 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT7 NDSAK MUX0]
		JUMP DSLOWH;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT7 NDSAK MUX1]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT7 NDSAK MUX1]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE IRQ DFFEN
		HOLDB EOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT7 NDSAK MUX1]
		JUMP HOME;

%-----------------------------------------------------------------------%
%	Routine DATA_FIFO_PIPELINED_READ_1  (100ns transfers)		%
%	--WRITE or READ--						%
%-----------------------------------------------------------------------%
%	FASTBUS pipeline block transfer read from the FASTBUS crate 	%
%	segment to the FSCC's Output Port Data FIFO, and also the 	%
%	Processor Data FIFO if enabled through the parrallel port.	%
%									%
%	Set FASTBUS xcievers for input (DDIR=1, SAB=1, FDOE*=0),	%
%		enable data and processor FIFO's (DFIFOEN=1, PFIFOEN=1),%
%		MS=3, RD=1, and continue.				%
%									%
%	Note: DDIR, and SAB must be held high throughout the block	%
%		transfer operation.					%
%									%
%DATFP1:IF FBREQ THEN Release bus, jump to EOEERROR.			%
%	ELSEIF WT=1							%
%	THEN Enable FASTBUS xceivers for input, MS=3, RD=1, Place local %
%		word counter into hold, and loop here.			%
%	ELSE Enable FASTBUS xceivers for input, MS=3, RD=1, Place local %
%		word counter into count, set DS=1, and JUMP to DATFP1X:	%
%									%
%PXFR1LP:IF FBREQ THEN Release bus, jump to EOEERROR.			%
%	ELSEIF WT=1							%
%	THEN Enable FASTBUS xceivers for input, MS=3, RD=1, Place local %
%		word counter into hold, and loop here.			%
%	ELSEIF EOB							%
%	THEN Enable FASTBUS xceivers for input, MS=3, RD=1, Place local %
%		word counter into hold mode, and JUMP to EOBPIPE.	%
%	ELSE Enable FASTBUS xceivers for input, MS=3, RD=1, Place local %
%		word counter into count, set DS=1, set FCLK, and 	%
%		continue.						%
%									%
%DATFP1X:Place counter into hold mode, negate FCLK, and 		%
%		continue.  This	cycle provides the FSCC's 		%
%		FASTBUS cycle time (100ns).				%
%									%
%	IF FBREQ THEN Release bus, jump to EOEERROR.			%
%	ELSEIF WT=1							%
%	THEN counter=hold, keep both FIFO's enabled and loop here.	%
%	ELSEIF EOB							%
%	THEN counter=hold, keep FIFO's enabled and jump to EOBPIPE.	%
%	ELSE counter=decr, set DS=0, set FCLK, keep FIFO's enabled,	%
%		and continue.						%
%									%
%	Place local word counter in hold, negate FCLK, keep processor 	%
%		and oport FIFO's enabled, and JUMP to PXFR1LP.		%
%		This cycle provides the FSCC's cycle time. 		%
%									%
%EOBPIPE:IF SS <> 2 (Local counter terminated the block transfer)	%
%	THEN FCLK continue.						%
%	ELSE (SS=2 terminated the block transfer) continue.		%
%									%
%	IF FBREQ THEN Release bus, jump to EOEERROR.			%
%	ELSEIF DS=1 							%
%	THEN counter=hold, TMR, continue.				%
%	ELSE counter=hold, TMR, JUMP DSLOWP.				%
%									%
%	--case  DS=1--							%
%DSHIGHP:IF FBREQ THEN Release bus, jump to EOEERROR.			%
%	ELSEIF DK=1 THEN Clear TMR, continue.				%
%	ELSE keep TMR true, and wait here.				%
%									%
%	Wait two cycles to allow for FIFO write.			%
%									%
%	IF FBREQ THEN Release bus, jump to EOEERROR.			%
%	ELSEIF WT=1 THEN RD=1, counter=hold, disable FIFO's, loop here.	%
%	ELSE RD=0, MS=0, DS=0, disable FIFO', continue.			%
%									%
%	IF FBREQ THEN Release bus, jump to EOEERROR.			%
%	ELSEIF DK=0 THEN clear TMR, EOBA, IRQ, continue.		%
%	ELSE TMR, wait here.						%
%									%
%	--case  DS=0--							%
%DSLOWP:IF FBREQ THEN Release bus, jump to EOEERROR.			%
%	ELSEIF DK=0 THEN clear TMR, CONTINUE.				%
%	ELSE TMR, wait here.						%
%									%
%	Wait three cycles to ensure FIFO write, then IRQ, EOBA, jump	%
%	home.								%
%									%
PXFR1LP:IF /I6		%FBREQ*%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP EOEERROR;
	ELSEIF I7		%FRWT%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		JUMP PXFR1LP;
	ELSEIF I3		%FEOB%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		JUMP EOBPIPE;
	ELSE 	[COUNT NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK SDS XAS
		PFFEN NSR NSCLK FCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

DATFP1X:	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

WAIT7:	IF /I6		%FBREQ*%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP EOEERROR;
	ELSEIF I7		%FRWT%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		JUMP WAIT7;
	ELSEIF I3		%FEOB%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		JUMP EOBPIPE;
	ELSE 	[COUNT NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK CDS XAS
		PFFEN NSR NSCLK FCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		JUMP PXFR1LP;

EOBPIPE:IF /I0		%/FRSS1%
	THEN	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK FCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;
	ELSE	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

	IF /I6		%FBREQ*%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP EOEERROR;
	ELSEIF I1		%FRDS%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;
	ELSE 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT8 NDSAK MUX0]
		JUMP DSLOWP;

%	Case  DS=1							%
DSHIGHP:IF /I6		%FBREQ*%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP EOEERROR;
	ELSEIF I4		%FRDK%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;
	ELSE 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT8 NDSAK MUX0]
		JUMP DSHIGHP;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

WAIT9:	IF /I6		%FBREQ*%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP EOEERROR;
	ELSEIF I7		%FRWT%
	THEN 	[CTRLDEF
		HOLDB NEOBA NILR NEG RD MS0 XWT XDK XDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		JUMP WAIT9;
	ELSE 	[CTRLDEF
		HOLDB NEOBA NILR NEG RD MS0 XWT XDK CDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

WAIT10:	IF /I6		%FBREQ*%
	THEN	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP EOEERROR;
	ELSEIF /I4	%FRDK=0%
	THEN	[CDEF NSRT NDW DATADEF NFDOE FCOE IRQ DFFDIS
		HOLDB EOBA NILR NEG NRD MS0 XWT XDK XDS XAS
		PFFDIS NSR SCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX1]
		JUMP HOME;
	ELSE	[CTRLDEF
		HOLDB NEOBA NILR NEG RD MS0 XWT XDK XDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT8 NDSAK MUX0]
		JUMP WAIT10;

%	Case  DS=0							%
DSLOWP:	IF /I6		%FBREQ*%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP EOEERROR;
	ELSEIF /I4		%FRDK=0%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT8 NDSAK MUX1]
		CONTINUE;
	ELSE 	[CHOLD NSRT NDW DATAINFIFO NFDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		JUMP DSLOWP;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT8 NDSAK MUX1]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT8 NDSAK MUX1]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE IRQ DFFEN
		HOLDB EOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT8 NDSAK MUX1]
		JUMP HOME;


%-----------------------------------------------------------------------%
%	Routine DATA_FIFO_PIPELINED_READ_2  (200ns transfers)		%
%	--WRITE or READ--						%
%-----------------------------------------------------------------------%
%	This routine does a FASTBUS pipeline block transfer read from	%
%	the FASTBUS crate segment to the FSCC's Output Port Data FIFO, 	%
%	and also the Processor Data FIFO.				%
%									%
%	Note: DDIR, and SAB must be held high throughout the block	%
%		transfer operation.					%
%									%
%DATFP2:IF FBREQ THEN Release bus, JUMP EOEERROR.			%
%	ELSEIF WT=1							%
%	THEN Enable FASTBUS xceivers for input, Enable FIFO's, MS=3,	%
%		RD=1, Place local word counter into hold, and loop here.%
%	ELSEIF EOB							%
%	THEN Enable FASTBUS xceivers for input, enable FIFO's, MS=3,	%
%		RD=1, Place local word counter into hold mode, and	%
%		JUMP to EOBPIPE.					%
%	ELSE Enable FASTBUS xceivers for input, enable FIFO's, MS=3,	%
%		RD=1, Place local word counter into count, set DS=1, 	%
%		and JUMP to DATFP2X.					%
%									%
%PXFR2LP:IF FBREQ THEN Release bus, JUMP EOEERROR.			%
%	ELSEIF WT=1							%
%	THEN Enable FASTBUS xceivers for input, Enable FIFO's, MS=3,	%
%		RD=1, Place local word counter into hold, and loop here.%
%	ELSEIF EOB							%
%	THEN Enable FASTBUS xceivers for input, enable FIFO's, MS=3,	%
%		RD=1, Place local word counter into hold mode, and	%
%		JUMP to EOBPIPE.					%
%	ELSE Enable FASTBUS xceivers for input, enable FIFO's, MS=3,	%
%		RD=1, Place local word counter into count, set DS=1, 	%
%		set FCLK, and continue.					%
%									%
%DATFP2X:Place counter into hold mode, negate FCLK, and 		%
%		continue.  These cycles provide the FSCC's 		%
%		FASTBUS cycle time (200ns).				%
%									%
%	Continue (add 50ns to cycle time).				%
%									%
%	Continue (add 50ns to cycle time).				%
%									%
%	IF FBREQ THEN Release bus, jump to EOEERROR.			%
%	ELSEIF WT=1							%
%	THEN counter=hold, keep both FIFO's enabled and loop here.	%
%	ELSEIF EOB							%
%	THEN counter=hold, keep FIFO's enabled and jump to EOBPIPE.	%
%	ELSE counter=decr, set DS=0, set FCLK, keep FIFO's enabled,	%
%		and continue.						%
%									%
%	Place local word counter in hold, negate FCLK, keep processor 	%
%		and oport FIFO's enabled, and Continue.			%
%		These cycles provide the FSCC's cycle time. 		%
%									%
%	Continue (add 50ns to cycle time).				%
%									%
%	Jump to PXFR2LP. (add 50ns to cycle time).			%
%									%
PXFR2LP:IF /I6		%FBREQ*%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP EOEERROR;
	ELSEIF I7		%FRWT%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		JUMP PXFR2LP;
	ELSEIF I3		%FEOB%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		JUMP EOBPIPE;
	ELSE 	[COUNT NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK SDS XAS
		PFFEN NSR NSCLK FCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

DATFP2X:	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;


WAIT11:	IF /I6		%FBREQ*%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP EOEERROR;
	ELSEIF I7		%FRWT%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		JUMP WAIT11;
	ELSEIF I3		%FEOB%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		JUMP EOBPIPE;
	ELSE 	[COUNT NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK CDS XAS
		PFFEN NSR NSCLK FCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		JUMP PXFR2LP;


%-----------------------------------------------------------------------%
%	Routine DATA_FIFO_PIPELINED_READ_4  (400ns transfers)		%
%	--READ or WRITE--						%
%-----------------------------------------------------------------------%
%	This routine does a FASTBUS pipeline block transfer read from	%
%	the FASTBUS crate segment to the FSCC's Output Port Data FIFO, 	%
%	and also the Processor Data FIFO.				%
%									%
%	Note: DDIR, and SAB must be held high throughout the block	%
%		transfer operation.					%
%									%
%DATFP4:IF FBREQ THEN Release bus, jump to EOEERROR			%
%	ELSEIF WT=1							%
%	THEN Enable FASTBUS xceivers for input, enable data and 	%
%		processor FIFO's, MS=3, RD=1, Place local word counter 	%
%		into hold, and loop here.				%
%	ELSEIF EOB							%
%	THEN Enable FASTBUS xceivers for input, enable FIFO's, Place 	%
%		local word counter into hold mode, MS=3, RD=1, and JUMP %
%		to EOBPIPE.						%
%	ELSE Enable FASTBUS xceivers for input, enable FIFO's, Place 	%
%		local word counter into count, MS=3, RD=1, set DS=1, 	%
%		and JUMP to DATFP4X.					%
%									%
%PXFR4LP:IF FBREQ THEN Release bus, jump to EOEERROR.			%
%	ELSEIF WT=1							%
%	THEN Enable FASTBUS xceivers for input, enable data and 	%
%		processor FIFO's, MS=3, RD=1, Place local word counter 	%
%		into hold, and loop here.				%
%	ELSEIF EOB							%
%	THEN Enable FASTBUS xceivers for input, enable FIFO's, Place 	%
%		local word counter into hold mode, MS=3, RD=1, and JUMP %
%		to EOBPIPE.						%
%	ELSE Enable FASTBUS xceivers for input, enable FIFO's, Place 	%
%		local word counter into count, MS=3, RD=1, set DS=1, 	%
%		set FCLK, and continue.					%
%									%
%	Place counter into hold mode, negate FCLK, and 			%
%		continue.  These cycles provide the FSCC's 		%
%		FASTBUS cycle time (400ns).				%
%									%
%	Continue (add 50ns to cycle time).				%
%									%
%	Continue (add 50ns to cycle time).				%
%									%
%	Continue (add 50ns to cycle time).				%
%									%
%	Continue (add 50ns to cycle time).				%
%									%
%	Continue (add 50ns to cycle time).				%
%									%
%	Continue (add 50ns to cycle time).				%
%									%
%	IF FBREQ THEN Release bus, jump to EOEERROR.			%
%	ELSEIF WT=1							%
%	THEN counter=hold, keep both FIFO's enabled and loop here.	%
%	ELSEIF EOB							%
%	THEN counter=hold, keep FIFO's enabled and jump to EOBPIPE.	%
%	ELSE counter=decr, set DS=0, set FCLK, keep FIFO's enabled,	%
%		and continue.						%
%									%
%	Place local word counter in hold, negate FCLK, keep processor 	%
%		and oport FIFO's enabled, and Continue.			%
%		These cycles provide the FSCC's cycle time. 		%
%									%
%	Continue (add 50ns to cycle time).				%
%									%
%	Continue (add 50ns to cycle time).				%
%									%
%	Continue (add 50ns to cycle time).				%
%									%
%	Continue (add 50ns to cycle time).				%
%									%
%	Continue (add 50ns to cycle time).				%
%									%
%	Jump to PXFR4LP.(add 50ns to cycle time).			%
%									%
PXFR4LP:IF /I6		%FBREQ*%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP EOEERROR;
	ELSEIF I7		%FRWT%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		JUMP PXFR4LP;
	ELSEIF I3		%FEOB%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		JUMP EOBPIPE;
	ELSE 	[COUNT NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK SDS XAS
		PFFEN NSR NSCLK FCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

DATFP4X:	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;


		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

WAIT12:	IF /I6		%FBREQ*%
	THEN 	[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP EOEERROR;
	ELSEIF I7		%FRWT%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		JUMP WAIT12;
	ELSEIF I3		%FEOB%
	THEN 	[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		JUMP EOBPIPE;
	ELSE 	[COUNT NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK CDS XAS
		PFFEN NSR NSCLK FCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		CONTINUE;

		[CHOLD NSRT NDW DATAINFIFO FDOE FCOE NIRQ DFFEN
		HOLDB NEOBA NILR NEG RD MS3 XWT XDK XDS XAS
		PFFEN NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT8 NDSAK MUX0]
		JUMP PXFR4LP;

%-----------------------------------------------------------------------%
%	Local_Counter_Load_From_FASTBUS (single word random read)	%
%	--READ--							%
%-----------------------------------------------------------------------%
%	IF FBREQ THEN clear FASTBUS lines, TMR=0, JUMP TO INTF.		%
%	ELSEIF WT=1 THEN Enable FASTBUS transceivers and drivers 	%
%		(FDOE*=0,DDIR=1,CPBA=0, DSAB=0,DSBA=0,DG*=0), enable 	%
%		data and processor FIFO's, Assert RD=1, MS=0 and	%
%		loop here.						%
%	ELSEIF DK=1 THEN continue.					%
%	ELSE Enable FASTBUS AD line drivers, place Local Counter into	%
%		Load mode, Assert RD=1, MS=0, DS(u), TMR, and loop here.%
%									%
%	Hold counter in Load mode for one more cycle, and continue.	%
%									%
%	IF FBREQ THEN clear FASTBUS lines, TMR=0, JUMP TO INTF.		%
%	ELSEIF WT=1 THEN disable FASTBUS transceivers, place counter	%
%		in Hold mode, continue to assert RD=1, MS=0, and DS=1, 	%
%		and loop here.						%
%	ELSEIF DK=0 THEN disable FASTBUS transceivers, deassert TMR, RD,%
%		and MS, and go HOME.					%
%	ELSE disable FASTBUS transceivers, place counter into hold mode,%
%		deassert RD, MS, and DS, assert TMR, and loop here.	%
%									%
%-----------------------------------------------------------------------%
LC_SWRX:	[CLOAD NSRT NDW DATAINHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG RD MS0 XWT XDK XDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT5 NDSAK MUX0]
		CONTINUE;

WAIT13:	IF /I6		%FBREQ*%
	THEN 	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF I7		%FRWT%
	THEN 	[CDEF NSRT NDW DATAINHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG RD MS0 XWT XDK XDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT5 NDSAK MUX0]
		JUMP WAIT13;
	ELSEIF /I4		%/FRDK%
	THEN 	[CDEF NSRT NDW DATAINHOLD FDOE FCOE NIRQ DFFDIS
		FBDEF
		PFFDIS NSR SCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT5 NDSAK MUX1]
		JUMP HOME;
	ELSE 	[CDEF NSRT NDW DATAINHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG NRD MS0 XWT XDK CDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE TMR NCCLR STAT5 NDSAK MUX0]
		JUMP WAIT13;


%-----------------------------------------------------------------------%
%	Routine DATA_FIFO_BLOCK_READ_WITH_LEADING_WORD_COUNT		%
%-----------------------------------------------------------------------%
%DATFBRWC:IF FBREQ							%
%	THEN release bus jump to INTF					%
%	ELSEIF WT=1							%
%	THEN Enable FASTBUS xceivers, MS=1, RD=1, loop here.		%
%	ELSEIF DK=1 THEN latch data, place local counter into load mode,%
%		jump to DATFBRWCX.					%
%	ELSE Turn on FASTBUS xcievers, enable processor and Data FIFO's	%
%		MS=1, RD=1, Place local word counter into hold, set 	%
%		DS=1, NO FCLK!, and loop.				%
%									%
%DATFBRWCX: Keep local word counter in load mode, keep RD=1, MS=1,	%
%		jump into middle of DATFBR routine to finish block	%
%		transfer with local counter termination.		%
DATFBRWCX:	[CLOAD NSRT NDW DATAINHOLD FDOE FCOE NIRQ DFFDIS
		HOLDB NEOBA NILR NEG RD MS1 XWT XDK XDS XAS
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT7 NDSAK MUX0]
		JUMP DATFBRX;


%-----------------------------------------------------------------------%
%	Null								%
%	--WRITE or READ--						%
%-----------------------------------------------------------------------%
NULLX:		[CTRLDEF
		FBDEF
		PFFDIS NSR SCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT12 NDSAK MUX1]
		JUMP HOME;


%-----------------------------------------------------------------------%
%	End Of Event							%
%	--WRITE--							%
%-----------------------------------------------------------------------%
%	--Two dummy words--						%
%	DW (Data FIFO Write), DEOE, CEOE, DFFEN, Set FASTBUS interface	%
%		transceivers for output to FIFO (Data and Processor).	%
%		DSACK, continue.					%
%									%
%	Hold all lines for one more cycle (make sure that the write	%
%		pulse to the FIFO's is long enough).			%
%									%
%	Hold DEOE true for one more cycle while DW is false.  This	%
%		provides the "hold" time for the fifo's.		%
%									%
%	Set DW, for two cycles to insert another dummy word with DEOE	%
%		false.							%
%									%
%	Hold DEOE true for one more cycle while DW is false, to 	%
%		ensure that the fifo data hold time spec is met.	%
%									%
EOEX:		[CDEF NSRT DW DATADEF NFDOE FCOE NIRQ DFFEN
		FBDEF
		PFFDIS NSR NSCLK NFCLK DEOE CEOE NTMR NCCLR STAT14 NDSAK MUX1]
		CONTINUE;

		[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFEN
		FBDEF
		PFFDIS NSR NSCLK NFCLK DEOE NCEOE NTMR NCCLR STAT14 NDSAK MUX1]
		CONTINUE;

		[CDEF NSRT DW DATADEF NFDOE FCOE NIRQ DFFEN
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT14 NDSAK MUX1]
		CONTINUE;

		[CDEF NSRT DW DATADEF NFDOE FCOE NIRQ DFFEN
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT14 NDSAK MUX1]
		CONTINUE;

		[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFEN
		FBDEF
		PFFDIS NSR SCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT14 NDSAK MUX1]
		JUMP HOME;


%-----------------------------------------------------------------------%
%	Trigger_Hold							%
%	--Write--				Status = B		%
%-----------------------------------------------------------------------%
%	Wait in loop until TSTRB becomes true.				%
TRIGGERX:	IF	/I6		%FBREQ*%
	THEN	[CTRLDEF
		REL
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP INTF;
	ELSEIF	I0		%TSTRB%
	THEN	[CTRLDEF
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT12 NDSAK MUX1]
		JUMP HOME;
	ELSE	[CTRLDEF
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT12 NDSAK MUX1]
		JUMP TRIGGERX;


%-----------------------------------------------------------------------%
%	List Retransmit							%
%	--Write--				Status = B		%
%-----------------------------------------------------------------------%
%	List reexecute							%
LRTX:		[CDEF SRT NDW DATADEF NFDOE FCOE NIRQ DFFDIS
		FBDEF
		PFFDIS NSR SCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT11 NDSAK MUX1]
		JUMP HOME;




%-----------------------------------------------------------------------%
%	If an error occurs during a block transfer to the data FIFO,	%
%	the error bit into the control FIFO is set.  Here, the		%
%	end-of-event bit is set so that the bad event is output with	%
%	the "bad event" tag true in the word count word.  The sequencer	%
%	then continues on to the normal Interrupt routine.		%
%									%
EOEERROR:	[CDEF NSRT DW DATADEF NFDOE FCOE NIRQ DFFEN
		FBDEF
		PFFDIS NSR NSCLK NFCLK DEOE CEOE NTMR NCCLR STAT14 NDSAK MUX1]
		CONTINUE;

		[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFEN
		FBDEF
		PFFDIS NSR NSCLK NFCLK DEOE NCEOE NTMR NCCLR STAT14 NDSAK MUX1]
		CONTINUE;

		[CDEF NSRT DW DATADEF NFDOE FCOE NIRQ DFFEN
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT14 NDSAK MUX1]
		CONTINUE;

		[CDEF NSRT DW DATADEF NFDOE FCOE NIRQ DFFEN
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT14 NDSAK MUX1]
		CONTINUE;

		[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFEN
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT14 NDSAK MUX1]
		CONTINUE;

		[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFEN
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT14 NDSAK MUX1]
		CONTINUE;

		[CDEF NSRT NDW DATADEF NFDOE FCOE NIRQ DFFEN
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT14 NDSAK MUX1]
		CONTINUE;

%-----------------------------------------------------------------------%
%	Interrupt handler						%
%-----------------------------------------------------------------------%
%	Being interrupted means that there was a FASTBUS error, or 	%
%	the RB (Reset Bus) line has been driven true.  In either case	%
%	the sequencer's assigned task is simply to abort any operation	%
%	it is currently doing, clear the latched error, and return to 	%
%	idle.  								%
%									%
INTF:		[CTRLDEF
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR CCLR STAT15 NDSAK MUX1]
		CONTINUE;
		[CTRLDEF
		FBDEF
		PFFDIS NSR NSCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		CONTINUE;
		[CTRLDEF
		FBDEF
		PFFDIS NSR SCLK NFCLK NDEOE NCEOE NTMR NCCLR STAT15 NDSAK MUX1]
		JUMP HOME;
