OPORT State Machine SAM format file
VDAS controller
V7.02  Friday 12-JUL-91	1300hrs
Change from V3: Keep oe true during reset to prevent 485 drivers from 
		oscillating on cable.
Change from V4: Change Start, and Step inputs to Mode0, and Mode1.
		Four possible modes are now:
		M1	M0	Mode
		0	0	Hold
		0	1	Start
		1	0	Force_Start
		1	1	CPU
Change from V5:	Reverse polarity of Strobe output, and remove Strobe, and
		OE from RESET state.  Now a negative going ~25 ns pulse
		will be generated by a one shot on the AUX card from the 
		rising edge of the the VDAS controller Strobe output.
		Change made 21-Mar-90  by Richard Kwarciany.
Change from V6:	Inverted PERMIN/PERMOUT signals as per E771's request, and
		corrected error in macros for vdas_oe line.  24-Mar-90  RK
Change from V6.01: Change polarity of WAIT input to match VDAS's /WAIT signal.
		10-APR-90, RK.
Change from V6.02: Change INHIB line to MODE2.  Encode the three mode lines
		to allow for two new modes.  The new modes are; EMPO, and PO.
		(Event With Manual Permit Out, and Permit Out).  The Eight
		possible modes are now:
		Mode		M2	M1	M0
		Hold		0	0	0
		Event		0	0	1
		Force_Event	0	1	0
		CPU (Step)	0	1	1
		Inhibit		1	0	0
		EMPO		1	0	1
		PO		1	1	0
		Reserved	1	1	1
Change from V7.00: Added two new states; Active2, and Wait3.  Active2 is the
		same as Active, except that EOE is not tested.  This state will
		only be used on the first data cycle, where EOE is not valid.
		Wait3 is the same as Wait, except that it returns to Active2
		instead of Active.
Change from V7.01: Made changes to fix bugs in Step mode operation.
		Add two clock cycles to Permout pulse.  Pulse is now 300ns.

PART: EPS448

INPUTS: wait@2, eoe@3, def@4, cef@5, permin@9, mode2@10, mode1@11, mode0@12

OUTPUTS: Q3@25, Q2@24, Q1@23, Q0@22, 
	lck@13, strobe@20, /cfifor@17, /dfifor@18,
	/loe@14, error@26, stpack@27, /prmout@28,
	/lclr@16, vdas_oe@1

MACROS:  % outNo   state    outputs %
	   RESET = "0000    0011100100"	%LCLR*%
           OUT0  = "0000    0011000101"	%LCLR*,LOE*,VDAS_OE%
           OUT1  = "0001    0001000111"	%CFR*,LOE*,VDAS_OE%
           OUT2  = "0010    0011000101"	%LCLR*,LOE*,VDAS_OE%
           OUT3  = "0011    1011000111"	%LCK*,LOE*,VDAS_OE%
	   OUT3A = "0011    0001000111" %CFR*,LOE*,VDAS_OE%
           OUT4  = "0100    1010000111"	%LCK,DFR*,LOE*,VDAS_OE%
           OUT5  = "0101    0011001011"	%STPACK,LOE*,VDAS_OE,PERMOUT*%
           OUT6  = "0110    0001000111"	%CFR*,LOE*,VDAS_OE%
           OUT7  = "0111    0011110100"	%ERROR,LCLR*%
           OUT8  = "1000    0011100110"	%no outputs%
           OUT9A = "1001    0011000101"	%LCLR*,LOE*,VDAS_OE%
           OUT9B = "1001    0010000001"	%LCLR*,DFR*,PERMOUT*,LOE*,VDAS_OE%
           OUT9C = "1001    0011000001"	%PERMOUT*,LCLR*,LOE*,VDAS_OE%
           OUT9D = "1001    0010100100"	%DFR*,LCLR*%
           OUT9E = "1001    0011000000"	%PERMOUT*,LCLR*,LOE*%
           OUT10 = "1010    1011000111"	%LCK,LOE*,VDAS_OE%
           OUT11 = "1011    0101000111"	%STROBE,CFR*,LOE*,VDAS_OE%
           OUT12 = "1100    0110000111"	%STROBE,DFR*,LOE*,VDAS_OE%
           OUT13 = "1101    0011001011"	%STPACK,LOE*,VDAS_OE,PERMOUT*%
           OUT14 = "1110    1011000111"	%LCK,LOE*,VDAS_OE%
           OUT15 = "1111    1011000111"	%LCK,LOE*,VDAS_OE%

EQUATIONS:
	MODE_0	=	/mode2  *  /mode1  *  /mode0;	%hold%
	MODE_1	=	/mode2  *  /mode1  *   mode0;	%Event%
	MODE_2  =	/mode2  *   mode1  *  /mode0;	%Force_Event%
	MODE_3	=	/mode2  *   mode1  *   mode0;	%CPU%
	MODE_4	=	 mode2  *  /mode1  *  /mode0;	%Inhibit%
	MODE_5	=	 mode2  *  /mode1  *   mode0;	%EMPO%
	MODE_6	=	 mode2  *   mode1  *  /mode0;	%PO%
	MODE_7	=	 mode2  *   mode1  *   mode0;	%Reserved%

PROGRAM:
%****************************************************************************%
%    State = IDLE, CK=L, strobe=H, cfifor=H, dfifor=H, oe=H, error=0,        %
%    stpack=L,  prmout=L                                                     %
%****************************************************************************%
	[RESET] CONTINUE;

RES:	IF (MODE_1 + MODE_3 + MODE_5)		%Event + CPU + EMPO%
	THEN [RESET] CONTINUE;
	ELSEIF MODE_2 THEN [OUT0] JUMP IDLES;	%Force_Event%
	ELSEIF MODE_4 THEN [OUT8] JUMP INHIBS;	%inhibit%
	ELSE [RESET] JUMP RES;

PINWAIT1:IF /permin + MODE_2			%permin* + Force_Event%
	THEN [OUT0] JUMP IDLES;
	ELSEIF MODE_4 THEN [OUT8] JUMP INHIBS;	%inhibit%
	ELSE [RESET] JUMP PINWAIT1;


%****************************************************************************%
%    State = IDLE, CK=L, strobe=H, cfifor=H, dfifor=H, oe=H, error=0,        %
%    stpack=L,  prmout=L                                                     %
%    IF inhib THEN State=INHIB (8)                                           %
%    ELSEIF ((Event + Force_Event + CPU + EMPO) * cef) State=SETUP (2)       %
%    ELSE state=IDLES (0)                                                    %
%****************************************************************************%
IDLES:	IF MODE_4				%Inhibit%
	THEN [OUT8] JUMP INHIBS;
      	ELSEIF (MODE_1 + MODE_2 + MODE_3 + MODE_5) * cef
	THEN [OUT2] JUMP SETUPS;
	ELSE [OUT0] JUMP IDLES;



%****************************************************************************%
%    State = INHIB, CK=L, strobe=H, cfifor=H, dfifor=H, oe=H, error=0,       %
%    stpack=L,  prmout=L                                                     %
%****************************************************************************%
INHIBS: IF MODE_4 THEN [OUT8] JUMP INHIBS;	%Inhibit%
        ELSE [OUT0] JUMP RES;



%****************************************************************************%
%    State = SETUP, CK=L, strobe=H, cfifor=H, dfifor=H, oe=H, error=0,       %
%    stpack=L,  prmout=L                                                     %
%    IF /wait State=ERROR (7), error go to H                                 %
%    ELSE State=CONTS (6), cfifor=L, oe=L                                    %
%****************************************************************************%
SETUPS: IF (/wait) THEN [OUT7] JUMP ERRORS;
        ELSEIF MODE_3 THEN [OUT3A] CONTINUE;	%Step%
        ELSE [OUT6] JUMP CONTS;

	[OUT3] JUMP STEPS;



%****************************************************************************%
%    State = CONTS, CK=L, strobe=H, cfifor=L, dfifor=H, oe=L, error=0,       %
%    stpack=L,  prmout=L                                                     %
%    IF cef State=ACTIVE (14), ck go to H, strobe=L, cfifor=H                %
%****************************************************************************%
CONTS: IF MODE_0 THEN [OUT4] JUMP HOLD1S;	%hold%
       ELSE [OUT14] JUMP ACTIVE2S;



%****************************************************************************%
%    State = ACTIVES, CK=H, strobe=L, cfifor=H, dfifor=H, oe=L, error=0,     %
%    stpack=L,  prmout=L                                                     %
%    IF /WAIT THEN WAITS						     %
%    IF eoe State=EOES (9), ck go to H, oe=H,                                %
%    ELSEIF def THEN State=DATA (12), ck=L, strobe=H, dfifor=H,              %
%    ELSE State = ACTIVES						     %
%****************************************************************************%
ACTIVES: IF (/wait) THEN [OUT15] JUMP WAITS;
         ELSEIF (eoe) THEN [OUT9A] JUMP CHKMODE;
         ELSEIF (def) THEN [OUT12] JUMP DATAS;
         ELSE [OUT14] JUMP ACTIVES;

ACTIVE2S:IF (/wait) THEN [OUT15] JUMP WAIT3S;
         ELSEIF (def) THEN [OUT12] JUMP DATAS;
         ELSE [OUT14] JUMP ACTIVE2S;



%****************************************************************************%
%    State = DATAS, CK=L, strobe=H, cfifor=H, dfifor=H, oe=L, error=0,       %
%    stpack=L,  prmout=L                                                     %
%    IF /start THEN HOLD1S.						     %
%    ELSE State=ACTIVE (14), ck go to H, strobe=L, cfifor=H         	     %
%****************************************************************************%
DATAS: IF MODE_0 THEN [OUT4] JUMP HOLD1S;	%hold%
       ELSE [OUT14] JUMP ACTIVES;



%****************************************************************************%
%    State = WAITS, CK=H, strobe=L, cfifor=H, dfifor=H, oe=L, error=0,       %
%    stpack=L,  prmout=L                                                     %
%    IF cef State=ACTIVE (14), same outputs                                  %
%****************************************************************************%
WAITS: IF (wait) THEN [OUT14] JUMP ACTIVES;	%/wait*%
       ELSE [OUT15] JUMP WAITS;

WAIT3S:IF (wait) THEN [OUT14] JUMP ACTIVE2S;	%/wait*%
       ELSE [OUT15] JUMP WAIT3S;



%****************************************************************************%
%    State = HOLD1S, CK=H, strobe=L, cfifor=H, dfifor=H, oe=L, error=0,      %
%    stpack=L,  prmout=L                                                     %
%    IF inhib State=INHIBS (8), ck go to L, strobe=H, oe=H                   %
%    ELSEIF (step * !start) State=IDLE, ck goto L, strobe=H, oe=H            %
%    ELSEIF (start) State=ACTIVE, same outputs                               %
%****************************************************************************%
HOLD1S: IF MODE_4 THEN [OUT8] JUMP INHIBS;
        ELSEIF MODE_3 THEN [OUT0] JUMP IDLES;	%Step%
        ELSEIF MODE_1 + MODE_2 + MODE_5		%Event + Force_Event + EMPO%
	THEN [OUT12] JUMP DATAS;
        ELSE [OUT4] JUMP HOLD1S;



%****************************************************************************%
%    State = STEPS, CK=L, strobe=H, cfifor=L, dfifor=H, oe=L, error=0,       %
%    stpack=L,  prmout=L                                                     %
%    IF /wait State=WAIT2S (1), same outputs                                 %
%    ELSEIF (!cef) State=STPACK1 cfifor=H, oe=H, stpack=H                    %
%    ELSE State=IDLE, stpack goto H, cfifor=H, oe=H                          %
%****************************************************************************%
STEPS: IF (/wait) THEN [OUT1] JUMP WAIT2S;
       ELSEIF (!cef) THEN [OUT5] JUMP STPACK1S;
       ELSE [OUT11] JUMP SDATAS;



%****************************************************************************%
%    State = SDATAS, CK=H, strobe=L, cfifor=H, dfifor=H, oe=L, error=0,      %
%    stpack=L,  prmout=L                                                     %
%    IF (!step) State=HOLD2S, same outputs                                   %
%    ELSEIF (cef) State=STEPS (3), ck go to L, strobe=H, cfifor=L            %
%****************************************************************************%
SDATAS: IF MODE_3 THEN [OUT3] JUMP STEPS;	%step%
        ELSE [OUT10] JUMP HOLD2S;



%****************************************************************************%
%    State = HOLD2S, CK=H, strobe=L, cfifor=H, dfifor=H, oe=L, error=0,      %
%    stpack=L,  prmout=L                                                     %
%    IF inhib State=INHIBS (8), ck go to L, strobe=H, oe=H                   %
%    ELSEIF (/step * /start) State=IDLES, ck goto L, strobe=H, oe=H          %
%    ELSEIF (start * step) State=SDATAS, same outputs                        %
%****************************************************************************%
HOLD2S: IF MODE_4 THEN [OUT8] JUMP INHIBS;	%Inhibit%
        ELSEIF MODE_1 + MODE_2 + MODE_5		%Event + Force_Event + EMPO%
	THEN [OUT0] JUMP IDLES;
        ELSEIF MODE_3 THEN [OUT11] JUMP SDATAS;	%step%
        ELSE [OUT10] JUMP HOLD2S;



%****************************************************************************%
%    State = WAIT2S, CK=L, strobe=H, cfifor=L, dfifor=H, oe=L, error=0,      %
%    stpack=L,  prmout=L                                                     %
%    IF cef State=STEP (3), same outputs                                     %
%****************************************************************************%
WAIT2S: IF (wait) THEN [OUT3] JUMP STEPS;
        ELSE [OUT1] JUMP WAIT2S;



%****************************************************************************%
%     EOE goto IDLE                                                          %
%****************************************************************************%
EOES:   [OUT9C] CONTINUE;		%permout for 300ns%

	[OUT9E] CONTINUE;		%disable VDAS drivers%
	[OUT9E] CONTINUE;
	[OUT9E] CONTINUE;
	[OUT9E] CONTINUE;

PINWAIT2:IF (/permin) THEN [OUT0] JUMP IDLES;	%/permin*%
	ELSEIF MODE_0 THEN [RESET] JUMP RES;	%hold%
	ELSEIF MODE_4 THEN [OUT8] JUMP INHIBS;	%inhibit%
	ELSE [RESET] JUMP PINWAIT2;


%****************************************************************************%
%     STPACK1S goto STPACK2                                                  %
%****************************************************************************%
STPACK1S:  [OUT13] JUMP STPACK2S;



%****************************************************************************%
%     STPACK2S goto PINWAIT2                                                 %
%****************************************************************************%
STPACK2S:   [OUT0] JUMP PINWAIT2;



%****************************************************************************%
%    State = ERRORS, CK=L, strobe=H, cfifor=H, dfifor=H, oe=H, error=1,      %
%    stpack=L,  prmout=L                                                     %
%    stay in ERRORS until hardware Reset                                     %
%****************************************************************************%
ERRORS: [OUT7] JUMP ERRORS;


CHKMODE:IF MODE_6 + MODE_1 + MODE_2		%PO + Event + Force_Event%
	THEN [OUT9B] JUMP EOES;
	ELSEIF MODE_0 THEN [OUT9D] JUMP CLEANUP;	%hold%
	ELSEIF MODE_4 THEN [OUT9D] JUMP INHIBS;		%Inhibit%
	ELSE [OUT9A] JUMP CHKMODE;


CLEANUP:[RESET] JUMP RES;

END$
