/*------------------------------------------------------------------
  MC68901 Multi-Function Peripheral (MFP) register offsets and bits
 
 	13-JUL-89 MDB	Added support for FSCC				
 ------------------------------------------------------------------
*/

#define MFP_GPIP              	0x00		/* GENERAL PURPOSE I/O REGISTER */
#define MFP_GPDR              	0x00		/* GENERAL PURPOSE DATA REGISTER */
#define MFP_AER               	0x01           	/* ACTIVE EDGE REGISTER */
#define MFP_DDR               	0x02           	/* DATA DIRECTION REGISTER  */

#define MFP_IERA              	0x03           	/* INT ENABLE REG A */
#define MFP_IERB              	0x04           	/* INT ENABLE REG B */
#define MFP_IPRA             	0x05           	/* INT PENDING REG A  */
#define MFP_IPRB              	0x06           	/* INT PENDING REG B  */
#define MFP_ISRA	      	0x07           	/* INT IN SERVICE REG A */
#define MFP_ISRB		0x08           	/* INT IN SERVICE REG B */
#define MFP_IMRA              	0x09           	/* INT MASK REG A */
#define MFP_IMRB              	0x0A           	/* INT MASK REG A */
#define MFP_IVR               	0x0B           	/* INT VECTOR REGISTER */

#define MFP_TACR              	0x0C           	/* TIMER A CONTROL REG */
#define MFP_TBCR		0x0D           	/* TIMER B CONTROL REG */
#define MFP_TCDCR             	0x0E           	/* TIMERS C & D CNTRL REG */
#define MFP_TADR              	0x0F           	/* TIMER A DATA REGISTER */ 
#define MFP_TBDR              	0x10           	/* TIMER B DATA REGISTER */
#define MFP_TCDR              	0x11           	/* TIMER C DATA REGISTER  */
#define MFP_TDDR              	0x12           	/* TIMER D DATA REGISTER  */

#define MFP_SCR	        	0x13		/* SYNCH CHAR CONTROL REG */
#define MFP_UCR               	0x14		/* USART CONTROL REGISTER */
#define MFP_RSR               	0x15		/* RECEIVER STATUS REG  */
#define MFP_TSR               	0x16		/* TRANSMITTER STATUS REG */
#define MFP_UDR               	0x17		/* USART DATA REGISTER  */

#define MFP_TBEMPTY	      	7		/* TRANSMIT BUFFER EMPTY */ 
#define MFP_RBFULL	      	7		/* RECEIVE BUFFER FULL */ 
#define MFP_OVERRUN	      	6		/* CHARACTER OVERRUN  */
#define MFP_BREAK	      	3		/* BREAK/ABORT FLAG */
                   
#define MFP_XMT_BIT_A	      	2		/*  Transmitter bit (register set A). */
#define MFP_RCV_BIT_A	      	4		/*  Receiver bit (register set A). */

#define MFP_GPIP0_BIT_B		0		/*  Gen Purpose Interrupt 0 (reg set B). */
#define MFP_GPIP1_BIT_B		 1		/*  Gen Purpose Interrupt 1 (reg set B). */
#define MFP_GPIP2_BIT_B		 2		/*  Gen Purpose Interrupt 2 (reg set B). */
#define MFP_GPIP3_BIT_B		 3		/*  Gen Purpose Interrupt 3 (reg set B). */
#define MFP_GPIP4_BIT_B		 6		/*  Gen Purpose Interrupt 4 (reg set B). */
#define MFP_GPIP5_BIT_B		 7		/*  Gen Purpose Interrupt 5 (reg set B). */
#define MFP_GPIP6_BIT_A		 6		/*  Gen Purpose Interrupt 6 (reg set A). */
#define MFP_GPIP7_BIT_A		 7		/*  Gen Purpose Interrupt 7 (reg set A). */
