/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	Header file for layer 1 routines for the FSCC
 *	
 * Author:  Chip Watson, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: fb_fscc_def.h,v $
 *   Revision 1.1.1.1  1996/08/21 19:20:38  heyes
 *   Imported sources
 *
*	  Revision 1.1  94/03/15  12:00:23  12:00:23  heyes (Graham Heyes)
*	  Initial revision
*	  
*	  Revision 1.2  93/11/22  09:04:31  09:04:31  abbottd (David Abbott)
*	  Added Data fifo reset macro FSCC_DATARS"
*	  
*	  Revision 1.1  93/10/27  09:26:53  09:26:53  heyes (Graham Heyes)
*	  Initial revision
*	  
 *	  Revision 1.1  1993/04/14  20:16:58  watson
 *	  Initial revision
 *
 *	  Revision 1.1  1993/04/14  20:16:58  watson
 *	  Initial revision
 *
 *	  Revision 1.1  1993/03/16  13:56:44  heyes
 *	  Initial revision
 *
 *	  Revision 1.7  1992/09/09  17:15:41  watson
 *	  fix HCR_COUNT, add processor fifo macros
 *
 *	  Revision 1.6  1992/09/04  13:28:02  watson
 *	  fix def of HCR_COUNT to word not char
 *
 *	  Revision 1.5  1992/09/03  18:34:21  watson
 *	  fix local counter enable/disable macros
 *
 *	  Revision 1.4  1992/07/29  12:48:30  watson
 *	  added null FPGADM and FPGACM
 *
 *	  Revision 1.3  1992/07/17  14:58:23  watson
 *	  added write block hardware primitive
 *
 *	  Revision 1.2  1992/07/16  14:55:11  watson
 *	  added new block xfer action number
 *
 *	  Revision 1.1  1992/07/15  19:07:43  watson
 *	  Initial revision
 *
 *
 */

#ifndef INCfbfsccdef
#define INCfbfsccdef

/******************************** Globals ***********************************/

extern int fscc_csr[32];	/* 8 = arbitration level, 9,1c-1f timers */
extern volatile int fscc_error;	/* error indicator from int handler */
extern int fscc_error_seq;	/* last good sequencer status */
extern int fscc_error_slv;	/* latched slave status */
extern int fscc_int_count;	/* count of interrupts */
extern int fscc_berr_count;	/* count of bus errors */
extern int fscc_seq_buf_action;	/* type of last action called w/ a seq buf */
extern int fscc_frlen_info;	/* auxilliary info for frlen */

#define ACTION_READ_BLOCK 1	/* read block to user buffer */
#define ACTION_WRITE_BLOCK 2	/* write block from user buffer */
#define ACTION_FIFO_BLOCK 3	/* read block to data fifo */


/*************** FSCC Fastbus Sequencer Starting Addresses ******************/

#define B_ARB_ *(unsigned long *) 0x620300 /* arbitrate */
#define B_REL_ *(unsigned long *) 0x600004 /* release bus */
#define AD_GEO *(unsigned long *) 0x600304 /* address data geographic */
#define AC_GEO *(unsigned long *) 0x600308 /* address control geo */
#define AD_LOG *(unsigned long *) 0x60030c /* address data logical */
#define AC_LOG *(unsigned long *) 0x600310 /* address control logical */
#define AD_BRO *(unsigned long *) 0x600314 /* address data broadcast */
#define AC_BRO *(unsigned long *) 0x600318 /* address control broadcast */
#define A_RELE *(unsigned long *) 0x60031c /* address release */
#define DP_RRD *(unsigned long *) 0x620320 /* random read */
#define DP_RWR *(unsigned long *) 0x600324 /* random write */
#define DP_SAR *(unsigned long *) 0x620328 /* secondary address read */
#define DP_SAW *(unsigned long *) 0x60032c /* secondary address write */
#define DP_BTR *(unsigned long *) 0x620008 /* block transfer read */
#define DP_BTW *(unsigned long *) 0x60000c /* block transfer write */
#define DP_BTT *(unsigned long *) 0x600330 /* block transfer terminate */
#define DF_BTR *(unsigned long *) 0x600334 /* block transfer to data fifo */
#define DF_PR1 *(unsigned long *) 0x600338 /* 100ns pipeline to data fifo */
#define DF_PR2 *(unsigned long *) 0x60033c /* 200ns pipeline to data fifo */
#define DF_PR4 *(unsigned long *) 0x600340 /* 400ns pipeline to data fifo */
#define NULL__ *(unsigned long *) 0x600020 /* sequencer nop */
#define LC_LD_ *(unsigned long *) 0x620010 /* local counter load */
#define LC_RD_ *(unsigned long *) 0x620014 /* local counter read */
#define FF_WR_ *(unsigned long *) 0x620018 /* data fifo write */
#define EOE___ *(unsigned long *) 0x600024 /* mark end of event */
#define SD_IPT *(unsigned long *) 0x62001c /* slave data input */
#define SD_OPT *(unsigned long *) 0x600344 /* slave data output */


/*************** FSCC Parallel Port Definitions *****************************/

#define PP1_PGCR  *(unsigned char *) 0x640000 /* port 1 general control reg */
#define PP1_PSRR  *(unsigned char *) 0x640001 /* port 1 service request reg */
#define PP1_PADDR *(unsigned char *) 0x640002 /* port 1A data dir register */
#define PP1_PBDDR *(unsigned char *) 0x640003 /* port 1B data dir register */
#define PP1_PCDDR *(unsigned char *) 0x640004 /* port 1C data dir register */
#define PP1_PACR  *(unsigned char *) 0x640006 /* port 1A control register */
#define PP1_PBCR  *(unsigned char *) 0x640007 /* port 1A control register */
#define PP1_PADR  *(unsigned char *) 0x640008 /* port 1A data register */
#define PP1_PBDR  *(unsigned char *) 0x640009 /* port 1B data register */
#define PP1_PCDR  *(unsigned char *) 0x64000C /* port 1C data register */
#define PP1_PSR   *(unsigned char *) 0x64000D /* port 1 status register */
#define PP1_TCR   *(unsigned char *) 0x640010 /* port 1 timer cntl reg */
#define PP1_TSR   *(unsigned char *) 0x64001A /* port 1 timer status reg */

#define PP2_PGCR  *(unsigned char *) 0x660000 /* port 2 general control reg */
#define PP2_PSRR  *(unsigned char *) 0x660001 /* port 2 service request reg */
#define PP2_PADDR *(unsigned char *) 0x660002 /* port 2A data dir register */
#define PP2_PBDDR *(unsigned char *) 0x660003 /* port 2B data dir register */
#define PP2_PCDDR *(unsigned char *) 0x660004 /* port 2C data dir register */
#define PP2_PACR  *(unsigned char *) 0x660006 /* port 2A control register */
#define PP2_PBCR  *(unsigned char *) 0x660007 /* port 2A control register */
#define PP2_PADR  *(unsigned char *) 0x660008 /* port 2A data register */
#define PP2_PBDR  *(unsigned char *) 0x660009 /* port 2B data register */
#define PP2_PBAR  *(unsigned char *) 0x66000B /* port 2A live data register */
#define PP2_PCDR  *(unsigned char *) 0x66000C /* port 2C data register */
#define PP2_PSR   *(unsigned char *) 0x66000D /* port 2 status register */
#define PP2_TCR   *(unsigned char *) 0x660010 /* port 2 timer cntl reg */
#define PP2_CPRH  *(unsigned char *) 0x660013 /* port 2 counter preload */
#define PP2_CPRM  *(unsigned char *) 0x660014 /* port 2 counter preload */
#define PP2_CPRL  *(unsigned char *) 0x660015 /* port 2 counter preload */
#define PP2_TSR   *(unsigned char *) 0x66001A /* port 2 timer status reg */

#define FSCC_PFIFO *(int *) 0x680000	/* Processor fifo */

#define PIT_PSR_H3 0x4		/* STATCLK from sequencer into PP1 */

#define OPORT_CSR0 *(unsigned char *) 0x4A0000 /* OPORT status1 register */
#define OPORT_CSR1 *(unsigned char *) 0x4A0001 /* OPORT control & status2 */

#define HCR_COUNT  *(unsigned short int *) 0x4E0000 /* H&C counter */
#define HCR_HEADER *(unsigned char *) 0x4E0002 /* H&C header (bits 0-4) */
#define HCR_CSR    *(unsigned char *) 0x4E0003 /* H&C control & status */

#define APORT_DR   *(unsigned char *) 0x4C0000 /* PARALLS aux data port */

/*	Port 1 reg A */
#define FSCC_M_FRRD		0x01	/* (AH,I) FASTBUS received RD */
#define FSCC_M_FRDS		0x02	/* (AH,I) FASTBUS received DS */
#define FSCC_M_FRMS0		0x04	/* (AH,I) FASTBUS received MS0 */
#define FSCC_M_FRMS1		0x08	/* (AH,I) FASTBUS received MS1 */
#define FSCC_M_FRMS2		0x10	/* (AH,I) FASTBUS received MS2 */
#define FSCC_M_FRAK		0x20	/* (AH,I) FASTBUS received AK */
#define FSCC_M_FRDY		0x40	/* (AH,I) FASTBUS master */
#define FSCC_M_FSLV		0x80	/* (AL,I) FASTBUS slave mode */

/*	Port 1 reg B */
#define FSCC_M_TRIG0		0x01	/* (AH,I) Trigger Vector 0 */
#define FSCC_M_TRIG1		0x02	/* (AH,I) Trigger Vector 1 */
#define FSCC_M_TRIG2		0x04	/* (AH,I) Trigger Vector 2 */
#define FSCC_M_TRIG3		0x08	/* (AH,I) Trigger Vector 3 */
#define FSCC_M_FP0		0x10	/* (AH,O) Front Panel 0 */
#define FSCC_M_FP1		0x20	/* (AH,O) Front Panel 1 */
#define FSCC_M_FP2		0x40	/* (AH,O) Front Panel 2 */
#define FSCC_M_FP3		0x80	/* (AH,O) Front Panel 3 */

/*	Port 1 reg C */
#define FSCC_M_PRS		0x01	/* (AL,O) Processor FIFO reset (low) */
#define FSCC_M_PEF		0x02	/* (AL,I) Processor FIFO empty (low) */
#define FSCC_M_COPYEN		0x04	/* (AH,O) Processor FIFO copy enable */
#define FSCC_M_WDTO		0x08	/* (AL,O) "Watchdog" timeout */
#define FSCC_M_DRS		0x10	/* (AL,O) Data FIFO reset */
#define FSCC_M_DRT		0x20	/* (AL,O) Data FIFO retransmit */
#define FSCC_M_SRS		0x40	/* (AL,O) Sequencer List FIFO reset */
#define FSCC_M_DFF		0x80	/* (AL,I) Data FIFO overflow (low) */

/*	Port 2 reg A */
#define FSCC_M_FDGK		0x01	/* (AH,O) FASTBUS drive GK */
#define FSCC_M_FDRB		0x02	/* (AH,O) FASTBUS drive RB */
#define FSCC_M_FDSS0		0x04	/* (AH,O) FASTBUS drive SS0 */
#define FSCC_M_FDSS1		0x08	/* (AH,O) FASTBUS drive SS1 */
#define FSCC_M_FDSS2		0x10	/* (AH,O) FASTBUS drive SS2 */
#define FSCC_M_LCEN		0x80	/* (AH,O) Local Counter Enable */

/*	Port 2 reg B */
#define FSCC_M_SSTAT0		0x01	/* (AH,I) Sequencer status 0 */
#define FSCC_M_SSTAT1		0x02	/* (AH,I) Sequencer status 1 */
#define FSCC_M_SSTAT2		0x04	/* (AH,I) Sequencer status 2 */
#define FSCC_M_SSTAT3		0x08	/* (AH,I) Sequencer status 3 */
#define FSCC_M_FRSR		0x10	/* (AH,I) FASTBUS SR */
#define FSCC_M_EOBINT		0x20	/* (AH,O) End-of-block int enable*/
#define FSCC_M_FCLERR		0x40	/* (AH,O) FASTBUS Clear Errors */
#define FSCC_M_SNRESET		0x80	/* (AL,O) FPORT Controller Reset */

/*	Port 2 reg C */
#define FSCC_M_STEN		0x01	/* (AH,O) Short timer enable */
#define FSCC_M_STO		0x02	/* (AL,I) Short timeout */
#define FSCC_M_LTEN		0x04	/* (AH,I) Long timer enable */
#define FSCC_M_LTO		0x08	/* (AL,O) Long timeout */
#define FSCC_M_FLSS0		0x10	/* (AH,I) FASTBUS latched SS0 */
#define FSCC_M_FLSS1		0x20	/* (AH,I) FASTBUS latched SS1 */
#define FSCC_M_FLSS2		0x40	/* (AH,I) FASTBUS latched SS2 */
#define FSCC_M_FRESET		0x80	/* (AL,I) FASTBUS reset */

#define FSCC_M_SS0 0x00		/* slave status values as in PP1_PCDR */
#define FSCC_M_SS1 0x10
#define FSCC_M_SS2 0x20
#define FSCC_M_SS3 0x30
#define FSCC_M_SS4 0x40
#define FSCC_M_SS5 0x50
#define FSCC_M_SS6 0x60
#define FSCC_M_SS7 0x70


/*************** FSCC Fastbus Primitives ************************************/

#define FPARB(arbl) B_ARB_=(arbl) /* arbitrate */
#define FPREL() B_REL_=0	/* release bus */

#define FPGAD(pa) AD_GEO=(pa)	/* address data geographic */
#define FPGAC(pa) AC_GEO=(pa)	/* address control geographic */
#define FPAD(pa) AD_LOG=(pa)	/* address data logical */
#define FPAC(pa) AC_LOG=(pa)	/* adderss control logical */
#define FPADM(pa) AD_BRO=(pa)	/* address data multiple listener */
#define FPACM(pa) AC_BRO=(pa)	/* adderss control multiple listener */
#define FPAREL() A_RELE=0	/* release address */

#define FPGADM(pa)		/* can't be called, but is referenced */
#define FPGACM(pa)		/* ditto */

#define FPSAW(sa) DP_SAW=(unsigned long)(sa) /* secondary address write */
#define FPSAR(sa) (sa)=DP_SAR	/* secondary address read */

#define FPR(data) (data)=DP_RRD /* random read */
#define FPW(data) DP_RWR=(data) /* random write */

#define FPRB(array) (array)=DP_BTR
#define FPWB(array) DP_BTW =(array)
#define FPBTT     DP_BTT=0
#define FPRBF     DF_BTR=0	/* block read to data fifo */
#define FPRP100   DF_PR1=0	/* 100ns pipeline read to data fifo */
#define FPRP200   DF_PR2=0	/* 200ns pipeline read to data fifo */
#define FPRP400   DF_PR4=0	/* 400ns pipeline read to data fifo */

/*************** FSCC non-Fastbus Sequencer Primitives **********************/

#define FPNOP NULL__=0
#define FPWLC(data) LC_LD_=data
#define FPWFF(data) FF_WR_=(data)


/*************** FSCC Support Primitives ************************************/

#define PP1_PADR_DEF 0		/* port active low outputs */
#define PP1_PBDR_DEF 0		/* (= values to drive to false) */
#define PP1_PCDR_DEF FSCC_M_PRS|FSCC_M_WDTO|FSCC_M_DRS|FSCC_M_DRT|FSCC_M_SRS 
#define PP2_PADR_DEF 0
#define PP2_PBDR_DEF FSCC_M_SNRESET
#define PP2_PCDR_DEF FSCC_M_LTO

#define PP1_PADDR_DEF 0		/* port data direction register values */
#define PP1_PBDDR_DEF 0xf0
#define PP1_PCDDR_DEF 0x7d
#define PP2_PADDR_DEF 0xff
#define PP2_PBDDR_DEF 0xe0
#define PP2_PCDDR_DEF 0x09

#define PIT_PORT_DEF(p) p##DDR=0;  p##DR=p##DR_DEF;  p##DDR=p##DDR_DEF;
#define PIT_INIT(p) p##TCR=0;  p##TSR=1;     p##PGCR=0; \
                    p##PSRR=0; p##PACR=0x80; p##PBCR=0; \
                    PIT_PORT_DEF(p##PA); \
                    PIT_PORT_DEF(p##PB); \
                    PIT_PORT_DEF(p##PC); p##PGCR=0x24;
#define FSCC_SEQS_RESET {unsigned char tmp; \
			 *(&tmp)=PP2_PBDR; *(&tmp)=PP2_PBDR;}
#define FSCC_SRESET { \
  PP2_PBDR = FSCC_M_FCLERR; /* clear errors, reset port (active low) */ \
  PP2_PBDR = FSCC_M_SNRESET; /* release reset */ \
}

#define FSCC_FCLERR { \
  PP2_PBDR = (FSCC_M_FCLERR | FSCC_M_SNRESET); /* clear errors */ \
  PP2_PBDR = FSCC_M_SNRESET; /* don't reset */ \
}

#define FSCC_WAIT {int i=100000; \
		   while (PP2_PSR & PIT_PSR_H3) \
		     if (--i) break;  /* wait for status clock */ \
}

#define FSCC_STATUS (PP2_PBDR & 0x1F) /* could later skip the AND??? */
#define FSCC_CSEQS (PP2_PBAR & 0x0F) /* current sequencer status (live data)*/
#define FSCC_FRAK (PP1_PADR & FSCC_M_FRAK)
#define FSCC_FRDY (PP1_PADR & FSCC_M_FRDY)
#define FSCC_DFF (!(PP1_PCDR & FSCC_M_DFF))
#define FSCC_STO (!(PP2_PCDR & FSCC_M_STO)) /* active low */
#define FSCC_SS (PP2_PCDR & (FSCC_M_FLSS0|FSCC_M_FLSS1|FSCC_M_FLSS2))
#define FSCC_LCEN PP2_PADR = FSCC_M_LCEN
#define FSCC_LCDIS PP2_PADR = 0
#define FSCC_DATARS  PP1_PCDR &=(~FSCC_M_DRS); PP1_PCDR |=FSCC_M_DRS;
#define FSCC_COPYRS  PP1_PCDR &=(~FSCC_M_PRS); PP1_PCDR |=FSCC_M_PRS;
#define FSCC_COPYEN  PP1_PCDR |=FSCC_M_COPYEN
#define FSCC_COPYDIS PP1_PCDR &=(~FSCC_M_COPYEN)

#endif  /* ifndef INCfbfsccdef */
