/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	Fastbus Standard Routines Library, level 1
 *	
 * Author:  Chip Watson, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: fb_fscc_1.c,v $
 *   Revision 1.1.1.1  1996/08/21 19:20:37  heyes
 *   Imported sources
 *
*	  Revision 1.1  94/03/15  12:01:09  12:01:09  heyes (Graham Heyes)
*	  Initial revision
*	  
 *	  Revision 1.2  93/07/26  10:21:18  10:21:18  heyes (Graham Heyes)
 *	  Fix comment within comment warning
 *	  
 *	  Revision 1.1  93/05/03  15:15:13  15:15:13  chen (Jie chen)
 *	  Initial revision
 *	  
 *	  Revision 1.3  1992/09/09  17:11:37  watson
 *	  add secondary address read/write
 *
 *	  Revision 1.2  1992/07/16  14:53:20  watson
 *	  added block transfer wrappers
 *
 *	  Revision 1.1  1992/07/15  19:53:41  watson
 *	  Initial revision
 *
 *
 *	This file contains low level routines to be called by the Fastbus
 *	standard routines to perform Fastbus actions on the FSCC (PC3).
 *	Routines in this file provide callable wrappers to the macro
 *	versions of the routines in fscc_1.macro.
 *
 *  Compile Options:
 *  ----------------
 *	FB_BUILD_NOIPL    assume code is being complied to run only at an
 *			  elevated interrupt priority level (service routine);
 *			  external to this routine, the ISR invokes 
 *			  FB_ISR_ENTER and FB_ISR_EXIT (may be NULL)
 *	FB_BUILD_NEWSEQ   remove most inline error checking code (for use
 *			  with new CEBAF sequencer code)
 *
 *  Public Routines:
 *  ---------------
 *      fb_frd_1()               read data
 *      fb_fwd_1()               write data
 *      fb_frc_1()               read control
 *      fb_fwc_1()               write control
 *      fb_frdm_1()              read data multiple
 *      fb_fwdm_1()              write data multiple
 *      fb_frcm_1()              read control multiple
 *      fb_fwcm_1()              write control multiple
 *
 *      fb_frdb_1()              read data block
 *      fb_fwdb_1()              write data block
 *      fb_frcb_1()              read control block
 *      fb_fwcb_1()              write control block
 *      fb_frdbm_1()             read data multiple block
 *      fb_fwdbm_1()             write data multiple block
 *      fb_frcbm_1()             read control multiple block
 *      fb_fwcbm_1()             write control multiple block
 *
 *	fb_frdsa_1()		 address data, read SA 
 *	fb_fwdsa_1()		 address data, write SA 
 *	fb_frcsa_1()		 address control, read SA 
 *	fb_fwcsa_1()		 address control, write SA 
 */

#include "fb_fscc_macro.h"

/**************************** Single Word Routines ****************************
 *
 *    data is the value (write) or address to return data (read) OR the value
 *    FB_DATA_FIFO (read), in which case data is placed into that external
 *    buffer
 *
 *****************************************************************************/

void fb_frd_1(int pa, int sa, int *data, int eg, 
	      int noarb, int nopa, int nosa, int noda, int holdas, int hold)
{
  FB_RD_SINGLE(AD,pa,sa,data,eg,noarb,nopa,nosa,noda,holdas,hold);
}

void fb_fwd_1(int pa, int sa, int data, int eg,
	      int noarb, int nopa, int nosa, int noda, int holdas, int hold)
{
  FB_WR_SINGLE(AD,pa,sa,data,eg,noarb,nopa,nosa,noda,holdas,hold);
}

void fb_frc_1(int pa, int sa, int *data, int eg,
	      int noarb, int nopa, int nosa, int noda, int holdas, int hold)
{
  FB_RD_SINGLE(AC,pa,sa,data,eg,noarb,nopa,nosa,noda,holdas,hold);
}

void fb_fwc_1(int pa, int sa, int data, int eg,
	      int noarb, int nopa, int nosa, int noda, int holdas, int hold)
{
  FB_WR_SINGLE(AC,pa,sa,data,eg,noarb,nopa,nosa,noda,holdas,hold);
}

void fb_frdm_1(int pa, int sa, int *data,
	       int noarb, int nopa, int nosa, int noda, int holdas, int hold)
{
  FB_RD_SINGLE(ADM,pa,sa,data,0,noarb,nopa,nosa,noda,holdas,hold);
}

void fb_fwdm_1(int pa, int sa, int data,
	       int noarb, int nopa, int nosa, int noda, int holdas, int hold)
{
  FB_WR_SINGLE(ADM,pa,sa,data,0,noarb,nopa,nosa,noda,holdas,hold);
}

void fb_frcm_1(int pa, int sa, int *data,
	       int noarb, int nopa, int nosa, int noda, int holdas, int hold)
{
  FB_RD_SINGLE(ACM,pa,sa,data,0,noarb,nopa,nosa,noda,holdas,hold);
}

void fb_fwcm_1(int pa, int sa, int data,
	       int noarb, int nopa, int nosa, int noda, int holdas, int hold)
{
  FB_WR_SINGLE(ACM,pa,sa,data,0,noarb,nopa,nosa,noda,holdas,hold);
}

/**************************** Block Transfer Routines *************************
 *
 *    data is the value address of the array of data (read/write) or the value
 *    FB_DATA_FIFO (read), in which case data is placed into that external
 *    buffer
 *
 *****************************************************************************/

void fb_frdb_1(int pa, int sa, int *data, int maxb, int eg, 
	       int noarb, int nopa, int nosa, int noda, 
	       int pipe, int holdas, int hold, int nowait)
{
  FB_RD_BLOCK(AD,pa,sa,data,maxb,eg,noarb,nopa,nosa,noda,
	      pipe,holdas,hold,nowait);
}

void fb_fwdb_1(int pa, int sa, int *data, int maxb, int eg, 
	       int noarb, int nopa, int nosa, int noda, 
	       int pipe, int holdas, int hold, int nowait)
{
  FB_WR_BLOCK(AD,pa,sa,data,maxb,eg,noarb,nopa,nosa,noda,
	      pipe,holdas,hold,nowait);
}

void fb_frcb_1(int pa, int sa, int *data, int maxb, int eg, 
	       int noarb, int nopa, int nosa, int noda, 
	       int pipe, int holdas, int hold, int nowait)
{
  FB_RD_BLOCK(AC,pa,sa,data,maxb,eg,noarb,nopa,nosa,noda,
	      pipe,holdas,hold,nowait);
}

void fb_fwcb_1(int pa, int sa, int *data, int maxb, int eg, 
	       int noarb, int nopa, int nosa, int noda, 
	       int pipe, int holdas, int hold, int nowait)
{
  FB_WR_BLOCK(AC,pa,sa,data,maxb,eg,noarb,nopa,nosa,noda,
	      pipe,holdas,hold,nowait);
}

void fb_frdbm_1(int pa, int sa, int *data, int maxb, int eg, 
	       int noarb, int nopa, int nosa, int noda, 
	       int pipe, int holdas, int hold, int nowait)
{
  FB_RD_BLOCK(ADM,pa,sa,data,maxb,eg,noarb,nopa,nosa,noda,
	      pipe,holdas,hold,nowait);
}

void fb_fwdbm_1(int pa, int sa, int *data, int maxb, int eg, 
	       int noarb, int nopa, int nosa, int noda, 
	       int pipe, int holdas, int hold, int nowait)
{
  FB_WR_BLOCK(ADM,pa,sa,data,maxb,eg,noarb,nopa,nosa,noda,
	      pipe,holdas,hold,nowait);
}

void fb_frcbm_1(int pa, int sa, int *data, int maxb, int eg, 
	       int noarb, int nopa, int nosa, int noda, 
	       int pipe, int holdas, int hold, int nowait)
{
  FB_RD_BLOCK(ACM,pa,sa,data,maxb,eg,noarb,nopa,nosa,noda,
	      pipe,holdas,hold,nowait);
}

void fb_fwcbm_1(int pa, int sa, int *data, int maxb, int eg, 
	       int noarb, int nopa, int nosa, int noda, 
	       int pipe, int holdas, int hold, int nowait)
{
  FB_WR_BLOCK(ACM,pa,sa,data,maxb,eg,noarb,nopa,nosa,noda,
	      pipe,holdas,hold,nowait);
}

/********************** Block Transfer Support Routines **********************/

void fb_frlen_1(int *data)
{
  FB_FRLEN_1(data);
}

/*********************Secondary Address Routines ****************************
 *
 *  To write SA, just do a read call with no data transfer (address only)
 *  To read SA, use FB_RD_SA macro
 */

void fb_frdsa_1(int pa, int *sa, int eg,
		int noarb, int nopa, int nosa, int holdas, int hold)
{
  FB_RD_SA(AD,pa,sa,eg,noarb,nopa,nosa,holdas,hold);
}

void fb_fwdsa_1(int pa, int sa, int eg,
		int noarb, int nopa, int nosa, int holdas, int hold)
{
  FB_RD_SINGLE(AD,pa,sa,0,eg,noarb,nopa,nosa,1,holdas,hold);
}

void fb_frcsa_1(int pa, int *sa, int eg,
		int noarb, int nopa, int nosa, int holdas, int hold)
{
  FB_RD_SA(AC,pa,sa,eg,noarb,nopa,nosa,holdas,hold);
}

void fb_fwcsa_1(int pa, int sa, int eg,
		int noarb, int nopa, int nosa, int holdas, int hold)
{
  FB_RD_SINGLE(AC,pa,sa,0,eg,noarb,nopa,nosa,1,holdas,hold);
}

/************************ Miscellaneous Routines ****************************/

void fb_fbprst_1()
{
  FB_FBPRST_1
}

