/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	Context sensitive help for xcefdmp
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: xcef_context_help.c,v $
 *   Revision 1.2  1997/06/11 01:44:07  heyes
 *   spy on DD systemcd /usr/local/coda/linux/source/event/xcefdmp!
 *
 *   Revision 1.1.1.1  1996/09/19 18:26:24  chen
 *   original port to solaris
 *
 *	  
 */
#include <stdio.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>

#include "xcef.h"
#include "xcef_layout.h"

static void help_message();
static void reset_help_message();

void context_help()
{
  XtAddEventHandler(text_in0,EnterWindowMask, FALSE, help_message, (XtPointer)0);
  XtAddEventHandler(text_in0,LeaveWindowMask, FALSE, reset_help_message, (XtPointer)0);

  XtAddEventHandler(text_in1,EnterWindowMask, FALSE, help_message, (XtPointer)1);
  XtAddEventHandler(text_in1,LeaveWindowMask, FALSE, reset_help_message, (XtPointer)1);

  XtAddEventHandler(text_in2,EnterWindowMask, FALSE, help_message, (XtPointer)2);
  XtAddEventHandler(text_in2,LeaveWindowMask, FALSE, reset_help_message, (XtPointer)2);

  XtAddEventHandler(text_in3,EnterWindowMask, FALSE, help_message, (XtPointer)3);
  XtAddEventHandler(text_in3,LeaveWindowMask, FALSE, reset_help_message, (XtPointer)3);

  XtAddEventHandler(scale,EnterWindowMask, FALSE, help_message, (XtPointer)4);
  XtAddEventHandler(scale,LeaveWindowMask, FALSE, reset_help_message, (XtPointer)4);

  XtAddEventHandler(hex_op0,EnterWindowMask, FALSE, help_message, (XtPointer)5);
  XtAddEventHandler(hex_op0,LeaveWindowMask, FALSE, reset_help_message, (XtPointer)5);

  XtAddEventHandler(hex_op1,EnterWindowMask, FALSE, help_message, (XtPointer)6);
  XtAddEventHandler(hex_op1,LeaveWindowMask, FALSE, reset_help_message, (XtPointer)6);

  XtAddEventHandler(dict_op0,EnterWindowMask, FALSE, help_message, (XtPointer)7);
  XtAddEventHandler(dict_op0,LeaveWindowMask, FALSE, reset_help_message, (XtPointer)7);  

  XtAddEventHandler(dict_op1,EnterWindowMask, FALSE, help_message, (XtPointer)8);
  XtAddEventHandler(dict_op1,LeaveWindowMask, FALSE, reset_help_message, (XtPointer)8);  

  XtAddEventHandler(tog_source,EnterWindowMask, FALSE, help_message, (XtPointer)9);
  XtAddEventHandler(tog_source,LeaveWindowMask, FALSE, reset_help_message, (XtPointer)9);  

  XtAddEventHandler(tog_stream,EnterWindowMask, FALSE, help_message, (XtPointer)10);
  XtAddEventHandler(tog_stream,LeaveWindowMask, FALSE, reset_help_message, (XtPointer)10);  

  XtAddEventHandler(pushb0,EnterWindowMask, FALSE, help_message, (XtPointer)11);
  XtAddEventHandler(pushb0,LeaveWindowMask, FALSE, reset_help_message, (XtPointer)11);  

  XtAddEventHandler(pushb1,EnterWindowMask, FALSE, help_message, (XtPointer)12);
  XtAddEventHandler(pushb1,LeaveWindowMask, FALSE, reset_help_message, (XtPointer)12);  

  XtAddEventHandler(pushb2,EnterWindowMask, FALSE, help_message, (XtPointer)13);
  XtAddEventHandler(pushb2,LeaveWindowMask, FALSE, reset_help_message, (XtPointer)13);  

  XtAddEventHandler(pushb3,EnterWindowMask, FALSE, help_message, (XtPointer)14);
  XtAddEventHandler(pushb3,LeaveWindowMask, FALSE, reset_help_message, (XtPointer)14); 
}

static void help_message(w,client_data,event,bl)
     Widget w;
     XtPointer client_data;
     XEvent *event;
     Boolean bl;
{
  int widget_num = (int)client_data;
  char temp[256];
  XmString tt;
  Arg      args[2];

  switch(widget_num){
  case 0:
    if(view_mode == 0)
      sprintf(temp,"Enter data source file name");
    else
      sprintf(temp,"Enter object name");
    break;
  case 1:
    sprintf(temp,"Enter dictionary file name");
    break;
  case 2:
    if(view_mode == 0)
      sprintf(temp,"Enter tag name ");
    else
      sprintf(temp,"Enter event type ");
    break;
  case 3:
    sprintf(temp,"Enter event number ");
    break;
  case 4:
    sprintf(temp,"Event number slider");
    break;
  case 5:
    if(hex_or_decimal == 0)
      sprintf(temp,"Events shown in decimal number");
    else
      sprintf(temp,"Click to show event in decimal number");
    break;
  case 6:
    if(hex_or_decimal == 0)
      sprintf(temp,"Click to show event in hexdecimal number");
    else
      sprintf(temp,"Events shown in hexdecimal number");
    break;
  case 7:
    if(disable_dict == 0)
      sprintf(temp,"Dictionary enabled");
    else
      sprintf(temp,"Click to enable dictionary");
    break;
  case 8:
    if(disable_dict == 0)
      sprintf(temp,"Click to disable dictionary");
    else
      sprintf(temp,"Disctionary disabled");
    break;
  case 9:
    if(view_mode == 0)
      sprintf(temp,"View event file mode");
    else
      sprintf(temp,"Click to view a event file");
    break;
  case 10:
    if(view_mode == 0)
      sprintf(temp,"Click to spy on data stream");
    else
      sprintf(temp,"Spy data stream mode");
    break;
  case 11:
    if(view_mode == 0)
      sprintf(temp,"Click to view next event");
    else
      sprintf(temp," ");
    break;
  case 12:
    if(view_mode == 0)
      sprintf(temp,"Click to view previous event");
    else
      sprintf(temp," ");
    break;
  case 13:
    if(view_mode == 0)
      sprintf(temp," ");
    else
      sprintf(temp,"Object name, event type->spying event");
    break;
  case 14:
    sprintf(temp,"Quit xcefdmp");
    break;
  default:
    break;
  }
  tt = XmStringCreateSimple(temp);
  XtSetArg(args[0], XmNlabelString, tt);
  XtSetValues(help_label, args,1);
  XmStringFree(tt);
}

static void reset_help_message(w,client_data,event,bl)
     Widget w;
     XtPointer client_data;
     XEvent *event;
     Boolean bl;
{
  XmString tt;
  Arg      args[2];

  tt = XmStringCreateSimple(" ");
  XtSetArg(args[0], XmNlabelString, tt);
  XtSetValues(help_label, args, 1);
  XmStringFree(tt);
}
