/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	Copy bytes utilities
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: bufcpy.c,v $
 *   Revision 1.1.1.1  1996/09/19 18:26:23  chen
 *   original port to solaris
 *
 *
 */

#include <stdio.h>
#include <string.h>
#include "xcef.h"

/***********************************************************************
 *              void bufcpy2 (des, src)                                *
 * Description:                                                        *
 *     Copy 2 bytes from src to des                                    *
 **********************************************************************/
void bufcpy2(temp,ev)
char temp[2];
Event *ev;
{
  memcpy(temp, ev, 2);
}

/***********************************************************************
 *              void bufcpy8 (des, src)                                *
 * Description:                                                        *
 *     Copy 8 bytes from src to des                                    *
 **********************************************************************/
void bufcpy8(temp,ev)
char temp[8];
Event *ev;
{
  memcpy(temp, ev, 8);
}

     
/***********************************************************************
 *              void bufcpy4 (des, src)                                *
 * Description:                                                        *
 *     Copy 4 bytes from src to des                                    *
 **********************************************************************/
void bufcpy(t,s)
char t[4];
char *s;
{
  memcpy(t, s, 4);
}   
