/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *          dump event content called from main()
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: dump_content.c,v $
 *   Revision 1.1.1.1  1996/09/24 14:21:27  chen
 *   Initial import to coda_2.0
 *
 *	  Revision 1.2  1995/04/05  20:18:28  chen
 *	  fix a bug for a bad evet
 *
 *	  Revision 1.1  1994/12/08  14:44:07  chen
 *	  Initial revision
 *
 */
#include <stdio.h>
#include "cef.h"
#include "evfile_msg.h"

typedef struct _node
{ 
  evTreeNode *p;
  int         nc;
}XNODE;

extern evTreeNode  *EvTreeConstruct();
extern evTreeNode  *match_tag();
extern void        dump_tree();

/***************************************************************
 *      void visit_tree (root, i, node)                        *
 * Description:                                                *
 *    Convert tree pointer representaion in to an array rep    *
 **************************************************************/
static void visit_tree(root,i,node)
evTreeNode *root;
int *i;
XNODE node[];
{
  evTreeNode *p;
  int n;

  p=root;
  n= *i;
  if(p !=NULL){
    node[n].p = p;
    node[n].nc = n;
    *i = *i +1;
    visit_tree(p->mleft,i,node);
    visit_tree(p->rsibling,i,node);
  }
}

/***************************************************************
 *           void dump_content (filename, tag)                 *
 * Description:                                                *
 *    Dump a event file with tag name 'tag'                    *
 **************************************************************/
void dump_content(filename,tag)
char *filename;
char *tag;
{
  Event ev[20000];
  int   i,j,num_of_event,ev_size,t_length,num_of_node;
  int   fd,status,c,nn;
  char  temp[4],key_input[20];
  Bank  *ev_t;
  short t_type;
  XNODE node[500];
  evTreeNode *root,*p;

  if((status = open_dict()) != 0){
    if(!is_string_empty(DIRC))
      empty_string(DIRC);
  }

  if((status = evOpen(filename,"r",&fd)) != S_SUCCESS){
    if(status == 0x80730003)
      fprintf(stderr,"Wrong data format.\n");
    else
      fprintf(stderr,"Cannot open %s named data source.\n",filename);
    exit(1);
  }

  num_of_event = 10000;
  if(start == 0 && ending == 0){
    start =0;
    ending = num_of_event - 1;
  }
  else if(start !=0 && ending == -1){
    start=start-1;
    ending = num_of_event -1;
  }
  else if(ending >= num_of_event)
    ending = num_of_event - 1;
  else if(start <= 0)
    start = 0;
  else{
    start=start-1;
    ending=ending-1;
  }
  
  if(start > 0){
    i=0;
    while(i < start && (status = evRead(fd,ev,5000)) == S_SUCCESS)
      i++;
    if(i < start){
      fprintf(stderr,"Total number of events is %d\n",i);
      evClose(fd);
      exit(1);
    }
  }     

  for(i=start;i<ending+1;i++){
    status = evRead(fd,ev,5000);
    if(status != S_SUCCESS){
      if(i != start){
	fprintf(stderr,"End of the file at end of event %d\n",i);
	break;
      }
      else{
	fprintf(stderr,"Number of events is %d\n",i);
	break;
      }
    }
    bufcpy(temp,ev);
    ev_size = *(int *)(temp);
    t_type = 0xC;
    t_length = ev_size;
    root = EvTreeConstruct(ev,t_type,t_length);
    if (!root){
      if(quick_dump_mode == 0){
	printf("Event number %d is corrupted!!!. type q<ret> or Q<ret> to Quit\n",i+1);
	printf("Type <ret> or anything else<ret> to continue to next event\n");
	gets(key_input);
	if(key_input[0] == 'Q' || key_input[0] == 'q')
	  break;
      }
    }
    else{
      if(is_string_empty(TAG)){
	dump_tree(root,ev);
	free_ev_tree (root);
	if(quick_dump_mode == 0){
	  printf("Event number %d finished, type q<ret> or Q<ret> to Quit\n",i+1);
	  printf("Type <ret> or anything else<ret> to continue to next event\n");
	  gets(key_input);
	  if(key_input[0] == 'Q' || key_input[0] == 'q')
	    break;
	}
      }
      else{
	nn = 0;
	visit_tree(root,&nn,node);
	num_of_node = nn;
	for(j=0;j<num_of_node;j++){
	  if(strcmp(TAG,node[j].p->name) == 0)
	    break;
	}
	if(j < num_of_node ){ /* there is a match in tag name */
	  root = node[j].p;
	  root->rsibling = NULL;
	  root->parent = NULL;
	  dump_tree(root,ev);
	  free_ev_tree (root);
	  if(quick_dump_mode == 0){
	    printf("Event number %d finished, type q<ret> or Q<ret> to Quit\n",i+1);
	    printf("Type <ret> or anything else<ret> to continue to next event\n");
	    gets(key_input);
	    if(key_input[0] == 'Q' || key_input[0] == 'q')
	      break;
	  }
	}
      }
    }
  }
  evClose(fd);
}

