/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:Initialize some global variables
 *	
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: cef_init.c,v $
 *   Revision 1.1.1.1  1996/09/24 14:21:27  chen
 *   Initial import to coda_2.0
 *
 *	  Revision 1.1  1994/12/08  14:42:55  chen
 *	  Initial revision
 *
 *
 */
#include <stdio.h>
#include "cef.h"

char DIRC[200];           /* dictionary name    */
char SOURCE[200];         /* data source name   */
char TAG[100];            /* tag name           */
int  quick_dump_mode;     /* 1 no waiting, 0 interactive*/
int  hex_or_decimal;      /* tell hex or decimal dump*/
int  start;               /* which event we start at*/
int  ending;              /* which event we are going to end at*/
int  num_of_tree;         /* number of trees in the forest of dictionary */
int  view_mode;           /* o view file, 1 spy_event */
TREE_NODE  *root_d[20];   /* dictionary tree node */

/**************************************************************************
 *             void EvInit (void)                                         *
 * Description:                                                           *
 *     Initialize all global variables here                               *
 *************************************************************************/
void EvInit()
{
  int i;
  
  DIRC[0] ='\0';
  SOURCE[0] = '\0';
  TAG[0]  = '\0';
  start = 0;
  ending = 0;
  hex_or_decimal = 0;
  view_mode = 0;
  num_of_tree = 0;
  quick_dump_mode = 0;
  for(i=0;i<20;i++)
    root_d[i] = (TREE_NODE *)0;
}
