/* EPICS channel access calls for tcl */
/* Johannes van Zeijts, March 94 */

#include "tcl.h"
#include <ctype.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include "db_access.h"
#include "cadef.h"
#include "chandata.h"

extern int ca_monitor_add_event_array();
extern int ca_monitor_clear_event_array();

extern chandata *pchandata;
int EPICSINITED = 0;
char *epicsupdatecmd = "global Control; set Control(Epicsupdate) 200; proc update.epics { } {\n global Control\n epics update\n after $Control(Epicsupdate) update.epics\n}\n update.epics\n";

int
EpicsCmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Not used. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
  double value; int group,res;
  int listArgc; char **listArgv;
  chid chan; int status;
  static char ret_string[MAX_STRING_SIZE];
  int code;

  if (argc < 2) {
    interp->result = "wrong # args";
    return TCL_ERROR;
  }
  if (strcmp(argv[1], "update") == 0) {
    if (argc > 2) {
      interp->result = "wrong # args";
      return TCL_ERROR;
    }
    status = ca_pend_event(0.0001);
/*
   This is supposed to time out if no update available

    SEVCHK(status,"tclCaPendEvent ca_pend_event failed!");
    if (status != ECA_NORMAL) return TCL_ERROR;
*/
  }
  else if (strcmp(argv[1], "get") == 0) {
    if (argc > 3) {
      interp->result = "wrong # args";
      return TCL_ERROR;
    }
    ca_find_devp(interp,argv[2],pchandata);
    chan = pchandata->chid;
    if (ca_field_type(chan) == TYPENOTCONN) {
      Tcl_AppendResult(interp, "Signal ", argv[2]," not connected",(char *) NULL);
      return TCL_ERROR;
    } else {
      status = ca_get(DBR_STRING,chan,ret_string);
      if (ca_pend_io(3.0) == ECA_TIMEOUT) {
	Tcl_AppendResult(interp, "Signal ", argv[2]," Get timed out",(char *) NULL);
	return TCL_ERROR;
      } else {
	interp->result = ret_string;
	return TCL_OK;
      }
    }
  }
  else if (strcmp(argv[1], "getcallback") == 0) {
    if (argc > 3) {
      interp->result = "wrong # args";
      return TCL_ERROR;
    }
    if (!EPICSINITED) {
      if (ca_task_initialize() == ECA_ALLOCMEM) {
	Tcl_AppendResult(interp, "Unable to initialze Channel Access", (char *) NULL);
	return TCL_ERROR;
      }     
      EPICSINITED = 1;
      if ((code = Tcl_Eval(interp,epicsupdatecmd)) != TCL_OK) {
	return code;
      }
    }
    ca_get_string3(argv[2]);
    if (pchandata->state == 3 || pchandata->state == 0)
      {
	Tcl_AppendResult(interp, "CA error in getcallback ", argv[2],(char *) NULL);
	return TCL_ERROR;
      }
    return TCL_OK;
  }
  else if (strcmp(argv[1], "put") == 0) {
    if (argc > 4) {
      interp->result = "wrong # args";
      return TCL_ERROR;
    }
    if (Tcl_GetDouble(interp,argv[3],&value) != TCL_OK) {
      Tcl_AppendResult(interp, "Expected floating point number got:", argv[3],(char *) NULL);
      return TCL_ERROR;
    }
    status = ca_find_dev(argv[2],pchandata);
    chan = pchandata->chid;
    if (ca_field_type(chan) == TYPENOTCONN) {
      Tcl_AppendResult(interp, "Signal ", argv[2]," not connected",(char *) NULL);
      return TCL_ERROR;
    } else {
      
      if (ca_field_type(chan) == DBR_ENUM) {
	sprintf(ret_string, "%d", (int) (value+0.5) );
      } else {
	sprintf(ret_string,"%f",  value);}
      if (ca_field_type(chan) == DBR_STRING) {
	status = ca_put(DBR_STRING,chan,ret_string);
      }
      else {
	status = ca_put(DBR_DOUBLE,chan,&value);
      }
      if (status != ECA_NORMAL) {
	interp->result = ca_message(status);
	return TCL_ERROR;}
      status = ca_flush_io(3.0);
      if (status != ECA_NORMAL) {
	interp->result = ca_message(status);
	return TCL_ERROR;}
    }
  }
  else if (strcmp(argv[1], "init") == 0) {
    if (argc > 3) {
      interp->result = "wrong # args";
      return TCL_ERROR;
    }
    return TCL_OK;
  }
 else if (strcmp(argv[1], "addlist") == 0) {
    if (argc != 3) {
      interp->result = "wrong # args";
      return TCL_ERROR;
    }
    if (!EPICSINITED) {
      if (ca_task_initialize() == ECA_ALLOCMEM) {
	Tcl_AppendResult(interp, "Unable to initialize Channel Access", (char *) NULL);
	return TCL_ERROR;
      }     
      EPICSINITED = 1;
      if ((code = Tcl_Eval(interp,epicsupdatecmd)) != TCL_OK) {
	return code;
      }
    }
    if (Tcl_SplitList(interp,argv[2],&listArgc,&listArgv) != TCL_OK) return TCL_ERROR;   
    code = ca_monitor_add_event_array(interp,listArgc,listArgv); 
    free((char *) listArgv);
    return code;
 }
 else if (strcmp(argv[1], "clearlist") == 0) {
    if (argc != 3) {
      interp->result = "wrong # args";
      return TCL_ERROR;
    }
    if (!EPICSINITED) {
      if (ca_task_initialize() == ECA_ALLOCMEM) {
	Tcl_AppendResult(interp, "Unable to initialize Channel Access", (char *) NULL);
	return TCL_ERROR;
      }     
      EPICSINITED = 1;
      if ((code = Tcl_Eval(interp,epicsupdatecmd)) != TCL_OK) {
	return code;
      }
    }
    if (Tcl_SplitList(interp,argv[2],&listArgc,&listArgv) != TCL_OK) return TCL_ERROR;   
    code = ca_monitor_clear_event_array(interp,listArgc,listArgv); 
    free((char *) listArgv);
    return code;
 } else if (strcmp(argv[1], "exit") == 0) {
     status = ca_task_exit();
     SEVCHK(status,"tclTaskInit: ca_task_initialize failed!");
     if (status != ECA_NORMAL) return TCL_ERROR;
   }
 else {
   Tcl_AppendResult(interp, "bad argument", argv[2], "should be get or set", (char *) NULL);
   return TCL_ERROR;
 }
return TCL_OK;
}

int Epics_Init(interp)
    Tcl_Interp *interp;		/* Interpreter to initialize. */
{
    /* 17-MAR-93  -Johannes add EPICS access */
    Tcl_CreateCommand(interp, "epics", EpicsCmd, (ClientData *) NULL, (Tcl_CmdDeleteProc *)NULL);
    return TCL_OK;
}


