#include "tcl.h"
#include "dd_sys.h"
#include "dd_user.h"

#define TCL_PROC(name) int name (ClientData object, Tcl_Interp *interp, int argc, char **argv)

TCL_PROC(dds_create_cmd) 
{
  char result[10];
  int status = dds_create();
  if (status !=0) {
    sprintf(result,"%d",status);
    Tcl_AppendResult(interp, argv[0], ": failed and returned ",result, 0);
    return TCL_ERROR;
  }  
  return TCL_OK;
}

TCL_PROC(dds_close_cmd) 
{
  dds_close(0);

  return TCL_OK;
}
TCL_PROC(ddu_start_cmd) 
{
  ddu_start(0);

  return TCL_OK;
}
TCL_PROC(ddu_stop_cmd) 
{
  ddu_stop(0);

  return TCL_OK;
}

TCL_PROC(ddu_init_cmd)
{
  char result[10], fname[100];
  int ix,status, reqcnt,ctl[4];
  struct fifo_mode fmode;

  if (argc < 5) {
    Tcl_AppendResult(interp, "usage:", argv[0], " name mode prescale wait ?ctl? [?ctl? ... ?ctl?]", 0);
    return TCL_ERROR;
  }

  switch (argv[2][0]) {
  case 'a':
    fmode.mode = FMODE_ALL;
    break;
  case 'c':
    fmode.mode = FMODE_COND;
    break;
  case 'r':
    fmode.mode = FMODE_ONREQ;
    break;
  default:
    Tcl_AppendResult(interp, "unknown mode ",argv[2], 0);
    return TCL_ERROR;
  }
  if (Tcl_GetInt(interp, argv[3], &fmode.prescale) == TCL_ERROR)
    {
      return TCL_ERROR ;
    }
  switch (argv[4][0]) {
  case 'a':
    fmode.wait = FWAIT_ASYNC;
    break;
  case 's':
    fmode.wait = FWAIT_SLEEP;
    break;
  default:
    Tcl_AppendResult(interp, "unknown wait mode ",argv[4], 0);
    return TCL_ERROR;
  }

  fmode.suser = FMODE_MULTI_USER;
  fmode.p2ctl = ctl;

  for (ix=0;ix<4;ix++)
    ctl[ix] = -1;

  if (argc>5) {
    int ix;
    for (ix=5;ix<argc;ix++) {
      if (Tcl_GetInt(interp, argv[ix],&ctl[ix - 5] ) == TCL_ERROR)
	{
	  return TCL_ERROR ;
	}
    }
  }

  strcpy(fname,argv[1]);

  status = ddu_init(fname,fmode);

  if (status !=0) {
    sprintf(result,"%d",status);
    Tcl_AppendResult(interp, argv[0], ": failed and returned ",result, 0);
    return TCL_ERROR;
  }  

  return TCL_OK;
}

TCL_PROC(ddu_attached_cmd) {
  char tmp[100];
  sprintf(tmp,"%d",ddu_attached());
  Tcl_AppendResult(interp, tmp, 0);
  return TCL_OK;
}

TCL_PROC(ddu_req_fev_cmd)
{
  struct fifo_entry *fev;
  char tmp[10],result[10];
  int len,status;

  if (argc < 2) {
    Tcl_AppendResult(interp, "usage:", argv[0], " buffer_length", 0);
    return TCL_ERROR;
  }

  if (Tcl_GetInt(interp, argv[1], &len ) == TCL_ERROR)
    {
      return TCL_ERROR ;
    }

  fev = (struct fifo_entry *) ckalloc(sizeof(struct fifo_entry));

  status = ddu_req_fev(len, fev);

  if (status !=0) {
    sprintf(result,"%d",status);
    Tcl_AppendResult(interp, argv[0], ": failed and returned ",result, 0);
    ckfree((char *) fev);
    return TCL_ERROR;
  }  

  sprintf(tmp,"%d",fev);

  Tcl_AppendResult(interp, tmp, 0);
  
  return TCL_OK;
}
TCL_PROC(ddu_get_fev_cmd)
{
  struct fifo_entry *fev;
  char tmp[10],result[10];
  int len,status;

  fev = (struct fifo_entry *) ckalloc(sizeof(struct fifo_entry));

  status = ddu_get_fev(fev);

  if (status !=0) {
    sprintf(result,"%d",status);
    Tcl_AppendResult(interp, argv[0], ": failed and returned ",result, 0);
    ckfree((char *) fev);
    return TCL_ERROR;
  }  

  sprintf(tmp,"%d",fev);

  Tcl_AppendResult(interp, tmp, 0);
  
  return TCL_OK;
}

TCL_PROC(ddu_put_fev_cmd)
{
  struct fifo_entry *fev;
  char tmp[10],result[20];
  int status;

  if (argc < 2) {
    Tcl_AppendResult(interp, "usage:", argv[0], " buffer_address", 0);
    return TCL_ERROR;
  }

  if (Tcl_GetInt(interp, argv[1], (int *) &fev ) == TCL_ERROR)
    {
      return TCL_ERROR ;
    }

  status = ddu_put_fev(*fev);

  ckfree(fev);

  if (status !=0) {
    sprintf(result,"%d",status);
    Tcl_AppendResult(interp, argv[0], ": failed and returned ",result, 0);
    return TCL_ERROR;
  }  
  
  return TCL_OK;
}

void DD_Init(Tcl_Interp *interp)
{
  Tcl_CreateCommand(interp, "dds_create", dds_create_cmd, 0, 0);
  Tcl_CreateCommand(interp, "ddu_init", ddu_init_cmd, 0, 0);
  Tcl_CreateCommand(interp, "ddu_attached", ddu_attached_cmd, 0, 0);
  Tcl_CreateCommand(interp, "ddu_req_fev",ddu_req_fev_cmd , 0, 0);
  Tcl_CreateCommand(interp, "ddu_put_fev",ddu_put_fev_cmd , 0, 0);
  Tcl_CreateCommand(interp, "dds_close", dds_close_cmd, 0, 0);
  Tcl_CreateCommand(interp, "ddu_start", ddu_start_cmd, 0, 0);
  Tcl_CreateCommand(interp, "ddu_stop", ddu_stop_cmd, 0, 0);
  Tcl_CreateCommand(interp, "ddu_get_fev", ddu_get_fev_cmd, 0, 0);
}
