/*
 * static char blasterCSid[]="@(#)blaster.c	32.1 9/10/92 SH00028 AppEng/SCCS Interphase";
 */
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <sys/errno.h>
#include <sys/file.h>

#ifndef LINUX
# include <sys/lock.h>
#endif

#include <pwd.h>
#include <errno.h>
#include <search.h>
#include <signal.h>
#include <stdarg.h>

#include "dplite.h"

#define INIT_DB 2
#define QUERY   3
#define QUIT    1

#define close(s) close(s);

static	int	readTimeout;
static long     codaDebugLevel = 0;

static void codaInitDebug()
{
  char	*env;
  char  *tmp;
  char  *debugString = NULL;
  char  *tok;
  char  *coda_debug = "CODA_DEBUG";
  int    num_levels = 0;

  env = getenv(coda_debug);
  if (env ) {
    debugString = (char *)strdup(env);
  }

  if (debugString == NULL) {
    return;
  }
  
  tok = (char *)strtok(debugString,":");

  if (tok != NULL) {
    printf("\n-------------------------------------------------------\n");
    printf("The environment variable %s is set... \n"
           "Debug output started for the following modules:\n\n", 
                 coda_debug);
  } else {
    printf("[codaInitDebug] The environment variable (%s) was set to an empty string.\n",
           coda_debug);
  }
  
  while (tok) {
    num_levels++;
    if (strcmp(tok,"ask") == 0) {
      codaDebugLevel |= 1;
      printf("Debug level : DP_ask\n");
    }
    if (strcmp(tok,"objects") == 0) {
      codaDebugLevel |= 2;
      printf("Debug level : objects\n");
    }
    if (strcmp(tok,"trans") == 0) {
      codaDebugLevel |= 4;
      printf("Debug level : transitioner\n");
    }
    if (strcmp(tok,"msg") == 0)	{
      codaDebugLevel |= 8;
      printf("Debug level : messages\n");
    }
    if (strcmp(tok,"dbase") == 0) {
      codaDebugLevel |= 16;
      printf("Debug level : dbase\n");
    }
    if (strcmp(tok,"xxx") == 0)	{
      codaDebugLevel |= 8;
      printf("Debug level : xxx\n");
    }

    tok = (char *)strtok(NULL,":");
  }
  if (num_levels > 0) {
    printf("\n-------------------------------------------------------\n\n");
  }

}

void
debug_printf(int level, char *fmt, ...) {
  va_list ap;
  int severity;

#ifdef VXWORKS
  va_start(ap);
#else
  va_start(ap,fmt);
#endif 
 
  if (level & codaDebugLevel) {

    switch (level) {
    case 1:
      fprintf(stderr, "[CODA dplite ] ");
      break;
    case 2:
      fprintf(stderr, "[CODA objects] ");
      break;
    case 3:
      fprintf(stderr, "[CODA trans  ] ");
      break;
    case 4:
      fprintf(stderr, "[CODA message] ");
      break;
    case 8:
      fprintf(stderr, "[CODA databas] ");
      break;
    default:
      fprintf(stderr, "[CODA %d debug] ",level);
      break;
    }
    vfprintf (stderr,fmt, ap);
  }
}

static void alarmHandler(sig)
	int	sig;
{
	signal(sig, alarmHandler);
	readTimeout = 1;
}

static void intToBuf(cp,val)
        u_char  *cp;
        int     val;
{
        *cp++ = (unsigned int)(val & 0x000000ff);
        *cp++ = (unsigned int)(val & 0x0000ff00) >> 8;
        *cp++ = (unsigned int)(val & 0x00ff0000) >> 16;
        *cp++ = (unsigned int)(val & 0xff000000) >> 24;
}


static int bufToInt(cp)
        u_char  *cp;
{
        int val=0;
 
        val = *cp++;
        val += ((int) *cp++) << 8 ;
        val += ((int) *cp++) << 16;
        val += ((int) *cp++) << 24;
        return(val);
}

static int hpHash;

typedef struct hashEnt *hashEntPtr;

typedef struct hashEnt {
  char name[80];
  char host[80];
  int port;
  int socket;
  hashEntPtr next;
} HASHENT;

static hashEntPtr tableHead = NULL;

static unsigned long broad_addr,broad_port,broad_sock;
static struct sockaddr_in sockaddr;

static int
inet_connect(host, port, server, udp, reuseAddr, lingerTime)
    char *host;			/* Host to connect, name or IP address */
    int port;			/* Port number to use */
    int server;			/* 1->make server, 0->connect to server */
    int udp;			/* Make it a udp protocol socket */
    int reuseAddr;		/* Allow local reuse of addresses */
    int lingerTime;		/* Time to linger on close */
{
    struct hostent *hostent, _hostent;
    int sock, status;
#ifdef __DGUX__
    struct sockaddr_in hostaddr, hostaddrPtr[2];
#else
    int hostaddr, hostaddrPtr[2];
#endif

#define MAXHOSTNAMELEN 200
    char localhost[MAXHOSTNAMELEN];
    int result;
    int linger[2];

    hostent = NULL;

    /*
     * Translate the hostname
     */
    if (host == NULL) {
      errno = EINVAL;
      return -1;
     /* gethostname(localhost,MAXHOSTNAMELEN);
      host = localhost;*/
    }
    if (!(udp|server)) {

      if (strcmp(host,"") == 0) {
	gethostname(localhost,MAXHOSTNAMELEN);
	host = localhost;
      }
      hostent = gethostbyname(host);
    }
#ifdef __DGUX__
    if (hostent == NULL) {
	if (strlen(host) == 0) {
            memset(&hostaddr,0,sizeof(hostaddr));
	} else {
	    hostaddr.sin_addr = inet_addr(host);
	}
	if ((int)hostaddr.sin_addr.s_addr == -1) {
	    if (server && !strlen(host)) {
		hostaddr.sin_addr.s_addr = INADDR_ANY;
	    } else {
		errno = EINVAL;
		return -1;
	    }
	}
#else
    if (hostent == NULL) {
	if (strlen(host) == 0) {
	    hostaddr = 0;
	} else {
	    hostaddr = inet_addr(host);
	}
	if (hostaddr == -1) {
	    if (server && !strlen(host)) {
		hostaddr = INADDR_ANY;
	    } else {
		errno = EINVAL;
		return -1;
	    }
	}
#endif

	_hostent.h_addr_list = (char **) hostaddrPtr;
#ifdef CRAY_HACKS
	hostaddr <<= 32;
#endif

#ifdef __DGUX__
	_hostent.h_addr_list[0] = (char *) &hostaddr.sin_addr;
	_hostent.h_length = sizeof(hostaddr.sin_addr);
#else
	_hostent.h_addr_list[0] = (char *) &hostaddr;
	_hostent.h_length = sizeof(hostaddr);
#endif
	_hostent.h_addr_list[1] = NULL;
	_hostent.h_addrtype = AF_INET;
	hostent = &_hostent;
    }

    /*
     * Create the socket
     */
    if (udp) {
	sock = socket(PF_INET, SOCK_DGRAM, 0);
    } else {
	sock = socket(PF_INET, SOCK_STREAM, 0);
    }

    if (sock < 0) {
	return -1;
    }

    /*
     * Set the linger and reuseAddr socket options
     */
#ifdef SO_LINGER
    linger[0] = lingerTime > 0;
    linger[1] = lingerTime;
    result = setsockopt(sock, SOL_SOCKET, SO_LINGER,
			(char *)linger, sizeof(linger));
#endif
    {
	int one = 1;
	result = setsockopt(sock, SOL_SOCKET, SO_REUSEADDR,
			    (char *)&one, sizeof(int));
    }
    {
      int val = 1;
      setsockopt(sock,IPPROTO_TCP,TCP_NODELAY,(char *)&val,sizeof(int));
    }
    {
      int val = 1;
      setsockopt(sock,SOL_SOCKET,SO_BROADCAST,(char *)&val,sizeof(int));
    }
    {
      int val = 1;
      setsockopt(sock,SOL_SOCKET,SO_DONTROUTE,(char *)&val,4);
    }

    /*
     * Bind the socket
     */
    memset((char *)&sockaddr, 0,sizeof(sockaddr));
    sockaddr.sin_family = AF_INET;
#ifdef CRAY_HACKS
    {
    unsigned long foo;

    memcpy((char *)&foo,
	   (char *)hostent->h_addr_list[0],
	   (size_t)hostent->h_length);

    sockaddr.sin_addr.s_addr = foo>>32;
    }
#else
    memcpy((char *)&(sockaddr.sin_addr.s_addr),
	   (char *)hostent->h_addr_list[0],
	   (size_t)hostent->h_length);
#endif

    sockaddr.sin_port = htons(port);

    if (server | udp) {
	status = bind(sock, (struct sockaddr *)&sockaddr, sizeof(sockaddr));
    } else {
	status = connect(sock, (struct sockaddr *)&sockaddr, sizeof(sockaddr));
    }

    if (status < 0) {
	close(sock);
	return -1;
    }

    /*
     * Finally, listen on the socket if it's a server.
     */
    if (server && !udp) {
	listen(sock, 5);
    }
    return sock;
}

int DP_cmd_init(char *host)
{
 static char tmp[100];
 char *tmp2,*tmp3;
 sprintf(tmp,"MSQL_TCP_HOST=%s",host);
 putenv(tmp);
 codaInitDebug();

 tmp2 = getenv ("ROC_BROADCAST_ADDR");
 if (tmp2) {
   broad_addr = inet_addr(tmp2);
   tmp3 = getenv ("ROC_BROADCAST_PORT");
   if (tmp3) {
     broad_port = atoi( tmp3);
     
     broad_sock = inet_connect(tmp2,broad_port,0,1,1,0);
     {
       unsigned long optval = 2;

       if (getenv("ROC_BROADCAST_TTL")) 
	 optval = atoi(getenv("ROC_BROADCAST_TTL"));

       setsockopt(broad_sock, 
		  IPPROTO_IP, 
		  IP_TTL, 
		  (char *)&optval, 
		  sizeof(optval));
     }
     if (broad_sock < 0) {
       perror("can't open UDP socket :");
       broad_sock = 0;
     }
   }
   else 
     {
       broad_addr = broad_port = 0;
     }
   
 }
 return 0;
}

int DP_cmd_retry(char *name,char *command,char *result,int timeout, int num_retries) 
{
  char *host;
  int port, status;
  hashEntPtr ent;
  int retries = 0;
  static int init = 1;
  
  if (init) {
    signal(SIGALRM,alarmHandler);
    init = 0;
  }

  alarm(40);

  readTimeout = 0;
  
  for (ent = tableHead;ent != NULL;ent = ent->next)
    if (strcmp(ent->name,name) == 0) break;

  if (!ent) {
    
    ent = (hashEntPtr) malloc(sizeof(HASHENT));
    
    strcpy(ent->name,name);

    get_hostport(NULL,name,ent->host,&ent->port,result);

    ent->socket = 0;
    ent->next = tableHead;
    tableHead = ent;

  }
  alarm(0);

retry:
  alarm(timeout);
  readTimeout = 0;

  status = do_command(ent->host,ent->port,command,result,&ent->socket,0);

  alarm(0);
  
  if ((status == -2) || (status == -4)) {
    int status2;

    if ((status == -2) && retries) {
      alarm(0);
      return status;
    }

    alarm(4);
    readTimeout = 0;

    debug_printf(DP_ASK_DBG,"DP_cmd: do_command failed status=%d\n",status);
    status2 = get_hostport(NULL,name,ent->host,&ent->port,result);
    ent->socket = 0;
    alarm(0);
    if (status2 < 0) {
      debug_printf(DP_ASK_DBG,"DP_cmd: get_hostport failed status2=%d\n",status2);
      return status2;
    }
    /*sleep(1);*/
    if (retries++ < num_retries) 
      goto retry;
  }

  return status;
}

int DP_cmd(char *name,char *command,char *result,int timeout) 
{
  debug_printf(DP_ASK_DBG,"here %s %s timeout %d\n",name,command,timeout);
  return (DP_cmd_retry(name, command, result, timeout, 5 /* default number of retries*/));
}

int DP_cmd_broadcast(char *command)
{
  int status;
  if (broad_sock) {

    debug_printf(DP_ASK_DBG,"broadcast length %d :%s\n",strlen(command)+1,command);

    status = sendto(broad_sock, command, strlen(command)+1, 0, 
		    (const struct sockaddr *)&sockaddr, sizeof(sockaddr));
  }

}

int DP_cmd_async(char *name,char *command) 
{
  char *host;
  int port, status = 0;
  hashEntPtr ent;
  int retries = 0;
  static int init = 1;
  static char result[1000];
  if (init) {
    signal(SIGALRM, alarmHandler);
    init = 0;
  }

  alarm(4);
  readTimeout = 0;


  for (ent = tableHead;ent != NULL;ent = ent->next)
    if (strcmp(ent->name,name) == 0) break;

  if (!ent) {
    
    ent = (hashEntPtr) malloc(sizeof(HASHENT));
    
    strcpy(ent->name,name);

    get_hostport(NULL,name,ent->host,&ent->port,result);
    ent->socket = 0;
    ent->next = tableHead;
    tableHead = ent;

  }
  alarm(0);

retry:
  
  alarm(4);
  readTimeout = 0;

  status = do_command(ent->host,ent->port,command,result, &ent->socket,1);
  alarm(0);
  
  if ((status == -2) ||(status == -4)) {
    int status2;
    
    if ((status == -2) && retries) {
      alarm(0);
      return status;
    }

    alarm(4);
    readTimeout = 0;

    debug_printf(DP_ASK_DBG,"DP_cmd_async: do_command failed status=%d\n",status);
    status2 = get_hostport(NULL,name,ent->host,&ent->port,result);
    ent->socket = 0;
    alarm(0);
    if (status2 < 0) {
      debug_printf(DP_ASK_DBG,"DP_cmd_async: get_hostport failed status2=%d\n",status2);
      return status2;
    }
    if (retries++ < 5) 
      goto retry;
  }

  if (status) {
    debug_printf(DP_ASK_DBG,"DP_cmd_async Error: %s\n", result);
  }

  return status;
}

int do_command(char *host,int port,char *command,char *result,int *so, int async) 
{
  struct sockaddr_in  sin;
  int 		      s, ix = 0;
  char 		      buffer[10000],*p;
  int                 on = 1;
  int                 y,l;
  char                rep;
  int 		      size;
  struct hostent      *hp, *gethostbyname ();

  bzero (&sin, sizeof (sin));

  if (!*so) {
    s = socket (AF_INET, SOCK_STREAM, 0);
    {
      int cval = 1;
      int linger[2];

      linger[0] = 0;
      linger[1] = 0;

      setsockopt(s, SOL_SOCKET, SO_LINGER,
		 (char *)linger, sizeof(linger));
      
      setsockopt(s, IPPROTO_TCP, TCP_NODELAY, (char *)&cval,4);
    }
    
    if (s < 0)
      printf ("cannot open socket\n");

    hp = gethostbyname (host);
    if (hp == 0 && (sin.sin_addr.s_addr = inet_addr (host)) == -1)
      {
	sprintf (result, "%s: unknown host (do_command)", host);
	close(s);*so = 0 ;
	return -1;
      }
    
    if (hp != 0)
      bcopy (hp->h_addr, &sin.sin_addr, hp->h_length);
    
    sin.sin_port 	= htons (port);
    sin.sin_family = AF_INET;
    
    if (connect (s, (struct sockaddr *) &sin, sizeof (sin)) < 0)
      {
	sprintf (result,"connect failed: host %s port %d", inet_ntoa (sin.sin_addr),
		 ntohs (sin.sin_port));
	close(s);*so = 0 ;
	return -2;
      }
    p = buffer;
    
    for (ix=0;ix<199;ix++,p++) {
      
      l = read(s,p,1);
      
      if (l <=0) {
	alarm(0);
	close(s);*so = 0 ;
	sprintf(result,"read returned <= 0 on connect\n");
	return -2;
      }
      
      if ((*p == '\n') || (l <= 0)) break;
      
    }
    if (readTimeout)
      {
	alarm(0);
	close(s);*so = 0 ;
	return(-3);
      }
    
    *so = s;
  } else {
    s = *so;
  }
  bzero(buffer,100);
  
  *((long *) buffer) = htonl(2+strlen(command));

  if (async) {
    buffer[4] = 'd';
  } else {
    buffer[4] = 'e';
  }

  buffer[5] = 0x31;
  sprintf(&buffer[6],command);
  if ((y = send(s, buffer, 6+strlen(command), MSG_DONTROUTE)) < 0)
    {
      sprintf (result,"write error");
      alarm(0);
      close(*so);*so = 0 ;
      return -4;
    }
  if (!async) {
    y = recv(s,(char *) &size,4,0);
    
    if (y <=0) {
      alarm(0);
      close(*so);*so = 0 ;
      return -5;
    }
    if (readTimeout)
      {
	alarm(0);
	close(*so);*so = 0 ;
	return(-5);
      }
    
    size = ntohl(size);
    
    p = buffer;
    
    while (size) {
      y = recv(s,p,100,0);
      p += y;
      size -= y;
    }
    
    if (y <=0) {
      alarm(0);
      close(*so);*so = 0 ;
      return -5;
    }
    
    if (readTimeout) {
      alarm(0);
      close(*so);*so = 0 ;
      return(-5);
    }
    
    *p = 0;
    
    p = buffer + 2;
    
    strcpy(result,p);

    if (buffer[0] == 'r') 
      return 0;

    if (buffer[0] == 'x') {
      close(*so);*so = 0 ;
      return -9;
    }
    close(s);
    *so = 0;
  }
  return 0;
}

int get_hostport(char *msqlHost,char *theName,char *theHost,int *thePort,char *result)
{
  struct sockaddr_in	sin;
  int 		  s, ix = 0;
  char 		  buffer[1000],*p;
  int             on = 1;
  int             y,l;
  char            rep;
  int		  blen,blocks;
  int 		  size;
  struct hostent *hp, *gethostbyname ();
  struct  servent         *serv_ptr;
  char           *host, *envVar;
  int             port;
  unsigned long   tl;
  int		  skip;
  
  bzero (&sin, sizeof (sin));
  
  s = socket (AF_INET, SOCK_STREAM, 0);

  {
    int cval = 1;
    int linger[2];
    
    linger[0] = 0;
    linger[1] = 0;
    setsockopt(s, SOL_SOCKET, SO_LINGER,
	       (char *)linger, sizeof(linger));

    setsockopt(s, IPPROTO_TCP, TCP_NODELAY, (char *)&cval,4);
  }
  
  if (s < 0)
    printf ("cannot open socket\n");
  
  host = msqlHost;

  if ((envVar = (char *) getenv("MSQL_TCP_HOST")))
    {
      host = envVar;
    }

  if (host == NULL) {
    sprintf(result,"msqld host required\n");
    close(s);
    return -10;
  }

  hp = gethostbyname (host);

  port = ntohs(8101);
#ifndef VXWORKS
  if ((serv_ptr = getservbyname("msql", "tcp")))
    {
      port = ntohs(serv_ptr->s_port);
    }
#endif
  if ((envVar =(char *) getenv("MSQL_TCP_PORT")))
    {
      port = ntohs(atoi(envVar)); 
    }
  
  if (hp == 0 && (sin.sin_addr.s_addr = inet_addr (host)) == -1)
    {
      sprintf (result, "%s: unknown msql host", host);
      close(s);
      return -11;
    }

  if (hp != 0)
        bcopy (hp->h_addr, &sin.sin_addr, hp->h_length);

    sin.sin_port 	= port;
    sin.sin_family 	= AF_INET;
    
    if (connect (s, (struct sockaddr *) &sin, sizeof (sin)) < 0)
      {
    	sprintf (result,"connect failed: host %s port %d\n", inet_ntoa (sin.sin_addr),
		ntohs (sin.sin_port));
	close(s);

	return -12;
      }

    bzero(buffer,100);

    p = buffer;

    read(s,&tl,4);
    blen = bufToInt(&tl);
    for (ix=0;ix<blen;ix++,p++) {
      
      l = read(s,p,1);

      if ((l <= 0) || readTimeout) {
	alarm(0);
	close(s);
	return -13;
      }
      if (l <= 0) break;
    }

    y = atoi(buffer);
    if (y == -1) {
      sprintf(result,"msql error: %s",&buffer[(int)index(buffer,':')+1]);
      close(s);
      return -14;
    }
    {
      struct passwd *pw;
      
      pw = (struct passwd *) getpwuid(getuid());

      if (!pw)
	{
	  sprintf(result,"error: unknown user");
	  close(s);
	  return(-15);
	}

      sprintf(&buffer[4],"%s\n",pw->pw_name);
      intToBuf(buffer,strlen(&buffer[4]));
      
      if ((y = send(s, buffer, 4+strlen(&buffer[4]), MSG_DONTROUTE)) < 0)
	{
	  sprintf (result,"write error");
	}
      
      bzero(buffer,100);
    
      p = buffer;
      
      read(s,&tl,4);
      blen = bufToInt(&tl);
      for (ix=0;ix<blen;ix++,p++) {
	
	l = read(s,p,1);

	if ((l <= 0) || readTimeout) {
	  alarm(0);
	  close(s);
	  return -16;
	}
	
	if (l <= 0) break;
		
      }

      y = atoi(buffer);
      if (y == -1) {
	sprintf(result,"msql error: %s",&buffer[(int)index(buffer,':')+1]);
	close(s);
	return -17;
      }
    }

    sprintf(&buffer[4],"%d:%s\n",INIT_DB,getenv("EXPID"));
    intToBuf(buffer,strlen(&buffer[4]));

    if ((y = send(s, buffer, 4+strlen(&buffer[4]), MSG_DONTROUTE)) < 0)
      {
	sprintf (result,"msql write error: ");
      }
    
    bzero(buffer,100);

    p = buffer;
    read(s,&tl,4);
    blen = bufToInt(&tl);

    for (ix=0;ix<blen;ix++,p++) {
      
      l = read(s,p,1);
      if ((l <= 0) || readTimeout) {
	alarm(0);
	close(s);
	return -18;
      }

      if (l <= 0) break;
    }

    sprintf(&buffer[4],"%d:select port from process where name='%s'\n",QUERY,theName);

    intToBuf(buffer,strlen(&buffer[4]));

    if ((y = send(s, buffer, 4+strlen(&buffer[4]), MSG_DONTROUTE)) < 0)
      {
	sprintf (result,"msql write error: ");
	close(s);
	return -19;
      }
    read(s,&tl,4);
    blen = bufToInt(&tl);

    p = buffer;
    for (ix=0;ix<blen;ix++,p++) {
      
      l = read(s,p,1);
      if ((l <= 0) || readTimeout) {
	alarm(0);
	close(s);
	return -20;
      }

      if (l <= 0) break;
    }

    y = atoi(buffer);
    if (y == -1) {
      sprintf(result,"msql error: %s",&buffer[(int)index(buffer,':')+1]);
      close(s);
      return -21;
    }

    bzero(buffer,100);

    p = buffer;
    read(s,&tl,4);
    blen = bufToInt(&tl);

    for (ix=0;ix<blen;ix++,p++) {
      
      l = read(s,p,1);
      if ((l <= 0) || readTimeout) {
	alarm(0);
	close(s);
	return -22;
      }

      if (l <= 0) break;
    }
    y = atoi(buffer);
    if (y == -100) {
      sprintf(result,"no entry in db\n");
      close(s);
      return -23;
    }
    *p = 0;
    ix=0;
    sscanf(&buffer[2],"%d",&ix);
    *thePort = ix;
    bzero(buffer,100);

    p = buffer;
    read(s,&tl,4);
    blen = bufToInt(&tl);

    for (ix=0;ix<blen;ix++,p++) {
      
      l = read(s,p,1);
      if ((l <= 0) || readTimeout) {
	alarm(0);
	close(s);
	return -24;
      }
      
      if (l <= 0) break;
    }

    bzero(buffer,100);
    p = buffer;
    read(s,&tl,4);
    blen = bufToInt(&tl);

    for (ix=0;ix<blen;ix++,p++) {
      
      l = read(s,p,1);
      if ((l <= 0) || readTimeout) {
	alarm(0);
	close(s);
	return -35;
      }

      if (l <= 0) break;
    }

    bzero(buffer,100);

    sprintf(&buffer[4],"%d:select host from process where name='%s'\n",QUERY,theName);

    intToBuf(buffer,strlen(&buffer[4]));

    if ((y = send(s, buffer, 4+strlen(&buffer[4]), MSG_DONTROUTE)) < 0)
      {
	perror ("blaster write error: ");
      }
    
    p = buffer;

    bzero(buffer,sizeof(buffer));

    read(s,&tl,4);
    blen = bufToInt(&tl);
    for (ix=0;ix<blen;ix++,p++) {
      
      l = read(s,p,1);
      if ((l <= 0) || readTimeout) {
	alarm(0);
	close(s);
	return -26;
      }

      if (l <= 0) break;
    }

   bzero(buffer,100);

    p = buffer;

    bzero(buffer,sizeof(buffer));

    read(s,&tl,4);
    blen = bufToInt(&tl);
    for (ix=0;ix<blen;ix++,p++) {
      
      l = read(s,p,1);
      if ((l <= 0) || readTimeout) {
	alarm(0);
	close(s);
	return -26;
      }

      if (l <= 0) break;
    }

    bzero(buffer,100);
    p = buffer;

    read(s,&tl,4);
    blen = bufToInt(&tl);
    for (ix=0;ix<blen;ix++,p++) {
      
      l = read(s,p,1);
      if ((l <= 0) || readTimeout) {
	alarm(0);
	close(s);
	return -27;
      }

      if (l <= 0) break;
    }

    *p = 0;
    y = atoi(buffer);
    if (y == -100) {
      sprintf(result,"no entry in db\n");
      close(s);
      return -28;
    }
    else if (y < 10 && y > 0) {
      /* skip 1 digit and colon */
      skip = 2;
    }
    else if (y < 100 && y > -10) {
      /* skip 2 digits and colon */
      skip = 3;
    }
    else
      skip = 4;
     
    strcpy(theHost,&buffer[skip]);
    for (l=0;l<strlen(theHost);l++)
      {
	if (theHost[l] == '\n')
	  theHost[l] = 0;
      }
    
    sprintf(&buffer[4],"%d:\n",QUIT);
    intToBuf(buffer,strlen(&buffer[4]));
    if ((y = send(s, buffer, 4+strlen(&buffer[4]), MSG_DONTROUTE)) < 0)
      {
	perror ("blaster write error: ");
      }
    
    close (s);
    
    return 0;

}


