/*
 * ddr_ui_callbacks.c 
 *          :  Callbacks for the ddr (dd rate) display   
 * Author   :  C.Witzig
 * Date     :  Apr 24, 1992 (no joke!)
 * Mods     :
 */


#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include <time.h>
#include <sys/signal.h>
#include <stdio.h>
#include <e787util.h>
#include <errno.h>
#include <stdlib.h>
#include <sys/time.h>
#include <fifo.h>
#include <dd_dcom.h>
#include <dd_sys.h>

#include <tcl.h>
#include <tk.h>

/* scrollbar length as defined in XDesigner... 
 * (clearly there are better ways to get this number!)
 */
#define SCROLLBARLENGTH  100
#define DD_SCALE 102

/*
 * Frequency of updating: In seconds and
 * microseconds.
 */
#define TSEC_UPDATE  1
#define TUSEC_UPDATE 0

#define TRUE 1
#define FALSE 0

static int init = 1;

static int timer_on = 0;

int max_fifo_nb =  MAX_FIFO_NB_MAX;
int fifo_depth = FIFO_DEPTH_MAX;

char fifo_text[50];

#define TCL_PROC(name) int name (void *object, Tcl_Interp *interp, int argc, char **argv)

double d_time() 
{
#ifndef VXWORKS
  double d1,d2;

#ifdef CLOCK_REALTIME
  struct timespec to;
  clock_gettime(CLOCK_REALTIME,&to);
#else
  struct timeval  to;
  struct timezone tz;

  gettimeofday(&to, &tz);
#endif

  d1 = to.tv_sec;
#ifdef CLOCK_REALTIME
  d2 = to.tv_nsec;
  d1 = d1 + (d2/1000000000.0);
#else
  d2 = to.tv_usec;
  d1 = d1 + (d2/1000000.0);
#endif

  return d1;
#endif
}

static double old_time;


TCL_PROC (DDR_start_cmd)
{
  int i;
  void cleanup();
  void ddr_update();

  if (init){
    dds_create();

    init = 0;
    atexit (cleanup);
  }

  old_time = d_time();

  if( Tcl_VarEval(interp, "DDR_start_tcl ",argv[1], NULL) != TCL_OK)
    return TCL_ERROR;
  
  timer_on = 1;
  
  return TCL_OK;
}

TCL_PROC (DDR_stop_cmd)
{
  timer_on = 0;

  return TCL_OK;
}

void DDR_exit()
{
  void cleanup();

  cleanup();
  exit(0);
}

void cleanup()
{
  struct itimerval tto, tti = {0,0,0,0};

  timer_on = 0;

  dds_close(0);
  /*fifo_close(0);*/
}

TCL_PROC (DDR_update)
{
  static int oldin[MAX_FIFO_NB_MAX], oldout[MAX_FIFO_NB_MAX];
  int i;
  int status[MAX_FIFO_NB_MAX], cnt[MAX_FIFO_NB_MAX];
  int devin[MAX_FIFO_NB_MAX], devout[MAX_FIFO_NB_MAX];
  double ratein[MAX_FIFO_NB_MAX], rateout[MAX_FIFO_NB_MAX];
  extern a_fifo *fifo_shm_start;
  char temp[256];

  if (fifo_rate(status, cnt, devin, devout)){
    fprintf(stderr," dd_rate: error in fifo_rate ");
    DDR_exit();
  }
  else{
    for (i=0;i<MAX_FIFO_NB_MAX;i++){
      sprintf(temp,"graph plot %d %d",i,cnt[i]);
      if ( Tcl_Eval(interp, temp) != TCL_OK)
	return TCL_ERROR;
      ratein[i]  = devin[i] /1000.0 /(d_time() - old_time);
      rateout[i] = devout[i]/ 1000.0 /(d_time() - old_time);

      sprintf(temp,"graph2 plot %d %f",i,ratein[i]);
      if ( Tcl_Eval(interp, temp) != TCL_OK)
	return TCL_ERROR;

      sprintf(fifo_text,"\"%4i %4i %4i\"",
	      ratein[i],
	      rateout[i],
	      cnt[i]);
      
      if ((fifo_shm_start + i)->fhdr.fname) {
	  sprintf(temp,"%d",i);
	  if( Tcl_VarEval(interp, "graph label ",
			  temp,
			  " ",
			  (fifo_shm_start + i)->fhdr.fname, NULL) != TCL_OK)
	    return TCL_ERROR;
	  if( Tcl_VarEval(interp, "graph2 label ",
			  temp,
			  " ",
			  (fifo_shm_start + i)->fhdr.fname, NULL) != TCL_OK)
	    return TCL_ERROR;
      }
      oldin[i] = devin[i];
      oldout[i] = devout[i];
    }
  }
  
  Tcl_Eval(interp,"after 300 itcl_context $this DDR_UI DDR_update");
  old_time = d_time();
  
  return TCL_OK;
}

