/* 
 * Main Application tkAppInit.c for 
 * tk interface to dw process
 */


#include <tk.h>

#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

#include <signal.h>
#include <string.h>
#include <fcntl.h>


#define TRUE 1
#define FALSE 0

Tcl_Interp *dd_interp;

/*
 * connection to dd ctl
 */
FILE     *todd, *fromdd;
pid_t ddctl_pid = 0;


/*
 * starting dd ctl
 */
int start_dd_ctl()
{
  int  to[2], from[2];
  char pname[1024], *p;

  if ( (p=getenv("DD_BIN")) == NULL ) {
    printf("environment variable DD_BIN not defined\n");
    return -1;
  }
  
  sprintf(pname,"%s%s",p,"/dd_ctl");
  ddctl_pid = spawn(pname, &todd, &fromdd );
  if (ddctl_pid == -1) {
    fprintf(stderr," dd_ctl not spawned!\n" );
    return -1;
  }
  else
    fcntl( fileno(fromdd), F_SETFL, O_NDELAY );
  
  return 0;
}


/*
 * general routines
 */

void read_ddctl(ClientData clientdata, int mask)
{
  char *status, buffer[1024];
  char cmd[1024];

  while ( status = fgets(buffer, sizeof(buffer), fromdd) ) {
    sprintf(cmd,".top.ddtext insert end \"%s\"\n",buffer);
    Tcl_Eval(dd_interp, cmd);
    Tcl_Eval(dd_interp,".top.ddtext yview -pickplace end");
/*
    sprintf(cmd, "ddtext_print \"%s\"\n",buffer);
    Tcl_Eval(dd_interp,cmd); 
*/
  }
}

int dd_cmd(ClientData clientdata, Tcl_Interp *interp, int argc, char *argv[])
{
  int i;
  char *p, cmd[1024];

  strcpy(cmd,"");
  if ( argc > 1 ) {
    for (i=1; i<argc; i++)  {
      strcat(cmd, argv[i]);
      strcat(cmd," ");
    }
    strcat(cmd,"\n");
  } else {
    interp->result = "dd_cmd: wrong syntax";
    return TCL_ERROR;
  }

  fprintf(todd,cmd);
  fflush(todd);

  return TCL_OK;
}

int my_exit(ClientData clientdata, Tcl_Interp *interp, int argc, char *argv[])
{
  int status;

  if ( ddctl_pid ) {
    fprintf(todd,"quit\n");
    fflush(todd);
  }
  exit(0);
}


/*
 * Main part :
 *============
 *
 */

int Tcl_AppInit(interp)
    Tcl_Interp *interp;	
{
    Tk_Window main;
  
    main = Tk_MainWindow(interp);
    dd_interp = interp;

    if (Tcl_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    if (Tk_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }

/*
 *  define TCL commands
 */
    Tcl_CreateCommand(interp, "dd_cmd", dd_cmd,
		      (ClientData)NULL, (Tcl_CmdDeleteProc*)NULL);
    Tcl_CreateCommand(interp, "my_exit",my_exit,
		      (ClientData)NULL, (Tcl_CmdDeleteProc*)NULL);

/*
 *  set up dd_ctl and its file handler
 */
    if ( start_dd_ctl() ) {
      fprintf(stderr,"error in starting dd_ctl - exit\n");
      exit(1);
    }

    Tk_CreateFileHandler(fileno(fromdd),TK_READABLE, read_ddctl, (ClientData)NULL);

    tcl_RcFileName = "~/.wishrc";

    return TCL_OK;
}


int main(int argc, char **argv)
{
  Tk_Main(argc, argv, Tcl_AppInit);
  return 0;
}








 
