
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <fifo.h>
#include <dd_dcom.h>

main()
{
  int status[MAX_FIFO_NB_MAX], cnt[MAX_FIFO_NB_MAX]; 
  int devin[MAX_FIFO_NB_MAX], devout[MAX_FIFO_NB_MAX];
  char *p2c;
  char filename[1024];
  int i,ii;
  char *cp;
  int tsec = 1;
  int scale;
  char clear_screen[] = "\033[2J";
  char home_cursor[] = "\033[1;1H";

  ddu_attach();

  scale = 10;
  printf("%s",clear_screen);
  fflush(stdout);

  while ( ddu_attached() ) {
    if (fifo_rate(status, cnt, devin, devout) == 0){
      printf("%s",home_cursor);
      fflush(stdout);
      printf("\n\n");
      for (i=0;i<max_fifo_nb;i++){
	if (status[i] != FSTAT_UNUSED){
	  if (status[i] == FSTAT_IDLE)
	    cp = "IDLE   ";
	  if (status[i] == FSTAT_ACTIVE) 
	    cp = "ACTIVE ";
	  printf(" FIFO %2i: status %s rate in %4i out %4i :",i,cp, 
		 devin[i]/tsec,devout[i]/tsec);
	  for (ii=0;ii<cnt[i]/scale;ii++)
	    printf("%c",'X');
	  for (ii=cnt[i]/scale;ii<fifo_depth/scale;ii++)
	    printf("%c",'.');
	  printf("\n");
	}
	else
	  printf("\n");
      }
      printf("\n");
      printf(" Number of fev requested    %i \n",dd_dcom->nfev_req);
      printf(" Number of vol buffers made %i \n",dd_dcom->nbuf_vol_made);
      printf(" Number of volatile buffers %i \n",dd_dcom->db_nbuf_vol);
      sleep(tsec);
    }
  }

  printf("no longer to DD attached - exit now\n");
  exit(0);
}
       


